/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.animation;

import androidx.ui.foundation.animation.AndroidFlingSplineKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0002\b\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/ui/foundation/animation/AndroidFlingSpline;", "", "NbSamples", "", "SplinePositions", "", "SplineTimes", "deceleration", "", "velocity", "", "friction", "flingPosition", "Landroidx/ui/foundation/animation/AndroidFlingSpline$FlingResult;", "time", "FlingResult", "ui-foundation_release"})
public final class AndroidFlingSpline {
    @NotNull
    public static final AndroidFlingSpline INSTANCE = new AndroidFlingSpline();
    private static final int NbSamples = 100;
    private static final float[] SplinePositions = new float[101];
    private static final float[] SplineTimes = new float[101];

    private AndroidFlingSpline() {
    }

    @NotNull
    public final FlingResult flingPosition(float time) {
        int index = (int)((float)100 * time);
        float distanceCoef = 1.0f;
        float velocityCoef = 0.0f;
        if (index < 100) {
            float tInf = (float)index / (float)100;
            float tSup = (float)(index + 1) / (float)100;
            float dInf = SplinePositions[index];
            float dSup = SplinePositions[index + 1];
            velocityCoef = (dSup - dInf) / (tSup - tInf);
            distanceCoef = dInf + (time - tInf) * velocityCoef;
        }
        return new FlingResult(distanceCoef, velocityCoef);
    }

    public final double deceleration(float velocity, float friction) {
        float f = 0.35f;
        boolean bl = false;
        float f2 = Math.abs(velocity);
        double d = (double)(f * f2) / (double)friction;
        boolean bl2 = false;
        return Math.log(d);
    }

    static {
        AndroidFlingSplineKt.access$computeSplineInfo(SplinePositions, SplineTimes, 100);
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u0012"}, d2={"Landroidx/ui/foundation/animation/AndroidFlingSpline$FlingResult;", "", "distanceCoefficient", "", "velocityCoefficient", "getDistanceCoefficient", "()F", "getVelocityCoefficient", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ui-foundation_release"})
    public static final class FlingResult {
        private final float distanceCoefficient;
        private final float velocityCoefficient;

        public FlingResult(float distanceCoefficient, float velocityCoefficient) {
            this.distanceCoefficient = distanceCoefficient;
            this.velocityCoefficient = velocityCoefficient;
        }

        public final float getDistanceCoefficient() {
            return this.distanceCoefficient;
        }

        public final float getVelocityCoefficient() {
            return this.velocityCoefficient;
        }

        public final float component1() {
            return this.distanceCoefficient;
        }

        public final float component2() {
            return this.velocityCoefficient;
        }

        @NotNull
        public final FlingResult copy(float distanceCoefficient, float velocityCoefficient) {
            return new FlingResult(distanceCoefficient, velocityCoefficient);
        }

        public static /* synthetic */ FlingResult copy$default(FlingResult this_, float distanceCoefficient, float velocityCoefficient, int n, Object object) {
            if ((n & 1) != 0) {
                distanceCoefficient = this_.distanceCoefficient;
            }
            if ((n & 2) != 0) {
                velocityCoefficient = this_.velocityCoefficient;
            }
            return this_.copy(distanceCoefficient, velocityCoefficient);
        }

        @NotNull
        public String toString() {
            return "FlingResult(distanceCoefficient=" + this.distanceCoefficient + ", velocityCoefficient=" + this.velocityCoefficient + ")";
        }

        public int hashCode() {
            return Float.hashCode(this.distanceCoefficient) * 31 + Float.hashCode(this.velocityCoefficient);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingResult)) {
                return false;
            }
            Object object = other;
            FlingResult flingResult = (FlingResult)object;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.distanceCoefficient), (Object)Float.valueOf(flingResult.distanceCoefficient))) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.velocityCoefficient), (Object)Float.valueOf(flingResult.velocityCoefficient));
        }
    }
}

