/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation;

import androidx.animation.AnimatedValue;
import androidx.compose.State;
import androidx.ui.core.ContentDrawScope;
import androidx.ui.core.DrawModifier;
import androidx.ui.core.Modifier;
import androidx.ui.foundation.CursorState;
import androidx.ui.foundation.TextFieldKt;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.drawscope.DrawScope;
import androidx.ui.input.TextFieldValue;
import androidx.ui.input.TransformedText;
import androidx.ui.input.VisualTransformation;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.TextFieldDelegate;
import androidx.ui.text.TextRange;
import androidx.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000J\u0016\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0003H\u00c6\u0003\u00f8\u0001\u0000J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u000bH\u00c6\u0003JD\u0010\u0018\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001\u00f8\u0001\u0000J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\f\u0010!\u001a\u00020\"*\u00020#H\u0016R\u001e\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0003\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Landroidx/ui/foundation/CursorModifier;", "Landroidx/ui/core/DrawModifier;", "color", "Landroidx/animation/AnimatedValue;", "Landroidx/ui/graphics/Color;", "cursorState", "Landroidx/ui/foundation/CursorState;", "textFieldValue", "Landroidx/compose/State;", "Landroidx/ui/input/TextFieldValue;", "visualTransformation", "Landroidx/ui/input/VisualTransformation;", "getColor", "()Landroidx/animation/AnimatedValue;", "getCursorState", "()Landroidx/ui/foundation/CursorState;", "getTextFieldValue", "()Landroidx/compose/State;", "getVisualTransformation", "()Landroidx/ui/input/VisualTransformation;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "draw", "", "Landroidx/ui/core/ContentDrawScope;", "ui-foundation_release"})
final class CursorModifier
implements DrawModifier {
    private final AnimatedValue<Color, ?> color;
    private final CursorState cursorState;
    private final State<TextFieldValue> textFieldValue;
    private final VisualTransformation visualTransformation;

    public CursorModifier(@NotNull AnimatedValue<Color, ?> color, @NotNull CursorState cursorState, @NotNull State<TextFieldValue> textFieldValue, @NotNull VisualTransformation visualTransformation) {
        Intrinsics.checkNotNullParameter(color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)cursorState, (String)"cursorState");
        Intrinsics.checkNotNullParameter(textFieldValue, (String)"textFieldValue");
        Intrinsics.checkNotNullParameter((Object)visualTransformation, (String)"visualTransformation");
        this.color = color;
        this.cursorState = cursorState;
        this.textFieldValue = textFieldValue;
        this.visualTransformation = visualTransformation;
    }

    @NotNull
    public final AnimatedValue<Color, ?> getColor() {
        return this.color;
    }

    @NotNull
    public final CursorState getCursorState() {
        return this.cursorState;
    }

    @NotNull
    public final State<TextFieldValue> getTextFieldValue() {
        return this.textFieldValue;
    }

    @NotNull
    public final VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (!(Color.getAlpha-impl((long)((Color)this.getColor().getValue()).unbox-impl()) == 0.0f)) {
            long l;
            float y$iv;
            TextRange it;
            Object object;
            TransformedText transformedText;
            TransformedText transformed = this.getVisualTransformation().filter(new AnnotatedString(((TextFieldValue)this.getTextFieldValue().getValue()).getText(), null, null, 6, null));
            TextRange textRange = ((TextFieldValue)this.getTextFieldValue().getValue()).getComposition();
            if (textRange == null) {
                transformedText = null;
            } else {
                object = textRange;
                boolean bl = false;
                boolean bl2 = false;
                it = object;
                boolean bl3 = false;
                transformedText = TextFieldDelegate.Companion.applyCompositionDecoration(it, transformed);
            }
            TransformedText transformedText2 = transformedText;
            TransformedText transformedText3 = transformedText2 == null ? transformed : transformedText2;
            float cursorWidth = TextFieldKt.access$getCursorThickness$cp$s-33320458() * $this$draw.getDensity();
            it = this.getCursorState().getLayoutResult();
            IntSize intSize = it == null ? (IntSize)null : it.getSize();
            Integer n = intSize == null ? (Integer)null : Integer.valueOf(intSize.getHeight());
            object = n == null ? (Float)null : Float.valueOf(n.intValue());
            float cursorHeight = object == null ? 0.0f : ((Float)object).floatValue();
            intSize = this.getCursorState().getLayoutResult();
            n = intSize == null ? (Rect)null : intSize.getCursorRect(transformedText3.getOffsetMap().originalToTransformed(((TextFieldValue)this.getTextFieldValue().getValue()).getSelection().getMin()));
            Integer cursorRect = n == null ? new Rect(0.0f, 0.0f, cursorWidth, cursorHeight) : n;
            float cursorX = (cursorRect.getLeft() + cursorRect.getRight()) / (float)2;
            float f = cursorRect.getTop();
            long l2 = ((Color)this.getColor().getValue()).unbox-impl();
            DrawScope drawScope = (DrawScope)$this$draw;
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            float f2 = cursorX;
            boolean bl = false;
            long v1$iv$iv = Float.floatToIntBits(f2);
            float f3 = y$iv;
            boolean bl4 = false;
            long v2$iv$iv = Float.floatToIntBits(f3);
            long l3 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
            Offset offset = new Offset(l3);
            y$iv = cursorRect.getBottom();
            $i$f$Offset = false;
            $i$f$packFloats = false;
            f2 = cursorX;
            bl = false;
            v1$iv$iv = Float.floatToIntBits(f2);
            f3 = y$iv;
            bl4 = false;
            v2$iv$iv = Float.floatToIntBits(f3);
            l3 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
            Offset offset2 = new Offset(l3);
            DrawScope.drawLine-LIcrJ00$default((DrawScope)drawScope, (long)l2, (Offset)offset, (Offset)offset2, (float)cursorWidth, null, null, (float)0.0f, null, null, (int)496, null);
        }
        $this$draw.drawContent();
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return Modifier.Element.DefaultImpls.all((Modifier.Element)this, predicate);
    }

    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return Modifier.Element.DefaultImpls.any((Modifier.Element)this, predicate);
    }

    @NotNull
    public Modifier plus(@NotNull Modifier other) {
        return Modifier.DefaultImpls.plus((Modifier)this, (Modifier)other);
    }

    @NotNull
    public final AnimatedValue<Color, ?> component1() {
        return this.color;
    }

    @NotNull
    public final CursorState component2() {
        return this.cursorState;
    }

    @NotNull
    public final State<TextFieldValue> component3() {
        return this.textFieldValue;
    }

    @NotNull
    public final VisualTransformation component4() {
        return this.visualTransformation;
    }

    @NotNull
    public final CursorModifier copy(@NotNull AnimatedValue<Color, ?> color, @NotNull CursorState cursorState, @NotNull State<TextFieldValue> textFieldValue, @NotNull VisualTransformation visualTransformation) {
        Intrinsics.checkNotNullParameter(color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)cursorState, (String)"cursorState");
        Intrinsics.checkNotNullParameter(textFieldValue, (String)"textFieldValue");
        Intrinsics.checkNotNullParameter((Object)visualTransformation, (String)"visualTransformation");
        return new CursorModifier(color, cursorState, textFieldValue, visualTransformation);
    }

    public static /* synthetic */ CursorModifier copy$default(CursorModifier this_, AnimatedValue color, CursorState cursorState, State textFieldValue, VisualTransformation visualTransformation, int n, Object object) {
        if ((n & 1) != 0) {
            color = this_.color;
        }
        if ((n & 2) != 0) {
            cursorState = this_.cursorState;
        }
        if ((n & 4) != 0) {
            textFieldValue = this_.textFieldValue;
        }
        if ((n & 8) != 0) {
            visualTransformation = this_.visualTransformation;
        }
        return this_.copy(color, cursorState, textFieldValue, visualTransformation);
    }

    @NotNull
    public String toString() {
        return "CursorModifier(color=" + this.color + ", cursorState=" + this.cursorState + ", textFieldValue=" + this.textFieldValue + ", visualTransformation=" + this.visualTransformation + ")";
    }

    public int hashCode() {
        return ((this.color.hashCode() * 31 + this.cursorState.hashCode()) * 31 + this.textFieldValue.hashCode()) * 31 + this.visualTransformation.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CursorModifier)) {
            return false;
        }
        Object object = other;
        CursorModifier cursorModifier2 = (CursorModifier)object;
        if (!Intrinsics.areEqual(this.color, cursorModifier2.color)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cursorState, (Object)cursorModifier2.cursorState)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textFieldValue, cursorModifier2.textFieldValue)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.visualTransformation, (Object)cursorModifier2.visualTransformation);
    }
}

