/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.animation;

import androidx.ui.foundation.animation.AndroidFlingCalculatorKt;
import androidx.ui.foundation.animation.AndroidFlingSpline;
import androidx.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/ui/foundation/animation/AndroidFlingCalculator;", "", "density", "Landroidx/ui/unit/Density;", "getDensity", "()Landroidx/ui/unit/Density;", "magicPhysicalCoefficient", "", "computeDeceleration", "flingDistance", "velocity", "flingDuration", "", "flingInfo", "Landroidx/ui/foundation/animation/AndroidFlingCalculator$FlingInfo;", "getSplineDeceleration", "", "FlingInfo", "ui-foundation_release"})
public final class AndroidFlingCalculator {
    private final Density density;
    private final float magicPhysicalCoefficient;

    public AndroidFlingCalculator(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.density = density;
        this.magicPhysicalCoefficient = this.computeDeceleration(this.getDensity());
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    private final float computeDeceleration(Density density) {
        return AndroidFlingCalculatorKt.access$computeDeceleration(0.84f, density.getDensity());
    }

    private final double getSplineDeceleration(float velocity) {
        return AndroidFlingSpline.INSTANCE.deceleration(velocity, AndroidFlingCalculatorKt.access$getFlingFriction$cp$s-86446856() * this.magicPhysicalCoefficient);
    }

    public final long flingDuration(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)AndroidFlingCalculatorKt.access$getDecelerationRate$cp$s-86446856() - 1.0;
        double d = l / decelMinusOne;
        double d2 = 1000.0;
        boolean bl = false;
        double d3 = Math.exp(d);
        return (long)(d2 * d3);
    }

    public final float flingDistance(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)AndroidFlingCalculatorKt.access$getDecelerationRate$cp$s-86446856() - 1.0;
        double d = (double)AndroidFlingCalculatorKt.access$getDecelerationRate$cp$s-86446856() / decelMinusOne * l;
        double d2 = AndroidFlingCalculatorKt.access$getFlingFriction$cp$s-86446856() * this.magicPhysicalCoefficient;
        boolean bl = false;
        double d3 = Math.exp(d);
        return (float)(d2 * d3);
    }

    @NotNull
    public final FlingInfo flingInfo(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)AndroidFlingCalculatorKt.access$getDecelerationRate$cp$s-86446856() - 1.0;
        double d = (double)AndroidFlingCalculatorKt.access$getDecelerationRate$cp$s-86446856() / decelMinusOne * l;
        double d2 = AndroidFlingCalculatorKt.access$getFlingFriction$cp$s-86446856() * this.magicPhysicalCoefficient;
        float f = velocity;
        boolean bl = false;
        double d3 = Math.exp(d);
        d = l / decelMinusOne;
        double d4 = 1000.0;
        float f2 = (float)(d2 * d3);
        bl = false;
        double d5 = Math.exp(d);
        long l2 = (long)(d4 * d5);
        float f3 = f2;
        float f4 = f;
        return new FlingInfo(f4, f3, l2);
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0018\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0006J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u001a"}, d2={"Landroidx/ui/foundation/animation/AndroidFlingCalculator$FlingInfo;", "", "initialVelocity", "", "distance", "duration", "", "getDistance", "()F", "getDuration", "()J", "getInitialVelocity", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "position", "time", "toString", "", "velocity", "ui-foundation_release"})
    public static final class FlingInfo {
        private final float initialVelocity;
        private final float distance;
        private final long duration;

        public FlingInfo(float initialVelocity, float distance, long duration) {
            this.initialVelocity = initialVelocity;
            this.distance = distance;
            this.duration = duration;
        }

        public final float getInitialVelocity() {
            return this.initialVelocity;
        }

        public final float getDistance() {
            return this.distance;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final float position(long time) {
            float splinePos = this.getDuration() > 0L ? (float)time / (float)this.getDuration() : 1.0f;
            float f = this.getInitialVelocity();
            float f2 = this.getDistance();
            boolean bl = false;
            float f3 = Math.signum(f);
            return f2 * f3 * AndroidFlingSpline.INSTANCE.flingPosition(splinePos).getDistanceCoefficient();
        }

        public final float velocity(long time) {
            float splinePos = this.getDuration() > 0L ? (float)time / (float)this.getDuration() : 1.0f;
            return AndroidFlingSpline.INSTANCE.flingPosition(splinePos).getVelocityCoefficient() * this.getDistance() / (float)this.getDuration() * 1000.0f;
        }

        public final float component1() {
            return this.initialVelocity;
        }

        public final float component2() {
            return this.distance;
        }

        public final long component3() {
            return this.duration;
        }

        @NotNull
        public final FlingInfo copy(float initialVelocity, float distance, long duration) {
            return new FlingInfo(initialVelocity, distance, duration);
        }

        public static /* synthetic */ FlingInfo copy$default(FlingInfo this_, float initialVelocity, float distance, long duration, int n, Object object) {
            if ((n & 1) != 0) {
                initialVelocity = this_.initialVelocity;
            }
            if ((n & 2) != 0) {
                distance = this_.distance;
            }
            if ((n & 4) != 0) {
                duration = this_.duration;
            }
            return this_.copy(initialVelocity, distance, duration);
        }

        @NotNull
        public String toString() {
            return "FlingInfo(initialVelocity=" + this.initialVelocity + ", distance=" + this.distance + ", duration=" + this.duration + ")";
        }

        public int hashCode() {
            return (Float.hashCode(this.initialVelocity) * 31 + Float.hashCode(this.distance)) * 31 + Long.hashCode(this.duration);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingInfo)) {
                return false;
            }
            Object object = other;
            FlingInfo flingInfo = (FlingInfo)object;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.initialVelocity), (Object)Float.valueOf(flingInfo.initialVelocity))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.distance), (Object)Float.valueOf(flingInfo.distance))) {
                return false;
            }
            return this.duration == flingInfo.duration;
        }
    }
}

