/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.gestures;

import androidx.compose.Composer;
import androidx.compose.EffectsKt;
import androidx.compose.SlotTable;
import androidx.ui.core.ComposedModifierKt;
import androidx.ui.core.Direction;
import androidx.ui.core.Modifier;
import androidx.ui.core.gesture.DragGestureFilterKt;
import androidx.ui.core.gesture.DragObserver;
import androidx.ui.foundation.Interaction;
import androidx.ui.foundation.InteractionState;
import androidx.ui.foundation.gestures.DragDirection;
import androidx.ui.foundation.gestures.DraggableState;
import androidx.ui.geometry.Offset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0090\u0001\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032#\b\u0002\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u00052#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\n0\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0005\u00a8\u0006\u0014"}, d2={"draggable", "Landroidx/ui/core/Modifier;", "dragDirection", "Landroidx/ui/foundation/gestures/DragDirection;", "onDragStarted", "Lkotlin/Function1;", "Landroidx/ui/geometry/Offset;", "Lkotlin/ParameterName;", "name", "startedPosition", "", "onDragStopped", "", "velocity", "enabled", "", "interactionState", "Landroidx/ui/foundation/InteractionState;", "startDragImmediately", "onDragDeltaConsumptionRequested", "ui-foundation_release"})
public final class DraggableKt {
    @NotNull
    public static final Modifier draggable(@NotNull Modifier $this$draggable, @NotNull DragDirection dragDirection, @NotNull Function1<? super Offset, Unit> onDragStarted, @NotNull Function1<? super Float, Unit> onDragStopped, boolean enabled, @Nullable InteractionState interactionState, boolean startDragImmediately, @NotNull Function1<? super Float, Float> onDragDeltaConsumptionRequested) {
        Intrinsics.checkNotNullParameter((Object)$this$draggable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dragDirection, (String)"dragDirection");
        Intrinsics.checkNotNullParameter(onDragStarted, (String)"onDragStarted");
        Intrinsics.checkNotNullParameter(onDragStopped, (String)"onDragStopped");
        Intrinsics.checkNotNullParameter(onDragDeltaConsumptionRequested, (String)"onDragDeltaConsumptionRequested");
        return ComposedModifierKt.composed((Modifier)$this$draggable, (Function4)new Function4<Modifier, Composer<?>, Integer, Integer, Modifier>(startDragImmediately, interactionState, enabled, onDragStarted, dragDirection, onDragDeltaConsumptionRequested, onDragStopped){
            private final /* synthetic */ boolean $startDragImmediately;
            private final /* synthetic */ InteractionState $interactionState;
            private final /* synthetic */ boolean $enabled;
            private final /* synthetic */ Function1<Offset, Unit> $onDragStarted;
            private final /* synthetic */ DragDirection $dragDirection;
            private final /* synthetic */ Function1<Float, Float> $onDragDeltaConsumptionRequested;
            private final /* synthetic */ Function1<Float, Unit> $onDragStopped;
            {
                this.$startDragImmediately = $startDragImmediately;
                this.$interactionState = $interactionState;
                this.$enabled = $enabled;
                this.$onDragStarted = $onDragStarted;
                this.$dragDirection = $dragDirection;
                this.$onDragDeltaConsumptionRequested = $onDragDeltaConsumptionRequested;
                this.$onDragStopped = $onDragStopped;
                super(4);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Modifier invoke(@NotNull Modifier modifier, @Nullable Composer<?> $composer, int $key, int $changed) {
                void $this$cache$iv$iv;
                void $key$iv;
                Intrinsics.checkNotNullParameter((Object)modifier, (String)"<this>");
                int n = -440477290;
                boolean $changed$iv = false;
                boolean $i$f$remember = false;
                $composer.startReplaceableGroup((int)$key$iv);
                Composer<?> composer = $composer;
                boolean valid$iv$iv = true;
                boolean $i$f$cache = false;
                Object result$iv$iv = $this$cache$iv$iv.nextSlot();
                if (result$iv$iv == SlotTable.Companion.getEMPTY()) {
                    DraggableState draggableState;
                    boolean bl = false;
                    DraggableState value$iv$iv = draggableState = new DraggableState();
                    $this$cache$iv$iv.updateValue((Object)value$iv$iv);
                    result$iv$iv = value$iv$iv;
                }
                Object object = result$iv$iv;
                $composer.endReplaceableGroup();
                DraggableState dragState = (DraggableState)object;
                EffectsKt.onDispose((Function0)((Function0)new Function0<Unit>(this.$interactionState){
                    private final /* synthetic */ InteractionState $interactionState;
                    {
                        this.$interactionState = $interactionState;
                        super(0);
                    }

                    public final void invoke() {
                        InteractionState interactionState = this.$interactionState;
                        if (interactionState != null) {
                            interactionState.removeInteraction(Interaction.Dragged.INSTANCE);
                        }
                    }
                }), $composer, (int)-440477256, (int)0);
                Modifier modifier2 = DragGestureFilterKt.dragGestureFilter((Modifier)modifier, (DragObserver)new DragObserver(this.$enabled, this.$interactionState, this.$onDragStarted, this.$dragDirection, this.$onDragDeltaConsumptionRequested, dragState, this.$onDragStopped){
                    private final /* synthetic */ boolean $enabled;
                    private final /* synthetic */ InteractionState $interactionState;
                    private final /* synthetic */ Function1<Offset, Unit> $onDragStarted;
                    private final /* synthetic */ DragDirection $dragDirection;
                    private final /* synthetic */ Function1<Float, Float> $onDragDeltaConsumptionRequested;
                    private final /* synthetic */ DraggableState $dragState;
                    private final /* synthetic */ Function1<Float, Unit> $onDragStopped;
                    {
                        this.$enabled = $enabled;
                        this.$interactionState = $interactionState;
                        this.$onDragStarted = $onDragStarted;
                        this.$dragDirection = $dragDirection;
                        this.$onDragDeltaConsumptionRequested = $onDragDeltaConsumptionRequested;
                        this.$dragState = $dragState;
                        this.$onDragStopped = $onDragStopped;
                    }

                    public void onStart(@NotNull Offset downPosition) {
                        Intrinsics.checkNotNullParameter((Object)downPosition, (String)"downPosition");
                        if (this.$enabled) {
                            InteractionState interactionState = this.$interactionState;
                            if (interactionState != null) {
                                InteractionState.addInteraction$default(interactionState, Interaction.Dragged.INSTANCE, null, 2, null);
                            }
                            this.$onDragStarted.invoke((Object)downPosition);
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public Offset onDrag(@NotNull Offset dragDistance) {
                        long l;
                        void x$iv;
                        Intrinsics.checkNotNullParameter((Object)dragDistance, (String)"dragDistance");
                        if (!this.$enabled) {
                            return dragDistance;
                        }
                        float projected = this.$dragDirection.project$ui_foundation_release(dragDistance);
                        float consumed = ((Number)this.$onDragDeltaConsumptionRequested.invoke((Object)Float.valueOf(projected))).floatValue();
                        this.$dragState.setValue(this.$dragState.getValue() + consumed);
                        float fractionConsumed = projected == 0.0f ? 0.0f : consumed / projected;
                        float f = ((Number)this.$dragDirection.getXProjection$ui_foundation_release().invoke((Object)Float.valueOf(dragDistance.getX()))).floatValue() * fractionConsumed;
                        float y$iv = ((Number)this.$dragDirection.getYProjection$ui_foundation_release().invoke((Object)Float.valueOf(dragDistance.getY()))).floatValue() * fractionConsumed;
                        boolean $i$f$Offset = false;
                        boolean $i$f$packFloats = false;
                        void var9_9 = x$iv;
                        boolean bl = false;
                        long v1$iv$iv = Float.floatToIntBits((float)var9_9);
                        float f2 = y$iv;
                        boolean bl2 = false;
                        long v2$iv$iv = Float.floatToIntBits(f2);
                        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
                        return new Offset(l2);
                    }

                    public void onCancel() {
                        if (this.$enabled) {
                            InteractionState interactionState = this.$interactionState;
                            if (interactionState != null) {
                                interactionState.removeInteraction(Interaction.Dragged.INSTANCE);
                            }
                            this.$onDragStopped.invoke((Object)Float.valueOf(0.0f));
                        }
                    }

                    public void onStop(@NotNull Offset velocity) {
                        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
                        if (this.$enabled) {
                            InteractionState interactionState = this.$interactionState;
                            if (interactionState != null) {
                                interactionState.removeInteraction(Interaction.Dragged.INSTANCE);
                            }
                            this.$onDragStopped.invoke((Object)Float.valueOf(this.$dragDirection.project$ui_foundation_release(velocity)));
                        }
                    }
                }, (Function1)((Function1)new Function1<Direction, Boolean>(this.$enabled, this.$dragDirection, dragState){
                    private final /* synthetic */ boolean $enabled;
                    private final /* synthetic */ DragDirection $dragDirection;
                    private final /* synthetic */ DraggableState $dragState;
                    {
                        this.$enabled = $enabled;
                        this.$dragDirection = $dragDirection;
                        this.$dragState = $dragState;
                        super(1);
                    }

                    public final boolean invoke(@NotNull Direction direction) {
                        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
                        return this.$enabled && (Boolean)this.$dragDirection.isDraggableInDirection$ui_foundation_release().invoke((Object)direction, (Object)Float.valueOf(this.$dragState.getValue())) != false;
                    }
                }), (boolean)this.$startDragImmediately);
                return modifier2;
            }
        });
    }

    public static /* synthetic */ Modifier draggable$default(Modifier $this$draggable_u24default, DragDirection dragDirection, Function1 onDragStarted, Function1 onDragStopped, boolean enabled, InteractionState interactionState, boolean startDragImmediately, Function1 onDragDeltaConsumptionRequested, int n, Object object) {
        if ((n & 2) != 0) {
            onDragStarted = (Function1)new Function1<Offset, Unit>(){

                public final void invoke(@NotNull Offset it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                }
            };
        }
        if ((n & 4) != 0) {
            onDragStopped = (Function1)new Function1<Float, Unit>(){

                public final void invoke(float it) {
                }
            };
        }
        if ((n & 8) != 0) {
            enabled = true;
        }
        if ((n & 0x10) != 0) {
            interactionState = null;
        }
        if ((n & 0x20) != 0) {
            startDragImmediately = false;
        }
        return DraggableKt.draggable($this$draggable_u24default, dragDirection, (Function1<? super Offset, Unit>)onDragStarted, (Function1<? super Float, Unit>)onDragStopped, enabled, interactionState, startDragImmediately, (Function1<? super Float, Float>)onDragDeltaConsumptionRequested);
    }
}

