/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.shape.corner;

import androidx.ui.foundation.shape.corner.CornerSize;
import androidx.ui.geometry.Size;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.Shape;
import androidx.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003J0\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H&J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0014H&J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u001b"}, d2={"Landroidx/ui/foundation/shape/corner/CornerBasedShape;", "Landroidx/ui/graphics/Shape;", "topLeft", "Landroidx/ui/foundation/shape/corner/CornerSize;", "topRight", "bottomRight", "bottomLeft", "getBottomLeft", "()Landroidx/ui/foundation/shape/corner/CornerSize;", "getBottomRight", "getTopLeft", "getTopRight", "copy", "all", "createOutline", "Landroidx/ui/graphics/Outline;", "size", "Landroidx/ui/geometry/Size;", "density", "Landroidx/ui/unit/Density;", "", "equals", "", "other", "", "hashCode", "", "ui-foundation_release"})
public abstract class CornerBasedShape
implements Shape {
    private final CornerSize topLeft;
    private final CornerSize topRight;
    private final CornerSize bottomRight;
    private final CornerSize bottomLeft;

    public CornerBasedShape(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }

    @NotNull
    public final CornerSize getTopLeft() {
        return this.topLeft;
    }

    @NotNull
    public final CornerSize getTopRight() {
        return this.topRight;
    }

    @NotNull
    public final CornerSize getBottomRight() {
        return this.bottomRight;
    }

    @NotNull
    public final CornerSize getBottomLeft() {
        return this.bottomLeft;
    }

    @NotNull
    public final Outline createOutline(@NotNull Size size, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        float halfMinDimension = size.getMinDimension() / 2.0f;
        float f = this.getTopLeft().toPx(size, density);
        boolean bl = false;
        float topLeft = Math.min(f, halfMinDimension);
        float f2 = this.getTopRight().toPx(size, density);
        boolean bl2 = false;
        float topRight = Math.min(f2, halfMinDimension);
        float f3 = this.getBottomRight().toPx(size, density);
        boolean bl3 = false;
        float bottomRight = Math.min(f3, halfMinDimension);
        float f4 = this.getBottomLeft().toPx(size, density);
        boolean bl4 = false;
        float bottomLeft = Math.min(f4, halfMinDimension);
        boolean bl5 = topLeft >= 0.0f && topRight >= 0.0f && bottomRight >= 0.0f && bottomLeft >= 0.0f;
        bl4 = false;
        boolean bl6 = false;
        if (!bl5) {
            boolean bl7 = false;
            String string = "Corner size in Px can't be negative(topLeft = " + topLeft + ", topRight = " + topRight + ", bottomRight = " + bottomRight + ", bottomLeft = " + bottomLeft + ")!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.createOutline(size, topLeft, topRight, bottomRight, bottomLeft);
    }

    @NotNull
    public abstract Outline createOutline(@NotNull Size var1, float var2, float var3, float var4, float var5);

    @NotNull
    public abstract CornerBasedShape copy(@NotNull CornerSize var1, @NotNull CornerSize var2, @NotNull CornerSize var3, @NotNull CornerSize var4);

    public static /* synthetic */ CornerBasedShape copy$default(CornerBasedShape this_, CornerSize topLeft, CornerSize topRight, CornerSize bottomRight, CornerSize bottomLeft, int n, Object object) {
        if ((n & 1) != 0) {
            topLeft = this_.getTopLeft();
        }
        if ((n & 2) != 0) {
            topRight = this_.getTopRight();
        }
        if ((n & 4) != 0) {
            bottomRight = this_.getBottomRight();
        }
        if ((n & 8) != 0) {
            bottomLeft = this_.getBottomLeft();
        }
        return this_.copy(topLeft, topRight, bottomRight, bottomLeft);
    }

    @NotNull
    public final CornerBasedShape copy(@NotNull CornerSize all) {
        Intrinsics.checkNotNullParameter((Object)all, (String)"all");
        return this.copy(all, all, all, all);
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? (Class<?>)null : object.getClass())) {
            return false;
        }
        object = other;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.ui.foundation.shape.corner.CornerBasedShape");
        }
        CornerBasedShape cfr_ignored_0 = (CornerBasedShape)object;
        if (!Intrinsics.areEqual((Object)this.getTopLeft(), (Object)((CornerBasedShape)other).getTopLeft())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTopRight(), (Object)((CornerBasedShape)other).getTopRight())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBottomRight(), (Object)((CornerBasedShape)other).getBottomRight())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getBottomLeft(), (Object)((CornerBasedShape)other).getBottomLeft());
    }

    public int hashCode() {
        int result = this.getTopLeft().hashCode();
        result = 31 * result + this.getTopRight().hashCode();
        result = 31 * result + this.getBottomRight().hashCode();
        result = 31 * result + this.getBottomLeft().hashCode();
        return result;
    }
}

