/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.shape.corner;

import androidx.ui.foundation.shape.corner.CornerBasedShape;
import androidx.ui.foundation.shape.corner.CornerSize;
import androidx.ui.geometry.RRectKt;
import androidx.ui.geometry.Radius;
import androidx.ui.geometry.Rect;
import androidx.ui.geometry.Size;
import androidx.ui.geometry.SizeKt;
import androidx.ui.graphics.Outline;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003J(\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Landroidx/ui/foundation/shape/corner/RoundedCornerShape;", "Landroidx/ui/foundation/shape/corner/CornerBasedShape;", "topLeft", "Landroidx/ui/foundation/shape/corner/CornerSize;", "topRight", "bottomRight", "bottomLeft", "copy", "createOutline", "Landroidx/ui/graphics/Outline;", "size", "Landroidx/ui/geometry/Size;", "", "toString", "", "toRadius", "Landroidx/ui/geometry/Radius;", "(F)J", "ui-foundation_release"})
public final class RoundedCornerShape
extends CornerBasedShape {
    public RoundedCornerShape(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        super(topLeft, topRight, bottomRight, bottomLeft);
    }

    @Override
    @NotNull
    public Outline createOutline(@NotNull Size size, float topLeft, float topRight, float bottomRight, float bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return topLeft + topRight + bottomLeft + bottomRight == 0.0f ? (Outline)new Outline.Rectangle(SizeKt.toRect((Size)size)) : (Outline)new Outline.Rounded(RRectKt.RRect-a8KmX9Q((Rect)SizeKt.toRect((Size)size), (long)this.toRadius(topLeft), (long)this.toRadius(topRight), (long)this.toRadius(bottomRight), (long)this.toRadius(bottomLeft)));
    }

    @Override
    @NotNull
    public RoundedCornerShape copy(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        return new RoundedCornerShape(topLeft, topRight, bottomRight, bottomLeft);
    }

    @NotNull
    public String toString() {
        return "RoundedCornerShape(topLeft = " + this.getTopLeft() + ", topRight = " + this.getTopRight() + ", bottomRight = " + this.getBottomRight() + ", bottomLeft = " + this.getBottomLeft() + ")";
    }

    private final long toRadius(float $this$toRadius) {
        float y$iv = $this$toRadius;
        boolean $i$f$Radius = false;
        boolean $i$f$packFloats = false;
        float f = $this$toRadius;
        boolean bl = false;
        long v1$iv$iv$iv = Float.floatToIntBits(f);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv$iv = Float.floatToIntBits(f2);
        return Radius.constructor-impl((long)(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL));
    }
}

