/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core;

import androidx.ui.core.Constraints;
import androidx.ui.core.DummyPlaceable;
import androidx.ui.core.IntPx;
import androidx.ui.core.IntrinsicMeasurable;
import androidx.ui.core.IntrinsicMinMax;
import androidx.ui.core.IntrinsicWidthHeight;
import androidx.ui.core.Measurable;
import androidx.ui.core.Placeable;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/ui/core/DefaultIntrinsicMeasurable;", "Landroidx/ui/core/Measurable;", "measurable", "Landroidx/ui/core/IntrinsicMeasurable;", "minMax", "Landroidx/ui/core/IntrinsicMinMax;", "widthHeight", "Landroidx/ui/core/IntrinsicWidthHeight;", "(Landroidx/ui/core/IntrinsicMeasurable;Landroidx/ui/core/IntrinsicMinMax;Landroidx/ui/core/IntrinsicWidthHeight;)V", "getMeasurable", "()Landroidx/ui/core/IntrinsicMeasurable;", "getMinMax", "()Landroidx/ui/core/IntrinsicMinMax;", "parentData", "", "getParentData", "()Ljava/lang/Object;", "getWidthHeight", "()Landroidx/ui/core/IntrinsicWidthHeight;", "maxIntrinsicHeight", "Landroidx/ui/core/IntPx;", "width", "maxIntrinsicWidth", "height", "measure", "Landroidx/ui/core/Placeable;", "constraints", "Landroidx/ui/core/Constraints;", "minIntrinsicHeight", "minIntrinsicWidth", "ui-framework_release"})
@PublishedApi
public final class DefaultIntrinsicMeasurable
implements Measurable {
    private final IntrinsicMeasurable measurable;
    private final IntrinsicMinMax minMax;
    private final IntrinsicWidthHeight widthHeight;

    public DefaultIntrinsicMeasurable(@NotNull IntrinsicMeasurable measurable, @NotNull IntrinsicMinMax minMax, @NotNull IntrinsicWidthHeight widthHeight) {
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)((Object)minMax), (String)"minMax");
        Intrinsics.checkParameterIsNotNull((Object)((Object)widthHeight), (String)"widthHeight");
        this.measurable = measurable;
        this.minMax = minMax;
        this.widthHeight = widthHeight;
    }

    @NotNull
    public final IntrinsicMeasurable getMeasurable() {
        return this.measurable;
    }

    @NotNull
    public final IntrinsicMinMax getMinMax() {
        return this.minMax;
    }

    @NotNull
    public final IntrinsicWidthHeight getWidthHeight() {
        return this.widthHeight;
    }

    @Nullable
    public Object getParentData() {
        return this.getMeasurable().getParentData();
    }

    @NotNull
    public Placeable measure(@NotNull Constraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        if (Intrinsics.areEqual((Object)((Object)this.getWidthHeight()), (Object)((Object)IntrinsicWidthHeight.Width))) {
            IntPx width = Intrinsics.areEqual((Object)((Object)this.getMinMax()), (Object)((Object)IntrinsicMinMax.Max)) ? this.getMeasurable().maxIntrinsicWidth(constraints.getMaxHeight()) : this.getMeasurable().minIntrinsicWidth(constraints.getMaxHeight());
            return new DummyPlaceable(width, constraints.getMaxHeight());
        }
        IntPx height = Intrinsics.areEqual((Object)((Object)this.getMinMax()), (Object)((Object)IntrinsicMinMax.Max)) ? this.getMeasurable().maxIntrinsicHeight(constraints.getMaxWidth()) : this.getMeasurable().minIntrinsicHeight(constraints.getMaxWidth());
        return new DummyPlaceable(constraints.getMaxWidth(), height);
    }

    @NotNull
    public IntPx minIntrinsicWidth(@NotNull IntPx height) {
        Intrinsics.checkParameterIsNotNull((Object)height, (String)"height");
        return this.getMeasurable().minIntrinsicWidth(height);
    }

    @NotNull
    public IntPx maxIntrinsicWidth(@NotNull IntPx height) {
        Intrinsics.checkParameterIsNotNull((Object)height, (String)"height");
        return this.getMeasurable().maxIntrinsicWidth(height);
    }

    @NotNull
    public IntPx minIntrinsicHeight(@NotNull IntPx width) {
        Intrinsics.checkParameterIsNotNull((Object)width, (String)"width");
        return this.getMeasurable().minIntrinsicHeight(width);
    }

    @NotNull
    public IntPx maxIntrinsicHeight(@NotNull IntPx width) {
        Intrinsics.checkParameterIsNotNull((Object)width, (String)"width");
        return this.getMeasurable().maxIntrinsicHeight(width);
    }
}

