/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core.gesture.util;

import androidx.ui.core.gesture.util.Matrix;
import androidx.ui.core.gesture.util.PolynomialFit;
import androidx.ui.core.gesture.util.Vector;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a,\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"DefaultWeight", "", "polyFitLeastSquares", "Landroidx/ui/core/gesture/util/PolynomialFit;", "x", "", "y", "degree", "", "ui-framework_release"})
public final class PolyFitLeastSquaresKt {
    private static final float DefaultWeight = 1.0f;

    @NotNull
    public static final PolynomialFit polyFitLeastSquares(@NotNull List<Float> x, @NotNull List<Float> y, int degree) {
        int i;
        int i2;
        int h;
        int j;
        int h2;
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull(x, (String)"x");
        Intrinsics.checkParameterIsNotNull(y, (String)"y");
        if (degree < 1) {
            throw new IllegalArgumentException("The degree must be at positive integer");
        }
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("x and y must be the same length");
        }
        if (x.isEmpty()) {
            throw new IllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= x.size() ? x.size() - 1 : degree;
        int n3 = degree + 1;
        boolean bl = false;
        ArrayList<Float> arrayList = new ArrayList<Float>(n3);
        int n4 = 0;
        int n5 = 0;
        n5 = 0;
        int n6 = n3;
        while (n5 < n6) {
            n2 = n5++;
            n = 0;
            int n7 = n2;
            ArrayList<Float> arrayList2 = arrayList;
            Float f = Float.valueOf(0.0f);
            arrayList2.add(f);
        }
        List coefficients = arrayList;
        int m = x.size();
        int n8 = truncatedDegree + 1;
        Matrix a = new Matrix(n8, m);
        n4 = 0;
        n5 = m + -1;
        if (m != Integer.MIN_VALUE && n4 <= n5) {
            do {
                h2 = n4++;
                a.set(0, h2, 1.0f);
                n2 = 1;
                n = n8 + -1;
                if (n8 == Integer.MIN_VALUE || n2 > n) continue;
                do {
                    int i3 = n2++;
                    a.set(i3, h2, a.get(i3 - 1, h2) * ((Number)x.get(h2)).floatValue());
                } while (n2 <= n);
            } while (n4 <= n5);
        }
        Matrix q = new Matrix(n8, m);
        Matrix r = new Matrix(n8, n8);
        h2 = 0;
        n2 = n8 + -1;
        if (n8 != Integer.MIN_VALUE && h2 <= n2) {
            do {
                float norm;
                int i4;
                j = h2++;
                int i3 = 0;
                int n9 = m + -1;
                if (m != Integer.MIN_VALUE && i3 <= n9) {
                    do {
                        int h3 = i3++;
                        q.set(j, h3, a.get(j, h3));
                    } while (i3 <= n9);
                }
                i3 = 0;
                n9 = j + -1;
                if (j != Integer.MIN_VALUE && i3 <= n9) {
                    do {
                        i4 = i3++;
                        float dot = q.getRow(j).times(q.getRow(i4));
                        int n10 = 0;
                        int n11 = m + -1;
                        if (m == Integer.MIN_VALUE || n10 > n11) continue;
                        do {
                            h = n10++;
                            q.set(j, h, q.get(j, h) - dot * q.get(i4, h));
                        } while (n10 <= n11);
                    } while (i3 <= n9);
                }
                if ((double)(norm = q.getRow(j).norm()) < 1.0E-6) {
                    throw new IllegalArgumentException("Vectors are linearly dependent or zero so no solution. TODO(shepshapard), actually determine what this means");
                }
                float inverseNorm = 1.0f / norm;
                i4 = 0;
                int dot = m + -1;
                if (m != Integer.MIN_VALUE && i4 <= dot) {
                    do {
                        int h4 = i4++;
                        q.set(j, h4, q.get(j, h4) * inverseNorm);
                    } while (i4 <= dot);
                }
                i4 = 0;
                dot = n8 + -1;
                if (n8 == Integer.MIN_VALUE || i4 > dot) continue;
                do {
                    r.set(j, i2, (i2 = i4++) < j ? 0.0f : q.getRow(j).times(a.getRow(i2)));
                } while (i4 <= dot);
            } while (h2 <= n2);
        }
        Vector wy = new Vector(m);
        n2 = 0;
        j = m + -1;
        if (m != Integer.MIN_VALUE && n2 <= j) {
            do {
                int h222 = n2++;
                wy.set(h222, ((Number)y.get(h222)).floatValue() * 1.0f);
            } while (n2 <= j);
        }
        if (0 <= (n2 = n8 - 1)) {
            do {
                i = n2;
                n2 += -1;
                ((Number)coefficients.set(i, Float.valueOf(q.getRow(i).times(wy)))).floatValue();
                int h222 = n8 - 1;
                int inverseNorm = i + 1;
                if (inverseNorm <= h222) {
                    int j2;
                    do {
                        j2 = h222;
                        h222 += -1;
                        List dot = coefficients;
                        i2 = i;
                        ((Number)dot.set(i2, Float.valueOf(((Number)dot.get(i2)).floatValue() - r.get(i, j2) * ((Number)coefficients.get(j2)).floatValue()))).floatValue();
                    } while (j2 != inverseNorm);
                }
                List h222 = coefficients;
                inverseNorm = i;
                ((Number)h222.set(inverseNorm, Float.valueOf(((Number)h222.get(inverseNorm)).floatValue() / r.get(i, i)))).floatValue();
            } while (0 <= n2);
        }
        float yMean = 0.0f;
        i = 0;
        int h222 = m + -1;
        if (m != Integer.MIN_VALUE && i <= h222) {
            do {
                int h5 = i++;
                yMean += ((Number)y.get(h5)).floatValue();
            } while (i <= h222);
        }
        yMean /= (float)m;
        float sumSquaredError = 0.0f;
        float sumSquaredTotal = 0.0f;
        int h5 = 0;
        int n12 = m + -1;
        if (m != Integer.MIN_VALUE && h5 <= n12) {
            do {
                int h6 = h5++;
                float term = 1.0f;
                float err = ((Number)y.get(h6)).floatValue() - ((Number)coefficients.get(0)).floatValue();
                h = 1;
                int n13 = n8 + -1;
                if (n8 != Integer.MIN_VALUE && h <= n13) {
                    do {
                        int i5 = h++;
                        err -= (term *= ((Number)x.get(h6)).floatValue()) * ((Number)coefficients.get(i5)).floatValue();
                    } while (h <= n13);
                }
                sumSquaredError += 1.0f * err * err;
                float v = ((Number)y.get(h6)).floatValue() - yMean;
                sumSquaredTotal += 1.0f * v * v;
            } while (h5 <= n12);
        }
        float confidence = sumSquaredTotal <= 1.0E-6f ? 1.0f : 1.0f - sumSquaredError / sumSquaredTotal;
        return new PolynomialFit(coefficients, confidence);
    }
}

