/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core.gesture.util;

import androidx.ui.core.Duration;
import androidx.ui.core.Durations;
import androidx.ui.core.Px;
import androidx.ui.core.PxPosition;
import androidx.ui.core.Timestamp;
import androidx.ui.core.Velocity;
import androidx.ui.core.gesture.util.PointAtTime;
import androidx.ui.core.gesture.util.PolyFitLeastSquaresKt;
import androidx.ui.core.gesture.util.PolynomialFit;
import androidx.ui.core.gesture.util.VelocityEstimate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0014"}, d2={"Landroidx/ui/core/gesture/util/VelocityTracker;", "", "()V", "index", "", "samples", "", "Landroidx/ui/core/gesture/util/PointAtTime;", "[Landroidx/ui/core/gesture/util/PointAtTime;", "addPosition", "", "time", "Landroidx/ui/core/Timestamp;", "position", "Landroidx/ui/core/PxPosition;", "calculateVelocity", "Landroidx/ui/core/Velocity;", "getVelocityEstimate", "Landroidx/ui/core/gesture/util/VelocityEstimate;", "resetTracking", "ui-framework_release"})
public final class VelocityTracker {
    private final PointAtTime[] samples;
    private int index;

    public VelocityTracker() {
        int n = 0;
        PointAtTime[] pointAtTimeArray = new PointAtTime[20];
        while (n < 20) {
            int n2 = n++;
            pointAtTimeArray[n2] = null;
        }
        this.samples = pointAtTimeArray;
    }

    public final void addPosition(@NotNull Timestamp time, @NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        this.index = (this.index + 1) % 20;
        this.samples[this.index] = new PointAtTime(position, time);
    }

    @NotNull
    public final Velocity calculateVelocity() {
        return new Velocity(this.getVelocityEstimate().getPixelsPerSecond());
    }

    public final void resetTracking() {
        ArraysKt.fill$default((Object[])this.samples, null, (int)0, (int)0, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final VelocityEstimate getVelocityEstimate() {
        PxPosition pxPosition;
        long l;
        void val1$iv$iv$iv;
        void y$iv$iv;
        void x$iv$iv;
        void other$iv;
        void this_$iv;
        PolynomialFit xFit;
        boolean bl;
        PointAtTime pointAtTime;
        PointAtTime newestSample;
        boolean bl2 = false;
        List x = new ArrayList();
        boolean bl3 = false;
        List y = new ArrayList();
        boolean bl4 = false;
        List time = new ArrayList();
        int sampleCount = 0;
        int index = this.index;
        PointAtTime pointAtTime2 = this.samples[index];
        if (pointAtTime2 == null) {
            return VelocityEstimate.Companion.getNone();
        }
        PointAtTime previousSample = newestSample = pointAtTime2;
        PointAtTime oldestSample = newestSample;
        while ((pointAtTime = this.samples[index]) != null) {
            PxPosition this_$iv2;
            PxPosition position;
            PointAtTime sample = pointAtTime;
            float age = Durations.inMilliseconds((Duration)newestSample.getTime().minus(sample.getTime()));
            long l2 = Durations.inMilliseconds((Duration)sample.getTime().minus(previousSample.getTime()));
            boolean bl5 = false;
            float delta = Math.abs(l2);
            previousSample = sample;
            if (age > 100.0f || delta > 40.0f) break;
            oldestSample = sample;
            PxPosition pxPosition2 = position = sample.getPoint();
            List list = x;
            long value$iv$iv = this_$iv2.getValue();
            FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
            int n = (int)(value$iv$iv >> 32);
            bl = false;
            float $this$px$iv$iv = Float.intBitsToFloat(n);
            Px px = new Px($this$px$iv$iv);
            list.add(Float.valueOf(px.getValue()));
            this_$iv2 = position;
            list = y;
            value$iv$iv = this_$iv2.getValue();
            floatCompanionObject = FloatCompanionObject.INSTANCE;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
            bl = false;
            $this$px$iv$iv = Float.intBitsToFloat(n);
            px = new Px($this$px$iv$iv);
            list.add(Float.valueOf(px.getValue()));
            time.add(Float.valueOf(-age));
            index = (index == 0 ? 20 : index) - 1;
            if (++sampleCount < 20) continue;
        }
        if (sampleCount >= 3) {
            try {
                PxPosition pxPosition3;
                long l3;
                void val1$iv$iv$iv2;
                void y$iv$iv2;
                void x$iv$iv2;
                void other$iv2;
                void this_$iv3;
                long l4;
                void val1$iv$iv;
                PxPosition y$iv;
                PxPosition x$iv;
                Px px;
                xFit = PolyFitLeastSquaresKt.polyFitLeastSquares(time, x, 2);
                PolynomialFit yFit = PolyFitLeastSquaresKt.polyFitLeastSquares(time, y, 2);
                float xSlope = ((Number)xFit.getCoefficients().get(1)).floatValue();
                float ySlope = ((Number)yFit.getCoefficients().get(1)).floatValue();
                float $this$px$iv22 = xSlope * (float)1000;
                Px $this$px$iv22 = px = new Px($this$px$iv22);
                float $this$px$iv32 = ySlope * (float)1000;
                Px $this$px$iv32 = px = new Px($this$px$iv32);
                float f = x$iv.getValue();
                float val2$iv$iv = y$iv.getValue();
                void var17_37 = val1$iv$iv;
                bl = false;
                long v1$iv$iv322 = Float.floatToIntBits((float)var17_37);
                float f2 = val2$iv$iv;
                boolean bl6 = false;
                long v2$iv$iv = Float.floatToIntBits(f2);
                long l5 = l4 = v1$iv$iv322 << 32 | v2$iv$iv & 0xFFFFFFFFL;
                px = new PxPosition(l5);
                x$iv = newestSample.getPoint();
                y$iv = oldestSample.getPoint();
                Duration duration = newestSample.getTime().minus(oldestSample.getTime());
                float f3 = xFit.getConfidence() * yFit.getConfidence();
                Px this_$iv$iv = this_$iv3;
                long value$iv$iv$iv = this_$iv$iv.getValue();
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int v1$iv$iv322 = (int)(value$iv$iv$iv >> 32);
                int n = 0;
                float $this$px$iv$iv$iv422 = Float.intBitsToFloat(v1$iv$iv322);
                this_$iv$iv = new Px($this$px$iv$iv$iv422);
                Px this_$iv$iv2 = other$iv2;
                long value$iv$iv$iv2 = this_$iv$iv2.getValue();
                FloatCompanionObject v1$iv$iv322 = FloatCompanionObject.INSTANCE;
                n = (int)(value$iv$iv$iv2 >> 32);
                int $this$px$iv$iv$iv422 = 0;
                float $this$px$iv$iv$iv = Float.intBitsToFloat(n);
                Px other$iv$iv = new Px($this$px$iv$iv$iv);
                this_$iv$iv = new Px(this_$iv$iv.getValue() - other$iv$iv.getValue());
                this_$iv$iv2 = this_$iv3;
                value$iv$iv$iv2 = this_$iv$iv2.getValue();
                v1$iv$iv322 = FloatCompanionObject.INSTANCE;
                n = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
                $this$px$iv$iv$iv422 = 0;
                $this$px$iv$iv$iv = Float.intBitsToFloat(n);
                this_$iv$iv2 = new Px($this$px$iv$iv$iv);
                void this_$iv$iv3 = other$iv2;
                long value$iv$iv$iv3 = this_$iv$iv3.getValue();
                FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
                $this$px$iv$iv$iv422 = (int)(value$iv$iv$iv3 & 0xFFFFFFFFL);
                boolean $this$px$iv$iv$iv3 = false;
                float $this$px$iv$iv$iv2 = Float.intBitsToFloat($this$px$iv$iv$iv422);
                Px other$iv$iv22 = new Px($this$px$iv$iv$iv2);
                this_$iv$iv2 = new Px(this_$iv$iv2.getValue() - other$iv$iv22.getValue());
                float other$iv$iv22 = x$iv$iv2.getValue();
                float val2$iv$iv$iv = y$iv$iv2.getValue();
                void $this$px$iv$iv$iv422 = val1$iv$iv$iv2;
                $this$px$iv$iv$iv3 = false;
                long v1$iv$iv$iv = Float.floatToIntBits((float)$this$px$iv$iv$iv422);
                float f4 = val2$iv$iv$iv;
                boolean bl7 = false;
                long v2$iv$iv$iv = Float.floatToIntBits(f4);
                long l6 = l3 = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
                PxPosition pxPosition4 = pxPosition3 = new PxPosition(l6);
                Duration duration2 = duration;
                float f5 = f3;
                Px px2 = px;
                return new VelocityEstimate((PxPosition)px2, f5, duration2, pxPosition4);
            }
            catch (IllegalArgumentException exception) {
                return VelocityEstimate.Companion.getNone();
            }
        }
        xFit = newestSample.getPoint();
        PxPosition exception = oldestSample.getPoint();
        Duration duration = newestSample.getTime().minus(oldestSample.getTime());
        float f = 1.0f;
        PxPosition pxPosition5 = PxPosition.Companion.getOrigin();
        Px this_$iv$iv = this_$iv;
        long value$iv$iv$iv = this_$iv$iv.getValue();
        FloatCompanionObject other$iv2 = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv$iv >> 32);
        int n2 = 0;
        float $this$px$iv$iv$iv = Float.intBitsToFloat(n);
        this_$iv$iv = new Px($this$px$iv$iv$iv);
        Px this_$iv$iv4 = other$iv;
        long value$iv$iv$iv4 = this_$iv$iv4.getValue();
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv4 >> 32);
        int n3 = 0;
        float $this$px$iv$iv$iv3 = Float.intBitsToFloat(n2);
        Px other$iv$iv = new Px($this$px$iv$iv$iv3);
        this_$iv$iv = new Px(this_$iv$iv.getValue() - other$iv$iv.getValue());
        this_$iv$iv4 = this_$iv;
        value$iv$iv$iv4 = this_$iv$iv4.getValue();
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv4 & 0xFFFFFFFFL);
        n3 = 0;
        $this$px$iv$iv$iv3 = Float.intBitsToFloat(n2);
        this_$iv$iv4 = new Px($this$px$iv$iv$iv3);
        void this_$iv$iv5 = other$iv;
        long value$iv$iv$iv5 = this_$iv$iv5.getValue();
        FloatCompanionObject floatCompanionObject3 = FloatCompanionObject.INSTANCE;
        n3 = (int)(value$iv$iv$iv5 & 0xFFFFFFFFL);
        boolean bl8 = false;
        $this$px$iv$iv$iv = Float.intBitsToFloat(n3);
        Px other$iv$iv32 = new Px($this$px$iv$iv$iv);
        this_$iv$iv4 = new Px(this_$iv$iv4.getValue() - other$iv$iv32.getValue());
        float other$iv$iv32 = x$iv$iv.getValue();
        float val2$iv$iv$iv = y$iv$iv.getValue();
        void var17_40 = val1$iv$iv$iv;
        bl8 = false;
        long v1$iv$iv$iv = Float.floatToIntBits((float)var17_40);
        float f6 = val2$iv$iv$iv;
        boolean bl9 = false;
        long v2$iv$iv$iv = Float.floatToIntBits(f6);
        long l7 = l = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
        PxPosition pxPosition6 = pxPosition = new PxPosition(l7);
        Duration duration3 = duration;
        float f7 = f;
        PxPosition pxPosition7 = pxPosition5;
        return new VelocityEstimate(pxPosition7, f7, duration3, pxPosition6);
    }
}

