/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core.selection;

import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.Px;
import androidx.ui.core.PxPosition;
import androidx.ui.core.gesture.DragObserver;
import androidx.ui.core.selection.Selection;
import androidx.ui.core.selection.SelectionKt;
import androidx.ui.core.selection.SelectionMode;
import androidx.ui.core.selection.SelectionRegistrar;
import androidx.ui.core.selection.TextSelectionHandler;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rJ\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\nJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0010H\u0016J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020,H\u0016R\u0018\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R(\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00060"}, d2={"Landroidx/ui/core/selection/SelectionManager;", "Landroidx/ui/core/selection/SelectionRegistrar;", "()V", "containerLayoutCoordinates", "Landroidx/ui/core/LayoutCoordinates;", "getContainerLayoutCoordinates", "()Landroidx/ui/core/LayoutCoordinates;", "setContainerLayoutCoordinates", "(Landroidx/ui/core/LayoutCoordinates;)V", "dragBeginPosition", "Landroidx/ui/core/PxPosition;", "dragTotalDistance", "draggingHandle", "", "handlers", "", "Landroidx/ui/core/selection/TextSelectionHandler;", "mode", "Landroidx/ui/core/selection/SelectionMode;", "getMode", "()Landroidx/ui/core/selection/SelectionMode;", "setMode", "(Landroidx/ui/core/selection/SelectionMode;)V", "onSelectionChange", "Lkotlin/Function1;", "Landroidx/ui/core/selection/Selection;", "", "getOnSelectionChange", "()Lkotlin/jvm/functions/Function1;", "setOnSelectionChange", "(Lkotlin/jvm/functions/Function1;)V", "selection", "getSelection", "()Landroidx/ui/core/selection/Selection;", "setSelection", "(Landroidx/ui/core/selection/Selection;)V", "getAdjustedCoordinates", "p", "handleDragObserver", "Landroidx/ui/core/gesture/DragObserver;", "dragStartHandle", "onPress", "position", "subscribe", "", "handler", "unsubscribe", "key", "ui-framework_release"})
public final class SelectionManager
implements SelectionRegistrar {
    private Selection selection;
    private Function1<? super Selection, Unit> onSelectionChange = (Function1)new Function1<Selection, Unit>(){

        public final void invoke(@Nullable Selection it) {
        }
    };
    private SelectionMode mode = SelectionMode.Vertical;
    @Nullable
    public LayoutCoordinates containerLayoutCoordinates;
    private final Set<TextSelectionHandler> handlers;
    private PxPosition dragBeginPosition;
    private PxPosition dragTotalDistance;
    private boolean draggingHandle;

    public SelectionManager() {
        Set set;
        SelectionManager selectionManager = this;
        boolean bl = false;
        selectionManager.handlers = set = (Set)new LinkedHashSet();
        this.dragBeginPosition = PxPosition.Companion.getOrigin();
        this.dragTotalDistance = PxPosition.Companion.getOrigin();
    }

    @Nullable
    public final Selection getSelection() {
        return this.selection;
    }

    public final void setSelection(@Nullable Selection selection) {
        this.selection = selection;
    }

    @NotNull
    public final Function1<Selection, Unit> getOnSelectionChange() {
        return this.onSelectionChange;
    }

    public final void setOnSelectionChange(@NotNull Function1<? super Selection, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.onSelectionChange = function1;
    }

    @NotNull
    public final SelectionMode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull SelectionMode selectionMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)selectionMode), (String)"<set-?>");
        this.mode = selectionMode;
    }

    @NotNull
    public final LayoutCoordinates getContainerLayoutCoordinates() {
        LayoutCoordinates layoutCoordinates2 = this.containerLayoutCoordinates;
        if (layoutCoordinates2 != null) {
            return layoutCoordinates2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"containerLayoutCoordinates");
        Void cfr_ignored_0 = (Void)Unit.INSTANCE;
        return null;
    }

    public final void setContainerLayoutCoordinates(@NotNull LayoutCoordinates layoutCoordinates2) {
        Intrinsics.checkParameterIsNotNull((Object)layoutCoordinates2, (String)"<set-?>");
        this.containerLayoutCoordinates = layoutCoordinates2;
    }

    @Override
    @NotNull
    public Object subscribe(@NotNull TextSelectionHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        this.handlers.add(handler);
        return handler;
    }

    @Override
    public void unsubscribe(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.handlers.remove((TextSelectionHandler)key);
    }

    public final void onPress(@NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (this.draggingHandle) {
            return;
        }
        Selection result = null;
        for (TextSelectionHandler handler : this.handlers) {
            result = SelectionKt.plus(result, handler.getSelection((Pair<PxPosition, PxPosition>)new Pair((Object)position, (Object)position), this.getContainerLayoutCoordinates(), this.getMode()));
        }
        this.getOnSelectionChange().invoke((Object)result);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PxPosition getAdjustedCoordinates(@NotNull PxPosition p) {
        long l;
        void val1$iv$iv;
        void x$iv;
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        PxPosition this_$iv = p;
        long value$iv$iv = this_$iv.getValue();
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv >> 32);
        int n2 = 0;
        float $this$px$iv$iv22 = Float.intBitsToFloat(n);
        this_$iv = new Px($this$px$iv$iv22);
        PxPosition this_$iv2 = p;
        long value$iv$iv2 = this_$iv2.getValue();
        FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $this$px$iv$iv22 = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n2);
        this_$iv2 = new Px($this$px$iv$iv);
        boolean $this$px$iv = true;
        Px other$iv22 = new Px((float)$this$px$iv);
        Px y$iv = new Px(this_$iv2.getValue() - other$iv22.getValue());
        float other$iv22 = x$iv.getValue();
        float val2$iv$iv = y$iv.getValue();
        void var6_9 = val1$iv$iv;
        n2 = 0;
        long v1$iv$iv = Float.floatToIntBits((float)var6_9);
        float f = val2$iv$iv;
        boolean bl = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new PxPosition(l2);
    }

    @NotNull
    public final DragObserver handleDragObserver(boolean dragStartHandle) {
        return new DragObserver(dragStartHandle, this){
            private final /* synthetic */ boolean $dragStartHandle;
            private final /* synthetic */ SelectionManager $this$handleDragObserver;
            {
                this.$dragStartHandle = $dragStartHandle;
                this.$this$handleDragObserver = $receiver;
            }

            public void onStart(@NotNull PxPosition downPosition) {
                PxPosition pxPosition;
                LayoutCoordinates layoutCoordinates2;
                Intrinsics.checkParameterIsNotNull((Object)downPosition, (String)"downPosition");
                if (this.$dragStartHandle) {
                    Selection selection = this.$this$handleDragObserver.getSelection();
                    if (selection == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((layoutCoordinates2 = selection.getStartLayoutCoordinates()) == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    Selection selection = this.$this$handleDragObserver.getSelection();
                    if (selection == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((layoutCoordinates2 = selection.getEndLayoutCoordinates()) == null) {
                        Intrinsics.throwNpe();
                    }
                }
                LayoutCoordinates beginLayoutCoordinates = layoutCoordinates2;
                if (this.$dragStartHandle) {
                    Selection selection = this.$this$handleDragObserver.getSelection();
                    if (selection == null) {
                        Intrinsics.throwNpe();
                    }
                    pxPosition = selection.getStartCoordinates();
                } else {
                    Selection selection = this.$this$handleDragObserver.getSelection();
                    if (selection == null) {
                        Intrinsics.throwNpe();
                    }
                    pxPosition = selection.getEndCoordinates();
                }
                PxPosition beginCoordinates = this.$this$handleDragObserver.getAdjustedCoordinates(pxPosition);
                SelectionManager.access$prop$setDragBeginPosition$0(this.$this$handleDragObserver, this.$this$handleDragObserver.getContainerLayoutCoordinates().childToLocal(beginLayoutCoordinates, beginCoordinates));
                SelectionManager.access$prop$setDragTotalDistance$1(this.$this$handleDragObserver, PxPosition.Companion.getOrigin());
                SelectionManager.access$prop$setDraggingHandle$2(this.$this$handleDragObserver, true);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public PxPosition onDrag(@NotNull PxPosition dragDistance) {
                PxPosition pxPosition;
                PxPosition currentStart;
                PxPosition pxPosition2;
                PxPosition other$iv;
                long l;
                void val1$iv$iv$iv;
                void y$iv$iv;
                void x$iv$iv;
                PxPosition this_$iv;
                Intrinsics.checkParameterIsNotNull((Object)dragDistance, (String)"dragDistance");
                Selection result = this.$this$handleDragObserver.getSelection();
                SelectionManager selectionManager = this.$this$handleDragObserver;
                PxPosition pxPosition3 = SelectionManager.access$prop$getDragTotalDistance$3(selectionManager);
                SelectionManager selectionManager2 = selectionManager;
                Px this_$iv$iv = this_$iv;
                long value$iv$iv$iv = this_$iv$iv.getValue();
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = (int)(value$iv$iv$iv >> 32);
                int n2 = 0;
                float $this$px$iv$iv$iv = Float.intBitsToFloat(n);
                this_$iv$iv = new Px($this$px$iv$iv$iv);
                PxPosition this_$iv$iv2 = dragDistance;
                long value$iv$iv$iv2 = this_$iv$iv2.getValue();
                FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
                n2 = (int)(value$iv$iv$iv2 >> 32);
                int n3 = 0;
                float $this$px$iv$iv$iv2 = Float.intBitsToFloat(n2);
                Px other$iv$iv = new Px($this$px$iv$iv$iv2);
                this_$iv$iv = new Px(this_$iv$iv.getValue() + other$iv$iv.getValue());
                this_$iv$iv2 = this_$iv;
                value$iv$iv$iv2 = this_$iv$iv2.getValue();
                floatCompanionObject2 = FloatCompanionObject.INSTANCE;
                n2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
                n3 = 0;
                $this$px$iv$iv$iv2 = Float.intBitsToFloat(n2);
                this_$iv$iv2 = new Px($this$px$iv$iv$iv2);
                PxPosition this_$iv$iv3 = dragDistance;
                long value$iv$iv$iv3 = this_$iv$iv3.getValue();
                FloatCompanionObject floatCompanionObject3 = FloatCompanionObject.INSTANCE;
                n3 = (int)(value$iv$iv$iv3 & 0xFFFFFFFFL);
                boolean $this$px$iv$iv$iv22 = false;
                float $this$px$iv$iv$iv3 = Float.intBitsToFloat(n3);
                Px other$iv$iv22 = new Px($this$px$iv$iv$iv3);
                this_$iv$iv2 = new Px(this_$iv$iv2.getValue() + other$iv$iv22.getValue());
                float other$iv$iv22 = x$iv$iv.getValue();
                float val2$iv$iv$iv = y$iv$iv.getValue();
                void var11_23 = val1$iv$iv$iv;
                $this$px$iv$iv$iv22 = false;
                long v1$iv$iv$iv = Float.floatToIntBits((float)var11_23);
                float f = val2$iv$iv$iv;
                boolean bl = false;
                long v2$iv$iv$iv = Float.floatToIntBits(f);
                long l2 = l = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
                PxPosition pxPosition4 = new PxPosition(l2);
                SelectionManager.access$prop$setDragTotalDistance$1(selectionManager2, pxPosition4);
                if (this.$dragStartHandle) {
                    long l3;
                    void val1$iv$iv$iv2;
                    void y$iv$iv2;
                    void x$iv$iv2;
                    this_$iv = SelectionManager.access$prop$getDragBeginPosition$4(this.$this$handleDragObserver);
                    other$iv = SelectionManager.access$prop$getDragTotalDistance$3(this.$this$handleDragObserver);
                    PxPosition this_$iv$iv4 = this_$iv;
                    long value$iv$iv$iv4 = this_$iv$iv4.getValue();
                    floatCompanionObject2 = FloatCompanionObject.INSTANCE;
                    int n4 = (int)(value$iv$iv$iv4 >> 32);
                    int n5 = 0;
                    float $this$px$iv$iv$iv4 = Float.intBitsToFloat(n4);
                    this_$iv$iv4 = new Px($this$px$iv$iv$iv4);
                    PxPosition this_$iv$iv5 = other$iv;
                    long value$iv$iv$iv5 = this_$iv$iv5.getValue();
                    floatCompanionObject3 = FloatCompanionObject.INSTANCE;
                    n5 = (int)(value$iv$iv$iv5 >> 32);
                    int n6 = 0;
                    float $this$px$iv$iv$iv5 = Float.intBitsToFloat(n5);
                    Px other$iv$iv3 = new Px($this$px$iv$iv$iv5);
                    this_$iv$iv4 = new Px(this_$iv$iv4.getValue() + other$iv$iv3.getValue());
                    this_$iv$iv5 = this_$iv;
                    value$iv$iv$iv5 = this_$iv$iv5.getValue();
                    floatCompanionObject3 = FloatCompanionObject.INSTANCE;
                    n5 = (int)(value$iv$iv$iv5 & 0xFFFFFFFFL);
                    n6 = 0;
                    $this$px$iv$iv$iv5 = Float.intBitsToFloat(n5);
                    this_$iv$iv5 = new Px($this$px$iv$iv$iv5);
                    PxPosition this_$iv$iv6 = other$iv;
                    long value$iv$iv$iv6 = this_$iv$iv6.getValue();
                    FloatCompanionObject floatCompanionObject4 = FloatCompanionObject.INSTANCE;
                    n6 = (int)(value$iv$iv$iv6 & 0xFFFFFFFFL);
                    boolean bl2 = false;
                    float $this$px$iv$iv$iv6 = Float.intBitsToFloat(n6);
                    Px other$iv$iv322 = new Px($this$px$iv$iv$iv6);
                    this_$iv$iv5 = new Px(this_$iv$iv5.getValue() + other$iv$iv322.getValue());
                    float other$iv$iv322 = x$iv$iv2.getValue();
                    float val2$iv$iv$iv2 = y$iv$iv2.getValue();
                    void var12_31 = val1$iv$iv$iv2;
                    bl2 = false;
                    long v1$iv$iv$iv2 = Float.floatToIntBits((float)var12_31);
                    float f2 = val2$iv$iv$iv2;
                    boolean bl3 = false;
                    long v2$iv$iv$iv2 = Float.floatToIntBits(f2);
                    long l4 = l3 = v1$iv$iv$iv2 << 32 | v2$iv$iv$iv2 & 0xFFFFFFFFL;
                    pxPosition2 = new PxPosition(l4);
                } else {
                    LayoutCoordinates layoutCoordinates2 = this.$this$handleDragObserver.getContainerLayoutCoordinates();
                    Selection selection = this.$this$handleDragObserver.getSelection();
                    if (selection == null) {
                        Intrinsics.throwNpe();
                    }
                    LayoutCoordinates layoutCoordinates3 = selection.getStartLayoutCoordinates();
                    if (layoutCoordinates3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Selection selection2 = this.$this$handleDragObserver.getSelection();
                    if (selection2 == null) {
                        Intrinsics.throwNpe();
                    }
                    pxPosition2 = currentStart = layoutCoordinates2.childToLocal(layoutCoordinates3, this.$this$handleDragObserver.getAdjustedCoordinates(selection2.getStartCoordinates()));
                }
                if (this.$dragStartHandle) {
                    LayoutCoordinates layoutCoordinates4 = this.$this$handleDragObserver.getContainerLayoutCoordinates();
                    Selection selection = this.$this$handleDragObserver.getSelection();
                    if (selection == null) {
                        Intrinsics.throwNpe();
                    }
                    LayoutCoordinates layoutCoordinates5 = selection.getEndLayoutCoordinates();
                    if (layoutCoordinates5 == null) {
                        Intrinsics.throwNpe();
                    }
                    Selection selection3 = this.$this$handleDragObserver.getSelection();
                    if (selection3 == null) {
                        Intrinsics.throwNpe();
                    }
                    pxPosition = layoutCoordinates4.childToLocal(layoutCoordinates5, this.$this$handleDragObserver.getAdjustedCoordinates(selection3.getEndCoordinates()));
                } else {
                    void val1$iv$iv$iv3;
                    void y$iv$iv3;
                    void x$iv$iv3;
                    void this_$iv2;
                    other$iv = SelectionManager.access$prop$getDragBeginPosition$4(this.$this$handleDragObserver);
                    PxPosition other$iv2 = SelectionManager.access$prop$getDragTotalDistance$3(this.$this$handleDragObserver);
                    Px this_$iv$iv7 = this_$iv2;
                    long value$iv$iv$iv7 = this_$iv$iv7.getValue();
                    floatCompanionObject3 = FloatCompanionObject.INSTANCE;
                    int n7 = (int)(value$iv$iv$iv7 >> 32);
                    int n8 = 0;
                    float $this$px$iv$iv$iv7 = Float.intBitsToFloat(n7);
                    this_$iv$iv7 = new Px($this$px$iv$iv$iv7);
                    PxPosition this_$iv$iv8 = other$iv2;
                    long value$iv$iv$iv8 = this_$iv$iv8.getValue();
                    FloatCompanionObject floatCompanionObject5 = FloatCompanionObject.INSTANCE;
                    n8 = (int)(value$iv$iv$iv8 >> 32);
                    int n9 = 0;
                    float $this$px$iv$iv$iv8 = Float.intBitsToFloat(n8);
                    Px other$iv$iv4 = new Px($this$px$iv$iv$iv8);
                    this_$iv$iv7 = new Px(this_$iv$iv7.getValue() + other$iv$iv4.getValue());
                    this_$iv$iv8 = this_$iv2;
                    value$iv$iv$iv8 = this_$iv$iv8.getValue();
                    floatCompanionObject5 = FloatCompanionObject.INSTANCE;
                    n8 = (int)(value$iv$iv$iv8 & 0xFFFFFFFFL);
                    n9 = 0;
                    $this$px$iv$iv$iv8 = Float.intBitsToFloat(n8);
                    this_$iv$iv8 = new Px($this$px$iv$iv$iv8);
                    PxPosition this_$iv$iv9 = other$iv2;
                    long value$iv$iv$iv9 = this_$iv$iv9.getValue();
                    FloatCompanionObject floatCompanionObject6 = FloatCompanionObject.INSTANCE;
                    n9 = (int)(value$iv$iv$iv9 & 0xFFFFFFFFL);
                    boolean bl4 = false;
                    float $this$px$iv$iv$iv9 = Float.intBitsToFloat(n9);
                    Px other$iv$iv422 = new Px($this$px$iv$iv$iv9);
                    this_$iv$iv8 = new Px(this_$iv$iv8.getValue() + other$iv$iv422.getValue());
                    float other$iv$iv422 = x$iv$iv3.getValue();
                    float val2$iv$iv$iv3 = y$iv$iv3.getValue();
                    void var13_38 = val1$iv$iv$iv3;
                    bl4 = false;
                    long v1$iv$iv$iv3 = Float.floatToIntBits((float)var13_38);
                    float f3 = val2$iv$iv$iv3;
                    boolean bl5 = false;
                    long v2$iv$iv$iv3 = Float.floatToIntBits(f3);
                    long l5 = l2 = v1$iv$iv$iv3 << 32 | v2$iv$iv$iv3 & 0xFFFFFFFFL;
                    pxPosition = new PxPosition(l5);
                }
                PxPosition currentEnd = pxPosition;
                for (TextSelectionHandler handler : SelectionManager.access$prop$getHandlers$5(this.$this$handleDragObserver)) {
                    result = SelectionKt.plus(result, handler.getSelection((Pair<PxPosition, PxPosition>)new Pair((Object)currentStart, (Object)currentEnd), this.$this$handleDragObserver.getContainerLayoutCoordinates(), this.$this$handleDragObserver.getMode()));
                }
                this.$this$handleDragObserver.getOnSelectionChange().invoke((Object)result);
                return dragDistance;
            }

            public void onStop(@NotNull PxPosition velocity) {
                Intrinsics.checkParameterIsNotNull((Object)velocity, (String)"velocity");
                DragObserver.DefaultImpls.onStop(this, velocity);
                SelectionManager.access$prop$setDraggingHandle$2(this.$this$handleDragObserver, false);
            }
        };
    }

    public static final /* synthetic */ void access$prop$setDragBeginPosition$0(SelectionManager $this, PxPosition value2) {
        $this.dragBeginPosition = value2;
    }

    public static final /* synthetic */ void access$prop$setDragTotalDistance$1(SelectionManager $this, PxPosition value2) {
        $this.dragTotalDistance = value2;
    }

    public static final /* synthetic */ void access$prop$setDraggingHandle$2(SelectionManager $this, boolean value2) {
        $this.draggingHandle = value2;
    }

    public static final /* synthetic */ PxPosition access$prop$getDragTotalDistance$3(SelectionManager $this) {
        return $this.dragTotalDistance;
    }

    public static final /* synthetic */ PxPosition access$prop$getDragBeginPosition$4(SelectionManager $this) {
        return $this.dragBeginPosition;
    }

    public static final /* synthetic */ Set access$prop$getHandlers$5(SelectionManager $this) {
        return $this.handlers;
    }
}

