/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core.selection;

import androidx.ui.core.Px;
import androidx.ui.core.PxPosition;
import androidx.ui.core.selection.SelectionMode;
import androidx.ui.text.TextDelegate;
import androidx.ui.text.TextRange;
import androidx.ui.text.style.TextDirection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\"\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ,\u0010?\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u000fH\u0002J\u0018\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020#2\u0006\u0010A\u001a\u00020\u000fH\u0002J\b\u0010D\u001a\u00020\nH\u0002R\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0011\"\u0004\b*\u0010\u0013R\u000e\u0010+\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R(\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0019\"\u0004\b6\u0010\u001bR\u001a\u00107\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001f\"\u0004\b9\u0010!R\u001a\u0010:\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010%\"\u0004\b<\u0010'R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>\u00a8\u0006E"}, d2={"Landroidx/ui/core/selection/TextSelectionProcessor;", "", "selectionCoordinates", "Lkotlin/Pair;", "Landroidx/ui/core/PxPosition;", "mode", "Landroidx/ui/core/selection/SelectionMode;", "onSelectionChange", "Lkotlin/Function1;", "Landroidx/ui/text/TextRange;", "", "textDelegate", "Landroidx/ui/text/TextDelegate;", "(Lkotlin/Pair;Landroidx/ui/core/selection/SelectionMode;Lkotlin/jvm/functions/Function1;Landroidx/ui/text/TextDelegate;)V", "containsWholeSelectionEnd", "", "getContainsWholeSelectionEnd$ui_framework_release", "()Z", "setContainsWholeSelectionEnd$ui_framework_release", "(Z)V", "containsWholeSelectionStart", "getContainsWholeSelectionStart$ui_framework_release", "setContainsWholeSelectionStart$ui_framework_release", "endCoordinates", "getEndCoordinates$ui_framework_release", "()Landroidx/ui/core/PxPosition;", "setEndCoordinates$ui_framework_release", "(Landroidx/ui/core/PxPosition;)V", "endDirection", "Landroidx/ui/text/style/TextDirection;", "getEndDirection$ui_framework_release", "()Landroidx/ui/text/style/TextDirection;", "setEndDirection$ui_framework_release", "(Landroidx/ui/text/style/TextDirection;)V", "endOffset", "", "getEndOffset$ui_framework_release", "()I", "setEndOffset$ui_framework_release", "(I)V", "isSelected", "isSelected$ui_framework_release", "setSelected$ui_framework_release", "length", "getMode", "()Landroidx/ui/core/selection/SelectionMode;", "getOnSelectionChange", "()Lkotlin/jvm/functions/Function1;", "setOnSelectionChange", "(Lkotlin/jvm/functions/Function1;)V", "getSelectionCoordinates", "()Lkotlin/Pair;", "startCoordinates", "getStartCoordinates$ui_framework_release", "setStartCoordinates$ui_framework_release", "startDirection", "getStartDirection$ui_framework_release", "setStartDirection$ui_framework_release", "startOffset", "getStartOffset$ui_framework_release", "setStartOffset$ui_framework_release", "getTextDelegate", "()Landroidx/ui/text/TextDelegate;", "getSelectionBorder", "position", "isStart", "getSelectionHandleCoordinates", "offset", "processTextSelection", "ui-framework_release"})
public final class TextSelectionProcessor {
    private final Pair<PxPosition, PxPosition> selectionCoordinates;
    private final SelectionMode mode;
    private Function1<? super TextRange, Unit> onSelectionChange;
    private final TextDelegate textDelegate;
    private PxPosition startCoordinates;
    private PxPosition endCoordinates;
    private int startOffset;
    private int endOffset;
    private TextDirection startDirection;
    private TextDirection endDirection;
    private boolean containsWholeSelectionStart;
    private boolean containsWholeSelectionEnd;
    private boolean isSelected;
    private final int length;

    public TextSelectionProcessor(@NotNull Pair<PxPosition, PxPosition> selectionCoordinates, @NotNull SelectionMode mode, @NotNull Function1<? super TextRange, Unit> onSelectionChange2, @NotNull TextDelegate textDelegate2) {
        Intrinsics.checkParameterIsNotNull(selectionCoordinates, (String)"selectionCoordinates");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        Intrinsics.checkParameterIsNotNull(onSelectionChange2, (String)"onSelectionChange");
        Intrinsics.checkParameterIsNotNull((Object)textDelegate2, (String)"textDelegate");
        this.selectionCoordinates = selectionCoordinates;
        this.mode = mode;
        this.onSelectionChange = onSelectionChange2;
        this.textDelegate = textDelegate2;
        this.startCoordinates = PxPosition.Companion.getOrigin();
        this.endCoordinates = PxPosition.Companion.getOrigin();
        this.startDirection = TextDirection.Ltr;
        this.endDirection = TextDirection.Ltr;
        this.length = this.getTextDelegate().getText().getText().length();
        this.processTextSelection();
    }

    public /* synthetic */ TextSelectionProcessor(Pair selectionCoordinates, SelectionMode mode, Function1 onSelectionChange2, TextDelegate textDelegate2, int $mask0, DefaultConstructorMarker $marker) {
        Function1 function1 = ($mask0 & 4) != 0 ? (Function1)new Function1<TextRange, Unit>(){

            public final void invoke(@Nullable TextRange it) {
            }
        } : onSelectionChange2;
        this((Pair<PxPosition, PxPosition>)selectionCoordinates, mode, (Function1<? super TextRange, Unit>)function1, textDelegate2);
    }

    @NotNull
    public final Pair<PxPosition, PxPosition> getSelectionCoordinates() {
        return this.selectionCoordinates;
    }

    @NotNull
    public final SelectionMode getMode() {
        return this.mode;
    }

    @NotNull
    public final Function1<TextRange, Unit> getOnSelectionChange() {
        return this.onSelectionChange;
    }

    public final void setOnSelectionChange(@NotNull Function1<? super TextRange, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.onSelectionChange = function1;
    }

    @NotNull
    public final TextDelegate getTextDelegate() {
        return this.textDelegate;
    }

    @NotNull
    public final PxPosition getStartCoordinates$ui_framework_release() {
        return this.startCoordinates;
    }

    public final void setStartCoordinates$ui_framework_release(@NotNull PxPosition pxPosition) {
        Intrinsics.checkParameterIsNotNull((Object)pxPosition, (String)"<set-?>");
        this.startCoordinates = pxPosition;
    }

    @NotNull
    public final PxPosition getEndCoordinates$ui_framework_release() {
        return this.endCoordinates;
    }

    public final void setEndCoordinates$ui_framework_release(@NotNull PxPosition pxPosition) {
        Intrinsics.checkParameterIsNotNull((Object)pxPosition, (String)"<set-?>");
        this.endCoordinates = pxPosition;
    }

    public final int getStartOffset$ui_framework_release() {
        return this.startOffset;
    }

    public final void setStartOffset$ui_framework_release(int n) {
        this.startOffset = n;
    }

    public final int getEndOffset$ui_framework_release() {
        return this.endOffset;
    }

    public final void setEndOffset$ui_framework_release(int n) {
        this.endOffset = n;
    }

    @NotNull
    public final TextDirection getStartDirection$ui_framework_release() {
        return this.startDirection;
    }

    public final void setStartDirection$ui_framework_release(@NotNull TextDirection textDirection) {
        Intrinsics.checkParameterIsNotNull((Object)textDirection, (String)"<set-?>");
        this.startDirection = textDirection;
    }

    @NotNull
    public final TextDirection getEndDirection$ui_framework_release() {
        return this.endDirection;
    }

    public final void setEndDirection$ui_framework_release(@NotNull TextDirection textDirection) {
        Intrinsics.checkParameterIsNotNull((Object)textDirection, (String)"<set-?>");
        this.endDirection = textDirection;
    }

    public final boolean getContainsWholeSelectionStart$ui_framework_release() {
        return this.containsWholeSelectionStart;
    }

    public final void setContainsWholeSelectionStart$ui_framework_release(boolean bl) {
        this.containsWholeSelectionStart = bl;
    }

    public final boolean getContainsWholeSelectionEnd$ui_framework_release() {
        return this.containsWholeSelectionEnd;
    }

    public final void setContainsWholeSelectionEnd$ui_framework_release(boolean bl) {
        this.containsWholeSelectionEnd = bl;
    }

    public final boolean isSelected$ui_framework_release() {
        return this.isSelected;
    }

    public final void setSelected$ui_framework_release(boolean bl) {
        this.isSelected = bl;
    }

    private final void processTextSelection() {
        PxPosition startPx = (PxPosition)this.getSelectionCoordinates().getFirst();
        PxPosition endPx = (PxPosition)this.getSelectionCoordinates().getSecond();
        if (!this.getMode().isSelected$ui_framework_release(this.getTextDelegate(), startPx, endPx)) {
            this.getOnSelectionChange().invoke(null);
            return;
        }
        this.setSelected$ui_framework_release(true);
        Pair<Integer, Boolean> pair = this.getSelectionBorder(this.getTextDelegate(), startPx, true);
        int textSelectionStart = ((Number)pair.component1()).intValue();
        boolean containsWholeSelectionStart = (Boolean)pair.component2();
        Pair<Integer, Boolean> pair2 = this.getSelectionBorder(this.getTextDelegate(), endPx, false);
        int textSelectionEnd = ((Number)pair2.component1()).intValue();
        boolean containsWholeSelectionEnd = (Boolean)pair2.component2();
        if (textSelectionStart == textSelectionEnd) {
            TextRange wordBoundary = this.getTextDelegate().getWordBoundary(textSelectionStart);
            textSelectionStart = wordBoundary.getStart();
            textSelectionEnd = wordBoundary.getEnd();
        }
        this.getOnSelectionChange().invoke((Object)new TextRange(textSelectionStart, textSelectionEnd));
        this.setStartCoordinates$ui_framework_release(this.getSelectionHandleCoordinates(textSelectionStart, true));
        this.setEndCoordinates$ui_framework_release(this.getSelectionHandleCoordinates(textSelectionEnd, false));
        this.setStartOffset$ui_framework_release(textSelectionStart);
        this.setEndOffset$ui_framework_release(textSelectionEnd);
        this.setStartDirection$ui_framework_release(this.getTextDelegate().getBidiRunDirection(textSelectionStart));
        this.setEndDirection$ui_framework_release(this.getTextDelegate().getBidiRunDirection(Math.max(textSelectionEnd - 1, 0)));
        this.setContainsWholeSelectionStart$ui_framework_release(containsWholeSelectionStart);
        this.setContainsWholeSelectionEnd$ui_framework_release(containsWholeSelectionEnd);
    }

    private final Pair<Integer, Boolean> getSelectionBorder(TextDelegate textDelegate2, PxPosition position, boolean isStart) {
        int n;
        if (isStart) {
            n = 0;
        } else {
            int n2 = this.length - 1;
            int n3 = 0;
            boolean bl = false;
            n = Math.max(n2, n3);
        }
        int selectionBorder = n;
        boolean containsWholeSelectionBorder = false;
        boolean $this$px$iv = false;
        Px top = new Px((float)$this$px$iv);
        float $this$px$iv2 = textDelegate2.getHeight();
        Px bottom = new Px($this$px$iv2);
        boolean $this$px$iv3 = false;
        Px left = new Px((float)$this$px$iv3);
        float $this$px$iv4 = textDelegate2.getWidth();
        Px right = new Px($this$px$iv4);
        PxPosition this_$iv = position;
        long value$iv$iv = this_$iv.getValue();
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n4 = (int)(value$iv$iv >> 32);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n4);
        this_$iv = new Px($this$px$iv$iv);
        if (Float.compare(this_$iv.getValue(), left.getValue()) >= 0) {
            this_$iv = position;
            value$iv$iv = this_$iv.getValue();
            floatCompanionObject = FloatCompanionObject.INSTANCE;
            n4 = (int)(value$iv$iv >> 32);
            bl = false;
            $this$px$iv$iv = Float.intBitsToFloat(n4);
            this_$iv = new Px($this$px$iv$iv);
            if (Float.compare(this_$iv.getValue(), right.getValue()) < 0) {
                this_$iv = position;
                value$iv$iv = this_$iv.getValue();
                floatCompanionObject = FloatCompanionObject.INSTANCE;
                n4 = (int)(value$iv$iv & 0xFFFFFFFFL);
                bl = false;
                $this$px$iv$iv = Float.intBitsToFloat(n4);
                this_$iv = new Px($this$px$iv$iv);
                if (Float.compare(this_$iv.getValue(), top.getValue()) >= 0) {
                    this_$iv = position;
                    value$iv$iv = this_$iv.getValue();
                    floatCompanionObject = FloatCompanionObject.INSTANCE;
                    n4 = (int)(value$iv$iv & 0xFFFFFFFFL);
                    bl = false;
                    $this$px$iv$iv = Float.intBitsToFloat(n4);
                    this_$iv = new Px($this$px$iv$iv);
                    if (Float.compare(this_$iv.getValue(), bottom.getValue()) < 0) {
                        int constrainedSelectionBorderOffset;
                        selectionBorder = constrainedSelectionBorderOffset = RangesKt.coerceIn((int)textDelegate2.getOffsetForPosition(position), (int)0, (int)(this.length - 1));
                        containsWholeSelectionBorder = true;
                    }
                }
            }
        }
        return new Pair((Object)selectionBorder, (Object)containsWholeSelectionBorder);
    }

    /*
     * WARNING - void declaration
     */
    private final PxPosition getSelectionHandleCoordinates(int offset, boolean isStart) {
        long l;
        void val1$iv$iv;
        void y$iv;
        void x$iv;
        int line = this.getTextDelegate().getLineForOffset(offset);
        int offsetToCheck = isStart ? offset : Math.max(offset - 1, 0);
        TextDirection bidiRunDirection = this.getTextDelegate().getBidiRunDirection(offsetToCheck);
        TextDirection paragraphDirection = this.getTextDelegate().getParagraphDirection(offset);
        float x = Intrinsics.areEqual((Object)bidiRunDirection, (Object)paragraphDirection) ? this.getTextDelegate().getPrimaryHorizontal(offset) : this.getTextDelegate().getSecondaryHorizontal(offset);
        float y = this.getTextDelegate().getLineBottom(line);
        float $this$px$iv22 = x;
        Px $this$px$iv22 = new Px($this$px$iv22);
        float $this$px$iv32 = y;
        Px $this$px$iv32 = new Px($this$px$iv32);
        float f = x$iv.getValue();
        float val2$iv$iv = y$iv.getValue();
        void var13_15 = val1$iv$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var13_15);
        float f2 = val2$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new PxPosition(l2);
    }
}

