/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vector;

import androidx.ui.core.Px;
import androidx.ui.graphics.Brush;
import androidx.ui.graphics.StrokeCap;
import androidx.ui.graphics.StrokeJoin;
import androidx.ui.graphics.vector.PathNode;
import androidx.ui.graphics.vector.VectorAsset;
import androidx.ui.graphics.vector.VectorGroup;
import androidx.ui.graphics.vector.VectorKt;
import androidx.ui.graphics.vector.VectorPath;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJw\u0010\u001d\u001a\u00020\u00002\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\b\b\u0002\u0010#\u001a\u00020\b2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\"2\b\b\u0002\u0010%\u001a\u00020\b2\b\b\u0002\u0010&\u001a\u00020\b2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\b\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u0000Jk\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u00020\b2\b\b\u0002\u00104\u001a\u00020\b2\b\b\u0002\u00105\u001a\u00020\b2\b\b\u0002\u00106\u001a\u00020\b2\b\b\u0002\u00107\u001a\u00020\b2\b\b\u0002\u00108\u001a\u00020\b2\b\b\u0002\u00109\u001a\u00020\b2\u000e\b\u0002\u0010:\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\u0010;R \u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001b\u00a8\u0006<"}, d2={"Landroidx/ui/graphics/vector/VectorAssetBuilder;", "", "name", "", "defaultWidth", "Landroidx/ui/core/Px;", "defaultHeight", "viewportWidth", "", "viewportHeight", "(Ljava/lang/String;Landroidx/ui/core/Px;Landroidx/ui/core/Px;FF)V", "<set-?>", "Landroidx/ui/graphics/vector/VectorGroup;", "currentGroup", "getCurrentGroup", "()Landroidx/ui/graphics/vector/VectorGroup;", "getDefaultHeight", "()Landroidx/ui/core/Px;", "getDefaultWidth", "isConsumed", "", "getName", "()Ljava/lang/String;", "nodes", "Ljava/util/Stack;", "root", "getViewportHeight", "()F", "getViewportWidth", "addPath", "pathData", "", "Landroidx/ui/graphics/vector/PathNode;", "fill", "Landroidx/ui/graphics/Brush;", "fillAlpha", "stroke", "strokeAlpha", "strokeLineWidth", "strokeLineCap", "Landroidx/ui/graphics/StrokeCap;", "strokeLineJoin", "Landroidx/ui/graphics/StrokeJoin;", "strokeLineMiter", "([Landroidx/ui/graphics/vector/PathNode;Ljava/lang/String;Landroidx/ui/graphics/Brush;FLandroidx/ui/graphics/Brush;FFLandroidx/ui/graphics/StrokeCap;Landroidx/ui/graphics/StrokeJoin;F)Landroidx/ui/graphics/vector/VectorAssetBuilder;", "build", "Landroidx/ui/graphics/vector/VectorAsset;", "ensureNotConsumed", "", "popGroup", "pushGroup", "rotate", "pivotX", "pivotY", "scaleX", "scaleY", "translationX", "translationY", "clipPathData", "(Ljava/lang/String;FFFFFFF[Landroidx/ui/graphics/vector/PathNode;)Landroidx/ui/graphics/vector/VectorAssetBuilder;", "ui-framework_release"})
public final class VectorAssetBuilder {
    private final String name;
    private final Px defaultWidth;
    private final Px defaultHeight;
    private final float viewportWidth;
    private final float viewportHeight;
    private final Stack<VectorGroup> nodes;
    private VectorGroup root;
    private boolean isConsumed;
    private VectorGroup currentGroup;

    public VectorAssetBuilder(@NotNull String name, @NotNull Px defaultWidth, @NotNull Px defaultHeight, float viewportWidth, float viewportHeight) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)defaultWidth, (String)"defaultWidth");
        Intrinsics.checkParameterIsNotNull((Object)defaultHeight, (String)"defaultHeight");
        this.name = name;
        this.defaultWidth = defaultWidth;
        this.defaultHeight = defaultHeight;
        this.viewportWidth = viewportWidth;
        this.viewportHeight = viewportHeight;
        this.nodes = new Stack();
        this.currentGroup = this.root = new VectorGroup(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, 511, null);
        this.nodes.add(this.root);
    }

    public /* synthetic */ VectorAssetBuilder(String name, Px defaultWidth, Px defaultHeight, float viewportWidth, float viewportHeight, int $mask0, DefaultConstructorMarker $marker) {
        String string = ($mask0 & 1) != 0 ? "" : name;
        this(string, defaultWidth, defaultHeight, viewportWidth, viewportHeight);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Px getDefaultWidth() {
        return this.defaultWidth;
    }

    @NotNull
    public final Px getDefaultHeight() {
        return this.defaultHeight;
    }

    public final float getViewportWidth() {
        return this.viewportWidth;
    }

    public final float getViewportHeight() {
        return this.viewportHeight;
    }

    private final VectorGroup getCurrentGroup() {
        return this.nodes.peek();
    }

    @NotNull
    public final VectorAssetBuilder pushGroup(@NotNull String name, float rotate, float pivotX, float pivotY, float scaleX, float scaleY, float translationX, float translationY, @NotNull PathNode[] clipPathData) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)clipPathData, (String)"clipPathData");
        this.ensureNotConsumed();
        VectorGroup group = new VectorGroup(name, rotate, pivotX, pivotY, scaleX, scaleY, translationX, translationY, clipPathData);
        this.nodes.add(group);
        this.getCurrentGroup().addNode$ui_framework_release(group);
        return this;
    }

    public static /* synthetic */ VectorAssetBuilder pushGroup$default(@NotNull VectorAssetBuilder this_, @Nullable String name, float rotate, float pivotX, float pivotY, float scaleX, float scaleY, float translationX, float translationY, @Nullable PathNode[] clipPathData, int $mask0, @Nullable Object $handler) {
        String string = ($mask0 & 1) != 0 ? "" : name;
        float f = ($mask0 & 2) != 0 ? 0.0f : rotate;
        float f2 = ($mask0 & 4) != 0 ? 0.0f : pivotX;
        float f3 = ($mask0 & 8) != 0 ? 0.0f : pivotY;
        float f4 = ($mask0 & 0x10) != 0 ? 1.0f : scaleX;
        float f5 = ($mask0 & 0x20) != 0 ? 1.0f : scaleY;
        float f6 = ($mask0 & 0x40) != 0 ? 0.0f : translationX;
        float f7 = ($mask0 & 0x80) != 0 ? 0.0f : translationY;
        PathNode[] pathNodeArray = ($mask0 & 0x100) != 0 ? VectorKt.getEmptyPath() : clipPathData;
        return this_.pushGroup(string, f, f2, f3, f4, f5, f6, f7, pathNodeArray);
    }

    @NotNull
    public final VectorAssetBuilder popGroup() {
        this.ensureNotConsumed();
        this.nodes.pop();
        return this;
    }

    @NotNull
    public final VectorAssetBuilder addPath(@NotNull PathNode[] pathData, @NotNull String name, @Nullable Brush fill, float fillAlpha, @Nullable Brush stroke, float strokeAlpha, float strokeLineWidth, @NotNull StrokeCap strokeLineCap, @NotNull StrokeJoin strokeLineJoin, float strokeLineMiter) {
        Intrinsics.checkParameterIsNotNull((Object)pathData, (String)"pathData");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)strokeLineCap, (String)"strokeLineCap");
        Intrinsics.checkParameterIsNotNull((Object)strokeLineJoin, (String)"strokeLineJoin");
        this.ensureNotConsumed();
        this.getCurrentGroup().addNode$ui_framework_release(new VectorPath(name, pathData, fill, fillAlpha, stroke, strokeAlpha, strokeLineWidth, strokeLineCap, strokeLineJoin, strokeLineMiter));
        return this;
    }

    public static /* synthetic */ VectorAssetBuilder addPath$default(@NotNull VectorAssetBuilder this_, @NotNull PathNode[] pathData, @Nullable String name, @Nullable Brush fill, float fillAlpha, @Nullable Brush stroke, float strokeAlpha, float strokeLineWidth, @Nullable StrokeCap strokeLineCap, @Nullable StrokeJoin strokeLineJoin, float strokeLineMiter, int $mask0, @Nullable Object $handler) {
        String string = ($mask0 & 2) != 0 ? "" : name;
        Brush brush = ($mask0 & 4) != 0 ? (Brush)null : fill;
        float f = ($mask0 & 8) != 0 ? 1.0f : fillAlpha;
        Brush brush2 = ($mask0 & 0x10) != 0 ? (Brush)null : stroke;
        float f2 = ($mask0 & 0x20) != 0 ? 1.0f : strokeAlpha;
        float f3 = ($mask0 & 0x40) != 0 ? 0.0f : strokeLineWidth;
        StrokeCap strokeCap = ($mask0 & 0x80) != 0 ? VectorKt.getDefaultStrokeLineCap() : strokeLineCap;
        StrokeJoin strokeJoin = ($mask0 & 0x100) != 0 ? VectorKt.getDefaultStrokeLineJoin() : strokeLineJoin;
        float f4 = ($mask0 & 0x200) != 0 ? 4.0f : strokeLineMiter;
        return this_.addPath(pathData, string, brush, f, brush2, f2, f3, strokeCap, strokeJoin, f4);
    }

    @NotNull
    public final VectorAsset build() {
        this.ensureNotConsumed();
        VectorAsset vectorImage = new VectorAsset(this.getName(), this.getDefaultWidth(), this.getDefaultHeight(), this.getViewportWidth(), this.getViewportHeight(), this.root);
        this.nodes.clear();
        this.root = new VectorGroup(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null, 511, null);
        this.nodes.add(this.root);
        this.isConsumed = true;
        return vectorImage;
    }

    public final void ensureNotConsumed() {
        if (this.isConsumed) {
            throw new IllegalStateException("VectorAssetBuilder is single use, create a new instance to create a new VectorAsset");
        }
    }
}

