/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vector.compat;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.core.content.res.ComplexColorCompat;
import androidx.core.content.res.TypedArrayUtils;
import androidx.ui.core.Px;
import androidx.ui.graphics.Brush;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Shader;
import androidx.ui.graphics.ShaderBrush;
import androidx.ui.graphics.SolidColor;
import androidx.ui.graphics.StrokeCap;
import androidx.ui.graphics.StrokeJoin;
import androidx.ui.graphics.vector.PathNode;
import androidx.ui.graphics.vector.VectorAssetBuilder;
import androidx.ui.graphics.vector.VectorKt;
import androidx.ui.graphics.vector.compat.AndroidVectorResources;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\rH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a*\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\f\u0010\u001f\u001a\u00020 *\u00020\u0018H\u0000\u001a4\u0010!\u001a\u00020\"*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0002\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u001a2\u0006\u0010#\u001a\u00020\u0017H\u0000\u001a2\u0010$\u001a\u00020\"*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0017H\u0000\u001a2\u0010%\u001a\u00020\"*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0017H\u0000\u001a\f\u0010&\u001a\u00020\u0018*\u00020\u0018H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"FILL_TYPE_WINDING", "", "LINECAP_BUTT", "LINECAP_ROUND", "LINECAP_SQUARE", "LINEJOIN_BEVEL", "LINEJOIN_MITER", "LINEJOIN_ROUND", "SHAPE_CLIP_PATH", "", "SHAPE_GROUP", "SHAPE_PATH", "getStrokeLineCap", "Landroidx/ui/graphics/StrokeCap;", "id", "defValue", "getStrokeLineJoin", "Landroidx/ui/graphics/StrokeJoin;", "obtainBrushFromComplexColor", "Landroidx/ui/graphics/Brush;", "complexColor", "Landroidx/core/content/res/ComplexColorCompat;", "createVectorImageBuilder", "Landroidx/ui/graphics/vector/VectorAssetBuilder;", "Lorg/xmlpull/v1/XmlPullParser;", "res", "Landroid/content/res/Resources;", "theme", "Landroid/content/res/Resources$Theme;", "attrs", "Landroid/util/AttributeSet;", "isAtEnd", "", "parseCurrentVectorNode", "", "builder", "parseGroup", "parsePath", "seekToStartTag", "ui-framework_release"})
public final class XmlVectorParserKt {
    private static final int LINECAP_BUTT = 0;
    private static final int LINECAP_ROUND = 1;
    private static final int LINECAP_SQUARE = 2;
    private static final int LINEJOIN_MITER = 0;
    private static final int LINEJOIN_ROUND = 1;
    private static final int LINEJOIN_BEVEL = 2;
    private static final int FILL_TYPE_WINDING = 0;
    private static final String SHAPE_CLIP_PATH = "clip-VPath";
    private static final String SHAPE_GROUP = "group";
    private static final String SHAPE_PATH = "path";

    private static final StrokeCap getStrokeLineCap(int id2, StrokeCap defValue) {
        int n = id2;
        return n == LINECAP_BUTT ? StrokeCap.butt : (n == LINECAP_ROUND ? StrokeCap.round : (n == LINECAP_SQUARE ? StrokeCap.square : defValue));
    }

    public static /* synthetic */ StrokeCap getStrokeLineCap$default(int id2, StrokeCap defValue, int $mask0, Object $handler) {
        StrokeCap strokeCap = ($mask0 & 2) != 0 ? StrokeCap.butt : defValue;
        return XmlVectorParserKt.getStrokeLineCap(id2, strokeCap);
    }

    private static final StrokeJoin getStrokeLineJoin(int id2, StrokeJoin defValue) {
        int n = id2;
        return n == LINEJOIN_MITER ? StrokeJoin.miter : (n == LINEJOIN_ROUND ? StrokeJoin.round : (n == LINEJOIN_BEVEL ? StrokeJoin.bevel : defValue));
    }

    public static /* synthetic */ StrokeJoin getStrokeLineJoin$default(int id2, StrokeJoin defValue, int $mask0, Object $handler) {
        StrokeJoin strokeJoin = ($mask0 & 2) != 0 ? StrokeJoin.miter : defValue;
        return XmlVectorParserKt.getStrokeLineJoin(id2, strokeJoin);
    }

    public static final boolean isAtEnd(@NotNull XmlPullParser $this$isAtEnd) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAtEnd, (String)"<this>");
        return $this$isAtEnd.getEventType() == 1 || $this$isAtEnd.getDepth() < 1 && $this$isAtEnd.getEventType() == 3;
    }

    public static final void parseCurrentVectorNode(@NotNull XmlPullParser $this$parseCurrentVectorNode, @NotNull Resources res, @NotNull AttributeSet attrs, @Nullable Resources.Theme theme, @NotNull VectorAssetBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$this$parseCurrentVectorNode, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        int n = $this$parseCurrentVectorNode.getEventType();
        switch (n) {
            case 2: {
                String string = $this$parseCurrentVectorNode.getName();
                if (Intrinsics.areEqual((Object)string, (Object)SHAPE_PATH)) {
                    XmlVectorParserKt.parsePath($this$parseCurrentVectorNode, res, theme, attrs, builder);
                    break;
                }
                if (Intrinsics.areEqual((Object)string, (Object)SHAPE_CLIP_PATH)) break;
                if (Intrinsics.areEqual((Object)string, (Object)SHAPE_GROUP)) {
                    XmlVectorParserKt.parseGroup($this$parseCurrentVectorNode, res, theme, attrs, builder);
                }
                break;
            }
            case 3: {
                if (Intrinsics.areEqual((Object)SHAPE_GROUP, (Object)$this$parseCurrentVectorNode.getName())) {
                    builder.popGroup();
                }
                break;
            }
        }
    }

    public static /* synthetic */ void parseCurrentVectorNode$default(@NotNull XmlPullParser $this$parseCurrentVectorNode_u24default, @NotNull Resources res, @NotNull AttributeSet attrs, @Nullable Resources.Theme theme, @NotNull VectorAssetBuilder builder, int $mask0, @Nullable Object $handler) {
        Resources.Theme theme2 = ($mask0 & 4) != 0 ? (Resources.Theme)null : theme;
        XmlVectorParserKt.parseCurrentVectorNode($this$parseCurrentVectorNode_u24default, res, attrs, theme2, builder);
    }

    @NotNull
    public static final XmlPullParser seekToStartTag(@NotNull XmlPullParser $this$seekToStartTag) throws XmlPullParserException {
        Intrinsics.checkParameterIsNotNull((Object)$this$seekToStartTag, (String)"<this>");
        int type = $this$seekToStartTag.next();
        while (type != 2 && type != 1) {
            type = $this$seekToStartTag.next();
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return $this$seekToStartTag;
    }

    @NotNull
    public static final VectorAssetBuilder createVectorImageBuilder(@NotNull XmlPullParser $this$createVectorImageBuilder, @NotNull Resources res, @Nullable Resources.Theme theme, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createVectorImageBuilder, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        TypedArray vectorAttrs = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_TYPE_ARRAY());
        float viewportWidth = TypedArrayUtils.getNamedFloat((TypedArray)vectorAttrs, (XmlPullParser)$this$createVectorImageBuilder, (String)"viewportWidth", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_VIEWPORT_WIDTH(), (float)0.0f);
        float viewportHeight = TypedArrayUtils.getNamedFloat((TypedArray)vectorAttrs, (XmlPullParser)$this$createVectorImageBuilder, (String)"viewportHeight", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_VIEWPORT_HEIGHT(), (float)0.0f);
        if (viewportWidth <= 0.0f) {
            throw new XmlPullParserException(Intrinsics.stringPlus((String)vectorAttrs.getPositionDescription(), (Object)"<VectorGraphic> tag requires viewportWidth > 0"));
        }
        if (viewportHeight <= 0.0f) {
            throw new XmlPullParserException(Intrinsics.stringPlus((String)vectorAttrs.getPositionDescription(), (Object)"<VectorGraphic> tag requires viewportHeight > 0"));
        }
        float defaultWidth = vectorAttrs.getDimension(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_WIDTH(), 0.0f);
        float defaultHeight = vectorAttrs.getDimension(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_HEIGHT(), 0.0f);
        vectorAttrs.recycle();
        return new VectorAssetBuilder(null, new Px(defaultWidth), new Px(defaultHeight), viewportWidth, viewportHeight, 1, null);
    }

    public static final void parsePath(@NotNull XmlPullParser $this$parsePath, @NotNull Resources res, @Nullable Resources.Theme theme, @NotNull AttributeSet attrs, @NotNull VectorAssetBuilder builder) throws IllegalArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)$this$parsePath, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH());
        boolean hasPathData = TypedArrayUtils.hasAttribute((XmlPullParser)$this$parsePath, (String)"pathData");
        if (!hasPathData) {
            throw new IllegalArgumentException("No path data available");
        }
        String string = a.getString(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_NAME());
        String name = string == null ? "" : string;
        String pathStr = a.getString(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_PATH_DATA());
        PathNode[] pathData = VectorKt.addPathNodes((String)pathStr);
        ComplexColorCompat fillColor = TypedArrayUtils.getNamedComplexColor((TypedArray)a, (XmlPullParser)$this$parsePath, (Resources.Theme)theme, (String)"fillColor", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_FILL_COLOR(), (int)0);
        float fillAlpha = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parsePath, (String)"fillAlpha", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_FILL_ALPHA(), (float)1.0f);
        int lineCap = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)$this$parsePath, (String)"strokeLineCap", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_LINE_CAP(), (int)-1);
        StrokeCap strokeLineCap = XmlVectorParserKt.getStrokeLineCap(lineCap, StrokeCap.butt);
        int lineJoin = TypedArrayUtils.getNamedInt((TypedArray)a, (XmlPullParser)$this$parsePath, (String)"strokeLineJoin", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_LINE_JOIN(), (int)-1);
        StrokeJoin strokeLineJoin = XmlVectorParserKt.getStrokeLineJoin(lineJoin, StrokeJoin.bevel);
        float strokeMiterLimit = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parsePath, (String)"strokeMiterLimit", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_MITER_LIMIT(), (float)1.0f);
        ComplexColorCompat strokeColor = TypedArrayUtils.getNamedComplexColor((TypedArray)a, (XmlPullParser)$this$parsePath, (Resources.Theme)theme, (String)"strokeColor", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_COLOR(), (int)0);
        float strokeAlpha = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parsePath, (String)"strokeAlpha", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_ALPHA(), (float)1.0f);
        float strokeLineWidth = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parsePath, (String)"strokeWidth", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_PATH_STROKE_WIDTH(), (float)1.0f);
        a.recycle();
        Brush fillBrush = XmlVectorParserKt.obtainBrushFromComplexColor(fillColor);
        Brush strokeBrush = XmlVectorParserKt.obtainBrushFromComplexColor(strokeColor);
        builder.addPath(pathData, name, fillBrush, fillAlpha, strokeBrush, strokeAlpha, strokeLineWidth, strokeLineCap, strokeLineJoin, strokeMiterLimit);
    }

    private static final Brush obtainBrushFromComplexColor(ComplexColorCompat complexColor) {
        android.graphics.Shader shader;
        return complexColor.willDraw() ? ((shader = complexColor.getShader()) != null ? (Brush)new ShaderBrush(new Shader(shader)) : (Brush)new SolidColor(ColorKt.Color((int)complexColor.getColor()))) : (Brush)null;
    }

    public static final void parseGroup(@NotNull XmlPullParser $this$parseGroup, @NotNull Resources res, @Nullable Resources.Theme theme, @NotNull AttributeSet attrs, @NotNull VectorAssetBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$this$parseGroup, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP());
        float rotate = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parseGroup, (String)"rotation", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_ROTATION(), (float)0.0f);
        float pivotX = a.getFloat(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_PIVOT_X(), 0.0f);
        float pivotY = a.getFloat(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_PIVOT_Y(), 0.0f);
        float scaleX = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parseGroup, (String)"scaleX", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_SCALE_X(), (float)1.0f);
        float scaleY = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parseGroup, (String)"scaleY", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_SCALE_Y(), (float)1.0f);
        float translateX = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parseGroup, (String)"translationX", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_TRANSLATE_X(), (float)0.0f);
        float translateY = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)$this$parseGroup, (String)"translationY", (int)AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_TRANSLATE_Y(), (float)0.0f);
        String string = a.getString(AndroidVectorResources.INSTANCE.getSTYLEABLE_VECTOR_DRAWABLE_GROUP_NAME());
        String name = string == null ? "" : string;
        PathNode[] clipPathData = VectorKt.getEmptyPath();
        a.recycle();
        builder.pushGroup(name, rotate, scaleX, scaleY, translateX, translateY, pivotX, pivotY, clipPathData);
    }

    static {
        LINECAP_ROUND = 1;
        LINECAP_SQUARE = 2;
        LINEJOIN_ROUND = 1;
        LINEJOIN_BEVEL = 2;
        SHAPE_CLIP_PATH = SHAPE_CLIP_PATH;
        SHAPE_GROUP = SHAPE_GROUP;
        SHAPE_PATH = SHAPE_PATH;
    }
}

