/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.ui.geometry.OffsetBase;
import androidx.ui.geometry.Rect;
import androidx.ui.geometry.Size;
import androidx.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003J\t\u0010'\u001a\u00020\u0000H\u0086\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006)"}, d2={"Landroidx/ui/geometry/Offset;", "Landroidx/ui/geometry/OffsetBase;", "dx", "", "dy", "(FF)V", "getDx", "()F", "getDy", "and", "Landroidx/ui/geometry/Rect;", "other", "Landroidx/ui/geometry/Size;", "component1", "component2", "copy", "div", "operand", "equals", "", "", "getDirection", "getDistance", "getDistanceSquared", "hashCode", "", "minus", "plus", "rem", "scale", "scaleX", "scaleY", "times", "toString", "", "translate", "translateX", "translateY", "truncDiv", "unaryMinus", "Companion", "ui-geometry_release"})
public final class Offset
implements OffsetBase {
    private final float dx;
    private final float dy;
    private static final Offset zero;
    private static final Offset infinite;
    @NotNull
    public static final Companion Companion;

    public Offset(float dx, float dy) {
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    public float getDx() {
        return this.dx;
    }

    @Override
    public float getDy() {
        return this.dy;
    }

    public final float getDistance() {
        float f = this.getDx() * this.getDx() + this.getDy() * this.getDy();
        boolean bl = false;
        return (float)Math.sqrt(f);
    }

    public final float getDistanceSquared() {
        return this.getDx() * this.getDx() + this.getDy() * this.getDy();
    }

    public final float getDirection() {
        float f = this.getDy();
        float f2 = this.getDx();
        boolean bl = false;
        return (float)Math.atan2(f, f2);
    }

    @NotNull
    public final Offset scale(float scaleX, float scaleY) {
        return new Offset(this.getDx() * scaleX, this.getDy() * scaleY);
    }

    @NotNull
    public final Offset translate(float translateX, float translateY) {
        return new Offset(this.getDx() + translateX, this.getDy() + translateY);
    }

    @NotNull
    public final Offset unaryMinus() {
        return new Offset(-this.getDx(), -this.getDy());
    }

    @NotNull
    public final Offset minus(@NotNull Offset other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Offset(this.getDx() - other.getDx(), this.getDy() - other.getDy());
    }

    @NotNull
    public final Offset plus(@NotNull Offset other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Offset(this.getDx() + other.getDx(), this.getDy() + other.getDy());
    }

    @NotNull
    public final Offset times(float operand) {
        return new Offset(this.getDx() * operand, this.getDy() * operand);
    }

    @NotNull
    public final Offset div(float operand) {
        return new Offset(this.getDx() / operand, this.getDy() / operand);
    }

    @NotNull
    public final Offset truncDiv(float operand) {
        return new Offset(MathKt.truncate((float)(this.getDx() / operand)), MathKt.truncate((float)(this.getDy() / operand)));
    }

    @NotNull
    public final Offset rem(float operand) {
        return new Offset(this.getDx() % operand, this.getDy() % operand);
    }

    @NotNull
    public final Rect and(@NotNull Size other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Rect.Companion.fromLTWH(this.getDx(), this.getDy(), other.getWidth(), other.getHeight());
    }

    @NotNull
    public String toString() {
        return "Offset(" + MathHelpersKt.toStringAsFixed((float)this.getDx(), (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.getDy(), (int)1) + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Offset)) {
            return false;
        }
        if (!(this.getDx() == ((Offset)other).getDx())) {
            return false;
        }
        return this.getDy() == ((Offset)other).getDy();
    }

    public int hashCode() {
        int result = Float.hashCode(this.getDx());
        result = 31 * result + Float.hashCode(this.getDy());
        return result;
    }

    public final float component1() {
        return this.dx;
    }

    public final float component2() {
        return this.dy;
    }

    @NotNull
    public final Offset copy(float dx, float dy) {
        return new Offset(dx, dy);
    }

    public static /* synthetic */ Offset copy$default(@NotNull Offset this_, float dx, float dy, int $mask0, @Nullable Object $handler) {
        float f = ($mask0 & 1) != 0 ? this_.dx : dx;
        float f2 = ($mask0 & 2) != 0 ? this_.dy : dy;
        return this_.copy(f, f2);
    }

    @Override
    public boolean isFinite() {
        return OffsetBase.DefaultImpls.isFinite(this);
    }

    @Override
    public boolean isGreaterOrEqThan(@NotNull OffsetBase other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return OffsetBase.DefaultImpls.isGreaterOrEqThan(this, other);
    }

    @Override
    public boolean isGreaterThan(@NotNull OffsetBase other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return OffsetBase.DefaultImpls.isGreaterThan(this, other);
    }

    @Override
    public boolean isInfinite() {
        return OffsetBase.DefaultImpls.isInfinite(this);
    }

    @Override
    public boolean isLessOrEqThan(@NotNull OffsetBase other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return OffsetBase.DefaultImpls.isLessOrEqThan(this, other);
    }

    @Override
    public boolean isLessThan(@NotNull OffsetBase other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return OffsetBase.DefaultImpls.isLessThan(this, other);
    }

    static {
        Companion = new Companion(null);
        zero = new Offset(0.0f, 0.0f);
        infinite = new Offset(FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0011"}, d2={"Landroidx/ui/geometry/Offset$Companion;", "", "()V", "infinite", "Landroidx/ui/geometry/Offset;", "getInfinite", "()Landroidx/ui/geometry/Offset;", "zero", "getZero", "isValid", "", "offset", "lerp", "start", "stop", "fraction", "", "ui-geometry_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Offset getZero() {
            return zero;
        }

        @NotNull
        public final Offset getInfinite() {
            return infinite;
        }

        @NotNull
        public final Offset lerp(@NotNull Offset start, @NotNull Offset stop, float fraction) {
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
            return new Offset(MathHelpersKt.lerp((float)start.getDx(), (float)stop.getDx(), (float)fraction), MathHelpersKt.lerp((float)start.getDy(), (float)stop.getDy(), (float)fraction));
        }

        /*
         * Unable to fully structure code
         */
        public final boolean isValid(@NotNull Offset offset) {
            Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
            var2_2 = offset.getDx();
            var3_4 = false;
            if (Float.isNaN(var2_2)) ** GOTO lbl-1000
            var2_2 = offset.getDy();
            var3_4 = false;
            if (!Float.isNaN(var2_2)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            var2_3 = v0;
            var3_4 = false;
            if (_Assertions.ENABLED && !var2_3) {
                var4_5 = "Offset argument contained a NaN value.";
                throw (Throwable)new AssertionError((Object)var4_5);
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

