/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.ui.geometry.Offset;
import androidx.ui.geometry.RRectKt;
import androidx.ui.geometry.Radius;
import androidx.ui.util.MathHelpersKt;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b+\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 B2\u00020\u0001:\u0001BBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0081\u0001\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u0003H\u00c6\u0001J\u0010\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0003H\u0007J\u0013\u00105\u001a\u00020/2\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u000208H\u00d6\u0001J\u0010\u00109\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0003H\u0007J(\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0003H\u0002J\b\u0010?\u001a\u00020\u0000H\u0002J\b\u0010@\u001a\u00020AH\u0016R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0012\u00a8\u0006C"}, d2={"Landroidx/ui/geometry/RRect;", "", "left", "", "top", "right", "bottom", "topLeftRadiusX", "topLeftRadiusY", "topRightRadiusX", "topRightRadiusY", "bottomRightRadiusX", "bottomRightRadiusY", "bottomLeftRadiusX", "bottomLeftRadiusY", "(FFFFFFFFFFFF)V", "_scaledRadiiRect", "getBottom", "()F", "getBottomLeftRadiusX", "getBottomLeftRadiusY", "getBottomRightRadiusX", "getBottomRightRadiusY", "height", "getHeight", "getLeft", "getRight", "getTop", "getTopLeftRadiusX", "getTopLeftRadiusY", "getTopRightRadiusX", "getTopRightRadiusY", "width", "getWidth", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "contains", "", "point", "Landroidx/ui/geometry/Offset;", "copy", "deflate", "delta", "equals", "other", "hashCode", "", "inflate", "minRadius", "min", "radius1", "radius2", "limit", "scaledRadiiRect", "toString", "", "Companion", "ui-geometry_release"})
public final class RRect {
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    private final float topLeftRadiusX;
    private final float topLeftRadiusY;
    private final float topRightRadiusX;
    private final float topRightRadiusY;
    private final float bottomRightRadiusX;
    private final float bottomRightRadiusY;
    private final float bottomLeftRadiusX;
    private final float bottomLeftRadiusY;
    private final float width;
    private final float height;
    private RRect _scaledRadiiRect;
    private static final RRect Zero;
    @NotNull
    public static final Companion Companion;

    public RRect(float left, float top, float right, float bottom, float topLeftRadiusX, float topLeftRadiusY, float topRightRadiusX, float topRightRadiusY, float bottomRightRadiusX, float bottomRightRadiusY, float bottomLeftRadiusX, float bottomLeftRadiusY) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.topLeftRadiusX = topLeftRadiusX;
        this.topLeftRadiusY = topLeftRadiusY;
        this.topRightRadiusX = topRightRadiusX;
        this.topRightRadiusY = topRightRadiusY;
        this.bottomRightRadiusX = bottomRightRadiusX;
        this.bottomRightRadiusY = bottomRightRadiusY;
        this.bottomLeftRadiusX = bottomLeftRadiusX;
        this.bottomLeftRadiusY = bottomLeftRadiusY;
        this.width = this.getRight() - this.getLeft();
        this.height = this.getBottom() - this.getTop();
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getTopLeftRadiusX() {
        return this.topLeftRadiusX;
    }

    public final float getTopLeftRadiusY() {
        return this.topLeftRadiusY;
    }

    public final float getTopRightRadiusX() {
        return this.topRightRadiusX;
    }

    public final float getTopRightRadiusY() {
        return this.topRightRadiusY;
    }

    public final float getBottomRightRadiusX() {
        return this.bottomRightRadiusX;
    }

    public final float getBottomRightRadiusY() {
        return this.bottomRightRadiusY;
    }

    public final float getBottomLeftRadiusX() {
        return this.bottomLeftRadiusX;
    }

    public final float getBottomLeftRadiusY() {
        return this.bottomLeftRadiusY;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    private final RRect scaledRadiiRect() {
        RRect rRect;
        RRect rRect2 = this._scaledRadiiRect;
        if (rRect2 == null) {
            RRect it;
            RRect rRect3 = this;
            boolean bl = false;
            boolean bl2 = false;
            RRect $this$scaledRadiiRect_u24lambda_u2d0 = rRect3;
            float scale = 1.0f;
            scale = $this$scaledRadiiRect_u24lambda_u2d0.minRadius(scale, $this$scaledRadiiRect_u24lambda_u2d0.getBottomLeftRadiusY(), $this$scaledRadiiRect_u24lambda_u2d0.getTopLeftRadiusY(), $this$scaledRadiiRect_u24lambda_u2d0.getHeight());
            scale = $this$scaledRadiiRect_u24lambda_u2d0.minRadius(scale, $this$scaledRadiiRect_u24lambda_u2d0.getTopLeftRadiusX(), $this$scaledRadiiRect_u24lambda_u2d0.getTopRightRadiusX(), $this$scaledRadiiRect_u24lambda_u2d0.getWidth());
            scale = $this$scaledRadiiRect_u24lambda_u2d0.minRadius(scale, $this$scaledRadiiRect_u24lambda_u2d0.getTopRightRadiusY(), $this$scaledRadiiRect_u24lambda_u2d0.getBottomRightRadiusY(), $this$scaledRadiiRect_u24lambda_u2d0.getHeight());
            scale = $this$scaledRadiiRect_u24lambda_u2d0.minRadius(scale, $this$scaledRadiiRect_u24lambda_u2d0.getBottomRightRadiusX(), $this$scaledRadiiRect_u24lambda_u2d0.getBottomLeftRadiusX(), $this$scaledRadiiRect_u24lambda_u2d0.getWidth());
            rRect3 = new RRect($this$scaledRadiiRect_u24lambda_u2d0.getLeft() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getTop() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getRight() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getBottom() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getTopLeftRadiusX() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getTopLeftRadiusY() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getTopRightRadiusX() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getTopRightRadiusY() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getBottomRightRadiusX() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getBottomRightRadiusY() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getBottomLeftRadiusX() * scale, $this$scaledRadiiRect_u24lambda_u2d0.getBottomLeftRadiusY() * scale);
            bl = false;
            bl2 = false;
            this._scaledRadiiRect = it = rRect3;
            rRect = rRect3;
        } else {
            rRect = rRect2;
        }
        return rRect;
    }

    private final float minRadius(float min, float radius1, float radius2, float limit) {
        float sum = radius1 + radius2;
        return sum > limit && !(sum == 0.0f) ? Math.min(min, limit / sum) : min;
    }

    public final boolean contains(@NotNull Offset point) {
        float radiusY;
        float radiusX;
        float y;
        float x;
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        if (point.getDx() < this.getLeft() || point.getDx() >= this.getRight() || point.getDy() < this.getTop() || point.getDy() >= this.getBottom()) {
            return false;
        }
        RRect scaled = this.scaledRadiiRect();
        if (point.getDx() < this.getLeft() + scaled.getTopLeftRadiusX() && point.getDy() < this.getTop() + scaled.getTopLeftRadiusY()) {
            x = point.getDx() - this.getLeft() - scaled.getTopLeftRadiusX();
            y = point.getDy() - this.getTop() - scaled.getTopLeftRadiusY();
            radiusX = scaled.getTopLeftRadiusX();
            radiusY = scaled.getTopLeftRadiusY();
        } else if (point.getDx() > this.getRight() - scaled.getTopRightRadiusX() && point.getDy() < this.getTop() + scaled.getTopRightRadiusY()) {
            x = point.getDx() - this.getRight() + scaled.getTopRightRadiusX();
            y = point.getDy() - this.getTop() - scaled.getTopRightRadiusY();
            radiusX = scaled.getTopRightRadiusX();
            radiusY = scaled.getTopRightRadiusY();
        } else if (point.getDx() > this.getRight() - scaled.getBottomRightRadiusX() && point.getDy() > this.getBottom() - scaled.getBottomRightRadiusY()) {
            x = point.getDx() - this.getRight() + scaled.getBottomRightRadiusX();
            y = point.getDy() - this.getBottom() + scaled.getBottomRightRadiusY();
            radiusX = scaled.getBottomRightRadiusX();
            radiusY = scaled.getBottomRightRadiusY();
        } else if (point.getDx() < this.getLeft() + scaled.getBottomLeftRadiusX() && point.getDy() > this.getBottom() - scaled.getBottomLeftRadiusY()) {
            x = point.getDx() - this.getLeft() - scaled.getBottomLeftRadiusX();
            y = point.getDy() - this.getBottom() + scaled.getBottomLeftRadiusY();
            radiusX = scaled.getBottomLeftRadiusX();
            radiusY = scaled.getBottomLeftRadiusY();
        } else {
            return true;
        }
        float newX = x / radiusX;
        float newY = y / radiusY;
        return newX * newX + newY * newY <= 1.0f;
    }

    @Deprecated(message="renamed to avoid conceptual naming collision with android inflate", replaceWith=@ReplaceWith(expression="grow(delta)", imports={"androidx.ui.geometry.grow"}), level=DeprecationLevel.ERROR)
    @NotNull
    public final RRect inflate(float delta) {
        return RRectKt.grow(this, delta);
    }

    @Deprecated(message="renamed to avoid conceptual naming collision with android inflate", replaceWith=@ReplaceWith(expression="shrink(delta)", imports={"androidx.ui.geometry.shrink"}), level=DeprecationLevel.ERROR)
    @NotNull
    public final RRect deflate(float delta) {
        return RRectKt.shrink(this, delta);
    }

    @NotNull
    public String toString() {
        Radius tlRadius = RRectKt.topLeftRadius(this);
        Radius trRadius = RRectKt.topRightRadius(this);
        Radius brRadius = RRectKt.bottomRightRadius(this);
        Radius blRadius = RRectKt.bottomLeftRadius(this);
        String rect = MathHelpersKt.toStringAsFixed((float)this.getLeft(), (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.getTop(), (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.getRight(), (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.getBottom(), (int)1);
        if (Intrinsics.areEqual((Object)tlRadius, (Object)trRadius) && Intrinsics.areEqual((Object)trRadius, (Object)brRadius) && Intrinsics.areEqual((Object)brRadius, (Object)blRadius)) {
            if (tlRadius.getX() == tlRadius.getY()) {
                return "RRect(rect=" + rect + ", radius=" + MathHelpersKt.toStringAsFixed((float)tlRadius.getX(), (int)1) + ")";
            }
            return "RRect(rect=" + rect + ", x=" + MathHelpersKt.toStringAsFixed((float)tlRadius.getX(), (int)1) + ", y=" + MathHelpersKt.toStringAsFixed((float)tlRadius.getY(), (int)1) + ")";
        }
        return "RRect(rect=" + rect + ", topLeft=" + tlRadius + ", topRight=" + trRadius + ", bottomRight=" + brRadius + ", bottomLeft=" + blRadius + ")";
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    public final float component5() {
        return this.topLeftRadiusX;
    }

    public final float component6() {
        return this.topLeftRadiusY;
    }

    public final float component7() {
        return this.topRightRadiusX;
    }

    public final float component8() {
        return this.topRightRadiusY;
    }

    public final float component9() {
        return this.bottomRightRadiusX;
    }

    public final float component10() {
        return this.bottomRightRadiusY;
    }

    public final float component11() {
        return this.bottomLeftRadiusX;
    }

    public final float component12() {
        return this.bottomLeftRadiusY;
    }

    @NotNull
    public final RRect copy(float left, float top, float right, float bottom, float topLeftRadiusX, float topLeftRadiusY, float topRightRadiusX, float topRightRadiusY, float bottomRightRadiusX, float bottomRightRadiusY, float bottomLeftRadiusX, float bottomLeftRadiusY) {
        return new RRect(left, top, right, bottom, topLeftRadiusX, topLeftRadiusY, topRightRadiusX, topRightRadiusY, bottomRightRadiusX, bottomRightRadiusY, bottomLeftRadiusX, bottomLeftRadiusY);
    }

    public static /* synthetic */ RRect copy$default(@NotNull RRect this_, float left, float top, float right, float bottom, float topLeftRadiusX, float topLeftRadiusY, float topRightRadiusX, float topRightRadiusY, float bottomRightRadiusX, float bottomRightRadiusY, float bottomLeftRadiusX, float bottomLeftRadiusY, int $mask0, @Nullable Object $handler) {
        float f = ($mask0 & 1) != 0 ? this_.left : left;
        float f2 = ($mask0 & 2) != 0 ? this_.top : top;
        float f3 = ($mask0 & 4) != 0 ? this_.right : right;
        float f4 = ($mask0 & 8) != 0 ? this_.bottom : bottom;
        float f5 = ($mask0 & 0x10) != 0 ? this_.topLeftRadiusX : topLeftRadiusX;
        float f6 = ($mask0 & 0x20) != 0 ? this_.topLeftRadiusY : topLeftRadiusY;
        float f7 = ($mask0 & 0x40) != 0 ? this_.topRightRadiusX : topRightRadiusX;
        float f8 = ($mask0 & 0x80) != 0 ? this_.topRightRadiusY : topRightRadiusY;
        float f9 = ($mask0 & 0x100) != 0 ? this_.bottomRightRadiusX : bottomRightRadiusX;
        float f10 = ($mask0 & 0x200) != 0 ? this_.bottomRightRadiusY : bottomRightRadiusY;
        float f11 = ($mask0 & 0x400) != 0 ? this_.bottomLeftRadiusX : bottomLeftRadiusX;
        float f12 = ($mask0 & 0x800) != 0 ? this_.bottomLeftRadiusY : bottomLeftRadiusY;
        return this_.copy(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public int hashCode() {
        return ((((((((((Float.hashCode(this.left) * 31 + Float.hashCode(this.top)) * 31 + Float.hashCode(this.right)) * 31 + Float.hashCode(this.bottom)) * 31 + Float.hashCode(this.topLeftRadiusX)) * 31 + Float.hashCode(this.topLeftRadiusY)) * 31 + Float.hashCode(this.topRightRadiusX)) * 31 + Float.hashCode(this.topRightRadiusY)) * 31 + Float.hashCode(this.bottomRightRadiusX)) * 31 + Float.hashCode(this.bottomRightRadiusY)) * 31 + Float.hashCode(this.bottomLeftRadiusX)) * 31 + Float.hashCode(this.bottomLeftRadiusY);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RRect)) {
            return false;
        }
        Object object = other;
        RRect rRect = (RRect)object;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.left), (Object)Float.valueOf(rRect.left))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.top), (Object)Float.valueOf(rRect.top))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.right), (Object)Float.valueOf(rRect.right))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.bottom), (Object)Float.valueOf(rRect.bottom))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.topLeftRadiusX), (Object)Float.valueOf(rRect.topLeftRadiusX))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.topLeftRadiusY), (Object)Float.valueOf(rRect.topLeftRadiusY))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.topRightRadiusX), (Object)Float.valueOf(rRect.topRightRadiusX))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.topRightRadiusY), (Object)Float.valueOf(rRect.topRightRadiusY))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.bottomRightRadiusX), (Object)Float.valueOf(rRect.bottomRightRadiusX))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.bottomRightRadiusY), (Object)Float.valueOf(rRect.bottomRightRadiusY))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.bottomLeftRadiusX), (Object)Float.valueOf(rRect.bottomLeftRadiusX))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.bottomLeftRadiusY), (Object)Float.valueOf(rRect.bottomLeftRadiusY));
    }

    static {
        Companion = new Companion(null);
        Zero = new RRect(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public static final RRect getZero() {
        return Companion.getZero();
    }

    @JvmStatic
    public static void Zero$annotations() {
        androidx.ui.geometry.RRect$Companion.Zero$annotations();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/ui/geometry/RRect$Companion;", "", "()V", "Zero", "Landroidx/ui/geometry/RRect;", "Zero$annotations", "getZero", "()Landroidx/ui/geometry/RRect;", "ui-geometry_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RRect getZero() {
            return Zero;
        }

        @JvmStatic
        public static /* synthetic */ void Zero$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

