/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Size;
import androidx.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 ;2\u00020\u0001:\u0001;B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u0013\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020\u0018J\u0006\u0010#\u001a\u00020\u0018J\u0006\u0010$\u001a\u00020\u0018J\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0018J\u0006\u0010*\u001a\u00020\u0018J\u0006\u0010+\u001a\u00020\u0018J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\u0016J\u0006\u00101\u001a\u00020\u0016J\u0006\u00102\u001a\u00020\u0016J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u00104\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\b\u00106\u001a\u000207H\u0016J\u0016\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006<"}, d2={"Landroidx/ui/geometry/Rect;", "", "left", "", "top", "right", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "getLeft", "getRight", "getTop", "width", "getWidth", "component1", "component2", "component3", "component4", "contains", "", "offset", "Landroidx/ui/geometry/Offset;", "copy", "deflate", "delta", "equals", "other", "expandToInclude", "getBottomCenter", "getBottomLeft", "getBottomRight", "getCenter", "getCenterLeft", "getCenterRight", "getLongestSide", "getShortestSide", "getSize", "Landroidx/ui/geometry/Size;", "getTopCenter", "getTopLeft", "getTopRight", "hashCode", "", "inflate", "intersect", "isEmpty", "isFinite", "isInfinite", "join", "overlaps", "shift", "toString", "", "translate", "translateX", "translateY", "Companion", "ui-geometry_release"})
public final class Rect {
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    private final float width;
    private final float height;
    private static final Rect zero;
    private static final float _giantScalar = 1.0E7f;
    private static final Rect largest;
    @NotNull
    public static final Companion Companion;

    public Rect(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = this.getRight() - this.getLeft();
        this.height = this.getBottom() - this.getTop();
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    @NotNull
    public final Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public final boolean isInfinite() {
        return this.getLeft() >= FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() || this.getTop() >= FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() || this.getRight() >= FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() || this.getBottom() >= FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFinite() {
        float f = this.getLeft();
        boolean bl = false;
        float f2 = f;
        boolean bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        f = this.getTop();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        f = this.getRight();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        f = this.getBottom();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        return true;
    }

    public final boolean isEmpty() {
        return this.getLeft() >= this.getRight() || this.getTop() >= this.getBottom();
    }

    @NotNull
    public final Rect shift(@NotNull Offset offset) {
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        return Companion.fromLTRB(this.getLeft() + offset.getDx(), this.getTop() + offset.getDy(), this.getRight() + offset.getDx(), this.getBottom() + offset.getDy());
    }

    @NotNull
    public final Rect translate(float translateX, float translateY) {
        return Companion.fromLTRB(this.getLeft() + translateX, this.getTop() + translateY, this.getRight() + translateX, this.getBottom() + translateY);
    }

    @NotNull
    public final Rect inflate(float delta) {
        return Companion.fromLTRB(this.getLeft() - delta, this.getTop() - delta, this.getRight() + delta, this.getBottom() + delta);
    }

    @NotNull
    public final Rect deflate(float delta) {
        return this.inflate(-delta);
    }

    @NotNull
    public final Rect intersect(@NotNull Rect other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Companion.fromLTRB(Math.max(this.getLeft(), other.getLeft()), Math.max(this.getTop(), other.getTop()), Math.min(this.getRight(), other.getRight()), Math.min(this.getBottom(), other.getBottom()));
    }

    @NotNull
    public final Rect expandToInclude(@NotNull Rect other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Companion.fromLTRB(Math.min(this.getLeft(), other.getLeft()), Math.min(this.getTop(), other.getTop()), Math.max(this.getRight(), other.getRight()), Math.max(this.getBottom(), other.getBottom()));
    }

    @NotNull
    public final Rect join(@NotNull Rect other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        return this.expandToInclude(other);
    }

    public final boolean overlaps(@NotNull Rect other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (this.getRight() <= other.getLeft() || other.getRight() <= this.getLeft()) {
            return false;
        }
        return !(this.getBottom() <= other.getTop()) && !(other.getBottom() <= this.getTop());
    }

    public final float getShortestSide() {
        float f = this.getWidth();
        boolean bl = false;
        float f2 = Math.abs(f);
        f = this.getHeight();
        float f3 = f2;
        bl = false;
        float f4 = Math.abs(f);
        return Math.min(f3, f4);
    }

    public final float getLongestSide() {
        float f = this.getWidth();
        boolean bl = false;
        float f2 = Math.abs(f);
        f = this.getHeight();
        float f3 = f2;
        bl = false;
        float f4 = Math.abs(f);
        return Math.max(f3, f4);
    }

    @NotNull
    public final Offset getTopLeft() {
        return new Offset(this.getLeft(), this.getTop());
    }

    @NotNull
    public final Offset getTopCenter() {
        return new Offset(this.getLeft() + this.getWidth() / 2.0f, this.getTop());
    }

    @NotNull
    public final Offset getTopRight() {
        return new Offset(this.getRight(), this.getTop());
    }

    @NotNull
    public final Offset getCenterLeft() {
        return new Offset(this.getLeft(), this.getTop() + this.getHeight() / 2.0f);
    }

    @NotNull
    public final Offset getCenter() {
        return new Offset(this.getLeft() + this.getWidth() / 2.0f, this.getTop() + this.getHeight() / 2.0f);
    }

    @NotNull
    public final Offset getCenterRight() {
        return new Offset(this.getRight(), this.getTop() + this.getHeight() / 2.0f);
    }

    @NotNull
    public final Offset getBottomLeft() {
        return new Offset(this.getLeft(), this.getBottom());
    }

    @NotNull
    public final Offset getBottomCenter() {
        return new Offset(this.getLeft() + this.getWidth() / 2.0f, this.getBottom());
    }

    @NotNull
    public final Offset getBottomRight() {
        return new Offset(this.getRight(), this.getBottom());
    }

    public final boolean contains(@NotNull Offset offset) {
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        return offset.getDx() >= this.getLeft() && offset.getDx() < this.getRight() && offset.getDy() >= this.getTop() && offset.getDy() < this.getBottom();
    }

    @NotNull
    public String toString() {
        return "Rect.fromLTRB(" + MathHelpersKt.toStringAsFixed((float)this.getLeft(), (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.getTop(), (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.getRight(), (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.getBottom(), (int)1) + ")";
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    @NotNull
    public final Rect copy(float left, float top, float right, float bottom) {
        return new Rect(left, top, right, bottom);
    }

    public static /* synthetic */ Rect copy$default(@NotNull Rect this_, float left, float top, float right, float bottom, int $mask0, @Nullable Object $handler) {
        float f = ($mask0 & 1) != 0 ? this_.left : left;
        float f2 = ($mask0 & 2) != 0 ? this_.top : top;
        float f3 = ($mask0 & 4) != 0 ? this_.right : right;
        float f4 = ($mask0 & 8) != 0 ? this_.bottom : bottom;
        return this_.copy(f, f2, f3, f4);
    }

    public int hashCode() {
        return ((Float.hashCode(this.left) * 31 + Float.hashCode(this.top)) * 31 + Float.hashCode(this.right)) * 31 + Float.hashCode(this.bottom);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        Object object = other;
        Rect rect = (Rect)object;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.left), (Object)Float.valueOf(rect.left))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.top), (Object)Float.valueOf(rect.top))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.right), (Object)Float.valueOf(rect.right))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.bottom), (Object)Float.valueOf(rect.bottom));
    }

    static {
        Companion = new Companion(null);
        zero = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
        _giantScalar = 1.0E7f;
        largest = Companion.fromLTRB(-Companion.get_giantScalar(), -Companion.get_giantScalar(), Companion.get_giantScalar(), Companion.get_giantScalar());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J&\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J&\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001c"}, d2={"Landroidx/ui/geometry/Rect$Companion;", "", "()V", "_giantScalar", "", "get_giantScalar", "()F", "largest", "Landroidx/ui/geometry/Rect;", "getLargest", "()Landroidx/ui/geometry/Rect;", "zero", "getZero", "fromCircle", "center", "Landroidx/ui/geometry/Offset;", "radius", "fromLTRB", "left", "top", "right", "bottom", "fromLTWH", "width", "height", "fromPoints", "a", "b", "ui-geometry_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rect fromLTRB(float left, float top, float right, float bottom) {
            return new Rect(left, top, right, bottom);
        }

        @NotNull
        public final Rect fromLTWH(float left, float top, float width, float height) {
            return new Rect(left, top, left + width, top + height);
        }

        @NotNull
        public final Rect fromCircle(@NotNull Offset center, float radius) {
            Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
            return new Rect(center.getDx() - radius, center.getDy() - radius, center.getDx() + radius, center.getDy() + radius);
        }

        @NotNull
        public final Rect fromPoints(@NotNull Offset a, @NotNull Offset b) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            return new Rect(Math.min(a.getDx(), b.getDx()), Math.min(a.getDy(), b.getDy()), Math.max(a.getDx(), b.getDx()), Math.max(a.getDy(), b.getDy()));
        }

        @NotNull
        public final Rect getZero() {
            return zero;
        }

        public final float get_giantScalar() {
            return _giantScalar;
        }

        @NotNull
        public final Rect getLargest() {
            return largest;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

