/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.ui.geometry.Offset;
import androidx.ui.geometry.RRect;
import androidx.ui.geometry.Radius;
import androidx.ui.geometry.Rect;
import androidx.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u0016\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a6\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0014\u001a\u001e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b\u001a.\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014\u001aN\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0014\u001a6\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b\u001a\u001e\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000b\u001a\n\u0010#\u001a\u00020\u0014*\u00020\u0002\u001a\n\u0010$\u001a\u00020\u0014*\u00020\u0002\u001a\n\u0010%\u001a\u00020&*\u00020\u0002\u001a\u0012\u0010'\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020\u000b\u001a\n\u0010)\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010*\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010+\u001a\u00020\u0012*\u00020\u0002\u001a\u0012\u0010,\u001a\u00020\u0002*\u00020\u00022\u0006\u0010-\u001a\u00020&\u001a\u0012\u0010.\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020\u000b\u001a\n\u0010/\u001a\u00020\u0012*\u00020\u0002\u001a\n\u00100\u001a\u00020\u0014*\u00020\u0002\u001a\n\u00101\u001a\u00020\u0014*\u00020\u0002\u001a\n\u00102\u001a\u00020\u0012*\u00020\u0002\u001a\u0012\u00103\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0003\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u00064"}, d2={"isCircle", "", "Landroidx/ui/geometry/RRect;", "(Landroidx/ui/geometry/RRect;)Z", "isEllipse", "isEmpty", "isFinite", "isRect", "isSimple", "isStadium", "longestSide", "", "getLongestSide", "(Landroidx/ui/geometry/RRect;)F", "shortestSide", "getShortestSide", "RRect", "rect", "Landroidx/ui/geometry/Rect;", "radius", "Landroidx/ui/geometry/Radius;", "topLeft", "topRight", "bottomRight", "bottomLeft", "radiusX", "radiusY", "left", "top", "right", "bottom", "lerp", "start", "stop", "fraction", "bottomLeftRadius", "bottomRightRadius", "center", "Landroidx/ui/geometry/Offset;", "grow", "delta", "middleRect", "outerRect", "safeInnerRect", "shift", "offset", "shrink", "tallMiddleRect", "topLeftRadius", "topRightRadius", "wideMiddleRect", "withRadius", "ui-geometry_release"})
public final class RRectKt {
    @NotNull
    public static final RRect RRect(float left, float top, float right, float bottom, float radiusX, float radiusY) {
        return new RRect(left, top, right, bottom, radiusX, radiusY, radiusX, radiusY, radiusX, radiusY, radiusX, radiusY);
    }

    @NotNull
    public static final RRect RRect(float left, float top, float right, float bottom, @NotNull Radius radius) {
        Intrinsics.checkParameterIsNotNull((Object)radius, (String)"radius");
        return RRectKt.RRect(left, top, right, bottom, radius.getX(), radius.getY());
    }

    @NotNull
    public static final RRect RRect(@NotNull Rect rect, float radiusX, float radiusY) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        return RRectKt.RRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), radiusX, radiusY);
    }

    @NotNull
    public static final RRect RRect(@NotNull Rect rect, @NotNull Radius radius) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        Intrinsics.checkParameterIsNotNull((Object)radius, (String)"radius");
        return RRectKt.RRect(rect, radius.getX(), radius.getY());
    }

    @NotNull
    public static final RRect RRect(float left, float top, float right, float bottom, @NotNull Radius topLeft, @NotNull Radius topRight, @NotNull Radius bottomRight, @NotNull Radius bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        return new RRect(left, top, right, bottom, topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    }

    public static /* synthetic */ RRect RRect$default(float left, float top, float right, float bottom, @Nullable Radius topLeft, @Nullable Radius topRight, @Nullable Radius bottomRight, @Nullable Radius bottomLeft, int $mask0, @Nullable Object $handler) {
        Radius radius = ($mask0 & 0x10) != 0 ? Radius.Companion.getZero() : topLeft;
        Radius radius2 = ($mask0 & 0x20) != 0 ? Radius.Companion.getZero() : topRight;
        Radius radius3 = ($mask0 & 0x40) != 0 ? Radius.Companion.getZero() : bottomRight;
        Radius radius4 = ($mask0 & 0x80) != 0 ? Radius.Companion.getZero() : bottomLeft;
        return RRectKt.RRect(left, top, right, bottom, radius, radius2, radius3, radius4);
    }

    @NotNull
    public static final RRect RRect(@NotNull Rect rect, @NotNull Radius topLeft, @NotNull Radius topRight, @NotNull Radius bottomRight, @NotNull Radius bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        return new RRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    }

    public static /* synthetic */ RRect RRect$default(@NotNull Rect rect, @Nullable Radius topLeft, @Nullable Radius topRight, @Nullable Radius bottomRight, @Nullable Radius bottomLeft, int $mask0, @Nullable Object $handler) {
        Radius radius = ($mask0 & 2) != 0 ? Radius.Companion.getZero() : topLeft;
        Radius radius2 = ($mask0 & 4) != 0 ? Radius.Companion.getZero() : topRight;
        Radius radius3 = ($mask0 & 8) != 0 ? Radius.Companion.getZero() : bottomRight;
        Radius radius4 = ($mask0 & 0x10) != 0 ? Radius.Companion.getZero() : bottomLeft;
        return RRectKt.RRect(rect, radius, radius2, radius3, radius4);
    }

    @NotNull
    public static final Radius topLeftRadius(@NotNull RRect $this$topLeftRadius) {
        Intrinsics.checkParameterIsNotNull((Object)$this$topLeftRadius, (String)"<this>");
        return Radius.Companion.elliptical($this$topLeftRadius.getTopLeftRadiusX(), $this$topLeftRadius.getTopLeftRadiusY());
    }

    @NotNull
    public static final Radius topRightRadius(@NotNull RRect $this$topRightRadius) {
        Intrinsics.checkParameterIsNotNull((Object)$this$topRightRadius, (String)"<this>");
        return Radius.Companion.elliptical($this$topRightRadius.getTopRightRadiusX(), $this$topRightRadius.getTopRightRadiusY());
    }

    @NotNull
    public static final Radius bottomRightRadius(@NotNull RRect $this$bottomRightRadius) {
        Intrinsics.checkParameterIsNotNull((Object)$this$bottomRightRadius, (String)"<this>");
        return Radius.Companion.elliptical($this$bottomRightRadius.getBottomRightRadiusX(), $this$bottomRightRadius.getBottomRightRadiusY());
    }

    @NotNull
    public static final Radius bottomLeftRadius(@NotNull RRect $this$bottomLeftRadius) {
        Intrinsics.checkParameterIsNotNull((Object)$this$bottomLeftRadius, (String)"<this>");
        return Radius.Companion.elliptical($this$bottomLeftRadius.getBottomLeftRadiusX(), $this$bottomLeftRadius.getBottomLeftRadiusY());
    }

    @NotNull
    public static final RRect shift(@NotNull RRect $this$shift, @NotNull Offset offset) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shift, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        return RRectKt.RRect($this$shift.getLeft() + offset.getDx(), $this$shift.getTop() + offset.getDy(), $this$shift.getRight() + offset.getDx(), $this$shift.getBottom() + offset.getDy(), Radius.Companion.elliptical($this$shift.getTopLeftRadiusX(), $this$shift.getTopLeftRadiusY()), Radius.Companion.elliptical($this$shift.getTopRightRadiusX(), $this$shift.getTopRightRadiusY()), Radius.Companion.elliptical($this$shift.getBottomRightRadiusX(), $this$shift.getBottomRightRadiusY()), Radius.Companion.elliptical($this$shift.getBottomLeftRadiusX(), $this$shift.getBottomLeftRadiusY()));
    }

    @NotNull
    public static final RRect grow(@NotNull RRect $this$grow, float delta) {
        Intrinsics.checkParameterIsNotNull((Object)$this$grow, (String)"<this>");
        return RRectKt.RRect($this$grow.getLeft() - delta, $this$grow.getTop() - delta, $this$grow.getRight() + delta, $this$grow.getBottom() + delta, Radius.Companion.elliptical($this$grow.getTopLeftRadiusX() + delta, $this$grow.getTopLeftRadiusY() + delta), Radius.Companion.elliptical($this$grow.getTopRightRadiusX() + delta, $this$grow.getTopRightRadiusY() + delta), Radius.Companion.elliptical($this$grow.getBottomRightRadiusX() + delta, $this$grow.getBottomRightRadiusY() + delta), Radius.Companion.elliptical($this$grow.getBottomLeftRadiusX() + delta, $this$grow.getBottomLeftRadiusY() + delta));
    }

    @NotNull
    public static final RRect withRadius(@NotNull RRect $this$withRadius, @NotNull Radius radius) {
        Intrinsics.checkParameterIsNotNull((Object)$this$withRadius, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)radius, (String)"radius");
        float f = $this$withRadius.getLeft();
        float f2 = $this$withRadius.getTop();
        float f3 = $this$withRadius.getRight();
        float f4 = $this$withRadius.getBottom();
        Radius radius2 = radius;
        Radius radius3 = radius;
        Radius radius4 = radius;
        Radius radius5 = radius;
        return RRectKt.RRect(f, f2, f3, f4, radius2, radius3, radius5, radius4);
    }

    @NotNull
    public static final RRect shrink(@NotNull RRect $this$shrink, float delta) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shrink, (String)"<this>");
        return RRectKt.grow($this$shrink, -delta);
    }

    @NotNull
    public static final Rect outerRect(@NotNull RRect $this$outerRect) {
        Intrinsics.checkParameterIsNotNull((Object)$this$outerRect, (String)"<this>");
        return Rect.Companion.fromLTRB($this$outerRect.getLeft(), $this$outerRect.getTop(), $this$outerRect.getRight(), $this$outerRect.getBottom());
    }

    @NotNull
    public static final Rect safeInnerRect(@NotNull RRect $this$safeInnerRect) {
        Intrinsics.checkParameterIsNotNull((Object)$this$safeInnerRect, (String)"<this>");
        float insetFactor = 0.29289323f;
        float leftRadius = Math.max($this$safeInnerRect.getBottomLeftRadiusX(), $this$safeInnerRect.getTopLeftRadiusX());
        float topRadius = Math.max($this$safeInnerRect.getTopLeftRadiusY(), $this$safeInnerRect.getTopRightRadiusY());
        float rightRadius = Math.max($this$safeInnerRect.getTopRightRadiusX(), $this$safeInnerRect.getBottomRightRadiusX());
        float bottomRadius = Math.max($this$safeInnerRect.getBottomRightRadiusY(), $this$safeInnerRect.getBottomLeftRadiusY());
        return Rect.Companion.fromLTRB($this$safeInnerRect.getLeft() + leftRadius * insetFactor, $this$safeInnerRect.getTop() + topRadius * insetFactor, $this$safeInnerRect.getRight() - rightRadius * insetFactor, $this$safeInnerRect.getBottom() - bottomRadius * insetFactor);
    }

    @NotNull
    public static final Rect middleRect(@NotNull RRect $this$middleRect) {
        Intrinsics.checkParameterIsNotNull((Object)$this$middleRect, (String)"<this>");
        float leftRadius = Math.max($this$middleRect.getBottomLeftRadiusX(), $this$middleRect.getTopLeftRadiusX());
        float topRadius = Math.max($this$middleRect.getTopLeftRadiusY(), $this$middleRect.getTopRightRadiusY());
        float rightRadius = Math.max($this$middleRect.getTopRightRadiusX(), $this$middleRect.getBottomRightRadiusX());
        float bottomRadius = Math.max($this$middleRect.getBottomRightRadiusY(), $this$middleRect.getBottomLeftRadiusY());
        return Rect.Companion.fromLTRB($this$middleRect.getLeft() + leftRadius, $this$middleRect.getTop() + topRadius, $this$middleRect.getRight() - rightRadius, $this$middleRect.getBottom() - bottomRadius);
    }

    @NotNull
    public static final Rect wideMiddleRect(@NotNull RRect $this$wideMiddleRect) {
        Intrinsics.checkParameterIsNotNull((Object)$this$wideMiddleRect, (String)"<this>");
        float topRadius = Math.max($this$wideMiddleRect.getTopLeftRadiusY(), $this$wideMiddleRect.getTopRightRadiusY());
        float bottomRadius = Math.max($this$wideMiddleRect.getBottomRightRadiusY(), $this$wideMiddleRect.getBottomLeftRadiusY());
        return Rect.Companion.fromLTRB($this$wideMiddleRect.getLeft(), $this$wideMiddleRect.getTop() + topRadius, $this$wideMiddleRect.getRight(), $this$wideMiddleRect.getBottom() - bottomRadius);
    }

    @NotNull
    public static final Rect tallMiddleRect(@NotNull RRect $this$tallMiddleRect) {
        Intrinsics.checkParameterIsNotNull((Object)$this$tallMiddleRect, (String)"<this>");
        float leftRadius = Math.max($this$tallMiddleRect.getBottomLeftRadiusX(), $this$tallMiddleRect.getTopLeftRadiusX());
        float rightRadius = Math.max($this$tallMiddleRect.getTopRightRadiusX(), $this$tallMiddleRect.getBottomRightRadiusX());
        return Rect.Companion.fromLTRB($this$tallMiddleRect.getLeft() + leftRadius, $this$tallMiddleRect.getTop(), $this$tallMiddleRect.getRight() - rightRadius, $this$tallMiddleRect.getBottom());
    }

    public static final boolean isEmpty(@NotNull RRect $this$isEmpty) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.getLeft() >= $this$isEmpty.getRight() || $this$isEmpty.getTop() >= $this$isEmpty.getBottom();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFinite(@NotNull RRect $this$isFinite) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFinite, (String)"<this>");
        float f = $this$isFinite.getLeft();
        boolean bl = false;
        float f2 = f;
        boolean bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        f = $this$isFinite.getTop();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        f = $this$isFinite.getRight();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        f = $this$isFinite.getBottom();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        return true;
    }

    public static final boolean isRect(@NotNull RRect $this$isRect) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isRect, (String)"<this>");
        return !(!($this$isRect.getTopLeftRadiusX() == 0.0f) && !($this$isRect.getTopLeftRadiusY() == 0.0f) || !($this$isRect.getTopRightRadiusX() == 0.0f) && !($this$isRect.getTopRightRadiusY() == 0.0f) || !($this$isRect.getBottomLeftRadiusX() == 0.0f) && !($this$isRect.getBottomLeftRadiusY() == 0.0f) || !($this$isRect.getBottomRightRadiusX() == 0.0f) && !($this$isRect.getBottomRightRadiusY() == 0.0f));
    }

    public static final boolean isStadium(@NotNull RRect $this$isStadium) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isStadium, (String)"<this>");
        return $this$isStadium.getTopLeftRadiusX() == $this$isStadium.getTopRightRadiusX() && $this$isStadium.getTopLeftRadiusY() == $this$isStadium.getTopRightRadiusY() && $this$isStadium.getTopRightRadiusX() == $this$isStadium.getBottomRightRadiusX() && $this$isStadium.getTopRightRadiusY() == $this$isStadium.getBottomRightRadiusY() && $this$isStadium.getBottomRightRadiusX() == $this$isStadium.getBottomLeftRadiusX() && $this$isStadium.getBottomRightRadiusY() == $this$isStadium.getBottomLeftRadiusY() && ((double)$this$isStadium.getWidth() <= 2.0 * (double)$this$isStadium.getTopLeftRadiusX() || (double)$this$isStadium.getHeight() <= 2.0 * (double)$this$isStadium.getTopLeftRadiusY());
    }

    public static final boolean isEllipse(@NotNull RRect $this$isEllipse) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isEllipse, (String)"<this>");
        return $this$isEllipse.getTopLeftRadiusX() == $this$isEllipse.getTopRightRadiusX() && $this$isEllipse.getTopLeftRadiusY() == $this$isEllipse.getTopRightRadiusY() && $this$isEllipse.getTopRightRadiusX() == $this$isEllipse.getBottomRightRadiusX() && $this$isEllipse.getTopRightRadiusY() == $this$isEllipse.getBottomRightRadiusY() && $this$isEllipse.getBottomRightRadiusX() == $this$isEllipse.getBottomLeftRadiusX() && $this$isEllipse.getBottomRightRadiusY() == $this$isEllipse.getBottomLeftRadiusY() && (double)$this$isEllipse.getWidth() <= 2.0 * (double)$this$isEllipse.getTopLeftRadiusX() && (double)$this$isEllipse.getHeight() <= 2.0 * (double)$this$isEllipse.getTopLeftRadiusY();
    }

    public static final boolean isCircle(@NotNull RRect $this$isCircle) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isCircle, (String)"<this>");
        return $this$isCircle.getWidth() == $this$isCircle.getHeight() && RRectKt.isEllipse($this$isCircle);
    }

    public static final float getShortestSide(@NotNull RRect $this$shortestSide) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shortestSide, (String)"<this>");
        float f = $this$shortestSide.getWidth();
        boolean bl = false;
        float f2 = Math.abs(f);
        f = $this$shortestSide.getHeight();
        float f3 = f2;
        bl = false;
        float f4 = Math.abs(f);
        return Math.min(f3, f4);
    }

    public static final float getLongestSide(@NotNull RRect $this$longestSide) {
        Intrinsics.checkParameterIsNotNull((Object)$this$longestSide, (String)"<this>");
        float f = $this$longestSide.getWidth();
        boolean bl = false;
        float f2 = Math.abs(f);
        f = $this$longestSide.getHeight();
        float f3 = f2;
        bl = false;
        float f4 = Math.abs(f);
        return Math.max(f3, f4);
    }

    @NotNull
    public static final Offset center(@NotNull RRect $this$center) {
        Intrinsics.checkParameterIsNotNull((Object)$this$center, (String)"<this>");
        return new Offset($this$center.getLeft() + $this$center.getWidth() / 2.0f, $this$center.getTop() + $this$center.getHeight() / 2.0f);
    }

    public static final boolean isSimple(@NotNull RRect $this$isSimple) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isSimple, (String)"<this>");
        return $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getTopLeftRadiusY() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getTopRightRadiusX() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getTopRightRadiusY() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getBottomRightRadiusX() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getBottomRightRadiusY() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getBottomLeftRadiusX() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getBottomLeftRadiusY();
    }

    @NotNull
    public static final RRect lerp(@NotNull RRect start, @NotNull RRect stop, float fraction) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
        return new RRect(MathHelpersKt.lerp((float)start.getLeft(), (float)stop.getLeft(), (float)fraction), MathHelpersKt.lerp((float)start.getTop(), (float)stop.getTop(), (float)fraction), MathHelpersKt.lerp((float)start.getRight(), (float)stop.getRight(), (float)fraction), MathHelpersKt.lerp((float)start.getBottom(), (float)stop.getBottom(), (float)fraction), MathHelpersKt.lerp((float)start.getTopLeftRadiusX(), (float)stop.getTopLeftRadiusX(), (float)fraction), MathHelpersKt.lerp((float)start.getTopLeftRadiusY(), (float)stop.getTopLeftRadiusY(), (float)fraction), MathHelpersKt.lerp((float)start.getTopRightRadiusX(), (float)stop.getTopRightRadiusX(), (float)fraction), MathHelpersKt.lerp((float)start.getTopRightRadiusY(), (float)stop.getTopRightRadiusY(), (float)fraction), MathHelpersKt.lerp((float)start.getBottomRightRadiusX(), (float)stop.getBottomRightRadiusX(), (float)fraction), MathHelpersKt.lerp((float)start.getBottomRightRadiusY(), (float)stop.getBottomRightRadiusY(), (float)fraction), MathHelpersKt.lerp((float)start.getBottomLeftRadiusX(), (float)stop.getBottomLeftRadiusX(), (float)fraction), MathHelpersKt.lerp((float)start.getBottomLeftRadiusY(), (float)stop.getBottomLeftRadiusY(), (float)fraction));
    }
}

