/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.ui.geometry.Offset;
import androidx.ui.geometry.OffsetBase;
import androidx.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\u0016J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000eH\u0086\u0002J\u0011\u0010#\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000eH\u0086\u0002J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003H\u0086\u0002J\b\u0010'\u001a\u00020(H\u0016J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010+\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006."}, d2={"Landroidx/ui/geometry/Size;", "Landroidx/ui/geometry/OffsetBase;", "width", "", "height", "(FF)V", "dx", "getDx", "()F", "dy", "getDy", "getHeight", "getWidth", "bottomCenter", "Landroidx/ui/geometry/Offset;", "origin", "bottomLeft", "bottomRight", "center", "centerLeft", "centerRight", "contains", "", "offset", "div", "operand", "equals", "other", "", "getFlipped", "getLongestSide", "getShortestSide", "hashCode", "", "isEmpty", "minus", "plus", "rem", "times", "toString", "", "topCenter", "topLeft", "topRight", "truncDiv", "Companion", "ui-geometry_release"})
public class Size
implements OffsetBase {
    private final float width;
    private final float height;
    private final float dx;
    private final float dy;
    private static final Size zero;
    private static final Size infinite;
    @NotNull
    public static final Companion Companion;

    public Size(float width, float height) {
        this.width = width;
        this.height = height;
        this.dx = this.getWidth();
        this.dy = this.getHeight();
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    @Override
    public float getDx() {
        return this.dx;
    }

    @Override
    public float getDy() {
        return this.dy;
    }

    public final boolean isEmpty() {
        return this.getWidth() <= 0.0f || this.getHeight() <= 0.0f;
    }

    @NotNull
    public final Size minus(@NotNull Offset other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Size(this.getWidth() - other.getDx(), this.getHeight() - other.getDy());
    }

    @NotNull
    public final Offset minus(@NotNull Size other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Offset(this.getWidth() - other.getWidth(), this.getHeight() - other.getHeight());
    }

    @NotNull
    public final Size plus(@NotNull Offset other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Size(this.getWidth() + other.getDx(), this.getHeight() + other.getDy());
    }

    @NotNull
    public final Size times(float operand) {
        return new Size(this.getWidth() * operand, this.getHeight() * operand);
    }

    @NotNull
    public final Size div(float operand) {
        return new Size(this.getWidth() / operand, this.getHeight() / operand);
    }

    @NotNull
    public final Size truncDiv(float operand) {
        return new Size(MathKt.truncate((float)(this.getWidth() / operand)), MathKt.truncate((float)(this.getHeight() / operand)));
    }

    @NotNull
    public final Size rem(float operand) {
        return new Size(this.getWidth() % operand, this.getHeight() % operand);
    }

    public final float getShortestSide() {
        float f = this.getWidth();
        boolean bl = false;
        float f2 = Math.abs(f);
        f = this.getHeight();
        float f3 = f2;
        bl = false;
        float f4 = Math.abs(f);
        return Math.min(f3, f4);
    }

    public final float getLongestSide() {
        float f = this.getWidth();
        boolean bl = false;
        float f2 = Math.abs(f);
        f = this.getHeight();
        float f3 = f2;
        bl = false;
        float f4 = Math.abs(f);
        return Math.max(f3, f4);
    }

    @NotNull
    public final Offset topLeft(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return origin;
    }

    @NotNull
    public final Offset topCenter(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new Offset(origin.getDx() + this.getWidth() / 2.0f, origin.getDy());
    }

    @NotNull
    public final Offset topRight(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new Offset(origin.getDx() + this.getWidth(), origin.getDy());
    }

    @NotNull
    public final Offset centerLeft(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new Offset(origin.getDx(), origin.getDy() + this.getHeight() / 2.0f);
    }

    @NotNull
    public final Offset center(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new Offset(origin.getDx() + this.getWidth() / 2.0f, origin.getDy() + this.getHeight() / 2.0f);
    }

    @NotNull
    public final Offset centerRight(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new Offset(origin.getDx() + this.getWidth(), origin.getDy() + this.getHeight() / 2.0f);
    }

    @NotNull
    public final Offset bottomLeft(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new Offset(origin.getDx(), origin.getDy() + this.getHeight());
    }

    @NotNull
    public final Offset bottomCenter(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new Offset(origin.getDx() + this.getWidth() / 2.0f, origin.getDy() + this.getHeight());
    }

    @NotNull
    public final Offset bottomRight(@NotNull Offset origin) {
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        return new Offset(origin.getDx() + this.getWidth(), origin.getDy() + this.getHeight());
    }

    public final boolean contains(@NotNull Offset offset) {
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        return offset.getDx() >= 0.0f && offset.getDx() < this.getWidth() && offset.getDy() >= 0.0f && offset.getDy() < this.getHeight();
    }

    @NotNull
    public final Size getFlipped() {
        return new Size(this.getHeight(), this.getWidth());
    }

    @NotNull
    public String toString() {
        return "Size(" + MathHelpersKt.toStringAsFixed((float)this.getWidth(), (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.getHeight(), (int)1) + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Size)) {
            return false;
        }
        return this.getDx() == ((Size)other).getDx() && this.getDy() == ((Size)other).getDy();
    }

    public int hashCode() {
        int result = Float.hashCode(this.getDx());
        result = 31 * result + Float.hashCode(this.getDy());
        return result;
    }

    @Override
    public boolean isFinite() {
        return OffsetBase.DefaultImpls.isFinite(this);
    }

    @Override
    public boolean isGreaterOrEqThan(@NotNull OffsetBase other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return OffsetBase.DefaultImpls.isGreaterOrEqThan(this, other);
    }

    @Override
    public boolean isGreaterThan(@NotNull OffsetBase other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return OffsetBase.DefaultImpls.isGreaterThan(this, other);
    }

    @Override
    public boolean isInfinite() {
        return OffsetBase.DefaultImpls.isInfinite(this);
    }

    @Override
    public boolean isLessOrEqThan(@NotNull OffsetBase other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return OffsetBase.DefaultImpls.isLessOrEqThan(this, other);
    }

    @Override
    public boolean isLessThan(@NotNull OffsetBase other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return OffsetBase.DefaultImpls.isLessThan(this, other);
    }

    static {
        Companion = new Companion(null);
        zero = new Size(0.0f, 0.0f);
        infinite = new Size(FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\rJ \u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0018"}, d2={"Landroidx/ui/geometry/Size$Companion;", "", "()V", "infinite", "Landroidx/ui/geometry/Size;", "getInfinite", "()Landroidx/ui/geometry/Size;", "zero", "getZero", "copy", "source", "fromHeight", "height", "", "fromRadius", "radius", "fromWidth", "width", "lerp", "start", "stop", "fraction", "square", "dimension", "ui-geometry_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Size copy(@NotNull Size source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return new Size(source.getWidth(), source.getHeight());
        }

        @NotNull
        public final Size square(float dimension) {
            return new Size(dimension, dimension);
        }

        @NotNull
        public final Size fromWidth(float width) {
            return new Size(width, FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
        }

        @NotNull
        public final Size fromHeight(float height) {
            return new Size(FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), height);
        }

        @NotNull
        public final Size fromRadius(float radius) {
            return new Size(radius * 2.0f, radius * 2.0f);
        }

        @NotNull
        public final Size getZero() {
            return zero;
        }

        @NotNull
        public final Size getInfinite() {
            return infinite;
        }

        @Nullable
        public final Size lerp(@NotNull Size start, @NotNull Size stop, float fraction) {
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
            return new Size(MathHelpersKt.lerp((float)start.getWidth(), (float)stop.getWidth(), (float)fraction), MathHelpersKt.lerp((float)start.getHeight(), (float)stop.getHeight(), (float)fraction));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

