/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.ui.geometry.Offset;
import androidx.ui.geometry.OffsetKt;
import androidx.ui.geometry.RRect;
import androidx.ui.geometry.Radius;
import androidx.ui.geometry.Rect;
import androidx.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a\u0016\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a6\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0014\u001a\u001e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b\u001a.\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014\u001aN\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0014\u001a6\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b\u001a\u001e\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u000b\u001a\n\u0010#\u001a\u00020\u0014*\u00020\u0002\u001a\n\u0010$\u001a\u00020\u0014*\u00020\u0002\u001a\u0012\u0010%\u001a\u00020&*\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'\u001a\u0012\u0010(\u001a\u00020\u0002*\u00020\u00022\u0006\u0010)\u001a\u00020\u000b\u001a\n\u0010*\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010+\u001a\u00020\u0012*\u00020\u0002\u001a\n\u0010,\u001a\u00020\u0012*\u00020\u0002\u001a\u001c\u0010-\u001a\u00020\u0002*\u00020\u00022\u0006\u0010.\u001a\u00020&\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u00100\u001a\u0012\u00101\u001a\u00020\u0002*\u00020\u00022\u0006\u0010)\u001a\u00020\u000b\u001a\n\u00102\u001a\u00020\u0012*\u00020\u0002\u001a\n\u00103\u001a\u00020\u0014*\u00020\u0002\u001a\n\u00104\u001a\u00020\u0014*\u00020\u0002\u001a\n\u00105\u001a\u00020\u0012*\u00020\u0002\u001a\u0012\u00106\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0003\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"isCircle", "", "Landroidx/ui/geometry/RRect;", "(Landroidx/ui/geometry/RRect;)Z", "isEllipse", "isEmpty", "isFinite", "isRect", "isSimple", "isStadium", "longestSide", "", "getLongestSide", "(Landroidx/ui/geometry/RRect;)F", "shortestSide", "getShortestSide", "RRect", "rect", "Landroidx/ui/geometry/Rect;", "radius", "Landroidx/ui/geometry/Radius;", "topLeft", "topRight", "bottomRight", "bottomLeft", "radiusX", "radiusY", "left", "top", "right", "bottom", "lerp", "start", "stop", "fraction", "bottomLeftRadius", "bottomRightRadius", "center", "Landroidx/ui/geometry/Offset;", "(Landroidx/ui/geometry/RRect;)J", "grow", "delta", "middleRect", "outerRect", "safeInnerRect", "shift", "offset", "shift-q6ZkaaM", "(Landroidx/ui/geometry/RRect;J)Landroidx/ui/geometry/RRect;", "shrink", "tallMiddleRect", "topLeftRadius", "topRightRadius", "wideMiddleRect", "withRadius", "ui-geometry_release"})
public final class RRectKt {
    @NotNull
    public static final RRect RRect(float left, float top, float right, float bottom, float radiusX, float radiusY) {
        return new RRect(left, top, right, bottom, radiusX, radiusY, radiusX, radiusY, radiusX, radiusY, radiusX, radiusY);
    }

    @NotNull
    public static final RRect RRect(float left, float top, float right, float bottom, @NotNull Radius radius) {
        Intrinsics.checkNotNullParameter((Object)radius, (String)"radius");
        return RRectKt.RRect(left, top, right, bottom, radius.getX(), radius.getY());
    }

    @NotNull
    public static final RRect RRect(@NotNull Rect rect, float radiusX, float radiusY) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return RRectKt.RRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), radiusX, radiusY);
    }

    @NotNull
    public static final RRect RRect(@NotNull Rect rect, @NotNull Radius radius) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)radius, (String)"radius");
        return RRectKt.RRect(rect, radius.getX(), radius.getY());
    }

    @NotNull
    public static final RRect RRect(float left, float top, float right, float bottom, @NotNull Radius topLeft, @NotNull Radius topRight, @NotNull Radius bottomRight, @NotNull Radius bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        return new RRect(left, top, right, bottom, topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    }

    public static /* synthetic */ RRect RRect$default(float left, float top, float right, float bottom, Radius topLeft, Radius topRight, Radius bottomRight, Radius bottomLeft, int n, Object object) {
        if ((n & 0x10) != 0) {
            topLeft = Radius.Companion.getZero();
        }
        if ((n & 0x20) != 0) {
            topRight = Radius.Companion.getZero();
        }
        if ((n & 0x40) != 0) {
            bottomRight = Radius.Companion.getZero();
        }
        if ((n & 0x80) != 0) {
            bottomLeft = Radius.Companion.getZero();
        }
        return RRectKt.RRect(left, top, right, bottom, topLeft, topRight, bottomRight, bottomLeft);
    }

    @NotNull
    public static final RRect RRect(@NotNull Rect rect, @NotNull Radius topLeft, @NotNull Radius topRight, @NotNull Radius bottomRight, @NotNull Radius bottomLeft) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)topRight, (String)"topRight");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkNotNullParameter((Object)bottomLeft, (String)"bottomLeft");
        return new RRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    }

    public static /* synthetic */ RRect RRect$default(Rect rect, Radius topLeft, Radius topRight, Radius bottomRight, Radius bottomLeft, int n, Object object) {
        if ((n & 2) != 0) {
            topLeft = Radius.Companion.getZero();
        }
        if ((n & 4) != 0) {
            topRight = Radius.Companion.getZero();
        }
        if ((n & 8) != 0) {
            bottomRight = Radius.Companion.getZero();
        }
        if ((n & 0x10) != 0) {
            bottomLeft = Radius.Companion.getZero();
        }
        return RRectKt.RRect(rect, topLeft, topRight, bottomRight, bottomLeft);
    }

    @NotNull
    public static final Radius topLeftRadius(@NotNull RRect $this$topLeftRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$topLeftRadius, (String)"<this>");
        return Radius.Companion.elliptical($this$topLeftRadius.getTopLeftRadiusX(), $this$topLeftRadius.getTopLeftRadiusY());
    }

    @NotNull
    public static final Radius topRightRadius(@NotNull RRect $this$topRightRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$topRightRadius, (String)"<this>");
        return Radius.Companion.elliptical($this$topRightRadius.getTopRightRadiusX(), $this$topRightRadius.getTopRightRadiusY());
    }

    @NotNull
    public static final Radius bottomRightRadius(@NotNull RRect $this$bottomRightRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$bottomRightRadius, (String)"<this>");
        return Radius.Companion.elliptical($this$bottomRightRadius.getBottomRightRadiusX(), $this$bottomRightRadius.getBottomRightRadiusY());
    }

    @NotNull
    public static final Radius bottomLeftRadius(@NotNull RRect $this$bottomLeftRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$bottomLeftRadius, (String)"<this>");
        return Radius.Companion.elliptical($this$bottomLeftRadius.getBottomLeftRadiusX(), $this$bottomLeftRadius.getBottomLeftRadiusY());
    }

    @NotNull
    public static final RRect shift-q6ZkaaM(@NotNull RRect $receiver, long offset) {
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        return RRectKt.RRect($receiver.getLeft() + Offset.getDx-impl(offset), $receiver.getTop() + Offset.getDy-impl(offset), $receiver.getRight() + Offset.getDx-impl(offset), $receiver.getBottom() + Offset.getDy-impl(offset), Radius.Companion.elliptical($receiver.getTopLeftRadiusX(), $receiver.getTopLeftRadiusY()), Radius.Companion.elliptical($receiver.getTopRightRadiusX(), $receiver.getTopRightRadiusY()), Radius.Companion.elliptical($receiver.getBottomRightRadiusX(), $receiver.getBottomRightRadiusY()), Radius.Companion.elliptical($receiver.getBottomLeftRadiusX(), $receiver.getBottomLeftRadiusY()));
    }

    @NotNull
    public static final RRect grow(@NotNull RRect $this$grow, float delta) {
        Intrinsics.checkNotNullParameter((Object)$this$grow, (String)"<this>");
        return RRectKt.RRect($this$grow.getLeft() - delta, $this$grow.getTop() - delta, $this$grow.getRight() + delta, $this$grow.getBottom() + delta, Radius.Companion.elliptical($this$grow.getTopLeftRadiusX() + delta, $this$grow.getTopLeftRadiusY() + delta), Radius.Companion.elliptical($this$grow.getTopRightRadiusX() + delta, $this$grow.getTopRightRadiusY() + delta), Radius.Companion.elliptical($this$grow.getBottomRightRadiusX() + delta, $this$grow.getBottomRightRadiusY() + delta), Radius.Companion.elliptical($this$grow.getBottomLeftRadiusX() + delta, $this$grow.getBottomLeftRadiusY() + delta));
    }

    @NotNull
    public static final RRect withRadius(@NotNull RRect $this$withRadius, @NotNull Radius radius) {
        Intrinsics.checkNotNullParameter((Object)$this$withRadius, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)radius, (String)"radius");
        float f = $this$withRadius.getLeft();
        float f2 = $this$withRadius.getTop();
        float f3 = $this$withRadius.getRight();
        float f4 = $this$withRadius.getBottom();
        Radius radius2 = radius;
        Radius radius3 = radius;
        Radius radius4 = radius;
        Radius radius5 = radius;
        return RRectKt.RRect(f, f2, f3, f4, radius2, radius3, radius5, radius4);
    }

    @NotNull
    public static final RRect shrink(@NotNull RRect $this$shrink, float delta) {
        Intrinsics.checkNotNullParameter((Object)$this$shrink, (String)"<this>");
        return RRectKt.grow($this$shrink, -delta);
    }

    @NotNull
    public static final Rect outerRect(@NotNull RRect $this$outerRect) {
        Intrinsics.checkNotNullParameter((Object)$this$outerRect, (String)"<this>");
        return Rect.Companion.fromLTRB($this$outerRect.getLeft(), $this$outerRect.getTop(), $this$outerRect.getRight(), $this$outerRect.getBottom());
    }

    @NotNull
    public static final Rect safeInnerRect(@NotNull RRect $this$safeInnerRect) {
        Intrinsics.checkNotNullParameter((Object)$this$safeInnerRect, (String)"<this>");
        float insetFactor = 0.29289323f;
        float f = $this$safeInnerRect.getBottomLeftRadiusX();
        float f2 = $this$safeInnerRect.getTopLeftRadiusX();
        boolean bl = false;
        float leftRadius = Math.max(f, f2);
        f2 = $this$safeInnerRect.getTopLeftRadiusY();
        float f3 = $this$safeInnerRect.getTopRightRadiusY();
        boolean bl2 = false;
        float topRadius = Math.max(f2, f3);
        f3 = $this$safeInnerRect.getTopRightRadiusX();
        float f4 = $this$safeInnerRect.getBottomRightRadiusX();
        boolean bl3 = false;
        float rightRadius = Math.max(f3, f4);
        f4 = $this$safeInnerRect.getBottomRightRadiusY();
        float f5 = $this$safeInnerRect.getBottomLeftRadiusY();
        boolean bl4 = false;
        float bottomRadius = Math.max(f4, f5);
        return Rect.Companion.fromLTRB($this$safeInnerRect.getLeft() + leftRadius * insetFactor, $this$safeInnerRect.getTop() + topRadius * insetFactor, $this$safeInnerRect.getRight() - rightRadius * insetFactor, $this$safeInnerRect.getBottom() - bottomRadius * insetFactor);
    }

    @NotNull
    public static final Rect middleRect(@NotNull RRect $this$middleRect) {
        Intrinsics.checkNotNullParameter((Object)$this$middleRect, (String)"<this>");
        float f = $this$middleRect.getBottomLeftRadiusX();
        float f2 = $this$middleRect.getTopLeftRadiusX();
        boolean bl = false;
        float leftRadius = Math.max(f, f2);
        f2 = $this$middleRect.getTopLeftRadiusY();
        float f3 = $this$middleRect.getTopRightRadiusY();
        boolean bl2 = false;
        float topRadius = Math.max(f2, f3);
        f3 = $this$middleRect.getTopRightRadiusX();
        float f4 = $this$middleRect.getBottomRightRadiusX();
        boolean bl3 = false;
        float rightRadius = Math.max(f3, f4);
        f4 = $this$middleRect.getBottomRightRadiusY();
        float f5 = $this$middleRect.getBottomLeftRadiusY();
        boolean bl4 = false;
        float bottomRadius = Math.max(f4, f5);
        return Rect.Companion.fromLTRB($this$middleRect.getLeft() + leftRadius, $this$middleRect.getTop() + topRadius, $this$middleRect.getRight() - rightRadius, $this$middleRect.getBottom() - bottomRadius);
    }

    @NotNull
    public static final Rect wideMiddleRect(@NotNull RRect $this$wideMiddleRect) {
        Intrinsics.checkNotNullParameter((Object)$this$wideMiddleRect, (String)"<this>");
        float f = $this$wideMiddleRect.getTopLeftRadiusY();
        float f2 = $this$wideMiddleRect.getTopRightRadiusY();
        boolean bl = false;
        float topRadius = Math.max(f, f2);
        f2 = $this$wideMiddleRect.getBottomRightRadiusY();
        float f3 = $this$wideMiddleRect.getBottomLeftRadiusY();
        boolean bl2 = false;
        float bottomRadius = Math.max(f2, f3);
        return Rect.Companion.fromLTRB($this$wideMiddleRect.getLeft(), $this$wideMiddleRect.getTop() + topRadius, $this$wideMiddleRect.getRight(), $this$wideMiddleRect.getBottom() - bottomRadius);
    }

    @NotNull
    public static final Rect tallMiddleRect(@NotNull RRect $this$tallMiddleRect) {
        Intrinsics.checkNotNullParameter((Object)$this$tallMiddleRect, (String)"<this>");
        float f = $this$tallMiddleRect.getBottomLeftRadiusX();
        float f2 = $this$tallMiddleRect.getTopLeftRadiusX();
        boolean bl = false;
        float leftRadius = Math.max(f, f2);
        f2 = $this$tallMiddleRect.getTopRightRadiusX();
        float f3 = $this$tallMiddleRect.getBottomRightRadiusX();
        boolean bl2 = false;
        float rightRadius = Math.max(f2, f3);
        return Rect.Companion.fromLTRB($this$tallMiddleRect.getLeft() + leftRadius, $this$tallMiddleRect.getTop(), $this$tallMiddleRect.getRight() - rightRadius, $this$tallMiddleRect.getBottom());
    }

    public static final boolean isEmpty(@NotNull RRect $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.getLeft() >= $this$isEmpty.getRight() || $this$isEmpty.getTop() >= $this$isEmpty.getBottom();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFinite(@NotNull RRect $this$isFinite) {
        Intrinsics.checkNotNullParameter((Object)$this$isFinite, (String)"<this>");
        float f = $this$isFinite.getLeft();
        boolean bl = false;
        float f2 = f;
        boolean bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        f = $this$isFinite.getTop();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        f = $this$isFinite.getRight();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        f = $this$isFinite.getBottom();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        return true;
    }

    public static final boolean isRect(@NotNull RRect $this$isRect) {
        Intrinsics.checkNotNullParameter((Object)$this$isRect, (String)"<this>");
        return !(!($this$isRect.getTopLeftRadiusX() == 0.0f) && !($this$isRect.getTopLeftRadiusY() == 0.0f) || !($this$isRect.getTopRightRadiusX() == 0.0f) && !($this$isRect.getTopRightRadiusY() == 0.0f) || !($this$isRect.getBottomLeftRadiusX() == 0.0f) && !($this$isRect.getBottomLeftRadiusY() == 0.0f) || !($this$isRect.getBottomRightRadiusX() == 0.0f) && !($this$isRect.getBottomRightRadiusY() == 0.0f));
    }

    public static final boolean isStadium(@NotNull RRect $this$isStadium) {
        Intrinsics.checkNotNullParameter((Object)$this$isStadium, (String)"<this>");
        return $this$isStadium.getTopLeftRadiusX() == $this$isStadium.getTopRightRadiusX() && $this$isStadium.getTopLeftRadiusY() == $this$isStadium.getTopRightRadiusY() && $this$isStadium.getTopRightRadiusX() == $this$isStadium.getBottomRightRadiusX() && $this$isStadium.getTopRightRadiusY() == $this$isStadium.getBottomRightRadiusY() && $this$isStadium.getBottomRightRadiusX() == $this$isStadium.getBottomLeftRadiusX() && $this$isStadium.getBottomRightRadiusY() == $this$isStadium.getBottomLeftRadiusY() && ((double)$this$isStadium.getWidth() <= 2.0 * (double)$this$isStadium.getTopLeftRadiusX() || (double)$this$isStadium.getHeight() <= 2.0 * (double)$this$isStadium.getTopLeftRadiusY());
    }

    public static final boolean isEllipse(@NotNull RRect $this$isEllipse) {
        Intrinsics.checkNotNullParameter((Object)$this$isEllipse, (String)"<this>");
        return $this$isEllipse.getTopLeftRadiusX() == $this$isEllipse.getTopRightRadiusX() && $this$isEllipse.getTopLeftRadiusY() == $this$isEllipse.getTopRightRadiusY() && $this$isEllipse.getTopRightRadiusX() == $this$isEllipse.getBottomRightRadiusX() && $this$isEllipse.getTopRightRadiusY() == $this$isEllipse.getBottomRightRadiusY() && $this$isEllipse.getBottomRightRadiusX() == $this$isEllipse.getBottomLeftRadiusX() && $this$isEllipse.getBottomRightRadiusY() == $this$isEllipse.getBottomLeftRadiusY() && (double)$this$isEllipse.getWidth() <= 2.0 * (double)$this$isEllipse.getTopLeftRadiusX() && (double)$this$isEllipse.getHeight() <= 2.0 * (double)$this$isEllipse.getTopLeftRadiusY();
    }

    public static final boolean isCircle(@NotNull RRect $this$isCircle) {
        Intrinsics.checkNotNullParameter((Object)$this$isCircle, (String)"<this>");
        return $this$isCircle.getWidth() == $this$isCircle.getHeight() && RRectKt.isEllipse($this$isCircle);
    }

    public static final float getShortestSide(@NotNull RRect $this$shortestSide) {
        Intrinsics.checkNotNullParameter((Object)$this$shortestSide, (String)"<this>");
        float f = $this$shortestSide.getWidth();
        boolean bl = false;
        f = Math.abs(f);
        float f2 = $this$shortestSide.getHeight();
        boolean bl2 = false;
        f2 = Math.abs(f2);
        bl2 = false;
        return Math.min(f, f2);
    }

    public static final float getLongestSide(@NotNull RRect $this$longestSide) {
        Intrinsics.checkNotNullParameter((Object)$this$longestSide, (String)"<this>");
        float f = $this$longestSide.getWidth();
        boolean bl = false;
        f = Math.abs(f);
        float f2 = $this$longestSide.getHeight();
        boolean bl2 = false;
        f2 = Math.abs(f2);
        bl2 = false;
        return Math.max(f, f2);
    }

    public static final long center(@NotNull RRect $this$center) {
        Intrinsics.checkNotNullParameter((Object)$this$center, (String)"<this>");
        return OffsetKt.Offset($this$center.getLeft() + $this$center.getWidth() / 2.0f, $this$center.getTop() + $this$center.getHeight() / 2.0f);
    }

    public static final boolean isSimple(@NotNull RRect $this$isSimple) {
        Intrinsics.checkNotNullParameter((Object)$this$isSimple, (String)"<this>");
        return $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getTopLeftRadiusY() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getTopRightRadiusX() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getTopRightRadiusY() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getBottomRightRadiusX() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getBottomRightRadiusY() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getBottomLeftRadiusX() && $this$isSimple.getTopLeftRadiusX() == $this$isSimple.getBottomLeftRadiusY();
    }

    @NotNull
    public static final RRect lerp(@NotNull RRect start, @NotNull RRect stop, float fraction) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
        return new RRect(MathHelpersKt.lerp((float)start.getLeft(), (float)stop.getLeft(), (float)fraction), MathHelpersKt.lerp((float)start.getTop(), (float)stop.getTop(), (float)fraction), MathHelpersKt.lerp((float)start.getRight(), (float)stop.getRight(), (float)fraction), MathHelpersKt.lerp((float)start.getBottom(), (float)stop.getBottom(), (float)fraction), MathHelpersKt.lerp((float)start.getTopLeftRadiusX(), (float)stop.getTopLeftRadiusX(), (float)fraction), MathHelpersKt.lerp((float)start.getTopLeftRadiusY(), (float)stop.getTopLeftRadiusY(), (float)fraction), MathHelpersKt.lerp((float)start.getTopRightRadiusX(), (float)stop.getTopRightRadiusX(), (float)fraction), MathHelpersKt.lerp((float)start.getTopRightRadiusY(), (float)stop.getTopRightRadiusY(), (float)fraction), MathHelpersKt.lerp((float)start.getBottomRightRadiusX(), (float)stop.getBottomRightRadiusX(), (float)fraction), MathHelpersKt.lerp((float)start.getBottomRightRadiusY(), (float)stop.getBottomRightRadiusY(), (float)fraction), MathHelpersKt.lerp((float)start.getBottomLeftRadiusX(), (float)stop.getBottomLeftRadiusX(), (float)fraction), MathHelpersKt.lerp((float)start.getBottomLeftRadiusY(), (float)stop.getBottomLeftRadiusY(), (float)fraction));
    }
}

