/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.ui.util.JvmMathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Landroidx/ui/geometry/Radius;", "", "x", "", "y", "(FF)V", "getX", "()F", "getY", "component1", "component2", "copy", "div", "operand", "equals", "", "other", "hashCode", "", "minus", "plus", "rem", "times", "toString", "", "truncDiv", "unaryMinus", "Companion", "ui-geometry_release"})
public final class Radius {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private static final Radius zero = Companion.circular(0.0f);

    public Radius(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    @NotNull
    public final Radius unaryMinus() {
        return Companion.elliptical(-this.getX(), -this.getY());
    }

    @NotNull
    public final Radius minus(@NotNull Radius other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.elliptical(this.getX() - other.getX(), this.getY() - other.getY());
    }

    @NotNull
    public final Radius plus(@NotNull Radius other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.elliptical(this.getX() + other.getX(), this.getY() + other.getY());
    }

    @NotNull
    public final Radius times(float operand) {
        return Companion.elliptical(this.getX() * operand, this.getY() * operand);
    }

    @NotNull
    public final Radius div(float operand) {
        return Companion.elliptical(this.getX() / operand, this.getY() / operand);
    }

    @NotNull
    public final Radius truncDiv(float operand) {
        return Companion.elliptical(MathKt.truncate((float)(this.getX() / operand)), MathKt.truncate((float)(this.getY() / operand)));
    }

    @NotNull
    public final Radius rem(float operand) {
        return Companion.elliptical(this.getX() % operand, this.getY() % operand);
    }

    @NotNull
    public String toString() {
        return this.getX() == this.getY() ? "Radius.circular(" + JvmMathHelpersKt.toStringAsFixed((float)this.getX(), (int)1) + ")" : "Radius.elliptical(" + JvmMathHelpersKt.toStringAsFixed((float)this.getX(), (int)1) + ", " + JvmMathHelpersKt.toStringAsFixed((float)this.getY(), (int)1) + ")";
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    @NotNull
    public final Radius copy(float x, float y) {
        return new Radius(x, y);
    }

    public static /* synthetic */ Radius copy$default(Radius this_, float x, float y, int n, Object object) {
        if ((n & 1) != 0) {
            x = this_.x;
        }
        if ((n & 2) != 0) {
            y = this_.y;
        }
        return this_.copy(x, y);
    }

    public int hashCode() {
        return Float.hashCode(this.x) * 31 + Float.hashCode(this.y);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Radius)) {
            return false;
        }
        Object object = other;
        Radius radius = (Radius)object;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.x), (Object)Float.valueOf(radius.x))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.y), (Object)Float.valueOf(radius.y));
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Landroidx/ui/geometry/Radius$Companion;", "", "()V", "zero", "Landroidx/ui/geometry/Radius;", "getZero", "()Landroidx/ui/geometry/Radius;", "circular", "radius", "", "elliptical", "x", "y", "ui-geometry_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Radius circular(float radius) {
            return new Radius(radius, radius);
        }

        @NotNull
        public final Radius elliptical(float x, float y) {
            return new Radius(x, y);
        }

        @NotNull
        public final Radius getZero() {
            return zero;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

