/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.geometry;

import androidx.ui.geometry.Offset;
import androidx.ui.geometry.OffsetKt;
import androidx.ui.geometry.SizeKt;
import androidx.ui.util.JvmMathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 B2\u00020\u0001:\u0001BB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u0013\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010(\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010)\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010*\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010+\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010,\u001a\u00020-\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010.\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u0010/\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u000e\u00100\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\t\u00101\u001a\u000202H\u00d6\u0001J\u000e\u00103\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u000e\u00104\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000J\u0006\u00105\u001a\u00020\u001aJ\u0006\u00106\u001a\u00020\u001aJ\u0006\u00107\u001a\u00020\u001aJ\u000e\u00108\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000J\u000e\u00109\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0000J\u0018\u0010:\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c\u00f8\u0001\u0000\u00a2\u0006\u0004\b;\u0010<J\b\u0010=\u001a\u00020>H\u0016J\u0016\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006C"}, d2={"Landroidx/ui/geometry/Rect;", "", "left", "", "top", "right", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "getLeft", "maxDimension", "getMaxDimension", "minDimension", "getMinDimension", "getRight", "getTop", "width", "getWidth", "component1", "component2", "component3", "component4", "contains", "", "offset", "Landroidx/ui/geometry/Offset;", "contains-RIqb49o", "(J)Z", "copy", "deflate", "delta", "equals", "other", "expandToInclude", "getBottomCenter", "()J", "getBottomLeft", "getBottomRight", "getCenter", "getCenterLeft", "getCenterRight", "getSize", "Landroidx/ui/geometry/Size;", "getTopCenter", "getTopLeft", "getTopRight", "hashCode", "", "inflate", "intersect", "isEmpty", "isFinite", "isInfinite", "join", "overlaps", "shift", "shift-RIqb49o", "(J)Landroidx/ui/geometry/Rect;", "toString", "", "translate", "translateX", "translateY", "Companion", "ui-geometry_release"})
public final class Rect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    private final float width;
    private final float height;
    private static final Rect zero = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
    private static final float _giantScalar = 1.0E7f;
    private static final Rect largest = Companion.fromLTRB(-Companion.get_giantScalar(), -Companion.get_giantScalar(), Companion.get_giantScalar(), Companion.get_giantScalar());

    public Rect(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = this.getRight() - this.getLeft();
        this.height = this.getBottom() - this.getTop();
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final long getSize() {
        return SizeKt.Size(this.getWidth(), this.getHeight());
    }

    public final boolean isInfinite() {
        return this.getLeft() >= FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() || this.getTop() >= FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() || this.getRight() >= FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY() || this.getBottom() >= FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFinite() {
        float f = this.getLeft();
        boolean bl = false;
        float f2 = f;
        boolean bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        f = this.getTop();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        f = this.getRight();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        f = this.getBottom();
        bl = false;
        f2 = f;
        bl2 = false;
        if (Float.isInfinite(f2)) return false;
        f2 = f;
        bl2 = false;
        if (Float.isNaN(f2)) return false;
        return true;
    }

    public final boolean isEmpty() {
        return this.getLeft() >= this.getRight() || this.getTop() >= this.getBottom();
    }

    @NotNull
    public final Rect shift-RIqb49o(long offset) {
        return Companion.fromLTRB(this.getLeft() + Offset.getDx-impl(offset), this.getTop() + Offset.getDy-impl(offset), this.getRight() + Offset.getDx-impl(offset), this.getBottom() + Offset.getDy-impl(offset));
    }

    @NotNull
    public final Rect translate(float translateX, float translateY) {
        return Companion.fromLTRB(this.getLeft() + translateX, this.getTop() + translateY, this.getRight() + translateX, this.getBottom() + translateY);
    }

    @NotNull
    public final Rect inflate(float delta) {
        return Companion.fromLTRB(this.getLeft() - delta, this.getTop() - delta, this.getRight() + delta, this.getBottom() + delta);
    }

    @NotNull
    public final Rect deflate(float delta) {
        return this.inflate(-delta);
    }

    @NotNull
    public final Rect intersect(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        float f = this.getLeft();
        float f2 = other.getLeft();
        Companion companion = Companion;
        boolean bl = false;
        float f3 = Math.max(f, f2);
        f = this.getTop();
        f2 = other.getTop();
        bl = false;
        float f4 = Math.max(f, f2);
        f = this.getRight();
        f2 = other.getRight();
        bl = false;
        float f5 = Math.min(f, f2);
        f = this.getBottom();
        f2 = other.getBottom();
        bl = false;
        float f6 = Math.min(f, f2);
        return companion.fromLTRB(f3, f4, f5, f6);
    }

    @NotNull
    public final Rect expandToInclude(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        float f = this.getLeft();
        float f2 = other.getLeft();
        Companion companion = Companion;
        boolean bl = false;
        float f3 = Math.min(f, f2);
        f = this.getTop();
        f2 = other.getTop();
        bl = false;
        float f4 = Math.min(f, f2);
        f = this.getRight();
        f2 = other.getRight();
        bl = false;
        float f5 = Math.max(f, f2);
        f = this.getBottom();
        f2 = other.getBottom();
        bl = false;
        float f6 = Math.max(f, f2);
        return companion.fromLTRB(f3, f4, f5, f6);
    }

    @NotNull
    public final Rect join(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        return this.expandToInclude(other);
    }

    public final boolean overlaps(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.getRight() <= other.getLeft() || other.getRight() <= this.getLeft()) {
            return false;
        }
        return !(this.getBottom() <= other.getTop()) && !(other.getBottom() <= this.getTop());
    }

    public final float getMinDimension() {
        float f = this.getWidth();
        boolean bl = false;
        f = Math.abs(f);
        float f2 = this.getHeight();
        boolean bl2 = false;
        f2 = Math.abs(f2);
        bl2 = false;
        return Math.min(f, f2);
    }

    public final float getMaxDimension() {
        float f = this.getWidth();
        boolean bl = false;
        f = Math.abs(f);
        float f2 = this.getHeight();
        boolean bl2 = false;
        f2 = Math.abs(f2);
        bl2 = false;
        return Math.max(f, f2);
    }

    public final long getTopLeft() {
        return OffsetKt.Offset(this.getLeft(), this.getTop());
    }

    public final long getTopCenter() {
        return OffsetKt.Offset(this.getLeft() + this.getWidth() / 2.0f, this.getTop());
    }

    public final long getTopRight() {
        return OffsetKt.Offset(this.getRight(), this.getTop());
    }

    public final long getCenterLeft() {
        return OffsetKt.Offset(this.getLeft(), this.getTop() + this.getHeight() / 2.0f);
    }

    public final long getCenter() {
        return OffsetKt.Offset(this.getLeft() + this.getWidth() / 2.0f, this.getTop() + this.getHeight() / 2.0f);
    }

    public final long getCenterRight() {
        return OffsetKt.Offset(this.getRight(), this.getTop() + this.getHeight() / 2.0f);
    }

    public final long getBottomLeft() {
        return OffsetKt.Offset(this.getLeft(), this.getBottom());
    }

    public final long getBottomCenter() {
        return OffsetKt.Offset(this.getLeft() + this.getWidth() / 2.0f, this.getBottom());
    }

    public final long getBottomRight() {
        return OffsetKt.Offset(this.getRight(), this.getBottom());
    }

    public final boolean contains-RIqb49o(long offset) {
        return Offset.getDx-impl(offset) >= this.getLeft() && Offset.getDx-impl(offset) < this.getRight() && Offset.getDy-impl(offset) >= this.getTop() && Offset.getDy-impl(offset) < this.getBottom();
    }

    @NotNull
    public String toString() {
        return "Rect.fromLTRB(" + JvmMathHelpersKt.toStringAsFixed((float)this.getLeft(), (int)1) + ", " + JvmMathHelpersKt.toStringAsFixed((float)this.getTop(), (int)1) + ", " + JvmMathHelpersKt.toStringAsFixed((float)this.getRight(), (int)1) + ", " + JvmMathHelpersKt.toStringAsFixed((float)this.getBottom(), (int)1) + ")";
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    @NotNull
    public final Rect copy(float left, float top, float right, float bottom) {
        return new Rect(left, top, right, bottom);
    }

    public static /* synthetic */ Rect copy$default(Rect this_, float left, float top, float right, float bottom, int n, Object object) {
        if ((n & 1) != 0) {
            left = this_.left;
        }
        if ((n & 2) != 0) {
            top = this_.top;
        }
        if ((n & 4) != 0) {
            right = this_.right;
        }
        if ((n & 8) != 0) {
            bottom = this_.bottom;
        }
        return this_.copy(left, top, right, bottom);
    }

    public int hashCode() {
        return ((Float.hashCode(this.left) * 31 + Float.hashCode(this.top)) * 31 + Float.hashCode(this.right)) * 31 + Float.hashCode(this.bottom);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        Object object = other;
        Rect rect = (Rect)object;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.left), (Object)Float.valueOf(rect.left))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.top), (Object)Float.valueOf(rect.top))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.right), (Object)Float.valueOf(rect.right))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.bottom), (Object)Float.valueOf(rect.bottom));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J&\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J&\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J \u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Landroidx/ui/geometry/Rect$Companion;", "", "()V", "_giantScalar", "", "get_giantScalar", "()F", "largest", "Landroidx/ui/geometry/Rect;", "getLargest", "()Landroidx/ui/geometry/Rect;", "zero", "getZero", "fromCircle", "center", "Landroidx/ui/geometry/Offset;", "radius", "fromCircle-hSKLB2U", "(JF)Landroidx/ui/geometry/Rect;", "fromLTRB", "left", "top", "right", "bottom", "fromLTWH", "width", "height", "fromPoints", "a", "b", "fromPoints-cs1Rg_A", "(JJ)Landroidx/ui/geometry/Rect;", "ui-geometry_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rect fromLTRB(float left, float top, float right, float bottom) {
            return new Rect(left, top, right, bottom);
        }

        @NotNull
        public final Rect fromLTWH(float left, float top, float width, float height) {
            return new Rect(left, top, left + width, top + height);
        }

        @NotNull
        public final Rect fromCircle-hSKLB2U(long center, float radius) {
            return new Rect(Offset.getDx-impl(center) - radius, Offset.getDy-impl(center) - radius, Offset.getDx-impl(center) + radius, Offset.getDy-impl(center) + radius);
        }

        @NotNull
        public final Rect fromPoints-cs1Rg_A(long a, long b) {
            float f;
            float f2 = Offset.getDx-impl(a);
            float f3 = Offset.getDx-impl(b);
            boolean bl = false;
            float f4 = Math.min(f2, f3);
            f2 = Offset.getDy-impl(a);
            f3 = Offset.getDy-impl(b);
            bl = false;
            float f5 = Math.min(f2, f3);
            f2 = Offset.getDx-impl(a);
            f3 = Offset.getDx-impl(b);
            bl = false;
            float f6 = Math.max(f2, f3);
            f2 = Offset.getDy-impl(a);
            f3 = Offset.getDy-impl(b);
            bl = false;
            float f7 = f = Math.max(f2, f3);
            float f8 = f6;
            float f9 = f5;
            float f10 = f4;
            return new Rect(f10, f9, f8, f7);
        }

        @NotNull
        public final Rect getZero() {
            return zero;
        }

        public final float get_giantScalar() {
            return _giantScalar;
        }

        @NotNull
        public final Rect getLargest() {
            return largest;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

