/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.Region;
import androidx.ui.core.RectHelperKt;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.RRect;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.AndroidImageAssetKt;
import androidx.ui.graphics.AndroidPath;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.BlendMode;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.CanvasUtils;
import androidx.ui.graphics.ClipOp;
import androidx.ui.graphics.ImageAsset;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.Picture;
import androidx.ui.graphics.PointMode;
import androidx.ui.graphics.Vertices;
import androidx.ui.graphics.vectormath.Matrix4;
import androidx.ui.graphics.vectormath.Matrix4Kt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J0\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J \u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0016J*\u0010-\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010\u00162\u0006\u0010/\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J \u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0016J&\u00103\u001a\u00020\u000f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020'052\u0006\u0010#\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0002J\u0018\u00108\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u00109\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<H\u0016J&\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020?2\f\u00104\u001a\b\u0012\u0004\u0012\u00020'052\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010=\u001a\u00020\u000f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020'052\u0006\u0010#\u001a\u00020$H\u0002J \u0010@\u001a\u00020\u000f2\u0006\u00104\u001a\u00020A2\u0006\u0010#\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0002J \u0010B\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020?2\u0006\u00104\u001a\u00020A2\u0006\u0010#\u001a\u00020$H\u0016J \u0010B\u001a\u00020\u000f2\u0006\u00104\u001a\u00020A2\u0006\u0010#\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0002J\u0018\u0010C\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J@\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J \u0010K\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010P\u001a\u00020\u000fH\u0016J\b\u0010Q\u001a\u00020\u000fH\u0016J\u0010\u0010R\u001a\u00020\u000f2\u0006\u0010S\u001a\u00020\u001fH\u0016J\b\u0010T\u001a\u00020\u000fH\u0016J\u0018\u0010U\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010W\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u001f2\u0006\u0010Y\u001a\u00020\u001fH\u0016J\u0018\u0010Z\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u001f2\u0006\u0010Y\u001a\u00020\u001fH\u0016J\u0018\u0010[\u001a\u00020\u000f2\u0006\u0010\\\u001a\u00020\u001f2\u0006\u0010]\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00060\u0003j\u0002`\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\u00a8\u0006^"}, d2={"Landroidx/ui/graphics/AndroidCanvas;", "Landroidx/ui/graphics/Canvas;", "internalCanvas", "Landroid/graphics/Canvas;", "(Landroid/graphics/Canvas;)V", "getInternalCanvas", "()Landroid/graphics/Canvas;", "internalPath", "Landroidx/ui/graphics/Path;", "internalRectF", "Landroid/graphics/RectF;", "nativeCanvas", "Landroidx/ui/graphics/NativeCanvas;", "getNativeCanvas", "clipPath", "", "path", "clipRRect", "rrect", "Landroidx/ui/geometry/RRect;", "clipRect", "rect", "Landroidx/ui/geometry/Rect;", "clipOp", "Landroidx/ui/graphics/ClipOp;", "concat", "matrix4", "Landroidx/ui/graphics/vectormath/Matrix4;", "disableZ", "drawArc", "startAngle", "", "sweepAngle", "useCenter", "", "paint", "Landroidx/ui/graphics/Paint;", "drawCircle", "center", "Landroidx/ui/geometry/Offset;", "radius", "drawImage", "image", "Landroidx/ui/graphics/ImageAsset;", "topLeftOffset", "drawImageRect", "src", "dst", "drawLine", "p1", "p2", "drawLines", "points", "", "stepBy", "", "drawOval", "drawPath", "drawPicture", "picture", "Landroidx/ui/graphics/Picture;", "drawPoints", "pointMode", "Landroidx/ui/graphics/PointMode;", "drawRawLines", "", "drawRawPoints", "drawRect", "drawRoundRect", "left", "top", "right", "bottom", "radiusX", "radiusY", "drawVertices", "vertices", "Landroidx/ui/graphics/Vertices;", "blendMode", "Landroidx/ui/graphics/BlendMode;", "enableZ", "restore", "rotate", "degrees", "save", "saveLayer", "bounds", "scale", "sx", "sy", "skew", "translate", "dx", "dy", "ui-graphics_release"})
final class AndroidCanvas
implements Canvas {
    private final android.graphics.Canvas internalCanvas;
    private final Path internalPath;
    private final RectF internalRectF;

    public AndroidCanvas(@NotNull android.graphics.Canvas internalCanvas) {
        Intrinsics.checkNotNullParameter((Object)internalCanvas, (String)"internalCanvas");
        this.internalCanvas = internalCanvas;
        this.internalPath = AndroidPathKt.Path();
        this.internalRectF = new RectF();
    }

    @NotNull
    public final android.graphics.Canvas getInternalCanvas() {
        return this.internalCanvas;
    }

    @Override
    public void save() {
        this.getInternalCanvas().save();
    }

    @Override
    public void restore() {
        this.getInternalCanvas().restore();
    }

    @Override
    @NotNull
    public android.graphics.Canvas getNativeCanvas() {
        return this.getInternalCanvas();
    }

    @Override
    public void saveLayer(@NotNull Rect bounds, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.getInternalCanvas().saveLayer(bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom(), paint.asFrameworkPaint(), 31);
    }

    @Override
    public void translate(float dx, float dy) {
        this.getInternalCanvas().translate(dx, dy);
    }

    @Override
    public void scale(float sx, float sy) {
        this.getInternalCanvas().scale(sx, sy);
    }

    @Override
    public void rotate(float degrees) {
        this.getInternalCanvas().rotate(degrees);
    }

    @Override
    public void skew(float sx, float sy) {
        this.getInternalCanvas().skew(sx, sy);
    }

    @Override
    public void concat(@NotNull Matrix4 matrix4) {
        Intrinsics.checkNotNullParameter((Object)matrix4, (String)"matrix4");
        if (!Matrix4Kt.isIdentity(matrix4)) {
            Matrix frameworkMatrix = new Matrix();
            if (!(matrix4.get(2, 0) == 0.0f && matrix4.get(2, 1) == 0.0f && matrix4.get(2, 0) == 0.0f && matrix4.get(2, 1) == 0.0f && matrix4.get(2, 2) == 1.0f && matrix4.get(2, 3) == 0.0f && matrix4.get(3, 2) == 0.0f)) {
                throw new IllegalStateException("Android does not support arbitrary transforms");
            }
            float[] fArray = new float[]{matrix4.get(0, 0), matrix4.get(1, 0), matrix4.get(3, 0), matrix4.get(0, 1), matrix4.get(1, 1), matrix4.get(3, 1), matrix4.get(0, 3), matrix4.get(1, 3), matrix4.get(3, 3)};
            float[] values = fArray;
            frameworkMatrix.setValues(values);
            this.getInternalCanvas().concat(frameworkMatrix);
        }
    }

    @Override
    public void clipRect(@NotNull Rect rect, @NotNull ClipOp clipOp) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)((Object)clipOp), (String)"clipOp");
        android.graphics.Rect frameworkRect = RectHelperKt.toAndroidRect(rect);
        ClipOp clipOp2 = clipOp;
        int n = WhenMappings.$EnumSwitchMapping$0[clipOp2.ordinal()];
        switch (n) {
            case 1: {
                this.getInternalCanvas().clipRect(frameworkRect);
                break;
            }
            case 2: {
                this.getInternalCanvas().clipRect(frameworkRect, Region.Op.DIFFERENCE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void clipRRect(@NotNull RRect rrect) {
        Intrinsics.checkNotNullParameter((Object)rrect, (String)"rrect");
        this.internalPath.reset();
        this.internalPath.addRRect(rrect);
        this.clipPath(this.internalPath);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clipPath(@NotNull Path path) {
        void $this$asAndroidPath$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path;
        android.graphics.Canvas canvas = this.getInternalCanvas();
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path3 = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        canvas.clipPath(path3);
    }

    @Override
    public void drawLine(@NotNull Offset p1, @NotNull Offset p2, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.getInternalCanvas().drawLine(p1.getDx(), p1.getDy(), p2.getDx(), p2.getDy(), paint.asFrameworkPaint());
    }

    @Override
    public void drawRect(@NotNull Rect rect, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.getInternalCanvas().drawRect(RectHelperKt.toAndroidRectF(rect), paint.asFrameworkPaint());
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float radiusX, float radiusY, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.getInternalCanvas().drawRoundRect(left, top, right, bottom, radiusX, radiusY, paint.asFrameworkPaint());
    }

    @Override
    public void drawOval(@NotNull Rect rect, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.internalRectF.set(RectHelperKt.toAndroidRect(rect));
        this.getInternalCanvas().drawOval(this.internalRectF, paint.asFrameworkPaint());
    }

    @Override
    public void drawCircle(@NotNull Offset center, float radius, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.getInternalCanvas().drawCircle(center.getDx(), center.getDy(), radius, paint.asFrameworkPaint());
    }

    @Override
    public void drawArc(@NotNull Rect rect, float startAngle, float sweepAngle, boolean useCenter, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.internalRectF.set(RectHelperKt.toAndroidRect(rect));
        this.getInternalCanvas().drawArc(this.internalRectF, startAngle, sweepAngle, useCenter, paint.asFrameworkPaint());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawPath(@NotNull Path path, @NotNull Paint paint) {
        void $this$asAndroidPath$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Path path2 = path;
        android.graphics.Canvas canvas = this.getInternalCanvas();
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path3 = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        canvas.drawPath(path3, paint.asFrameworkPaint());
    }

    @Override
    public void drawImage(@NotNull ImageAsset image, @NotNull Offset topLeftOffset, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)topLeftOffset, (String)"topLeftOffset");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.getInternalCanvas().drawBitmap(AndroidImageAssetKt.asAndroidBitmap(image), topLeftOffset.getDx(), topLeftOffset.getDy(), paint.asFrameworkPaint());
    }

    @Override
    public void drawImageRect(@NotNull ImageAsset image, @Nullable Rect src, @NotNull Rect dst, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Rect rect = src;
        this.getInternalCanvas().drawBitmap(AndroidImageAssetKt.asAndroidBitmap(image), rect == null ? (android.graphics.Rect)null : RectHelperKt.toAndroidRect(rect), RectHelperKt.toAndroidRect(dst), paint.asFrameworkPaint());
    }

    @Override
    public void drawPicture(@NotNull Picture picture) {
        Intrinsics.checkNotNullParameter((Object)picture, (String)"picture");
        this.getInternalCanvas().drawPicture(picture.getFrameworkPicture());
    }

    @Override
    public void drawPoints(@NotNull PointMode pointMode, @NotNull List<Offset> points, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)((Object)pointMode), (String)"pointMode");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        PointMode pointMode2 = pointMode;
        int n = WhenMappings.$EnumSwitchMapping$1[pointMode2.ordinal()];
        switch (n) {
            case 1: {
                this.drawLines(points, paint, 2);
                break;
            }
            case 2: {
                this.drawLines(points, paint, 1);
                break;
            }
            case 3: {
                this.drawPoints(points, paint);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void enableZ() {
        CanvasUtils.INSTANCE.enableZ(this.getInternalCanvas(), true);
    }

    @Override
    public void disableZ() {
        CanvasUtils.INSTANCE.enableZ(this.getInternalCanvas(), false);
    }

    private final void drawPoints(List<Offset> points, Paint paint) {
        for (Offset point : points) {
            this.getInternalCanvas().drawPoint(point.getDx(), point.getDy(), paint.asFrameworkPaint());
        }
    }

    private final void drawLines(List<Offset> points, Paint paint, int stepBy) {
        if (points.size() >= 2) {
            int n = points.size() - 1;
            int n2 = n + -1;
            if (stepBy <= 0) {
                throw new IllegalArgumentException("Step must be positive, was: " + stepBy + ".");
            }
            int n3 = stepBy;
            int n4 = 0;
            int n5 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n2, (int)n3);
            int n6 = n3;
            if (n != Integer.MIN_VALUE && n4 <= n5) {
                int i;
                do {
                    i = n4;
                    n4 += n6;
                    Offset p1 = points.get(i);
                    Offset p2 = points.get(i + 1);
                    this.getInternalCanvas().drawLine(p1.getDx(), p1.getDy(), p2.getDx(), p2.getDy(), paint.asFrameworkPaint());
                } while (i != n5);
            }
        }
    }

    @Override
    public void drawRawPoints(@NotNull PointMode pointMode, @NotNull float[] points, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)((Object)pointMode), (String)"pointMode");
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("points must have an even number of values");
        }
        PointMode pointMode2 = pointMode;
        int n = WhenMappings.$EnumSwitchMapping$1[pointMode2.ordinal()];
        switch (n) {
            case 1: {
                this.drawRawLines(points, paint, 2);
                break;
            }
            case 2: {
                this.drawRawLines(points, paint, 1);
                break;
            }
            case 3: {
                this.drawRawPoints(points, paint, 2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void drawRawPoints(float[] points, Paint paint, int stepBy) {
        if (points.length % 2 == 0) {
            int n = points.length - 1;
            int n2 = n + -1;
            if (stepBy <= 0) {
                throw new IllegalArgumentException("Step must be positive, was: " + stepBy + ".");
            }
            int n3 = stepBy;
            int n4 = 0;
            int n5 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n2, (int)n3);
            int n6 = n3;
            if (n != Integer.MIN_VALUE && n4 <= n5) {
                int i;
                do {
                    i = n4;
                    n4 += n6;
                    float x = points[i];
                    float y = points[i + 1];
                    this.getInternalCanvas().drawPoint(x, y, paint.asFrameworkPaint());
                } while (i != n5);
            }
        }
    }

    private final void drawRawLines(float[] points, Paint paint, int stepBy) {
        if (points.length >= 4 && points.length % 2 == 0) {
            int n = points.length - 3;
            int n2 = n + -1;
            int n3 = stepBy * 2;
            if (n3 <= 0) {
                throw new IllegalArgumentException("Step must be positive, was: " + n3 + ".");
            }
            int n4 = n3;
            int n5 = 0;
            int n6 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n2, (int)n4);
            int n7 = n4;
            if (n != Integer.MIN_VALUE && n5 <= n6) {
                int i;
                do {
                    i = n5;
                    n5 += n7;
                    float x1 = points[i];
                    float y1 = points[i + 1];
                    float x2 = points[i + 2];
                    float y2 = points[i + 3];
                    this.getInternalCanvas().drawLine(x1, y1, x2, y2, paint.asFrameworkPaint());
                } while (i != n6);
            }
        }
    }

    @Override
    public void drawVertices(@NotNull Vertices vertices, @NotNull BlendMode blendMode, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        Intrinsics.checkNotNullParameter((Object)((Object)blendMode), (String)"blendMode");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.getInternalCanvas().drawVertices(vertices.getVertexMode().toFrameworkVertexMode(), vertices.getPositions().length, vertices.getPositions(), 0, vertices.getTextureCoordinates(), 0, vertices.getColors(), 0, vertices.getIndices(), 0, vertices.getIndices().length, paint.asFrameworkPaint());
    }

    @Override
    public void drawArcRad(@NotNull Rect rect, float startAngleRad, float sweepAngleRad, boolean useCenter, @NotNull Paint paint) {
        Canvas.DefaultImpls.drawArcRad(this, rect, startAngleRad, sweepAngleRad, useCenter, paint);
    }

    @Override
    public void skewRad(float sxRad, float syRad) {
        Canvas.DefaultImpls.skewRad(this, sxRad, syRad);
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ClipOp.values().length];
            nArray[ClipOp.intersect.ordinal()] = 1;
            nArray[ClipOp.difference.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PointMode.values().length];
            nArray[PointMode.lines.ordinal()] = 1;
            nArray[PointMode.polygon.ordinal()] = 2;
            nArray[PointMode.points.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

