/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import androidx.ui.geometry.Rect;
import androidx.ui.graphics.AndroidCanvas;
import androidx.ui.graphics.AndroidImageAssetKt;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.ImageAsset;
import androidx.ui.graphics.PictureRecorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Canvas", "Landroidx/ui/graphics/Canvas;", "c", "Landroid/graphics/Canvas;", "image", "Landroidx/ui/graphics/ImageAsset;", "recorder", "Landroidx/ui/graphics/PictureRecorder;", "cullRect", "Landroidx/ui/geometry/Rect;", "ui-graphics_release"})
public final class AndroidCanvasKt {
    @NotNull
    public static final Canvas Canvas(@NotNull ImageAsset image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return new AndroidCanvas(new android.graphics.Canvas(AndroidImageAssetKt.asAndroidBitmap(image)));
    }

    @NotNull
    public static final Canvas Canvas(@NotNull PictureRecorder recorder, @NotNull Rect cullRect) {
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        Intrinsics.checkNotNullParameter((Object)cullRect, (String)"cullRect");
        android.graphics.Canvas canvas = recorder.getFrameworkPicture$ui_graphics_release().beginRecording((int)cullRect.getWidth(), (int)cullRect.getHeight());
        Intrinsics.checkNotNullExpressionValue((Object)canvas, (String)"recorder.frameworkPicture.beginRecording(\n            cullRect.width.toInt(),\n            cullRect.height.toInt()\n        )");
        return new AndroidCanvas(canvas);
    }

    public static /* synthetic */ Canvas Canvas$default(PictureRecorder recorder, Rect cullRect, int n, Object object) {
        if ((n & 2) != 0) {
            cullRect = Rect.Companion.getLargest();
        }
        return AndroidCanvasKt.Canvas(recorder, cullRect);
    }

    @NotNull
    public static final Canvas Canvas(@NotNull android.graphics.Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new AndroidCanvas(c);
    }
}

