/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.ui.core.RectHelperKt;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.RRect;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.PathFillType;
import androidx.ui.graphics.PathOperation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J \u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010-\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u000fH\u0016J\b\u0010/\u001a\u00020\u001cH\u0016J8\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u001fH\u0016J\b\u00107\u001a\u00020\u001aH\u0016J\u0018\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001fH\u0016J\u0018\u0010;\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001fH\u0016J \u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u00012\u0006\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@H\u0016J(\u0010A\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001fH\u0016J8\u0010B\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u001fH\u0016J\u0018\u0010C\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001fH\u0016J\u0018\u0010D\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u001fH\u0016J(\u0010E\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001fH\u0016J\b\u0010F\u001a\u00020\u001cH\u0016J\u0010\u0010G\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Landroidx/ui/graphics/AndroidPath;", "Landroidx/ui/graphics/Path;", "internalPath", "Landroid/graphics/Path;", "(Landroid/graphics/Path;)V", "value", "Landroidx/ui/graphics/PathFillType;", "fillType", "getFillType", "()Landroidx/ui/graphics/PathFillType;", "setFillType", "(Landroidx/ui/graphics/PathFillType;)V", "getInternalPath", "()Landroid/graphics/Path;", "isConvex", "", "()Z", "isEmpty", "mMatrix", "Landroid/graphics/Matrix;", "radii", "", "rectF", "Landroid/graphics/RectF;", "_rectIsValid", "rect", "Landroidx/ui/geometry/Rect;", "addArc", "", "oval", "startAngleDegrees", "", "sweepAngleDegrees", "addArcRad", "startAngleRadians", "sweepAngleRadians", "addOval", "addPath", "path", "offset", "Landroidx/ui/geometry/Offset;", "addRRect", "rrect", "Landroidx/ui/geometry/RRect;", "addRect", "arcTo", "forceMoveTo", "close", "cubicTo", "x1", "y1", "x2", "y2", "x3", "y3", "getBounds", "lineTo", "dx", "dy", "moveTo", "op", "path1", "path2", "operation", "Landroidx/ui/graphics/PathOperation;", "quadraticBezierTo", "relativeCubicTo", "relativeLineTo", "relativeMoveTo", "relativeQuadraticBezierTo", "reset", "shift", "ui-graphics_release"})
public final class AndroidPath
implements Path {
    private final android.graphics.Path internalPath;
    private final RectF rectF;
    private final float[] radii;
    private final Matrix mMatrix;

    public AndroidPath(@NotNull android.graphics.Path internalPath) {
        Intrinsics.checkNotNullParameter((Object)internalPath, (String)"internalPath");
        this.internalPath = internalPath;
        this.rectF = new RectF();
        this.radii = new float[8];
        this.mMatrix = new Matrix();
    }

    public /* synthetic */ AndroidPath(android.graphics.Path internalPath, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            internalPath = new android.graphics.Path();
        }
        this(internalPath);
    }

    @NotNull
    public final android.graphics.Path getInternalPath() {
        return this.internalPath;
    }

    @Override
    @NotNull
    public PathFillType getFillType() {
        if (Intrinsics.areEqual((Object)this.getInternalPath().getFillType(), (Object)Path.FillType.EVEN_ODD)) {
            return PathFillType.evenOdd;
        }
        return PathFillType.nonZero;
    }

    @Override
    public void setFillType(@NotNull PathFillType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.getInternalPath().setFillType(Intrinsics.areEqual((Object)((Object)value), (Object)((Object)PathFillType.evenOdd)) ? Path.FillType.EVEN_ODD : Path.FillType.WINDING);
    }

    @Override
    public void moveTo(float dx, float dy) {
        this.getInternalPath().moveTo(dx, dy);
    }

    @Override
    public void relativeMoveTo(float dx, float dy) {
        this.getInternalPath().rMoveTo(dx, dy);
    }

    @Override
    public void lineTo(float dx, float dy) {
        this.getInternalPath().lineTo(dx, dy);
    }

    @Override
    public void relativeLineTo(float dx, float dy) {
        this.getInternalPath().rLineTo(dx, dy);
    }

    @Override
    public void quadraticBezierTo(float x1, float y1, float x2, float y2) {
        this.getInternalPath().quadTo(x1, y1, x2, y2);
    }

    @Override
    public void relativeQuadraticBezierTo(float x1, float y1, float x2, float y2) {
        this.getInternalPath().rQuadTo(x1, y1, x2, y2);
    }

    @Override
    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.getInternalPath().cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void relativeCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.getInternalPath().rCubicTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void arcTo(@NotNull Rect rect, float startAngleDegrees, float sweepAngleDegrees, boolean forceMoveTo) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        float left = rect.getLeft();
        float top = rect.getTop();
        float right = rect.getRight();
        float bottom = rect.getBottom();
        this.rectF.set(left, top, right, bottom);
        this.getInternalPath().arcTo(this.rectF, startAngleDegrees, sweepAngleDegrees, forceMoveTo);
    }

    @Override
    public void addRect(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        boolean bl = this._rectIsValid(rect);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.rectF.set(RectHelperKt.toAndroidRect(rect));
        this.getInternalPath().addRect(this.rectF, Path.Direction.CCW);
    }

    @Override
    public void addOval(@NotNull Rect oval) {
        Intrinsics.checkNotNullParameter((Object)oval, (String)"oval");
        this.rectF.set(RectHelperKt.toAndroidRect(oval));
        this.getInternalPath().addOval(this.rectF, Path.Direction.CCW);
    }

    @Override
    public void addArcRad(@NotNull Rect oval, float startAngleRadians, float sweepAngleRadians) {
        Intrinsics.checkNotNullParameter((Object)oval, (String)"oval");
        Rect rect = oval;
        AndroidPath androidPath = this;
        boolean $i$f$degrees = false;
        float f = startAngleRadians * 57.295776f;
        $i$f$degrees = false;
        float f2 = sweepAngleRadians * 57.295776f;
        androidPath.addArc(rect, f, f2);
    }

    @Override
    public void addArc(@NotNull Rect oval, float startAngleDegrees, float sweepAngleDegrees) {
        Intrinsics.checkNotNullParameter((Object)oval, (String)"oval");
        boolean bl = this._rectIsValid(oval);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.rectF.set(RectHelperKt.toAndroidRect(oval));
        this.getInternalPath().addArc(this.rectF, startAngleDegrees, sweepAngleDegrees);
    }

    @Override
    public void addRRect(@NotNull RRect rrect) {
        Intrinsics.checkNotNullParameter((Object)rrect, (String)"rrect");
        this.rectF.set(rrect.getLeft(), rrect.getTop(), rrect.getRight(), rrect.getBottom());
        this.radii[0] = rrect.getTopLeftRadiusX();
        this.radii[1] = rrect.getTopLeftRadiusY();
        this.radii[2] = rrect.getTopRightRadiusX();
        this.radii[3] = rrect.getTopRightRadiusY();
        this.radii[4] = rrect.getBottomRightRadiusX();
        this.radii[5] = rrect.getBottomRightRadiusY();
        this.radii[6] = rrect.getBottomLeftRadiusX();
        this.radii[7] = rrect.getBottomLeftRadiusY();
        this.getInternalPath().addRoundRect(this.rectF, this.radii, Path.Direction.CCW);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addPath(@NotNull Path path, @NotNull Offset offset) {
        void $this$asAndroidPath$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Path path2 = path;
        android.graphics.Path path3 = this.getInternalPath();
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path4 = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        path3.addPath(path4, offset.getDx(), offset.getDy());
    }

    @Override
    public void close() {
        this.getInternalPath().close();
    }

    @Override
    public void reset() {
        this.getInternalPath().reset();
    }

    @Override
    public void shift(@NotNull Offset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        this.mMatrix.reset();
        this.mMatrix.setTranslate(offset.getDx(), offset.getDy());
        this.getInternalPath().transform(this.mMatrix);
    }

    @Override
    @NotNull
    public Rect getBounds() {
        this.getInternalPath().computeBounds(this.rectF, true);
        return new Rect(this.rectF.left, this.rectF.top, this.rectF.right, this.rectF.bottom);
    }

    @Override
    public boolean op(@NotNull Path path1, @NotNull Path path2, @NotNull PathOperation operation) {
        Path $this$asAndroidPath$iv;
        Path.Op op;
        Intrinsics.checkNotNullParameter((Object)path1, (String)"path1");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Object object = operation;
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: {
                op = Path.Op.DIFFERENCE;
                break;
            }
            case 2: {
                op = Path.Op.INTERSECT;
                break;
            }
            case 3: {
                op = Path.Op.REVERSE_DIFFERENCE;
                break;
            }
            case 4: {
                op = Path.Op.UNION;
                break;
            }
            default: {
                op = Path.Op.XOR;
            }
        }
        Path.Op op2 = op;
        object = path1;
        android.graphics.Path path = this.getInternalPath();
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path3 = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        $this$asAndroidPath$iv = path2;
        $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        android.graphics.Path path4 = ((AndroidPath)$this$asAndroidPath$iv).getInternalPath();
        return path.op(path3, path4, op2);
    }

    @Override
    public boolean isConvex() {
        return this.getInternalPath().isConvex();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternalPath().isEmpty();
    }

    private final boolean _rectIsValid(Rect rect) {
        boolean bl = !(FloatCompanionObject.INSTANCE.getNaN() == rect.getLeft());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Rect.left is NaN";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !(FloatCompanionObject.INSTANCE.getNaN() == rect.getTop());
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Rect.top is NaN";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !(FloatCompanionObject.INSTANCE.getNaN() == rect.getRight());
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Rect.right is NaN";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !(FloatCompanionObject.INSTANCE.getNaN() == rect.getBottom());
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl7 = false;
            String string = "Rect.bottom is NaN";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return true;
    }

    @Override
    public void arcToRad(@NotNull Rect rect, float startAngleRadians, float sweepAngleRadians, boolean forceMoveTo) {
        Path.DefaultImpls.arcToRad(this, rect, startAngleRadians, sweepAngleRadians, forceMoveTo);
    }

    public AndroidPath() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathOperation.values().length];
            nArray[PathOperation.difference.ordinal()] = 1;
            nArray[PathOperation.intersect.ordinal()] = 2;
            nArray[PathOperation.reverseDifference.ordinal()] = 3;
            nArray[PathOperation.union.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

