/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Float16;
import androidx.ui.graphics.colorspace.ColorModel;
import androidx.ui.graphics.colorspace.ColorSpace;
import androidx.ui.graphics.colorspace.ColorSpaceKt;
import androidx.ui.graphics.colorspace.ColorSpaces;
import androidx.ui.graphics.colorspace.Rgb;
import androidx.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u0014\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a:\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\u0018\u0010\u0007\u001a\u00020\u00022\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\u001a6\u0010\u0007\u001a\u00020\u00022\b\b\u0001\u0010\b\u001a\u00020\u00112\b\b\u0001\u0010\n\u001a\u00020\u00112\b\b\u0001\u0010\u000b\u001a\u00020\u00112\b\b\u0003\u0010\f\u001a\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\u0016\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u001a1\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0082\b\u001a*\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00022\b\b\u0001\u0010\u001f\u001a\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!\u001a\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0002\u001a\u001c\u0010$\u001a\u00020\u0002*\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'\u001a\u0016\u0010(\u001a\u00020)*\u00020\u0002H\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b*\u0010+\u001a\u0014\u0010,\u001a\u00020\t*\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.\u001a\u0016\u0010/\u001a\u00020\u0011*\u00020\u0002H\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101\u001a(\u00102\u001a\u00020\u0002*\u00020\u00022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000204H\u0086\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b5\u00106\"\u0019\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0019\u0010\u0005\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u009920\u0001\u00a8\u00067"}, d2={"isSet", "", "Landroidx/ui/graphics/Color;", "isSet-QEYXlZo", "(J)Z", "isUnset", "isUnset-QEYXlZo", "Color", "red", "", "green", "blue", "alpha", "colorSpace", "Landroidx/ui/graphics/colorspace/ColorSpace;", "(FFFFLandroidx/ui/graphics/colorspace/ColorSpace;)J", "color", "", "(I)J", "(IIII)J", "", "(J)J", "compositeComponent", "fgC", "bgC", "fgA", "bgA", "a", "lerp", "start", "stop", "fraction", "lerp-hhXNEtA", "(JJF)J", "saturate", "v", "compositeOver", "background", "compositeOver-MsF30Tg", "(JJ)J", "getComponents", "", "getComponents-QEYXlZo", "(J)[F", "luminance", "luminance-QEYXlZo", "(J)F", "toArgb", "toArgb-QEYXlZo", "(J)I", "useOrElse", "block", "Lkotlin/Function0;", "useOrElse-4UtWFt0", "(JLkotlin/jvm/functions/Function0;)J", "ui-graphics_release"})
public final class ColorKt {
    public static final long Color(float red, float green, float blue, float alpha, @NotNull ColorSpace colorSpace) {
        int argb;
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        boolean bl = RangesKt.rangeTo((float)colorSpace.getMinValue(0), (float)colorSpace.getMaxValue(0)).contains((Comparable)Float.valueOf(red)) && RangesKt.rangeTo((float)colorSpace.getMinValue(1), (float)colorSpace.getMaxValue(1)).contains((Comparable)Float.valueOf(green)) && RangesKt.rangeTo((float)colorSpace.getMinValue(2), (float)colorSpace.getMaxValue(2)).contains((Comparable)Float.valueOf(blue)) && RangesKt.rangeTo((float)0.0f, (float)1.0f).contains((Comparable)Float.valueOf(alpha));
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean $i$a$-require-ColorKt$Color$42 = false;
            String string = "red = " + red + ", green = " + green + ", blue = " + blue + ", alpha = " + alpha + " outside the range for " + colorSpace;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (colorSpace.isSrgb()) {
            n = argb = (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
            bl2 = false;
            long l = ULong.constructor-impl((long)n);
            long $i$a$-require-ColorKt$Color$42 = 0xFFFFFFFFL;
            boolean bl3 = false;
            l = ULong.constructor-impl((long)(l & $i$a$-require-ColorKt$Color$42));
            int $i$a$-require-ColorKt$Color$42 = 32;
            boolean bl4 = false;
            return Color.constructor-VKZWuLQ(ULong.constructor-impl((long)(l << $i$a$-require-ColorKt$Color$42)));
        }
        argb = colorSpace.getComponentCount() == 3 ? 1 : 0;
        n = 0;
        bl2 = false;
        if (argb == 0) {
            boolean bl52 = false;
            String string = "Color only works with ColorSpaces with 3 components";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int id = colorSpace.getId$ui_graphics_release();
        n = id != -1 ? 1 : 0;
        bl2 = false;
        boolean bl52 = false;
        if (n == 0) {
            boolean bl6 = false;
            String bl52 = "Unknown color space, please use a color space in ColorSpaces";
            throw (Throwable)new IllegalArgumentException(bl52.toString());
        }
        short r = Float16.constructor-impl(red);
        short g = Float16.constructor-impl(green);
        short b = Float16.constructor-impl(blue);
        float f = 0.0f;
        float f2 = 1.0f;
        boolean bl7 = false;
        f2 = Math.min(alpha, f2);
        bl7 = false;
        int a = (int)(Math.max(f, f2) * 1023.0f + 0.5f);
        short s = r;
        boolean bl8 = false;
        long l = ULong.constructor-impl((long)s);
        long l2 = 65535L;
        boolean bl9 = false;
        l = ULong.constructor-impl((long)(l & l2));
        int n2 = 48;
        boolean bl10 = false;
        l = ULong.constructor-impl((long)(l << n2));
        n2 = g;
        bl10 = false;
        long l3 = ULong.constructor-impl((long)n2);
        long l4 = 65535L;
        boolean bl11 = false;
        l3 = ULong.constructor-impl((long)(l3 & l4));
        int n3 = 32;
        boolean bl12 = false;
        l3 = ULong.constructor-impl((long)(l3 << n3));
        n3 = 0;
        l = ULong.constructor-impl((long)(l | l3));
        short s2 = b;
        bl10 = false;
        long l5 = ULong.constructor-impl((long)s2);
        long l6 = 65535L;
        bl11 = false;
        l5 = ULong.constructor-impl((long)(l5 & l6));
        int n4 = 16;
        bl12 = false;
        l5 = ULong.constructor-impl((long)(l5 << n4));
        n4 = 0;
        l = ULong.constructor-impl((long)(l | l5));
        int n5 = a;
        bl10 = false;
        long l7 = ULong.constructor-impl((long)n5);
        long l8 = 1023L;
        bl11 = false;
        l7 = ULong.constructor-impl((long)(l7 & l8));
        int n6 = 6;
        bl12 = false;
        l7 = ULong.constructor-impl((long)(l7 << n6));
        n6 = 0;
        l = ULong.constructor-impl((long)(l | l7));
        int n7 = id;
        bl10 = false;
        long l9 = ULong.constructor-impl((long)n7);
        long l10 = 63L;
        bl11 = false;
        l9 = ULong.constructor-impl((long)(l9 & l10));
        boolean bl13 = false;
        return Color.constructor-VKZWuLQ(ULong.constructor-impl((long)(l | l9)));
    }

    public static /* synthetic */ long Color$default(float red, float green, float blue, float alpha, ColorSpace colorSpace, int n, Object object) {
        if ((n & 8) != 0) {
            alpha = 1.0f;
        }
        if ((n & 0x10) != 0) {
            colorSpace = ColorSpaces.INSTANCE.getSrgb();
        }
        return ColorKt.Color(red, green, blue, alpha, colorSpace);
    }

    public static final long Color(@ColorInt int color) {
        int n = color;
        boolean bl = false;
        long l = ULong.constructor-impl((long)n);
        int n2 = 32;
        boolean bl2 = false;
        return Color.constructor-VKZWuLQ(ULong.constructor-impl((long)(l << n2)));
    }

    public static final long Color(long color) {
        long l = color;
        boolean bl = false;
        l = ULong.constructor-impl((long)l);
        long l2 = 0xFFFFFFFFL;
        boolean bl2 = false;
        l = ULong.constructor-impl((long)(l & l2));
        int n = 32;
        boolean bl3 = false;
        return Color.constructor-VKZWuLQ(ULong.constructor-impl((long)(l << n)));
    }

    public static final long Color(@IntRange(from=0L, to=255L) int red, @IntRange(from=0L, to=255L) int green, @IntRange(from=0L, to=255L) int blue, @IntRange(from=0L, to=255L) int alpha) {
        int color = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        return ColorKt.Color(color);
    }

    public static /* synthetic */ long Color$default(int red, int green, int blue, int alpha, int n, Object object) {
        if ((n & 8) != 0) {
            alpha = 255;
        }
        return ColorKt.Color(red, green, blue, alpha);
    }

    public static final long lerp-hhXNEtA(long start, long stop, @FloatRange(from=0.0, to=1.0) float fraction) {
        Rgb linearColorSpace = ColorSpaces.INSTANCE.getLinearExtendedSrgb();
        long startColor = Color.convert-impl(start, linearColorSpace);
        long endColor = Color.convert-impl(stop, linearColorSpace);
        float startA = Color.getAlpha-impl(startColor);
        float startR = Color.getRed-impl(startColor);
        float startG = Color.getGreen-impl(startColor);
        float startB = Color.getBlue-impl(startColor);
        float endA = Color.getAlpha-impl(endColor);
        float endR = Color.getRed-impl(endColor);
        float endG = Color.getGreen-impl(endColor);
        float endB = Color.getBlue-impl(endColor);
        float f = MathHelpersKt.lerp((float)startA, (float)endA, (float)fraction);
        float f2 = MathHelpersKt.lerp((float)startR, (float)endR, (float)fraction);
        float f3 = MathHelpersKt.lerp((float)startG, (float)endG, (float)fraction);
        float f4 = MathHelpersKt.lerp((float)startB, (float)endB, (float)fraction);
        Rgb rgb = linearColorSpace;
        long interpolated = ColorKt.Color(f2, f3, f4, f, rgb);
        return Color.convert-impl(interpolated, Color.getColorSpace-impl(stop));
    }

    /*
     * WARNING - void declaration
     */
    public static final long compositeOver-MsF30Tg(long $receiver, long background) {
        void fgC$iv;
        void fgC$iv2;
        void fgC$iv3;
        long fg = Color.convert-impl($receiver, Color.getColorSpace-impl(background));
        float bgA = Color.getAlpha-impl(background);
        float fgA = Color.getAlpha-impl(fg);
        float a = fgA + bgA * (1.0f - fgA);
        float f = Color.getRed-impl(fg);
        float bgC$iv = Color.getRed-impl(background);
        boolean $i$f$compositeComponent = false;
        float r = a == 0.0f ? 0.0f : (fgC$iv3 * fgA + bgC$iv * bgA * (1.0f - fgA)) / a;
        bgC$iv = Color.getGreen-impl(fg);
        float bgC$iv2 = Color.getGreen-impl(background);
        boolean $i$f$compositeComponent2 = false;
        float g = a == 0.0f ? 0.0f : (fgC$iv2 * fgA + bgC$iv2 * bgA * (1.0f - fgA)) / a;
        bgC$iv2 = Color.getBlue-impl(fg);
        float bgC$iv3 = Color.getBlue-impl(background);
        boolean $i$f$compositeComponent3 = false;
        float b = a == 0.0f ? 0.0f : (fgC$iv * fgA + bgC$iv3 * bgA * (1.0f - fgA)) / a;
        return ColorKt.Color(r, g, b, a, Color.getColorSpace-impl(background));
    }

    private static final float compositeComponent(float fgC, float bgC, float fgA, float bgA, float a) {
        boolean $i$f$compositeComponent = false;
        return a == 0.0f ? 0.0f : (fgC * fgA + bgC * bgA * (1.0f - fgA)) / a;
    }

    @Size(value=4L)
    private static final float[] getComponents-QEYXlZo(long $receiver) {
        float[] fArray = new float[]{Color.getRed-impl($receiver), Color.getGreen-impl($receiver), Color.getBlue-impl($receiver), Color.getAlpha-impl($receiver)};
        return fArray;
    }

    public static final float luminance-QEYXlZo(long $receiver) {
        ColorSpace colorSpace = Color.getColorSpace-impl($receiver);
        boolean bl = colorSpace.getModel() == ColorModel.Rgb;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"The specified color must be encoded in an RGB color space. The supplied color space is ", (Object)((Object)colorSpace.getModel()));
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Function1<Double, Double> eotf2 = ((Rgb)colorSpace).getEotf();
        double r = ((Number)eotf2.invoke((Object)Color.getRed-impl($receiver))).doubleValue();
        double g = ((Number)eotf2.invoke((Object)Color.getGreen-impl($receiver))).doubleValue();
        double b = ((Number)eotf2.invoke((Object)Color.getBlue-impl($receiver))).doubleValue();
        return ColorKt.saturate((float)(0.2126 * r + 0.7152 * g + 0.0722 * b));
    }

    private static final float saturate(float v) {
        return v <= 0.0f ? 0.0f : (v >= 1.0f ? 1.0f : v);
    }

    @ColorInt
    public static final int toArgb-QEYXlZo(long $receiver) {
        ColorSpace colorSpace = Color.getColorSpace-impl($receiver);
        if (colorSpace.isSrgb()) {
            long l = $receiver;
            int n = 32;
            boolean bl = false;
            l = ULong.constructor-impl((long)(l >>> n));
            n = 0;
            return (int)l;
        }
        float[] color = ColorKt.getComponents-QEYXlZo($receiver);
        ColorSpaceKt.connect$default(colorSpace, null, null, 3, null).transform(color);
        return (int)(color[3] * 255.0f + 0.5f) << 24 | (int)(color[0] * 255.0f + 0.5f) << 16 | (int)(color[1] * 255.0f + 0.5f) << 8 | (int)(color[2] * 255.0f + 0.5f);
    }

    public static final boolean isSet-QEYXlZo(long $receiver) {
        boolean bl = false;
        return $receiver != Color.Companion.getUnset();
    }

    public static final boolean isUnset-QEYXlZo(long $receiver) {
        boolean bl = false;
        return $receiver == Color.Companion.getUnset();
    }

    public static final long useOrElse-4UtWFt0(long $receiver, @NotNull Function0<Color> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean bl = false;
        boolean bl2 = false;
        return $receiver != Color.Companion.getUnset() ? $receiver : ((Color)block.invoke()).unbox-impl();
    }

    public static final /* synthetic */ float[] access$getComponents-QEYXlZo(long l) {
        return ColorKt.getComponents-QEYXlZo(l);
    }
}

