/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import androidx.ui.graphics.BlendMode;
import androidx.ui.graphics.ColorFilter;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.FilterQuality;
import androidx.ui.graphics.PaintingStyle;
import androidx.ui.graphics.StrokeCap;
import androidx.ui.graphics.StrokeJoin;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010L\u001a\u00020$J\u0010\u0010M\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR'\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0003\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010'R$\u0010)\u001a\u00020(2\u0006\u0010\u0003\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010/\u001a\u0004\u0018\u00010&2\b\u0010\u0003\u001a\u0004\u0018\u00010&8F@FX\u0086\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00105\u001a\u0002042\u0006\u0010\u0003\u001a\u0002048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010;\u001a\u00020:2\u0006\u0010\u0003\u001a\u00020:8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R$\u0010@\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010\u0007\"\u0004\bB\u0010\tR$\u0010C\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010\u0007\"\u0004\bE\u0010\tR$\u0010G\u001a\u00020F2\u0006\u0010\u0003\u001a\u00020F8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010K\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006N"}, d2={"Landroidx/ui/graphics/Paint;", "", "()V", "value", "", "alpha", "getAlpha", "()F", "setAlpha", "(F)V", "Landroidx/ui/graphics/BlendMode;", "blendMode", "getBlendMode", "()Landroidx/ui/graphics/BlendMode;", "setBlendMode", "(Landroidx/ui/graphics/BlendMode;)V", "color", "Landroidx/ui/graphics/Color;", "getColor", "()J", "setColor-QEYXlZo", "(J)V", "Landroidx/ui/graphics/ColorFilter;", "colorFilter", "getColorFilter", "()Landroidx/ui/graphics/ColorFilter;", "setColorFilter", "(Landroidx/ui/graphics/ColorFilter;)V", "Landroidx/ui/graphics/FilterQuality;", "filterQuality", "getFilterQuality", "()Landroidx/ui/graphics/FilterQuality;", "setFilterQuality", "(Landroidx/ui/graphics/FilterQuality;)V", "internalColorFilter", "internalPaint", "Landroid/graphics/Paint;", "internalShader", "Landroidx/ui/graphics/Shader;", "Landroid/graphics/Shader;", "", "isAntiAlias", "()Z", "setAntiAlias", "(Z)V", "porterDuffMode", "Landroid/graphics/PorterDuff$Mode;", "shader", "getShader", "()Landroid/graphics/Shader;", "setShader-DcPGf4I", "(Landroid/graphics/Shader;)V", "Landroidx/ui/graphics/StrokeCap;", "strokeCap", "getStrokeCap", "()Landroidx/ui/graphics/StrokeCap;", "setStrokeCap", "(Landroidx/ui/graphics/StrokeCap;)V", "Landroidx/ui/graphics/StrokeJoin;", "strokeJoin", "getStrokeJoin", "()Landroidx/ui/graphics/StrokeJoin;", "setStrokeJoin", "(Landroidx/ui/graphics/StrokeJoin;)V", "strokeMiterLimit", "getStrokeMiterLimit", "setStrokeMiterLimit", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "Landroidx/ui/graphics/PaintingStyle;", "style", "getStyle", "()Landroidx/ui/graphics/PaintingStyle;", "setStyle", "(Landroidx/ui/graphics/PaintingStyle;)V", "asFrameworkPaint", "porterDuffModeToBlendMode", "ui-graphics_release"})
public final class Paint {
    private android.graphics.Paint internalPaint = new android.graphics.Paint(1);
    private PorterDuff.Mode porterDuffMode = PorterDuff.Mode.SRC_OVER;
    private Shader internalShader;
    private ColorFilter internalColorFilter;

    @NotNull
    public final android.graphics.Paint asFrameworkPaint() {
        return this.internalPaint;
    }

    public final float getAlpha() {
        return (float)this.internalPaint.getAlpha() / 255.0f;
    }

    public final void setAlpha(float value) {
        float f = value * 255.0f;
        android.graphics.Paint paint = this.internalPaint;
        boolean bl = false;
        float f2 = (float)Math.rint(f);
        paint.setAlpha((int)f2);
    }

    public final boolean isAntiAlias() {
        return this.internalPaint.isAntiAlias();
    }

    public final void setAntiAlias(boolean value) {
        this.internalPaint.setAntiAlias(value);
    }

    public final long getColor() {
        return ColorKt.Color(this.internalPaint.getColor());
    }

    public final void setColor-QEYXlZo(long color) {
        this.internalPaint.setColor(ColorKt.toArgb-QEYXlZo(color));
    }

    @NotNull
    public final BlendMode getBlendMode() {
        return this.porterDuffModeToBlendMode(this.porterDuffMode);
    }

    public final void setBlendMode(@NotNull BlendMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.porterDuffMode = value.toPorterDuffMode();
        this.internalPaint.setXfermode((Xfermode)new PorterDuffXfermode(this.porterDuffMode));
    }

    private final BlendMode porterDuffModeToBlendMode(PorterDuff.Mode porterDuffMode) {
        BlendMode blendMode;
        PorterDuff.Mode mode = porterDuffMode;
        int n = WhenMappings.$EnumSwitchMapping$0[mode.ordinal()];
        switch (n) {
            case 1: {
                blendMode = BlendMode.clear;
                break;
            }
            case 2: {
                blendMode = BlendMode.src;
                break;
            }
            case 3: {
                blendMode = BlendMode.dst;
                break;
            }
            case 4: {
                blendMode = BlendMode.srcOver;
                break;
            }
            case 5: {
                blendMode = BlendMode.dstOver;
                break;
            }
            case 6: {
                blendMode = BlendMode.srcIn;
                break;
            }
            case 7: {
                blendMode = BlendMode.dstIn;
                break;
            }
            case 8: {
                blendMode = BlendMode.srcOut;
                break;
            }
            case 9: {
                blendMode = BlendMode.dstOut;
                break;
            }
            case 10: {
                blendMode = BlendMode.srcATop;
                break;
            }
            case 11: {
                blendMode = BlendMode.dstATop;
                break;
            }
            case 12: {
                blendMode = BlendMode.xor;
                break;
            }
            case 13: {
                blendMode = BlendMode.darken;
                break;
            }
            case 14: {
                blendMode = BlendMode.lighten;
                break;
            }
            case 15: {
                blendMode = BlendMode.multiply;
                break;
            }
            case 16: {
                blendMode = BlendMode.screen;
                break;
            }
            case 17: {
                blendMode = BlendMode.plus;
                break;
            }
            case 18: {
                blendMode = BlendMode.overlay;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return blendMode;
    }

    @NotNull
    public final PaintingStyle getStyle() {
        Paint.Style style = this.internalPaint.getStyle();
        int n = style == null ? -1 : WhenMappings.$EnumSwitchMapping$1[style.ordinal()];
        return n == 1 ? PaintingStyle.stroke : PaintingStyle.fill;
    }

    public final void setStyle(@NotNull PaintingStyle value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        PaintingStyle paintingStyle = value;
        int n = WhenMappings.$EnumSwitchMapping$2[paintingStyle.ordinal()];
        Paint.Style style = n == 1 ? Paint.Style.STROKE : Paint.Style.FILL;
        this.internalPaint.setStyle(style);
    }

    public final float getStrokeWidth() {
        return this.internalPaint.getStrokeWidth();
    }

    public final void setStrokeWidth(float value) {
        this.internalPaint.setStrokeWidth(value);
    }

    @NotNull
    public final StrokeCap getStrokeCap() {
        StrokeCap strokeCap;
        Paint.Cap cap = this.internalPaint.getStrokeCap();
        int n = cap == null ? -1 : WhenMappings.$EnumSwitchMapping$3[cap.ordinal()];
        switch (n) {
            case 1: {
                strokeCap = StrokeCap.butt;
                break;
            }
            case 2: {
                strokeCap = StrokeCap.round;
                break;
            }
            case 3: {
                strokeCap = StrokeCap.square;
                break;
            }
            default: {
                strokeCap = StrokeCap.butt;
            }
        }
        return strokeCap;
    }

    public final void setStrokeCap(@NotNull StrokeCap value) {
        Paint.Cap cap;
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        StrokeCap strokeCap = value;
        int n = WhenMappings.$EnumSwitchMapping$4[strokeCap.ordinal()];
        switch (n) {
            case 1: {
                cap = Paint.Cap.SQUARE;
                break;
            }
            case 2: {
                cap = Paint.Cap.ROUND;
                break;
            }
            case 3: {
                cap = Paint.Cap.BUTT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.internalPaint.setStrokeCap(cap);
    }

    @NotNull
    public final StrokeJoin getStrokeJoin() {
        StrokeJoin strokeJoin;
        Paint.Join join = this.internalPaint.getStrokeJoin();
        int n = join == null ? -1 : WhenMappings.$EnumSwitchMapping$5[join.ordinal()];
        switch (n) {
            case 1: {
                strokeJoin = StrokeJoin.miter;
                break;
            }
            case 2: {
                strokeJoin = StrokeJoin.bevel;
                break;
            }
            case 3: {
                strokeJoin = StrokeJoin.round;
                break;
            }
            default: {
                strokeJoin = StrokeJoin.miter;
            }
        }
        return strokeJoin;
    }

    public final void setStrokeJoin(@NotNull StrokeJoin value) {
        Paint.Join join;
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        StrokeJoin strokeJoin = value;
        int n = WhenMappings.$EnumSwitchMapping$6[strokeJoin.ordinal()];
        switch (n) {
            case 1: {
                join = Paint.Join.MITER;
                break;
            }
            case 2: {
                join = Paint.Join.BEVEL;
                break;
            }
            case 3: {
                join = Paint.Join.ROUND;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.internalPaint.setStrokeJoin(join);
    }

    public final float getStrokeMiterLimit() {
        return this.internalPaint.getStrokeMiter();
    }

    public final void setStrokeMiterLimit(float value) {
        this.internalPaint.setStrokeMiter(value);
    }

    @NotNull
    public final FilterQuality getFilterQuality() {
        return !this.internalPaint.isFilterBitmap() ? FilterQuality.none : FilterQuality.low;
    }

    public final void setFilterQuality(@NotNull FilterQuality value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.internalPaint.setFilterBitmap(!Intrinsics.areEqual((Object)((Object)value), (Object)((Object)FilterQuality.none)));
    }

    @Nullable
    public final Shader getShader() {
        return this.internalShader;
    }

    public final void setShader-DcPGf4I(@Nullable Shader value) {
        this.internalShader = value;
        Shader shader = this.internalShader;
        this.internalPaint.setShader(shader == null ? (Shader)null : shader);
    }

    @Nullable
    public final ColorFilter getColorFilter() {
        return this.internalColorFilter;
    }

    public final void setColorFilter(@Nullable ColorFilter value) {
        this.internalColorFilter = value;
        if (value != null) {
            this.internalPaint.setColorFilter((android.graphics.ColorFilter)new PorterDuffColorFilter(ColorKt.toArgb-QEYXlZo(value.getColor()), value.getBlendMode().toPorterDuffMode()));
        } else {
            this.internalPaint.setColorFilter((android.graphics.ColorFilter)null);
        }
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$6;

        static {
            int[] nArray = new int[PorterDuff.Mode.values().length];
            nArray[PorterDuff.Mode.CLEAR.ordinal()] = 1;
            nArray[PorterDuff.Mode.SRC.ordinal()] = 2;
            nArray[PorterDuff.Mode.DST.ordinal()] = 3;
            nArray[PorterDuff.Mode.SRC_OVER.ordinal()] = 4;
            nArray[PorterDuff.Mode.DST_OVER.ordinal()] = 5;
            nArray[PorterDuff.Mode.SRC_IN.ordinal()] = 6;
            nArray[PorterDuff.Mode.DST_IN.ordinal()] = 7;
            nArray[PorterDuff.Mode.SRC_OUT.ordinal()] = 8;
            nArray[PorterDuff.Mode.DST_OUT.ordinal()] = 9;
            nArray[PorterDuff.Mode.SRC_ATOP.ordinal()] = 10;
            nArray[PorterDuff.Mode.DST_ATOP.ordinal()] = 11;
            nArray[PorterDuff.Mode.XOR.ordinal()] = 12;
            nArray[PorterDuff.Mode.DARKEN.ordinal()] = 13;
            nArray[PorterDuff.Mode.LIGHTEN.ordinal()] = 14;
            nArray[PorterDuff.Mode.MULTIPLY.ordinal()] = 15;
            nArray[PorterDuff.Mode.SCREEN.ordinal()] = 16;
            nArray[PorterDuff.Mode.ADD.ordinal()] = 17;
            nArray[PorterDuff.Mode.OVERLAY.ordinal()] = 18;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Paint.Style.values().length];
            nArray[Paint.Style.STROKE.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PaintingStyle.values().length];
            nArray[PaintingStyle.stroke.ordinal()] = 1;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[Paint.Cap.values().length];
            nArray[Paint.Cap.BUTT.ordinal()] = 1;
            nArray[Paint.Cap.ROUND.ordinal()] = 2;
            nArray[Paint.Cap.SQUARE.ordinal()] = 3;
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[StrokeCap.values().length];
            nArray[StrokeCap.square.ordinal()] = 1;
            nArray[StrokeCap.round.ordinal()] = 2;
            nArray[StrokeCap.butt.ordinal()] = 3;
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[Paint.Join.values().length];
            nArray[Paint.Join.MITER.ordinal()] = 1;
            nArray[Paint.Join.BEVEL.ordinal()] = 2;
            nArray[Paint.Join.ROUND.ordinal()] = 3;
            $EnumSwitchMapping$5 = nArray;
            nArray = new int[StrokeJoin.values().length];
            nArray[StrokeJoin.miter.ordinal()] = 1;
            nArray[StrokeJoin.bevel.ordinal()] = 2;
            nArray[StrokeJoin.round.ordinal()] = 3;
            $EnumSwitchMapping$6 = nArray;
        }
    }
}

