/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import android.graphics.BitmapShader;
import android.graphics.LinearGradient;
import android.graphics.RadialGradient;
import androidx.ui.geometry.Offset;
import androidx.ui.graphics.AndroidImageAssetKt;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.ImageAsset;
import androidx.ui.graphics.Shader;
import androidx.ui.graphics.TileMode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u001aH\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\u001aH\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u001a)\u0010\u0017\u001a\u00020\u00182\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rH\u0002\u00f8\u0001\u0000\u001a\u0015\u0010\u0019\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00f8\u0001\u0000*\n\u0010\u001b\"\u00020\u001c2\u00020\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"ImageShader", "Landroidx/ui/graphics/Shader;", "image", "Landroidx/ui/graphics/ImageAsset;", "tileModeX", "Landroidx/ui/graphics/TileMode;", "tileModeY", "(Landroidx/ui/graphics/ImageAsset;Landroidx/ui/graphics/TileMode;Landroidx/ui/graphics/TileMode;)Landroid/graphics/Shader;", "LinearGradientShader", "from", "Landroidx/ui/geometry/Offset;", "to", "colors", "", "Landroidx/ui/graphics/Color;", "colorStops", "", "tileMode", "(Landroidx/ui/geometry/Offset;Landroidx/ui/geometry/Offset;Ljava/util/List;Ljava/util/List;Landroidx/ui/graphics/TileMode;)Landroid/graphics/Shader;", "RadialGradientShader", "center", "radius", "(Landroidx/ui/geometry/Offset;FLjava/util/List;Ljava/util/List;Landroidx/ui/graphics/TileMode;)Landroid/graphics/Shader;", "validateColorStops", "", "toIntArray", "", "NativeShader", "Landroid/graphics/Shader;", "ui-graphics_release"})
public final class ShaderKt {
    @NotNull
    public static final android.graphics.Shader LinearGradientShader(@NotNull Offset from, @NotNull Offset to, @NotNull List<Color> colors, @Nullable List<Float> colorStops, @NotNull TileMode tileMode) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)((Object)tileMode), (String)"tileMode");
        ShaderKt.validateColorStops(colors, colorStops);
        List<Float> list = colorStops;
        return Shader.constructor-impl((android.graphics.Shader)new LinearGradient(from.getDx(), from.getDy(), to.getDx(), to.getDy(), ShaderKt.toIntArray(colors), list == null ? (float[])null : CollectionsKt.toFloatArray((Collection)list), tileMode.getNativeTileMode()));
    }

    public static /* synthetic */ android.graphics.Shader LinearGradientShader$default(Offset from, Offset to, List colors, List colorStops, TileMode tileMode, int n, Object object) {
        if ((n & 8) != 0) {
            colorStops = null;
        }
        if ((n & 0x10) != 0) {
            tileMode = TileMode.Clamp;
        }
        return ShaderKt.LinearGradientShader(from, to, colors, colorStops, tileMode);
    }

    @NotNull
    public static final android.graphics.Shader RadialGradientShader(@NotNull Offset center, float radius, @NotNull List<Color> colors, @Nullable List<Float> colorStops, @NotNull TileMode tileMode) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)((Object)tileMode), (String)"tileMode");
        ShaderKt.validateColorStops(colors, colorStops);
        List<Float> list = colorStops;
        return Shader.constructor-impl((android.graphics.Shader)new RadialGradient(center.getDx(), center.getDy(), radius, ShaderKt.toIntArray(colors), list == null ? (float[])null : CollectionsKt.toFloatArray((Collection)list), tileMode.getNativeTileMode()));
    }

    public static /* synthetic */ android.graphics.Shader RadialGradientShader$default(Offset center, float radius, List colors, List colorStops, TileMode tileMode, int n, Object object) {
        if ((n & 8) != 0) {
            colorStops = null;
        }
        if ((n & 0x10) != 0) {
            tileMode = TileMode.Clamp;
        }
        return ShaderKt.RadialGradientShader(center, radius, colors, colorStops, tileMode);
    }

    @NotNull
    public static final android.graphics.Shader ImageShader(@NotNull ImageAsset image, @NotNull TileMode tileModeX, @NotNull TileMode tileModeY) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)((Object)tileModeX), (String)"tileModeX");
        Intrinsics.checkNotNullParameter((Object)((Object)tileModeY), (String)"tileModeY");
        return Shader.constructor-impl((android.graphics.Shader)new BitmapShader(AndroidImageAssetKt.asAndroidBitmap(image), tileModeX.getNativeTileMode(), tileModeY.getNativeTileMode()));
    }

    public static /* synthetic */ android.graphics.Shader ImageShader$default(ImageAsset image, TileMode tileModeX, TileMode tileModeY, int n, Object object) {
        if ((n & 2) != 0) {
            tileModeX = TileMode.Clamp;
        }
        if ((n & 4) != 0) {
            tileModeY = TileMode.Clamp;
        }
        return ShaderKt.ImageShader(image, tileModeX, tileModeY);
    }

    private static final int[] toIntArray(List<Color> $this$toIntArray) {
        int n = 0;
        int n2 = $this$toIntArray.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = ColorKt.toArgb-QEYXlZo($this$toIntArray.get(n3).unbox-impl());
        }
        return nArray;
    }

    private static final void validateColorStops(List<Color> colors, List<Float> colorStops) {
        if (colorStops == null) {
            if (colors.size() < 2) {
                throw new IllegalArgumentException("colors must have length of at least 2 if colorStops is omitted.");
            }
        } else if (colors.size() != colorStops.size()) {
            throw new IllegalArgumentException("colors and colorStops arguments must have equal length.");
        }
    }
}

