/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.colorspace;

import androidx.annotation.Size;
import androidx.ui.graphics.colorspace.Adaptation;
import androidx.ui.graphics.colorspace.ColorModel;
import androidx.ui.graphics.colorspace.ColorSpace;
import androidx.ui.graphics.colorspace.ColorSpaceKt;
import androidx.ui.graphics.colorspace.Illuminant;
import androidx.ui.graphics.colorspace.RenderIntent;
import androidx.ui.graphics.colorspace.Rgb;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u001f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0007J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0017\u001a\u00020\fH\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/ui/graphics/colorspace/Connector;", "", "source", "Landroidx/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/ui/graphics/colorspace/RenderIntent;", "(Landroidx/ui/graphics/colorspace/ColorSpace;Landroidx/ui/graphics/colorspace/ColorSpace;Landroidx/ui/graphics/colorspace/RenderIntent;)V", "transformSource", "transformDestination", "renderIntent", "transform", "", "(Landroidx/ui/graphics/colorspace/ColorSpace;Landroidx/ui/graphics/colorspace/ColorSpace;Landroidx/ui/graphics/colorspace/ColorSpace;Landroidx/ui/graphics/colorspace/ColorSpace;Landroidx/ui/graphics/colorspace/RenderIntent;[F)V", "getDestination", "()Landroidx/ui/graphics/colorspace/ColorSpace;", "getRenderIntent", "()Landroidx/ui/graphics/colorspace/RenderIntent;", "getSource", "r", "", "g", "b", "v", "Companion", "RgbConnector", "ui-graphics_release"})
public class Connector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ColorSpace source;
    private final ColorSpace destination;
    private final ColorSpace transformSource;
    private final ColorSpace transformDestination;
    private final RenderIntent renderIntent;
    private final float[] transform;

    public Connector(@NotNull ColorSpace source, @NotNull ColorSpace destination, @NotNull ColorSpace transformSource, @NotNull ColorSpace transformDestination, @NotNull RenderIntent renderIntent, @Size(value=3L) @Nullable float[] transform) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)transformSource, (String)"transformSource");
        Intrinsics.checkNotNullParameter((Object)transformDestination, (String)"transformDestination");
        Intrinsics.checkNotNullParameter((Object)((Object)renderIntent), (String)"renderIntent");
        this.source = source;
        this.destination = destination;
        this.transformSource = transformSource;
        this.transformDestination = transformDestination;
        this.renderIntent = renderIntent;
        this.transform = transform;
    }

    @NotNull
    public final ColorSpace getSource() {
        return this.source;
    }

    @NotNull
    public final ColorSpace getDestination() {
        return this.destination;
    }

    @NotNull
    public final RenderIntent getRenderIntent() {
        return this.renderIntent;
    }

    public Connector(@NotNull ColorSpace source, @NotNull ColorSpace destination, @NotNull RenderIntent intent) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)((Object)intent), (String)"intent");
        this(source, destination, Intrinsics.areEqual((Object)((Object)source.getModel()), (Object)((Object)ColorModel.Rgb)) ? ColorSpaceKt.adapt$default(source, Illuminant.INSTANCE.getD50(), null, 2, null) : source, Intrinsics.areEqual((Object)((Object)destination.getModel()), (Object)((Object)ColorModel.Rgb)) ? ColorSpaceKt.adapt$default(destination, Illuminant.INSTANCE.getD50(), null, 2, null) : destination, intent, Connector.Companion.computeTransform(source, destination, intent));
    }

    @Size(value=3L)
    @NotNull
    public final float[] transform(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.transform(fArray);
    }

    @Size(min=3L)
    @NotNull
    public float[] transform(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float[] xyz = this.transformSource.toXyz(v);
        if (this.transform != null) {
            float[] fArray = xyz;
            fArray[0] = fArray[0] * this.transform[0];
            fArray = xyz;
            fArray[1] = fArray[1] * this.transform[1];
            fArray = xyz;
            fArray[2] = fArray[2] * this.transform[2];
        }
        return this.transformDestination.fromXyz(xyz);
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u0012\u0010\r\u001a\u00020\t2\b\b\u0001\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/ui/graphics/colorspace/Connector$RgbConnector;", "Landroidx/ui/graphics/colorspace/Connector;", "mSource", "Landroidx/ui/graphics/colorspace/Rgb;", "mDestination", "intent", "Landroidx/ui/graphics/colorspace/RenderIntent;", "(Landroidx/ui/graphics/colorspace/Rgb;Landroidx/ui/graphics/colorspace/Rgb;Landroidx/ui/graphics/colorspace/RenderIntent;)V", "mTransform", "", "computeTransform", "source", "destination", "transform", "v", "ui-graphics_release"})
    public static final class RgbConnector
    extends Connector {
        private final Rgb mSource;
        private final Rgb mDestination;
        private final float[] mTransform;

        public RgbConnector(@NotNull Rgb mSource, @NotNull Rgb mDestination, @NotNull RenderIntent intent) {
            Intrinsics.checkNotNullParameter((Object)mSource, (String)"mSource");
            Intrinsics.checkNotNullParameter((Object)mDestination, (String)"mDestination");
            Intrinsics.checkNotNullParameter((Object)((Object)intent), (String)"intent");
            super(mSource, mDestination, mSource, mDestination, intent, null);
            this.mSource = mSource;
            this.mDestination = mDestination;
            this.mTransform = this.computeTransform(this.mSource, this.mDestination, intent);
        }

        @Override
        @NotNull
        public float[] transform(@Size(min=3L) @NotNull float[] v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v[0] = (float)((Number)this.mSource.getEotf().invoke((Object)v[0])).doubleValue();
            v[1] = (float)((Number)this.mSource.getEotf().invoke((Object)v[1])).doubleValue();
            v[2] = (float)((Number)this.mSource.getEotf().invoke((Object)v[2])).doubleValue();
            ColorSpaceKt.mul3x3Float3(this.mTransform, v);
            v[0] = (float)((Number)this.mDestination.getOetf().invoke((Object)v[0])).doubleValue();
            v[1] = (float)((Number)this.mDestination.getOetf().invoke((Object)v[1])).doubleValue();
            v[2] = (float)((Number)this.mDestination.getOetf().invoke((Object)v[2])).doubleValue();
            return v;
        }

        @Size(value=9L)
        private final float[] computeTransform(Rgb source, Rgb destination, RenderIntent intent) {
            float[] fArray;
            boolean bl;
            float[] fArray2;
            float[] fArray3;
            float[] fArray4;
            if (ColorSpaceKt.compare(source.getWhitePoint(), destination.getWhitePoint())) {
                return ColorSpaceKt.mul3x3(destination.getInverseTransform$ui_graphics_release(), source.getTransform$ui_graphics_release());
            }
            float[] transform = source.getTransform$ui_graphics_release();
            float[] inverseTransform = destination.getInverseTransform$ui_graphics_release();
            float[] srcXYZ = source.getWhitePoint().toXyz$ui_graphics_release();
            float[] dstXYZ = destination.getWhitePoint().toXyz$ui_graphics_release();
            if (!ColorSpaceKt.compare(source.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                fArray4 = Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                fArray3 = srcXYZ;
                fArray2 = Adaptation.Bradford.getTransform$ui_graphics_release();
                bl = false;
                float[] fArray5 = Arrays.copyOf(fArray4, fArray4.length);
                Intrinsics.checkNotNullExpressionValue((Object)fArray5, (String)"java.util.Arrays.copyOf(this, size)");
                fArray = fArray5;
                float[] srcAdaptation = ColorSpaceKt.chromaticAdaptation(fArray2, fArray3, fArray);
                transform = ColorSpaceKt.mul3x3(srcAdaptation, source.getTransform$ui_graphics_release());
            }
            if (!ColorSpaceKt.compare(destination.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                fArray4 = Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                fArray3 = dstXYZ;
                fArray2 = Adaptation.Bradford.getTransform$ui_graphics_release();
                bl = false;
                float[] fArray6 = Arrays.copyOf(fArray4, fArray4.length);
                Intrinsics.checkNotNullExpressionValue((Object)fArray6, (String)"java.util.Arrays.copyOf(this, size)");
                fArray = fArray6;
                float[] dstAdaptation = ColorSpaceKt.chromaticAdaptation(fArray2, fArray3, fArray);
                inverseTransform = ColorSpaceKt.inverse3x3(ColorSpaceKt.mul3x3(dstAdaptation, destination.getTransform$ui_graphics_release()));
            }
            if (Intrinsics.areEqual((Object)((Object)intent), (Object)((Object)RenderIntent.Absolute))) {
                float[] fArray7 = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                transform = ColorSpaceKt.mul3x3Diag(fArray7, transform);
            }
            return ColorSpaceKt.mul3x3(inverseTransform, transform);
        }
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Landroidx/ui/graphics/colorspace/Connector$Companion;", "", "()V", "computeTransform", "", "source", "Landroidx/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/ui/graphics/colorspace/RenderIntent;", "identity", "Landroidx/ui/graphics/colorspace/Connector;", "identity$ui_graphics_release", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        private final float[] computeTransform(ColorSpace source, ColorSpace destination, RenderIntent intent) {
            if (!Intrinsics.areEqual((Object)((Object)intent), (Object)((Object)RenderIntent.Absolute))) {
                return null;
            }
            boolean srcRGB = Intrinsics.areEqual((Object)((Object)source.getModel()), (Object)((Object)ColorModel.Rgb));
            boolean dstRGB = Intrinsics.areEqual((Object)((Object)destination.getModel()), (Object)((Object)ColorModel.Rgb));
            if (srcRGB && dstRGB) {
                return null;
            }
            if (srcRGB || dstRGB) {
                Rgb rgb = (Rgb)(srcRGB ? source : destination);
                float[] srcXYZ = srcRGB ? rgb.getWhitePoint().toXyz$ui_graphics_release() : Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                float[] dstXYZ = dstRGB ? rgb.getWhitePoint().toXyz$ui_graphics_release() : Illuminant.INSTANCE.getD50Xyz$ui_graphics_release();
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                return fArray;
            }
            return null;
        }

        @NotNull
        public final Connector identity$ui_graphics_release(@NotNull ColorSpace source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            RenderIntent renderIntent = RenderIntent.Relative;
            return new Connector(source, renderIntent){
                private final /* synthetic */ ColorSpace $source;
                {
                    this.$source = $source;
                    super($source, $source, renderIntent);
                }

                @NotNull
                public float[] transform(@Size(min=3L) @NotNull float[] v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return v;
                }
            };
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

