/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.colorspace;

import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.ui.graphics.colorspace.ColorModel;
import androidx.ui.graphics.colorspace.ColorSpace;
import androidx.ui.graphics.colorspace.ColorSpaceKt;
import androidx.ui.graphics.colorspace.ColorSpaces;
import androidx.ui.graphics.colorspace.Illuminant;
import androidx.ui.graphics.colorspace.TransferParameters;
import androidx.ui.graphics.colorspace.WhitePoint;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0011\u0018\u0000 H2\u00020\u0001:\u0001HBC\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\nB[\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011B#\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014B+\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0015B5\b\u0010\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018B#\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0019\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aB+\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0019\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001bBE\b\u0010\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0019\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u001cB!\b\u0010\u0012\u0006\u0010\u001d\u001a\u00020\u0000\u0012\b\b\u0001\u0010\u001e\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001fB{\b\u0000\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\b\u0010 \u001a\u0004\u0018\u00010\u0013\u0012\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010!J\u0013\u00106\u001a\u00020*2\b\u00107\u001a\u0004\u0018\u000108H\u0096\u0002J \u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\u000fH\u0007J\u0012\u00109\u001a\u00020\u00052\b\b\u0001\u0010=\u001a\u00020\u0005H\u0007J\u0012\u0010>\u001a\u00020\u00052\b\b\u0001\u0010=\u001a\u00020\u0005H\u0017J\b\u0010?\u001a\u00020\u0005H\u0007J\u0012\u0010?\u001a\u00020\u00052\b\b\u0001\u0010&\u001a\u00020\u0005H\u0007J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u0017H\u0016J\u0010\u0010B\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u0017H\u0016J\b\u0010C\u001a\u00020\u0005H\u0007J\u0012\u0010C\u001a\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010D\u001a\u00020\u0005H\u0007J\u0012\u0010D\u001a\u00020\u00052\b\b\u0001\u0010\u001e\u001a\u00020\u0005H\u0007J\b\u0010E\u001a\u00020\u0017H\u0016J \u0010F\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\u000fH\u0007J\u0012\u0010F\u001a\u00020\u00052\b\b\u0001\u0010=\u001a\u00020\u0005H\u0007J\u0012\u0010G\u001a\u00020\u00052\b\b\u0001\u0010=\u001a\u00020\u0005H\u0017R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010+R\u0014\u0010,\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010+R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010#R \u0010.\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010#R\u0014\u0010\u000b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010(R\u0013\u0010 \u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010\u001e\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010(R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006I"}, d2={"Landroidx/ui/graphics/colorspace/Rgb;", "Landroidx/ui/graphics/colorspace/ColorSpace;", "name", "", "toXYZ", "", "oetf", "Lkotlin/Function1;", "", "eotf", "(Ljava/lang/String;[FLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "primaries", "whitePoint", "Landroidx/ui/graphics/colorspace/WhitePoint;", "min", "", "max", "(Ljava/lang/String;[FLandroidx/ui/graphics/colorspace/WhitePoint;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;FF)V", "function", "Landroidx/ui/graphics/colorspace/TransferParameters;", "(Ljava/lang/String;[FLandroidx/ui/graphics/colorspace/TransferParameters;)V", "(Ljava/lang/String;[FLandroidx/ui/graphics/colorspace/WhitePoint;Landroidx/ui/graphics/colorspace/TransferParameters;)V", "id", "", "(Ljava/lang/String;[FLandroidx/ui/graphics/colorspace/WhitePoint;Landroidx/ui/graphics/colorspace/TransferParameters;I)V", "gamma", "(Ljava/lang/String;[FD)V", "(Ljava/lang/String;[FLandroidx/ui/graphics/colorspace/WhitePoint;D)V", "(Ljava/lang/String;[FLandroidx/ui/graphics/colorspace/WhitePoint;DFFI)V", "colorSpace", "transform", "(Landroidx/ui/graphics/colorspace/Rgb;[FLandroidx/ui/graphics/colorspace/WhitePoint;)V", "transferParameters", "(Ljava/lang/String;[FLandroidx/ui/graphics/colorspace/WhitePoint;[FLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;FFLandroidx/ui/graphics/colorspace/TransferParameters;I)V", "getEotf", "()Lkotlin/jvm/functions/Function1;", "eotfOrig", "getEotfOrig$ui_graphics_release", "inverseTransform", "getInverseTransform$ui_graphics_release", "()[F", "isSrgb", "", "()Z", "isWideGamut", "getOetf", "oetfOrig", "getOetfOrig$ui_graphics_release", "getPrimaries$ui_graphics_release", "getTransferParameters", "()Landroidx/ui/graphics/colorspace/TransferParameters;", "getTransform$ui_graphics_release", "getWhitePoint", "()Landroidx/ui/graphics/colorspace/WhitePoint;", "equals", "other", "", "fromLinear", "r", "g", "b", "v", "fromXyz", "getInverseTransform", "getMaxValue", "component", "getMinValue", "getPrimaries", "getTransform", "hashCode", "toLinear", "toXyz", "Companion", "ui-graphics_release"})
public final class Rgb
extends ColorSpace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final WhitePoint whitePoint;
    private final float min;
    private final float max;
    private final TransferParameters transferParameters;
    private final float[] primaries;
    private final float[] transform;
    private final float[] inverseTransform;
    private final Function1<Double, Double> oetfOrig;
    private final Function1<Double, Double> oetf;
    private final Function1<Double, Double> eotfOrig;
    private final Function1<Double, Double> eotf;
    private final boolean isWideGamut;
    private final boolean isSrgb;
    private static final Function1<Double, Double> DoubleIdentity = (Function1)new Function1<Double, Double>(){

        public final double invoke(double d) {
            return d;
        }
    };

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, @Size(value=9L) @Nullable float[] transform, @NotNull Function1<? super Double, Double> oetf2, @NotNull Function1<? super Double, Double> eotf2, float min, float max, @Nullable TransferParameters transferParameters, @IntRange(from=-1L, to=63L) int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter(oetf2, (String)"oetf");
        Intrinsics.checkNotNullParameter(eotf2, (String)"eotf");
        super(name, ColorModel.Rgb, id);
        this.whitePoint = whitePoint;
        this.min = min;
        this.max = max;
        this.transferParameters = transferParameters;
        this.oetfOrig = oetf2;
        this.oetf = (Function1)new Function1<Double, Double>(this){
            private final /* synthetic */ Rgb $this;
            {
                this.$this = $receiver;
                super(1);
            }

            public final double invoke(double x) {
                return RangesKt.coerceIn((double)((Number)this.$this.getOetfOrig$ui_graphics_release().invoke((Object)x)).doubleValue(), (double)Rgb.access$getMin$p(this.$this), (double)Rgb.access$getMax$p(this.$this));
            }
        };
        this.eotfOrig = eotf2;
        this.eotf = (Function1)new Function1<Double, Double>(this){
            private final /* synthetic */ Rgb $this;
            {
                this.$this = $receiver;
                super(1);
            }

            public final double invoke(double x) {
                return ((Number)this.$this.getEotfOrig$ui_graphics_release().invoke((Object)RangesKt.coerceIn((double)x, (double)Rgb.access$getMin$p(this.$this), (double)Rgb.access$getMax$p(this.$this)))).doubleValue();
            }
        };
        if (primaries.length != 6 && primaries.length != 9) {
            throw new IllegalArgumentException("The color space's primaries must be defined as an array of 6 floats in xyY or 9 floats in XYZ");
        }
        if (this.min >= this.max) {
            throw new IllegalArgumentException("Invalid range: min=" + this.min + ", max=" + this.max + "; min must be strictly < max");
        }
        this.primaries = Rgb.Companion.xyPrimaries(primaries);
        if (transform == null) {
            this.transform = Rgb.Companion.computeXYZMatrix(this.getPrimaries$ui_graphics_release(), this.getWhitePoint());
        } else {
            if (transform.length != 9) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Transform must have 9 entries! Has ", (Object)transform.length));
            }
            this.transform = transform;
        }
        this.inverseTransform = ColorSpaceKt.inverse3x3(this.getTransform$ui_graphics_release());
        this.isWideGamut = Rgb.Companion.isWideGamut(this.getPrimaries$ui_graphics_release(), this.min, this.max);
        this.isSrgb = Rgb.Companion.isSrgb(this.getPrimaries$ui_graphics_release(), this.getWhitePoint(), (Function1<? super Double, Double>)oetf2, (Function1<? super Double, Double>)eotf2, this.min, this.max, id);
    }

    @NotNull
    public final WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    @Nullable
    public final TransferParameters getTransferParameters() {
        return this.transferParameters;
    }

    @NotNull
    public final float[] getPrimaries$ui_graphics_release() {
        return this.primaries;
    }

    @NotNull
    public final float[] getTransform$ui_graphics_release() {
        return this.transform;
    }

    @NotNull
    public final float[] getInverseTransform$ui_graphics_release() {
        return this.inverseTransform;
    }

    @NotNull
    public final Function1<Double, Double> getOetfOrig$ui_graphics_release() {
        return this.oetfOrig;
    }

    @NotNull
    public final Function1<Double, Double> getOetf() {
        return this.oetf;
    }

    @NotNull
    public final Function1<Double, Double> getEotfOrig$ui_graphics_release() {
        return this.eotfOrig;
    }

    @NotNull
    public final Function1<Double, Double> getEotf() {
        return this.eotf;
    }

    @Override
    public boolean isWideGamut() {
        return this.isWideGamut;
    }

    @Override
    public boolean isSrgb() {
        return this.isSrgb;
    }

    @Size(value=6L)
    @NotNull
    public final float[] getPrimaries() {
        return (float[])this.getPrimaries$ui_graphics_release().clone();
    }

    @Size(value=9L)
    @NotNull
    public final float[] getTransform() {
        return (float[])this.getTransform$ui_graphics_release().clone();
    }

    @Size(value=9L)
    @NotNull
    public final float[] getInverseTransform() {
        return (float[])this.getInverseTransform$ui_graphics_release().clone();
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(value=9L) @NotNull float[] toXYZ, @NotNull Function1<? super Double, Double> oetf2, @NotNull Function1<? super Double, Double> eotf2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)toXYZ, (String)"toXYZ");
        Intrinsics.checkNotNullParameter(oetf2, (String)"oetf");
        Intrinsics.checkNotNullParameter(eotf2, (String)"eotf");
        this(name, Companion.computePrimaries$ui_graphics_release(toXYZ), Rgb.Companion.computeWhitePoint(toXYZ), null, oetf2, eotf2, 0.0f, 1.0f, null, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, @NotNull Function1<? super Double, Double> oetf2, @NotNull Function1<? super Double, Double> eotf2, float min, float max) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter(oetf2, (String)"oetf");
        Intrinsics.checkNotNullParameter(eotf2, (String)"eotf");
        this(name, primaries, whitePoint, null, oetf2, eotf2, min, max, null, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(value=9L) @NotNull float[] toXYZ, @NotNull TransferParameters function) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)toXYZ, (String)"toXYZ");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this(name, Companion.computePrimaries$ui_graphics_release(toXYZ), Rgb.Companion.computeWhitePoint(toXYZ), function, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, @NotNull TransferParameters function) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this(name, primaries, whitePoint, function, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, final @NotNull TransferParameters function, @IntRange(from=-1L, to=63L) int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this(name, primaries, whitePoint, null, (Function1<? super Double, Double>)(function.getE() == 0.0 && function.getF() == 0.0 ? (Function1)new Function1<Double, Double>(){

            public final double invoke(double x) {
                return ColorSpaceKt.rcpResponse(x, function.getA(), function.getB(), function.getC(), function.getD(), function.getGamma());
            }
        } : (Function1)new Function1<Double, Double>(){

            public final double invoke(double x) {
                return ColorSpaceKt.rcpResponse(x, function.getA(), function.getB(), function.getC(), function.getD(), function.getE(), function.getF(), function.getGamma());
            }
        }), (Function1<? super Double, Double>)(function.getE() == 0.0 && function.getF() == 0.0 ? (Function1)new Function1<Double, Double>(){

            public final double invoke(double x) {
                return ColorSpaceKt.response(x, function.getA(), function.getB(), function.getC(), function.getD(), function.getGamma());
            }
        } : (Function1)new Function1<Double, Double>(){

            public final double invoke(double x) {
                return ColorSpaceKt.response(x, function.getA(), function.getB(), function.getC(), function.getD(), function.getE(), function.getF(), function.getGamma());
            }
        }), 0.0f, 1.0f, function, id);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(value=9L) @NotNull float[] toXYZ, double gamma) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)toXYZ, (String)"toXYZ");
        this(name, Companion.computePrimaries$ui_graphics_release(toXYZ), Rgb.Companion.computeWhitePoint(toXYZ), gamma, 0.0f, 1.0f, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, double gamma) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        this(name, primaries, whitePoint, gamma, 0.0f, 1.0f, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, final double gamma, float min, float max, @IntRange(from=-1L, to=63L) int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        this(name, primaries, whitePoint, null, (Function1<? super Double, Double>)(gamma == 1.0 ? DoubleIdentity : (Function1)new Function1<Double, Double>(){

            public final double invoke(double x) {
                double d = x < 0.0 ? 0.0 : x;
                double d2 = 1.0 / gamma;
                boolean bl = false;
                return Math.pow(d, d2);
            }
        }), (Function1<? super Double, Double>)(gamma == 1.0 ? DoubleIdentity : (Function1)new Function1<Double, Double>(){

            public final double invoke(double x) {
                double d = x < 0.0 ? 0.0 : x;
                double d2 = gamma;
                boolean bl = false;
                return Math.pow(d, d2);
            }
        }), min, max, new TransferParameters(gamma, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 96, null), id);
    }

    public Rgb(@NotNull Rgb colorSpace, @Size(value=9L) @NotNull float[] transform, @NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        this(colorSpace.getName(), colorSpace.getPrimaries$ui_graphics_release(), whitePoint, transform, colorSpace.getOetfOrig$ui_graphics_release(), colorSpace.getEotfOrig$ui_graphics_release(), colorSpace.min, colorSpace.max, colorSpace.getTransferParameters(), -1);
    }

    @Size(min=6L)
    @NotNull
    public final float[] getPrimaries(@Size(min=6L) @NotNull float[] primaries) {
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        return ArraysKt.copyInto$default((float[])this.getPrimaries$ui_graphics_release(), (float[])primaries, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Size(min=9L)
    @NotNull
    public final float[] getTransform(@Size(min=9L) @NotNull float[] transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        return ArraysKt.copyInto$default((float[])this.getTransform$ui_graphics_release(), (float[])transform, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Size(min=9L)
    @NotNull
    public final float[] getInverseTransform(@Size(min=9L) @NotNull float[] inverseTransform) {
        Intrinsics.checkNotNullParameter((Object)inverseTransform, (String)"inverseTransform");
        return ArraysKt.copyInto$default((float[])this.getInverseTransform$ui_graphics_release(), (float[])inverseTransform, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Override
    public float getMinValue(int component) {
        return this.min;
    }

    @Override
    public float getMaxValue(int component) {
        return this.max;
    }

    @Size(value=3L)
    @NotNull
    public final float[] toLinear(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.toLinear(fArray);
    }

    @Size(min=3L)
    @NotNull
    public final float[] toLinear(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v[0] = (float)((Number)this.getEotf().invoke((Object)v[0])).doubleValue();
        v[1] = (float)((Number)this.getEotf().invoke((Object)v[1])).doubleValue();
        v[2] = (float)((Number)this.getEotf().invoke((Object)v[2])).doubleValue();
        return v;
    }

    @Size(value=3L)
    @NotNull
    public final float[] fromLinear(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.fromLinear(fArray);
    }

    @Size(min=3L)
    @NotNull
    public final float[] fromLinear(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v[0] = (float)((Number)this.getOetf().invoke((Object)v[0])).doubleValue();
        v[1] = (float)((Number)this.getOetf().invoke((Object)v[1])).doubleValue();
        v[2] = (float)((Number)this.getOetf().invoke((Object)v[2])).doubleValue();
        return v;
    }

    @Override
    @Size(min=3L)
    @NotNull
    public float[] toXyz(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v[0] = (float)((Number)this.getEotf().invoke((Object)v[0])).doubleValue();
        v[1] = (float)((Number)this.getEotf().invoke((Object)v[1])).doubleValue();
        v[2] = (float)((Number)this.getEotf().invoke((Object)v[2])).doubleValue();
        return ColorSpaceKt.mul3x3Float3(this.getTransform$ui_graphics_release(), v);
    }

    @Override
    @Size(min=3L)
    @NotNull
    public float[] fromXyz(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        ColorSpaceKt.mul3x3Float3(this.getInverseTransform$ui_graphics_release(), v);
        v[0] = (float)((Number)this.getOetf().invoke((Object)v[0])).doubleValue();
        v[1] = (float)((Number)this.getOetf().invoke((Object)v[1])).doubleValue();
        v[2] = (float)((Number)this.getOetf().invoke((Object)v[2])).doubleValue();
        return v;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Object object = other;
        Rgb rgb = (Rgb)object;
        if (Float.compare(rgb.min, this.min) != 0) {
            return false;
        }
        if (Float.compare(rgb.max, this.max) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getWhitePoint(), (Object)rgb.getWhitePoint())) {
            return false;
        }
        object = this.getPrimaries$ui_graphics_release();
        float[] fArray = rgb.getPrimaries$ui_graphics_release();
        boolean bl = false;
        if (!Arrays.equals((float[])object, fArray)) {
            return false;
        }
        if (this.getTransferParameters() != null) {
            return Intrinsics.areEqual((Object)this.getTransferParameters(), (Object)rgb.getTransferParameters());
        }
        if (rgb.getTransferParameters() == null) {
            return true;
        }
        return !Intrinsics.areEqual(this.getOetfOrig$ui_graphics_release(), rgb.getOetfOrig$ui_graphics_release()) ? false : Intrinsics.areEqual(this.getEotfOrig$ui_graphics_release(), rgb.getEotfOrig$ui_graphics_release());
    }

    @Override
    public int hashCode() {
        int n;
        int n2;
        int result = super.hashCode();
        result = 31 * result + this.getWhitePoint().hashCode();
        float[] fArray = this.getPrimaries$ui_graphics_release();
        int n3 = 31 * result;
        boolean bl = false;
        int n4 = Arrays.hashCode(fArray);
        result = n3 + n4;
        int n5 = 31 * result;
        if (!(this.min == 0.0f)) {
            float f = this.min;
            n3 = n5;
            bl = false;
            n4 = Float.floatToIntBits(f);
            n5 = n3;
            n2 = n4;
        } else {
            n2 = 0;
        }
        result = n5 + n2;
        int n6 = 31 * result;
        if (!(this.max == 0.0f)) {
            float f = this.max;
            n3 = n6;
            bl = false;
            n4 = Float.floatToIntBits(f);
            n6 = n3;
            n = n4;
        } else {
            n = 0;
        }
        result = n6 + n;
        result = 31 * result + (this.getTransferParameters() != null ? this.getTransferParameters().hashCode() : 0);
        if (this.getTransferParameters() == null) {
            result = 31 * result + this.getOetfOrig$ui_graphics_release().hashCode();
            result = 31 * result + this.getEotfOrig$ui_graphics_release().hashCode();
        }
        return result;
    }

    public static final /* synthetic */ float access$getMin$p(Rgb rgb) {
        return rgb.min;
    }

    public static final /* synthetic */ float access$getMax$p(Rgb rgb) {
        return rgb.max;
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0002J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0017\u0010\u000f\u001a\u00020\t2\b\b\u0001\u0010\u0010\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u0011J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0010\u001a\u00020\tH\u0003J\u001a\u0010\u0014\u001a\u00020\t2\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0013H\u0003J\u001c\u0010\u0016\u001a\u00020\u000b2\b\b\u0001\u0010\u0017\u001a\u00020\t2\b\b\u0001\u0010\u0018\u001a\u00020\tH\u0002J(\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\\\u0010\u001e\u001a\u00020\u000b2\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00132\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\b\b\u0001\u0010#\u001a\u00020$H\u0002J\"\u0010%\u001a\u00020\u000b2\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0012\u0010&\u001a\u00020\t2\b\b\u0001\u0010\b\u001a\u00020\tH\u0003J\u0017\u0010'\u001a\u00020\t2\b\b\u0001\u0010\u0015\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b(R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/ui/graphics/colorspace/Rgb$Companion;", "", "()V", "DoubleIdentity", "Lkotlin/Function1;", "", "area", "", "primaries", "", "compare", "", "point", "a", "b", "computePrimaries", "toXYZ", "computePrimaries$ui_graphics_release", "computeWhitePoint", "Landroidx/ui/graphics/colorspace/WhitePoint;", "computeXYZMatrix", "whitePoint", "contains", "p1", "p2", "cross", "ax", "ay", "bx", "by", "isSrgb", "OETF", "EOTF", "min", "max", "id", "", "isWideGamut", "xyPrimaries", "xyWhitePoint", "xyWhitePoint$ui_graphics_release", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSrgb(@Size(value=6L) float[] primaries, WhitePoint whitePoint, Function1<? super Double, Double> OETF, Function1<? super Double, Double> EOTF, float min, float max, @IntRange(from=-1L, to=63L) int id) {
            if (id == 0) {
                return true;
            }
            if (!ColorSpaceKt.compare(primaries, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics_release())) {
                return false;
            }
            if (!ColorSpaceKt.compare(whitePoint, Illuminant.INSTANCE.getD65())) {
                return false;
            }
            if (!(min == 0.0f)) {
                return false;
            }
            if (!(max == 1.0f)) {
                return false;
            }
            Rgb srgb = ColorSpaces.INSTANCE.getSrgb();
            for (double x = 0.0; x <= 1.0; x += 0.00392156862745098) {
                if (!this.compare(x, OETF, srgb.getOetfOrig$ui_graphics_release())) {
                    return false;
                }
                if (this.compare(x, EOTF, srgb.getEotfOrig$ui_graphics_release())) continue;
                return false;
            }
            return true;
        }

        private final boolean compare(double point, Function1<? super Double, Double> a, Function1<? super Double, Double> b) {
            double rA = ((Number)a.invoke((Object)point)).doubleValue();
            double rB = ((Number)b.invoke((Object)point)).doubleValue();
            double d = rA - rB;
            boolean bl = false;
            return Math.abs(d) <= 0.001;
        }

        private final boolean isWideGamut(@Size(value=6L) float[] primaries, float min, float max) {
            return this.area(primaries) / this.area(ColorSpaces.INSTANCE.getNtsc1953Primaries$ui_graphics_release()) > 0.9f && this.contains(primaries, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics_release()) || min < 0.0f && max > 1.0f;
        }

        private final float area(@Size(value=6L) float[] primaries) {
            float rx = primaries[0];
            float gy = primaries[3];
            float ry = primaries[1];
            float bx = primaries[4];
            float gx = primaries[2];
            float by = primaries[5];
            float det = rx * gy + ry * bx + gx * by - gy * bx - ry * gx - rx * by;
            float r = 0.5f * det;
            return r < 0.0f ? -r : r;
        }

        private final float cross(float ax, float ay, float bx, float by) {
            return ax * by - ay * bx;
        }

        private final boolean contains(@Size(value=6L) float[] p1, @Size(value=6L) float[] p2) {
            float[] fArray = new float[]{p1[0] - p2[0], p1[1] - p2[1], p1[2] - p2[2], p1[3] - p2[3], p1[4] - p2[4], p1[5] - p2[5]};
            float[] p0 = fArray;
            if (this.cross(p0[0], p0[1], p2[0] - p2[4], p2[1] - p2[5]) < 0.0f || this.cross(p2[0] - p2[2], p2[1] - p2[3], p0[0], p0[1]) < 0.0f) {
                return false;
            }
            if (this.cross(p0[2], p0[3], p2[2] - p2[0], p2[3] - p2[1]) < 0.0f || this.cross(p2[2] - p2[4], p2[3] - p2[5], p0[2], p0[3]) < 0.0f) {
                return false;
            }
            return !(this.cross(p0[4], p0[5], p2[4] - p2[2], p2[5] - p2[3]) < 0.0f) && !(this.cross(p2[4] - p2[0], p2[5] - p2[1], p0[4], p0[5]) < 0.0f);
        }

        @Size(value=6L)
        @NotNull
        public final float[] computePrimaries$ui_graphics_release(@Size(value=9L) @NotNull float[] toXYZ) {
            Intrinsics.checkNotNullParameter((Object)toXYZ, (String)"toXYZ");
            float[] fArray = new float[]{1.0f, 0.0f, 0.0f};
            float[] r = ColorSpaceKt.mul3x3Float3(toXYZ, fArray);
            float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
            float[] g = ColorSpaceKt.mul3x3Float3(toXYZ, fArray2);
            float[] fArray3 = new float[]{0.0f, 0.0f, 1.0f};
            float[] b = ColorSpaceKt.mul3x3Float3(toXYZ, fArray3);
            float rSum = r[0] + r[1] + r[2];
            float gSum = g[0] + g[1] + g[2];
            float bSum = b[0] + b[1] + b[2];
            float[] fArray4 = new float[]{r[0] / rSum, r[1] / rSum, g[0] / gSum, g[1] / gSum, b[0] / bSum, b[1] / bSum};
            return fArray4;
        }

        @Size(value=2L)
        private final WhitePoint computeWhitePoint(@Size(value=9L) float[] toXYZ) {
            float[] fArray = new float[]{1.0f, 1.0f, 1.0f};
            float[] w = ColorSpaceKt.mul3x3Float3(toXYZ, fArray);
            float sum = w[0] + w[1] + w[2];
            return new WhitePoint(w[0] / sum, w[1] / sum);
        }

        @Size(value=6L)
        private final float[] xyPrimaries(@Size(min=6L, max=9L) float[] primaries) {
            float[] xyPrimaries = new float[6];
            if (primaries.length == 9) {
                float sum = primaries[0] + primaries[1] + primaries[2];
                xyPrimaries[0] = primaries[0] / sum;
                xyPrimaries[1] = primaries[1] / sum;
                sum = primaries[3] + primaries[4] + primaries[5];
                xyPrimaries[2] = primaries[3] / sum;
                xyPrimaries[3] = primaries[4] / sum;
                sum = primaries[6] + primaries[7] + primaries[8];
                xyPrimaries[4] = primaries[6] / sum;
                xyPrimaries[5] = primaries[7] / sum;
            } else {
                ArraysKt.copyInto$default((float[])primaries, (float[])xyPrimaries, (int)0, (int)0, (int)6, (int)6, null);
            }
            return xyPrimaries;
        }

        @Size(value=2L)
        @NotNull
        public final float[] xyWhitePoint$ui_graphics_release(@Size(min=2L, max=3L) @NotNull float[] whitePoint) {
            Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
            float[] xyWhitePoint = new float[2];
            if (whitePoint.length == 3) {
                float sum = whitePoint[0] + whitePoint[1] + whitePoint[2];
                xyWhitePoint[0] = whitePoint[0] / sum;
                xyWhitePoint[1] = whitePoint[1] / sum;
            } else {
                ArraysKt.copyInto$default((float[])whitePoint, (float[])xyWhitePoint, (int)0, (int)0, (int)2, (int)6, null);
            }
            return xyWhitePoint;
        }

        @Size(value=9L)
        private final float[] computeXYZMatrix(@Size(value=6L) float[] primaries, WhitePoint whitePoint) {
            float rx = primaries[0];
            float ry = primaries[1];
            float gx = primaries[2];
            float gy = primaries[3];
            float bx = primaries[4];
            float by = primaries[5];
            float wx = whitePoint.getX();
            float wy = whitePoint.getY();
            float oneRxRy = (1.0f - rx) / ry;
            float oneGxGy = (1.0f - gx) / gy;
            float oneBxBy = (1.0f - bx) / by;
            float oneWxWy = (1.0f - wx) / wy;
            float rxRy = rx / ry;
            float gxGy = gx / gy;
            float bxBy = bx / by;
            float wxWy = wx / wy;
            float byNumerator = (oneWxWy - oneRxRy) * (gxGy - rxRy) - (wxWy - rxRy) * (oneGxGy - oneRxRy);
            float byDenominator = (oneBxBy - oneRxRy) * (gxGy - rxRy) - (bxBy - rxRy) * (oneGxGy - oneRxRy);
            float bY = byNumerator / byDenominator;
            float gY = (wxWy - rxRy - bY * (bxBy - rxRy)) / (gxGy - rxRy);
            float rY = 1.0f - gY - bY;
            float rYRy = rY / ry;
            float gYGy = gY / gy;
            float bYBy = bY / by;
            float[] fArray = new float[]{rYRy * rx, rY, rYRy * (1.0f - rx - ry), gYGy * gx, gY, gYGy * (1.0f - gx - gy), bYBy * bx, bY, bYBy * (1.0f - bx - by)};
            return fArray;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

