/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vectormath;

import androidx.ui.graphics.vectormath.Matrix3;
import androidx.ui.graphics.vectormath.Matrix4;
import androidx.ui.graphics.vectormath.Vector3;
import androidx.ui.graphics.vectormath.Vector4;
import androidx.ui.graphics.vectormath.VectorExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0013\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0000\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006\u001a \u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006\u001a\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a6\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e\u001a&\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e\u001a\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u0016\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000e\u001a\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0006\u001a\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0006\u001a\u000e\u0010 \u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010 \u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006!"}, d2={"inverse", "Landroidx/ui/graphics/vectormath/Matrix3;", "m", "Landroidx/ui/graphics/vectormath/Matrix4;", "lookAt", "eye", "Landroidx/ui/graphics/vectormath/Vector3;", "target", "up", "lookTowards", "forward", "normal", "ortho", "l", "", "r", "b", "t", "n", "f", "perspective", "fov", "ratio", "near", "far", "rotation", "d", "axis", "angle", "scale", "s", "translation", "transpose", "ui-graphics_release"})
public final class MatrixExtensionsKt {
    @NotNull
    public static final Matrix3 transpose(@NotNull Matrix3 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Matrix3(new Vector3(m.getX().getX(), m.getY().getX(), m.getZ().getX()), new Vector3(m.getX().getY(), m.getY().getY(), m.getZ().getY()), new Vector3(m.getX().getZ(), m.getY().getZ(), m.getZ().getZ()));
    }

    @NotNull
    public static final Matrix3 inverse(@NotNull Matrix3 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        float a = m.getX().getX();
        float b = m.getX().getY();
        float c = m.getX().getZ();
        float d = m.getY().getX();
        float e = m.getY().getY();
        float f = m.getY().getZ();
        float g = m.getZ().getX();
        float h = m.getZ().getY();
        float i = m.getZ().getZ();
        float A = e * i - f * h;
        float B = f * g - d * i;
        float C = d * h - e * g;
        float det = a * A + b * B + c * C;
        float[] fArray = new float[]{A / det, B / det, C / det, (c * h - b * i) / det, (a * i - c * g) / det, (b * g - a * h) / det, (b * f - c * e) / det, (c * d - a * f) / det, (a * e - b * d) / det};
        return Matrix3.Companion.of(fArray);
    }

    @NotNull
    public static final Matrix4 transpose(@NotNull Matrix4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Matrix4(new Vector4(m.getX().getX(), m.getY().getX(), m.getZ().getX(), m.getW().getX()), new Vector4(m.getX().getY(), m.getY().getY(), m.getZ().getY(), m.getW().getY()), new Vector4(m.getX().getZ(), m.getY().getZ(), m.getZ().getZ(), m.getW().getZ()), new Vector4(m.getX().getW(), m.getY().getW(), m.getZ().getW(), m.getW().getW()));
    }

    @NotNull
    public static final Matrix4 inverse(@NotNull Matrix4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Matrix4 result = new Matrix4(null, null, null, null, 15, null);
        float pair0 = m.getZ().getZ() * m.getW().getW();
        float pair1 = m.getW().getZ() * m.getZ().getW();
        float pair2 = m.getY().getZ() * m.getW().getW();
        float pair3 = m.getW().getZ() * m.getY().getW();
        float pair4 = m.getY().getZ() * m.getZ().getW();
        float pair5 = m.getZ().getZ() * m.getY().getW();
        float pair6 = m.getX().getZ() * m.getW().getW();
        float pair7 = m.getW().getZ() * m.getX().getW();
        float pair8 = m.getX().getZ() * m.getZ().getW();
        float pair9 = m.getZ().getZ() * m.getX().getW();
        float pair10 = m.getX().getZ() * m.getY().getW();
        float pair11 = m.getY().getZ() * m.getX().getW();
        result.getX().setX(pair0 * m.getY().getY() + pair3 * m.getZ().getY() + pair4 * m.getW().getY());
        Vector4 vector4 = result.getX();
        vector4.setX(vector4.getX() - (pair1 * m.getY().getY() + pair2 * m.getZ().getY() + pair5 * m.getW().getY()));
        result.getX().setY(pair1 * m.getX().getY() + pair6 * m.getZ().getY() + pair9 * m.getW().getY());
        vector4 = result.getX();
        vector4.setY(vector4.getY() - (pair0 * m.getX().getY() + pair7 * m.getZ().getY() + pair8 * m.getW().getY()));
        result.getX().setZ(pair2 * m.getX().getY() + pair7 * m.getY().getY() + pair10 * m.getW().getY());
        vector4 = result.getX();
        vector4.setZ(vector4.getZ() - (pair3 * m.getX().getY() + pair6 * m.getY().getY() + pair11 * m.getW().getY()));
        result.getX().setW(pair5 * m.getX().getY() + pair8 * m.getY().getY() + pair11 * m.getZ().getY());
        vector4 = result.getX();
        vector4.setW(vector4.getW() - (pair4 * m.getX().getY() + pair9 * m.getY().getY() + pair10 * m.getZ().getY()));
        result.getY().setX(pair1 * m.getY().getX() + pair2 * m.getZ().getX() + pair5 * m.getW().getX());
        vector4 = result.getY();
        vector4.setX(vector4.getX() - (pair0 * m.getY().getX() + pair3 * m.getZ().getX() + pair4 * m.getW().getX()));
        result.getY().setY(pair0 * m.getX().getX() + pair7 * m.getZ().getX() + pair8 * m.getW().getX());
        vector4 = result.getY();
        vector4.setY(vector4.getY() - (pair1 * m.getX().getX() + pair6 * m.getZ().getX() + pair9 * m.getW().getX()));
        result.getY().setZ(pair3 * m.getX().getX() + pair6 * m.getY().getX() + pair11 * m.getW().getX());
        vector4 = result.getY();
        vector4.setZ(vector4.getZ() - (pair2 * m.getX().getX() + pair7 * m.getY().getX() + pair10 * m.getW().getX()));
        result.getY().setW(pair4 * m.getX().getX() + pair9 * m.getY().getX() + pair10 * m.getZ().getX());
        vector4 = result.getY();
        vector4.setW(vector4.getW() - (pair5 * m.getX().getX() + pair8 * m.getY().getX() + pair11 * m.getZ().getX()));
        pair0 = m.getZ().getX() * m.getW().getY();
        pair1 = m.getW().getX() * m.getZ().getY();
        pair2 = m.getY().getX() * m.getW().getY();
        pair3 = m.getW().getX() * m.getY().getY();
        pair4 = m.getY().getX() * m.getZ().getY();
        pair5 = m.getZ().getX() * m.getY().getY();
        pair6 = m.getX().getX() * m.getW().getY();
        pair7 = m.getW().getX() * m.getX().getY();
        pair8 = m.getX().getX() * m.getZ().getY();
        pair9 = m.getZ().getX() * m.getX().getY();
        pair10 = m.getX().getX() * m.getY().getY();
        pair11 = m.getY().getX() * m.getX().getY();
        result.getZ().setX(pair0 * m.getY().getW() + pair3 * m.getZ().getW() + pair4 * m.getW().getW());
        vector4 = result.getZ();
        vector4.setX(vector4.getX() - (pair1 * m.getY().getW() + pair2 * m.getZ().getW() + pair5 * m.getW().getW()));
        result.getZ().setY(pair1 * m.getX().getW() + pair6 * m.getZ().getW() + pair9 * m.getW().getW());
        vector4 = result.getZ();
        vector4.setY(vector4.getY() - (pair0 * m.getX().getW() + pair7 * m.getZ().getW() + pair8 * m.getW().getW()));
        result.getZ().setZ(pair2 * m.getX().getW() + pair7 * m.getY().getW() + pair10 * m.getW().getW());
        vector4 = result.getZ();
        vector4.setZ(vector4.getZ() - (pair3 * m.getX().getW() + pair6 * m.getY().getW() + pair11 * m.getW().getW()));
        result.getZ().setW(pair5 * m.getX().getW() + pair8 * m.getY().getW() + pair11 * m.getZ().getW());
        vector4 = result.getZ();
        vector4.setW(vector4.getW() - (pair4 * m.getX().getW() + pair9 * m.getY().getW() + pair10 * m.getZ().getW()));
        result.getW().setX(pair2 * m.getZ().getZ() + pair5 * m.getW().getZ() + pair1 * m.getY().getZ());
        vector4 = result.getW();
        vector4.setX(vector4.getX() - (pair4 * m.getW().getZ() + pair0 * m.getY().getZ() + pair3 * m.getZ().getZ()));
        result.getW().setY(pair8 * m.getW().getZ() + pair0 * m.getX().getZ() + pair7 * m.getZ().getZ());
        vector4 = result.getW();
        vector4.setY(vector4.getY() - (pair6 * m.getZ().getZ() + pair9 * m.getW().getZ() + pair1 * m.getX().getZ()));
        result.getW().setZ(pair6 * m.getY().getZ() + pair11 * m.getW().getZ() + pair3 * m.getX().getZ());
        vector4 = result.getW();
        vector4.setZ(vector4.getZ() - (pair10 * m.getW().getZ() + pair2 * m.getX().getZ() + pair7 * m.getY().getZ()));
        result.getW().setW(pair10 * m.getZ().getZ() + pair4 * m.getX().getZ() + pair9 * m.getY().getZ());
        vector4 = result.getW();
        vector4.setW(vector4.getW() - (pair8 * m.getY().getZ() + pair11 * m.getZ().getZ() + pair5 * m.getX().getZ()));
        float determinant = m.getX().getX() * result.getX().getX() + m.getY().getX() * result.getX().getY() + m.getZ().getX() * result.getX().getZ() + m.getW().getX() * result.getX().getW();
        return result.div(determinant);
    }

    @NotNull
    public static final Matrix4 scale(@NotNull Vector3 s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return new Matrix4(new Vector4(s.getX(), 0.0f, 0.0f, 0.0f, 14, null), new Vector4(0.0f, s.getY(), 0.0f, 0.0f, 13, null), new Vector4(0.0f, 0.0f, s.getZ(), 0.0f, 11, null), null, 8, null);
    }

    @NotNull
    public static final Matrix4 scale(@NotNull Matrix4 m) {
        float f;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Matrix4 this_$iv = m;
        boolean $i$f$getScale = false;
        Object this_$iv$iv = this_$iv.getX();
        boolean $i$f$getXyz = false;
        Vector3 vector3 = new Vector3(((Vector4)this_$iv$iv).getX(), ((Vector4)this_$iv$iv).getY(), ((Vector4)this_$iv$iv).getZ());
        Object v$iv$iv = vector3;
        boolean $i$f$length = false;
        float f2 = ((Vector3)v$iv$iv).getX() * ((Vector3)v$iv$iv).getX() + ((Vector3)v$iv$iv).getY() * ((Vector3)v$iv$iv).getY() + ((Vector3)v$iv$iv).getZ() * ((Vector3)v$iv$iv).getZ();
        boolean bl = false;
        float f3 = (float)Math.sqrt(f2);
        v$iv$iv = this_$iv.getY();
        $i$f$getXyz = false;
        Vector3 vector32 = new Vector3(((Vector4)this_$iv$iv).getX(), ((Vector4)this_$iv$iv).getY(), ((Vector4)this_$iv$iv).getZ());
        this_$iv$iv = vector32;
        $i$f$length = false;
        f2 = ((Vector3)v$iv$iv).getX() * ((Vector3)v$iv$iv).getX() + ((Vector3)v$iv$iv).getY() * ((Vector3)v$iv$iv).getY() + ((Vector3)v$iv$iv).getZ() * ((Vector3)v$iv$iv).getZ();
        bl = false;
        float f4 = (float)Math.sqrt(f2);
        v$iv$iv = this_$iv.getZ();
        $i$f$getXyz = false;
        Vector3 vector33 = new Vector3(((Vector4)this_$iv$iv).getX(), ((Vector4)this_$iv$iv).getY(), ((Vector4)this_$iv$iv).getZ());
        this_$iv$iv = vector33;
        $i$f$length = false;
        f2 = ((Vector3)v$iv$iv).getX() * ((Vector3)v$iv$iv).getX() + ((Vector3)v$iv$iv).getY() * ((Vector3)v$iv$iv).getY() + ((Vector3)v$iv$iv).getZ() * ((Vector3)v$iv$iv).getZ();
        bl = false;
        float f5 = f = (float)Math.sqrt(f2);
        float f6 = f4;
        float f7 = f3;
        return MatrixExtensionsKt.scale(new Vector3(f7, f6, f5));
    }

    @NotNull
    public static final Matrix4 translation(@NotNull Vector3 t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new Matrix4(null, null, null, new Vector4(t, 1.0f), 7, null);
    }

    @NotNull
    public static final Matrix4 translation(@NotNull Matrix4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Matrix4 this_$iv = m;
        boolean $i$f$getTranslation = false;
        Vector4 this_$iv$iv = this_$iv.getW();
        boolean $i$f$getXyz = false;
        return MatrixExtensionsKt.translation(new Vector3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ()));
    }

    @NotNull
    public static final Matrix4 rotation(@NotNull Matrix4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Matrix4 this_$iv = m;
        boolean $i$f$getRight = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getXyz = false;
        Vector3 vector3 = new Vector3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        this_$iv = m;
        vector3 = VectorExtensionsKt.normalize(vector3);
        boolean $i$f$getUp = false;
        this_$iv$iv = this_$iv.getY();
        $i$f$getXyz = false;
        Vector3 vector32 = new Vector3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        this_$iv = m;
        vector32 = VectorExtensionsKt.normalize(vector32);
        boolean $i$f$getForward = false;
        this_$iv$iv = this_$iv.getZ();
        $i$f$getXyz = false;
        Vector3 vector33 = new Vector3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        Vector3 vector34 = null;
        Vector3 vector35 = VectorExtensionsKt.normalize(vector33);
        Vector3 vector36 = vector32;
        Vector3 vector37 = vector3;
        return new Matrix4(vector37, vector36, vector35, vector34, n, defaultConstructorMarker);
    }

    @NotNull
    public static final Matrix4 rotation(@NotNull Vector3 d) {
        float x;
        float x2;
        float p0;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        boolean $i$f$transform = false;
        Vector3 this_$iv$iv = Vector3.copy$default(d, 0.0f, 0.0f, 0.0f, 7, null);
        boolean $i$f$transform2 = false;
        float f = this_$iv$iv.getX();
        Vector3 vector3 = this_$iv$iv;
        boolean $i$f$radians = false;
        float f2 = p0 * ((float)Math.PI / 180);
        vector3.setX(f2);
        p0 = this_$iv$iv.getY();
        vector3 = this_$iv$iv;
        $i$f$radians = false;
        f2 = p0 * ((float)Math.PI / 180);
        vector3.setY(f2);
        p0 = this_$iv$iv.getZ();
        vector3 = this_$iv$iv;
        $i$f$radians = false;
        f2 = p0 * ((float)Math.PI / 180);
        vector3.setZ(f2);
        Vector3 r = this_$iv$iv;
        boolean $i$f$transform3 = false;
        Vector3 this_$iv$iv2 = Vector3.copy$default(r, 0.0f, 0.0f, 0.0f, 7, null);
        boolean $i$f$transform4 = false;
        float $i$f$radians2 = this_$iv$iv2.getX();
        vector3 = this_$iv$iv2;
        boolean bl = false;
        boolean bl2 = false;
        f2 = (float)Math.cos(x2);
        vector3.setX(f2);
        x2 = this_$iv$iv2.getY();
        vector3 = this_$iv$iv2;
        bl = false;
        bl2 = false;
        f2 = (float)Math.cos(x2);
        vector3.setY(f2);
        x2 = this_$iv$iv2.getZ();
        vector3 = this_$iv$iv2;
        bl = false;
        bl2 = false;
        f2 = (float)Math.cos(x2);
        vector3.setZ(f2);
        Vector3 c = this_$iv$iv2;
        $i$f$transform = false;
        Vector3 this_$iv$iv3 = Vector3.copy$default(r, 0.0f, 0.0f, 0.0f, 7, null);
        boolean $i$f$transform5 = false;
        float $i$a$-transform-MatrixExtensionsKt$rotation$c$2 = this_$iv$iv3.getX();
        vector3 = this_$iv$iv3;
        boolean bl3 = false;
        boolean bl4 = false;
        f2 = (float)Math.sin(x);
        vector3.setX(f2);
        x = this_$iv$iv3.getY();
        vector3 = this_$iv$iv3;
        bl3 = false;
        bl4 = false;
        f2 = (float)Math.sin(x);
        vector3.setY(f2);
        x = this_$iv$iv3.getZ();
        vector3 = this_$iv$iv3;
        bl3 = false;
        bl4 = false;
        f2 = (float)Math.sin(x);
        vector3.setZ(f2);
        Vector3 s = this_$iv$iv3;
        float[] fArray = new float[]{c.getY() * c.getZ(), -c.getX() * s.getZ() + s.getX() * s.getY() * c.getZ(), s.getX() * s.getZ() + c.getX() * s.getY() * c.getZ(), 0.0f, c.getY() * s.getZ(), c.getX() * c.getZ() + s.getX() * s.getY() * s.getZ(), -s.getX() * c.getZ() + c.getX() * s.getY() * s.getZ(), 0.0f, -s.getY(), s.getX() * c.getY(), c.getX() * c.getY(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return Matrix4.Companion.of(fArray);
    }

    @NotNull
    public static final Matrix4 rotation(@NotNull Vector3 axis, float angle) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        boolean $i$f$radians = false;
        float r = angle * ((float)Math.PI / 180);
        boolean bl = false;
        float c = (float)Math.cos(r);
        boolean bl2 = false;
        float s = (float)Math.sin(r);
        float d = 1.0f - c;
        float[] fArray = new float[]{x * x * d + c, x * y * d - z * s, x * y * d + y * s, 0.0f, y * x * d + z * s, y * y * d + c, y * z * d - x * s, 0.0f, z * x * d - y * s, z * y * d + x * s, z * z * d + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return Matrix4.Companion.of(fArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Matrix4 normal(@NotNull Matrix4 m) {
        void $this$div$iv;
        float f;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        float f2 = 1.0f;
        Object this_$iv = m;
        boolean $i$f$getRight = false;
        Vector4 this_$iv$iv = ((Matrix4)this_$iv).getX();
        boolean $i$f$getXyz = false;
        Vector3 vector3 = new Vector3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        Object v$iv = vector3;
        boolean $i$f$length2 = false;
        float f3 = ((Vector3)v$iv).getX() * ((Vector3)v$iv).getX() + ((Vector3)v$iv).getY() * ((Vector3)v$iv).getY() + ((Vector3)v$iv).getZ() * ((Vector3)v$iv).getZ();
        v$iv = m;
        boolean $i$f$getUp = false;
        this_$iv$iv = ((Matrix4)this_$iv).getY();
        $i$f$getXyz = false;
        Vector3 vector32 = new Vector3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        this_$iv = vector32;
        $i$f$length2 = false;
        float f4 = ((Vector3)v$iv).getX() * ((Vector3)v$iv).getX() + ((Vector3)v$iv).getY() * ((Vector3)v$iv).getY() + ((Vector3)v$iv).getZ() * ((Vector3)v$iv).getZ();
        v$iv = m;
        boolean $i$f$getForward = false;
        this_$iv$iv = ((Matrix4)this_$iv).getZ();
        $i$f$getXyz = false;
        Vector3 vector33 = new Vector3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ());
        this_$iv = vector33;
        $i$f$length2 = false;
        float f5 = f = ((Vector3)v$iv).getX() * ((Vector3)v$iv).getX() + ((Vector3)v$iv).getY() * ((Vector3)v$iv).getY() + ((Vector3)v$iv).getZ() * ((Vector3)v$iv).getZ();
        float f6 = f4;
        float f7 = f3;
        v$iv = new Vector3(f7, f6, f5);
        boolean $i$f$div = false;
        return MatrixExtensionsKt.scale(new Vector3((float)($this$div$iv / ((Vector3)v$iv).getX()), (float)($this$div$iv / ((Vector3)v$iv).getY()), (float)($this$div$iv / ((Vector3)v$iv).getZ()))).times(m);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Matrix4 lookAt(@NotNull Vector3 eye, @NotNull Vector3 target, @NotNull Vector3 up) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)eye, (String)"eye");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Vector3 vector3 = target;
        Vector3 vector32 = eye;
        boolean $i$f$minus = false;
        Vector3 vector33 = new Vector3(this_$iv.getX() - eye.getX(), this_$iv.getY() - eye.getY(), this_$iv.getZ() - eye.getZ());
        return MatrixExtensionsKt.lookTowards(vector32, vector33, up);
    }

    public static /* synthetic */ Matrix4 lookAt$default(Vector3 eye, Vector3 target, Vector3 up, int n, Object object) {
        if ((n & 4) != 0) {
            up = new Vector3(0.0f, 0.0f, 1.0f, 3, null);
        }
        return MatrixExtensionsKt.lookAt(eye, target, up);
    }

    @NotNull
    public static final Matrix4 lookTowards(@NotNull Vector3 eye, @NotNull Vector3 forward, @NotNull Vector3 up) {
        Vector3 r;
        Vector3 f;
        Intrinsics.checkNotNullParameter((Object)eye, (String)"eye");
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Vector3 $this$x$iv = f = VectorExtensionsKt.normalize(forward);
        boolean $i$f$x = false;
        Vector3 $this$x$iv2 = r = VectorExtensionsKt.normalize(new Vector3($this$x$iv.getY() * up.getZ() - $this$x$iv.getZ() * up.getY(), $this$x$iv.getZ() * up.getX() - $this$x$iv.getX() * up.getZ(), $this$x$iv.getX() * up.getY() - $this$x$iv.getY() * up.getX()));
        boolean $i$f$x2 = false;
        Vector3 u = VectorExtensionsKt.normalize(new Vector3($this$x$iv2.getY() * f.getZ() - $this$x$iv2.getZ() * f.getY(), $this$x$iv2.getZ() * f.getX() - $this$x$iv2.getX() * f.getZ(), $this$x$iv2.getX() * f.getY() - $this$x$iv2.getY() * f.getX()));
        return new Matrix4(new Vector4(r, 0.0f, 2, null), new Vector4(u, 0.0f, 2, null), new Vector4(f, 0.0f, 2, null), new Vector4(eye, 1.0f));
    }

    public static /* synthetic */ Matrix4 lookTowards$default(Vector3 eye, Vector3 forward, Vector3 up, int n, Object object) {
        if ((n & 4) != 0) {
            up = new Vector3(0.0f, 0.0f, 1.0f, 3, null);
        }
        return MatrixExtensionsKt.lookTowards(eye, forward, up);
    }

    @NotNull
    public static final Matrix4 perspective(float fov, float ratio, float near, float far) {
        float f = 1.0f;
        boolean $i$f$radians22 = false;
        float f2 = fov * ((float)Math.PI / 180);
        float $i$f$radians22 = f2 * 0.5f;
        boolean bl = false;
        f2 = (float)Math.tan($i$f$radians22);
        float t = f / f2;
        float a = (far + near) / (far - near);
        float b = 2.0f * far * near / (far - near);
        float c = t / ratio;
        return new Matrix4(new Vector4(c, 0.0f, 0.0f, 0.0f, 14, null), new Vector4(0.0f, t, 0.0f, 0.0f, 13, null), new Vector4(0.0f, 0.0f, a, 1.0f, 3, null), new Vector4(0.0f, 0.0f, -b, 0.0f, 11, null));
    }

    @NotNull
    public static final Matrix4 ortho(float l, float r, float b, float t, float n, float f) {
        return new Matrix4(new Vector4(2.0f / (r - 1.0f), 0.0f, 0.0f, 0.0f, 14, null), new Vector4(0.0f, 2.0f / (t - b), 0.0f, 0.0f, 13, null), new Vector4(0.0f, 0.0f, -2.0f / (f - n), 0.0f, 11, null), new Vector4(-(r + l) / (r - l), -(t + b) / (t - b), -(f + n) / (f - n), 1.0f));
    }
}

