/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.annotation.RequiresApi;
import androidx.ui.graphics.AndroidImageAsset;
import androidx.ui.graphics.ImageAsset;
import androidx.ui.graphics.ImageAssetConfig;
import androidx.ui.graphics.colorspace.ColorSpace;
import androidx.ui.graphics.colorspace.ColorSpaces;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0010\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0006H\u0000\u001a\f\u0010\u0014\u001a\u00020\n*\u00020\u0015H\u0001\u001a\f\u0010\u0016\u001a\u00020\u0015*\u00020\nH\u0001\u001a\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0013H\u0000\u00a8\u0006\u0018"}, d2={"ImageAsset", "Landroidx/ui/graphics/ImageAsset;", "width", "", "height", "config", "Landroidx/ui/graphics/ImageAssetConfig;", "hasAlpha", "", "colorSpace", "Landroidx/ui/graphics/colorspace/ColorSpace;", "imageFromResource", "res", "Landroid/content/res/Resources;", "resId", "asAndroidBitmap", "Landroid/graphics/Bitmap;", "asImageAsset", "toBitmapConfig", "Landroid/graphics/Bitmap$Config;", "toComposeColorSpace", "Landroid/graphics/ColorSpace;", "toFrameworkColorSpace", "toImageConfig", "ui-graphics_release"})
public final class AndroidImageAssetKt {
    @NotNull
    public static final ImageAsset imageFromResource(@NotNull Resources res, int resId) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)resId);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeResource(res, resId)");
        return new AndroidImageAsset(bitmap);
    }

    @NotNull
    public static final ImageAsset asImageAsset(@NotNull Bitmap $this$asImageAsset) {
        Intrinsics.checkNotNullParameter((Object)$this$asImageAsset, (String)"<this>");
        return new AndroidImageAsset($this$asImageAsset);
    }

    @NotNull
    public static final ImageAsset ImageAsset(int width, int height, @NotNull ImageAssetConfig config, boolean hasAlpha, @NotNull ColorSpace colorSpace) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Bitmap.Config bitmapConfig = AndroidImageAssetKt.toBitmapConfig(config);
        if (Build.VERSION.SDK_INT >= 26) {
            Bitmap bitmap2 = Bitmap.createBitmap((DisplayMetrics)null, (int)width, (int)height, (Bitmap.Config)bitmapConfig, (boolean)hasAlpha, (android.graphics.ColorSpace)AndroidImageAssetKt.toFrameworkColorSpace(colorSpace));
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(\n            null,\n            width,\n            height,\n            bitmapConfig,\n            hasAlpha,\n            colorSpace.toFrameworkColorSpace()\n        )");
            bitmap = bitmap2;
        } else {
            Bitmap bitmap3 = Bitmap.createBitmap((DisplayMetrics)null, (int)width, (int)height, (Bitmap.Config)bitmapConfig);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(\n            null as DisplayMetrics?,\n            width,\n            height,\n            bitmapConfig\n        )");
            bitmap = bitmap3;
            bitmap.setHasAlpha(hasAlpha);
        }
        return new AndroidImageAsset(bitmap);
    }

    public static /* synthetic */ ImageAsset ImageAsset$default(int width, int height, ImageAssetConfig config, boolean hasAlpha, ColorSpace colorSpace, int n, Object object) {
        if ((n & 4) != 0) {
            config = ImageAssetConfig.Argb8888;
        }
        if ((n & 8) != 0) {
            hasAlpha = true;
        }
        if ((n & 0x10) != 0) {
            colorSpace = ColorSpaces.INSTANCE.getSrgb();
        }
        return AndroidImageAssetKt.ImageAsset(width, height, config, hasAlpha, colorSpace);
    }

    @NotNull
    public static final Bitmap asAndroidBitmap(@NotNull ImageAsset $this$asAndroidBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$asAndroidBitmap, (String)"<this>");
        ImageAsset imageAsset = $this$asAndroidBitmap;
        if (!(imageAsset instanceof AndroidImageAsset)) {
            throw new UnsupportedOperationException("Unable to obtain android.graphics.Bitmap");
        }
        return ((AndroidImageAsset)$this$asAndroidBitmap).getBitmap$ui_graphics_release();
    }

    @NotNull
    public static final Bitmap.Config toBitmapConfig(@NotNull ImageAssetConfig $this$toBitmapConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toBitmapConfig), (String)"<this>");
        return Intrinsics.areEqual((Object)((Object)$this$toBitmapConfig), (Object)((Object)ImageAssetConfig.Argb8888)) ? Bitmap.Config.ARGB_8888 : (Intrinsics.areEqual((Object)((Object)$this$toBitmapConfig), (Object)((Object)ImageAssetConfig.Alpha8)) ? Bitmap.Config.ALPHA_8 : (Intrinsics.areEqual((Object)((Object)$this$toBitmapConfig), (Object)((Object)ImageAssetConfig.Rgb565)) ? Bitmap.Config.RGB_565 : (Build.VERSION.SDK_INT >= 26 && Intrinsics.areEqual((Object)((Object)$this$toBitmapConfig), (Object)((Object)ImageAssetConfig.F16)) ? Bitmap.Config.RGBA_F16 : (Build.VERSION.SDK_INT >= 26 && Intrinsics.areEqual((Object)((Object)$this$toBitmapConfig), (Object)((Object)ImageAssetConfig.Gpu)) ? Bitmap.Config.HARDWARE : Bitmap.Config.ARGB_8888))));
    }

    @NotNull
    public static final ImageAssetConfig toImageConfig(@NotNull Bitmap.Config $this$toImageConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$toImageConfig, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$toImageConfig, (Object)Bitmap.Config.ALPHA_8) ? ImageAssetConfig.Alpha8 : (Intrinsics.areEqual((Object)$this$toImageConfig, (Object)Bitmap.Config.RGB_565) ? ImageAssetConfig.Rgb565 : (Intrinsics.areEqual((Object)$this$toImageConfig, (Object)Bitmap.Config.ARGB_4444) ? ImageAssetConfig.Argb8888 : (Build.VERSION.SDK_INT >= 26 && Intrinsics.areEqual((Object)$this$toImageConfig, (Object)Bitmap.Config.RGBA_F16) ? ImageAssetConfig.F16 : (Build.VERSION.SDK_INT >= 26 && Intrinsics.areEqual((Object)$this$toImageConfig, (Object)Bitmap.Config.HARDWARE) ? ImageAssetConfig.Gpu : ImageAssetConfig.Argb8888))));
    }

    @RequiresApi(value=26)
    @NotNull
    public static final android.graphics.ColorSpace toFrameworkColorSpace(@NotNull ColorSpace $this$toFrameworkColorSpace) {
        Intrinsics.checkNotNullParameter((Object)$this$toFrameworkColorSpace, (String)"<this>");
        ColorSpace colorSpace = $this$toFrameworkColorSpace;
        ColorSpace.Named frameworkNamedSpace = Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getSrgb()) ? ColorSpace.Named.SRGB : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getAces()) ? ColorSpace.Named.ACES : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getAcescg()) ? ColorSpace.Named.ACESCG : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getAdobeRgb()) ? ColorSpace.Named.ADOBE_RGB : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getBt2020()) ? ColorSpace.Named.BT2020 : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getBt709()) ? ColorSpace.Named.BT709 : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getCieLab()) ? ColorSpace.Named.CIE_LAB : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getCieXyz()) ? ColorSpace.Named.CIE_XYZ : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getDciP3()) ? ColorSpace.Named.DCI_P3 : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getDisplayP3()) ? ColorSpace.Named.DISPLAY_P3 : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getExtendedSrgb()) ? ColorSpace.Named.EXTENDED_SRGB : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getLinearExtendedSrgb()) ? ColorSpace.Named.LINEAR_EXTENDED_SRGB : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getLinearSrgb()) ? ColorSpace.Named.LINEAR_SRGB : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getNtsc1953()) ? ColorSpace.Named.NTSC_1953 : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getProPhotoRgb()) ? ColorSpace.Named.PRO_PHOTO_RGB : (Intrinsics.areEqual((Object)colorSpace, (Object)ColorSpaces.INSTANCE.getSmpteC()) ? ColorSpace.Named.SMPTE_C : ColorSpace.Named.SRGB)))))))))))))));
        colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)frameworkNamedSpace);
        Intrinsics.checkNotNullExpressionValue((Object)colorSpace, (String)"get(frameworkNamedSpace)");
        return colorSpace;
    }

    @RequiresApi(value=26)
    @NotNull
    public static final ColorSpace toComposeColorSpace(@NotNull android.graphics.ColorSpace $this$toComposeColorSpace) {
        Intrinsics.checkNotNullParameter((Object)$this$toComposeColorSpace, (String)"<this>");
        android.graphics.ColorSpace colorSpace = $this$toComposeColorSpace;
        return Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB)) ? (ColorSpace)ColorSpaces.INSTANCE.getSrgb() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ACES)) ? (ColorSpace)ColorSpaces.INSTANCE.getAces() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ACESCG)) ? (ColorSpace)ColorSpaces.INSTANCE.getAcescg() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ADOBE_RGB)) ? (ColorSpace)ColorSpaces.INSTANCE.getAdobeRgb() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.BT2020)) ? (ColorSpace)ColorSpaces.INSTANCE.getBt2020() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.BT709)) ? (ColorSpace)ColorSpaces.INSTANCE.getBt709() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.CIE_LAB)) ? ColorSpaces.INSTANCE.getCieLab() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.CIE_XYZ)) ? ColorSpaces.INSTANCE.getCieXyz() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.DCI_P3)) ? (ColorSpace)ColorSpaces.INSTANCE.getDciP3() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.DISPLAY_P3)) ? (ColorSpace)ColorSpaces.INSTANCE.getDisplayP3() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.EXTENDED_SRGB)) ? (ColorSpace)ColorSpaces.INSTANCE.getExtendedSrgb() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.LINEAR_EXTENDED_SRGB)) ? (ColorSpace)ColorSpaces.INSTANCE.getLinearExtendedSrgb() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.LINEAR_SRGB)) ? (ColorSpace)ColorSpaces.INSTANCE.getLinearSrgb() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.NTSC_1953)) ? (ColorSpace)ColorSpaces.INSTANCE.getNtsc1953() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.PRO_PHOTO_RGB)) ? (ColorSpace)ColorSpaces.INSTANCE.getProPhotoRgb() : (Intrinsics.areEqual((Object)colorSpace, (Object)android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SMPTE_C)) ? (ColorSpace)ColorSpaces.INSTANCE.getSmpteC() : (ColorSpace)ColorSpaces.INSTANCE.getSrgb())))))))))))))));
    }
}

