/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.painter;

import androidx.ui.geometry.Rect;
import androidx.ui.geometry.SizeKt;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.ColorFilter;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.painter.CanvasScope;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxSize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0012\u0010\u001a\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J6\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\b\u0010 \u001a\u00020\u0012H\u0002J\f\u0010!\u001a\u00020\u000b*\u00020\u0006H$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/ui/graphics/painter/Painter;", "", "()V", "alpha", "", "canvasScope", "Landroidx/ui/graphics/painter/CanvasScope;", "colorFilter", "Landroidx/ui/graphics/ColorFilter;", "drawLambda", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "intrinsicSize", "Landroidx/ui/unit/PxSize;", "getIntrinsicSize", "()Landroidx/ui/unit/PxSize;", "layerPaint", "Landroidx/ui/graphics/Paint;", "rtl", "", "useLayer", "applyAlpha", "applyColorFilter", "applyRtl", "configureAlpha", "configureColorFilter", "configureRtl", "draw", "canvas", "Landroidx/ui/graphics/Canvas;", "size", "obtainPaint", "onDraw", "ui-graphics_release"})
public abstract class Painter {
    private Paint layerPaint;
    private boolean useLayer;
    private ColorFilter colorFilter;
    private final CanvasScope canvasScope = new CanvasScope();
    private float alpha = 1.0f;
    private boolean rtl;
    private final Function1<CanvasScope, Unit> drawLambda = (Function1)new Function1<CanvasScope, Unit>(this){
        private final /* synthetic */ Painter $this;
        {
            this.$this = $receiver;
            super(1);
        }

        public final void invoke(@NotNull CanvasScope canvasScope) {
            Intrinsics.checkNotNullParameter((Object)canvasScope, (String)"<this>");
            this.$this.onDraw(canvasScope);
        }
    };

    private final Paint obtainPaint() {
        Paint target = this.layerPaint;
        if (target == null) {
            this.layerPaint = target = new Paint();
        }
        return target;
    }

    private final void configureColorFilter(ColorFilter colorFilter) {
        if (!Intrinsics.areEqual((Object)this.colorFilter, (Object)colorFilter)) {
            boolean consumedColorFilter = this.applyColorFilter(colorFilter);
            if (!consumedColorFilter) {
                if (colorFilter == null) {
                    Paint paint = this.layerPaint;
                    if (paint != null) {
                        paint.setColorFilter(null);
                    }
                    this.useLayer = false;
                } else {
                    this.obtainPaint().setColorFilter(colorFilter);
                    this.useLayer = true;
                }
            }
            this.colorFilter = colorFilter;
        }
    }

    private final void configureAlpha(float alpha) {
        if (!(this.alpha == alpha)) {
            boolean consumed = this.applyAlpha(alpha);
            if (!consumed) {
                if (alpha == 1.0f) {
                    Paint paint = this.layerPaint;
                    if (paint != null) {
                        paint.setAlpha(alpha);
                    }
                    this.useLayer = false;
                } else {
                    this.obtainPaint().setAlpha(alpha);
                    this.useLayer = true;
                }
            }
            this.alpha = alpha;
        }
    }

    private final void configureRtl(boolean rtl) {
        if (this.rtl != rtl) {
            this.applyRtl(rtl);
            this.rtl = rtl;
        }
    }

    @NotNull
    public abstract PxSize getIntrinsicSize();

    protected abstract void onDraw(@NotNull CanvasScope var1);

    protected boolean applyAlpha(float alpha) {
        return false;
    }

    protected boolean applyColorFilter(@Nullable ColorFilter colorFilter) {
        return false;
    }

    protected boolean applyRtl(boolean rtl) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void draw(@NotNull Canvas canvas, @NotNull PxSize size, float alpha, @Nullable ColorFilter colorFilter, boolean rtl) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.configureAlpha(alpha);
        this.configureColorFilter(colorFilter);
        this.configureRtl(rtl);
        PxSize this_$iv = size;
        boolean $i$f$getWidth = false;
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv >> 32);
        int n2 = 0;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        boolean $i$f$getPx = false;
        this_$iv = size;
        float f = Px.constructor-impl((float)$this$px$iv$iv);
        boolean $i$f$getHeight2 = false;
        value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv & 0xFFFFFFFFL);
        n2 = 0;
        $this$px$iv$iv = Float.intBitsToFloat(n);
        $i$f$getPx = false;
        float f2 = Px.constructor-impl((float)$this$px$iv$iv);
        long scopeSize = SizeKt.Size((float)f, (float)f2);
        if (alpha > 0.0f) {
            if (this.useLayer) {
                void $this$withSaveLayer$iv;
                Object this_$iv2;
                PxSize $i$f$getHeight2 = size;
                float f3 = 0.0f;
                f2 = 0.0f;
                Rect.Companion companion = Rect.Companion;
                boolean $i$f$getWidth2 = false;
                long value$iv$iv2 = this_$iv2.getValue();
                boolean $i$f$unpackFloat12 = false;
                FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
                n2 = (int)(value$iv$iv2 >> 32);
                boolean bl = false;
                float $this$px$iv$iv2 = Float.intBitsToFloat(n2);
                boolean $i$f$getPx2 = false;
                float f4 = Px.constructor-impl((float)$this$px$iv$iv2);
                this_$iv2 = size;
                boolean $i$f$getHeight3 = false;
                value$iv$iv2 = this_$iv2.getValue();
                boolean $i$f$unpackFloat22 = false;
                floatCompanionObject2 = FloatCompanionObject.INSTANCE;
                n2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
                bl = false;
                $this$px$iv$iv2 = Float.intBitsToFloat(n2);
                $i$f$getPx2 = false;
                float f5 = Px.constructor-impl((float)$this$px$iv$iv2);
                Rect layerRect = companion.fromLTWH(f2, f3, f4, f5);
                this_$iv2 = canvas;
                Paint paint$iv = this.obtainPaint();
                boolean $i$f$withSaveLayer = false;
                try {
                    $this$withSaveLayer$iv.saveLayer(layerRect, paint$iv);
                    boolean bl2 = false;
                    this.canvasScope.draw-mEaFHtM(canvas, scopeSize, this.drawLambda);
                }
                finally {
                    $this$withSaveLayer$iv.restore();
                }
            } else {
                this.canvasScope.draw-mEaFHtM(canvas, scopeSize, this.drawLambda);
            }
        }
    }

    public static /* synthetic */ void draw$default(Painter this_, Canvas canvas, PxSize size, float alpha, ColorFilter colorFilter, boolean rtl, int n, Object object) {
        if ((n & 4) != 0) {
            alpha = 1.0f;
        }
        if ((n & 8) != 0) {
            colorFilter = null;
        }
        if ((n & 0x10) != 0) {
            rtl = false;
        }
        this_.draw(canvas, size, alpha, colorFilter, rtl);
    }
}

