/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vectormath;

import androidx.ui.graphics.vectormath.Matrix3;
import androidx.ui.graphics.vectormath.MatrixColumn;
import androidx.ui.graphics.vectormath.MatrixExtensionsKt;
import androidx.ui.graphics.vectormath.Vector3;
import androidx.ui.graphics.vectormath.Vector4;
import androidx.ui.graphics.vectormath.VectorExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 d2\u00020\u0001:\u0001dB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tB-\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0000J\u0014\u0010:\u001a\u0002082\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aJ\t\u0010<\u001a\u00020\u000bH\u00c6\u0003J\t\u0010=\u001a\u00020\u000bH\u00c6\u0003J\t\u0010>\u001a\u00020\u000bH\u00c6\u0003J\t\u0010?\u001a\u00020\u000bH\u00c6\u0003J1\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bH\u00c6\u0001J\u000e\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u0000J\t\u0010C\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0011H\u0086\u0002J\u0013\u0010F\u001a\u00020G2\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0011\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020JH\u0086\u0002J\u0019\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0086\u0002J\u0011\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020LH\u0086\u0002J\u0019\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020L2\u0006\u0010K\u001a\u00020LH\u0086\u0002J\u000e\u0010M\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020LJ\t\u0010N\u001a\u00020LH\u00d6\u0001J\t\u0010O\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010P\u001a\u00020\u0011J\u0011\u0010Q\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0011H\u0086\u0002J\u000e\u0010R\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u0003J\u0011\u0010S\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0011H\u0086\u0002J\u000e\u0010T\u001a\u0002082\u0006\u0010U\u001a\u00020\u0011J\u000e\u0010V\u001a\u0002082\u0006\u0010U\u001a\u00020\u0011J\u000e\u0010W\u001a\u0002082\u0006\u0010U\u001a\u00020\u0011J+\u0010#\u001a\u0002082\u0006\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010XJ\u0019\u0010Y\u001a\u0002082\u0006\u0010I\u001a\u00020L2\u0006\u0010E\u001a\u00020\u000bH\u0086\u0002J!\u0010Y\u001a\u0002082\u0006\u0010I\u001a\u00020L2\u0006\u0010K\u001a\u00020L2\u0006\u0010E\u001a\u00020\u0011H\u0086\u0002J\u000e\u0010Z\u001a\u0002082\u0006\u0010B\u001a\u00020\u0000J\u001e\u0010[\u001a\u0002082\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0011J\u0011\u0010\\\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\\\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020\u000bH\u0086\u0002J\u0011\u0010\\\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0011H\u0086\u0002J\u0011\u0010]\u001a\u0002082\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010^\u001a\u00020_J\b\u0010`\u001a\u00020aH\u0016J\"\u0010b\u001a\u0002082\u0006\u0010\n\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u0011J\t\u0010c\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R&\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR&\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018R\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0016R\u0012\u0010#\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016R\u0012\u0010%\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0016R&\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0016\"\u0004\b(\u0010\u0018R\u0012\u0010)\u001a\u00020*8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010.\"\u0004\b2\u00100R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010.\"\u0004\b4\u00100R\u001a\u0010\r\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010.\"\u0004\b6\u00100\u00a8\u0006e"}, d2={"Landroidx/ui/graphics/vectormath/Matrix4;", "", "right", "Landroidx/ui/graphics/vectormath/Vector3;", "up", "forward", "position", "(Landroidx/ui/graphics/vectormath/Vector3;Landroidx/ui/graphics/vectormath/Vector3;Landroidx/ui/graphics/vectormath/Vector3;Landroidx/ui/graphics/vectormath/Vector3;)V", "m", "(Landroidx/ui/graphics/vectormath/Matrix4;)V", "x", "Landroidx/ui/graphics/vectormath/Vector4;", "y", "z", "w", "(Landroidx/ui/graphics/vectormath/Vector4;Landroidx/ui/graphics/vectormath/Vector4;Landroidx/ui/graphics/vectormath/Vector4;Landroidx/ui/graphics/vectormath/Vector4;)V", "determinant", "", "getDeterminant", "()F", "value", "getForward", "()Landroidx/ui/graphics/vectormath/Vector3;", "setForward", "(Landroidx/ui/graphics/vectormath/Vector3;)V", "m4storage", "", "getM4storage", "()Ljava/util/List;", "getPosition", "setPosition", "getRight", "setRight", "rotation", "getRotation", "scale", "getScale", "translation", "getTranslation", "getUp", "setUp", "upperLeft", "Landroidx/ui/graphics/vectormath/Matrix3;", "getUpperLeft", "()Landroidx/ui/graphics/vectormath/Matrix3;", "getW", "()Landroidx/ui/graphics/vectormath/Vector4;", "setW", "(Landroidx/ui/graphics/vectormath/Vector4;)V", "getX", "setX", "getY", "setY", "getZ", "setZ", "assignColumns", "", "other", "assignFromStorage", "storage", "component1", "component2", "component3", "component4", "copy", "copyInverse", "arg", "dec", "div", "v", "equals", "", "get", "column", "Landroidx/ui/graphics/vectormath/MatrixColumn;", "row", "", "getRow", "hashCode", "inc", "invert", "minus", "perspectiveTransform", "plus", "rotateX", "radians", "rotateY", "rotateZ", "(Ljava/lang/Object;Ljava/lang/Float;Ljava/lang/Float;)V", "set", "setFrom", "setTranslationRaw", "times", "timesAssign", "toFloatArray", "", "toString", "", "translate", "unaryMinus", "Companion", "ui-graphics_release"})
public final class Matrix4 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Vector4 x;
    private Vector4 y;
    private Vector4 z;
    private Vector4 w;

    public Matrix4(@NotNull Vector4 x, @NotNull Vector4 y, @NotNull Vector4 z, @NotNull Vector4 w) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public /* synthetic */ Matrix4(Vector4 x, Vector4 y, Vector4 z, Vector4 w, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            x = new Vector4(1.0f, 0.0f, 0.0f, 0.0f, 14, null);
        }
        if ((n & 2) != 0) {
            y = new Vector4(0.0f, 1.0f, 0.0f, 0.0f, 13, null);
        }
        if ((n & 4) != 0) {
            z = new Vector4(0.0f, 0.0f, 1.0f, 0.0f, 11, null);
        }
        if ((n & 8) != 0) {
            w = new Vector4(0.0f, 0.0f, 0.0f, 1.0f, 7, null);
        }
        this(x, y, z, w);
    }

    @NotNull
    public final Vector4 getX() {
        return this.x;
    }

    public final void setX(@NotNull Vector4 vector4) {
        Intrinsics.checkNotNullParameter((Object)vector4, (String)"<set-?>");
        this.x = vector4;
    }

    @NotNull
    public final Vector4 getY() {
        return this.y;
    }

    public final void setY(@NotNull Vector4 vector4) {
        Intrinsics.checkNotNullParameter((Object)vector4, (String)"<set-?>");
        this.y = vector4;
    }

    @NotNull
    public final Vector4 getZ() {
        return this.z;
    }

    public final void setZ(@NotNull Vector4 vector4) {
        Intrinsics.checkNotNullParameter((Object)vector4, (String)"<set-?>");
        this.z = vector4;
    }

    @NotNull
    public final Vector4 getW() {
        return this.w;
    }

    public final void setW(@NotNull Vector4 vector4) {
        Intrinsics.checkNotNullParameter((Object)vector4, (String)"<set-?>");
        this.w = vector4;
    }

    public Matrix4(@NotNull Vector3 right, @NotNull Vector3 up, @NotNull Vector3 forward, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this(new Vector4(right, 0.0f, 2, null), new Vector4(up, 0.0f, 2, null), new Vector4(forward, 0.0f, 2, null), new Vector4(position, 1.0f));
    }

    public /* synthetic */ Matrix4(Vector3 right, Vector3 up, Vector3 forward, Vector3 position, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            position = new Vector3(0.0f, 0.0f, 0.0f, 7, null);
        }
        this(right, up, forward, position);
    }

    public Matrix4(@NotNull Matrix4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this(Vector4.copy$default(m.getX(), 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Vector4.copy$default(m.getY(), 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Vector4.copy$default(m.getZ(), 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Vector4.copy$default(m.getW(), 0.0f, 0.0f, 0.0f, 0.0f, 15, null));
    }

    @NotNull
    public final List<Float> getM4storage() {
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv = this.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv.getX()), Float.valueOf(this_$iv.getY()), Float.valueOf(this_$iv.getZ()), Float.valueOf(this_$iv.getW())};
        this_$iv = this.getY();
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv.getX()), Float.valueOf(this_$iv.getY()), Float.valueOf(this_$iv.getZ()), Float.valueOf(this_$iv.getW())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv = this.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv.getX()), Float.valueOf(this_$iv.getY()), Float.valueOf(this_$iv.getZ()), Float.valueOf(this_$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv = this.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv.getX()), Float.valueOf(this_$iv.getY()), Float.valueOf(this_$iv.getZ()), Float.valueOf(this_$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @NotNull
    public final Vector3 getRight() {
        boolean $i$f$getRight = false;
        Vector4 this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        return new Vector3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setRight(@NotNull Vector3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setRight = false;
        Vector4 this_$iv = this.getX();
        boolean $i$f$setXyz = false;
        this_$iv.setX(value.getX());
        this_$iv.setY(value.getY());
        this_$iv.setZ(value.getZ());
    }

    @NotNull
    public final Vector3 getUp() {
        boolean $i$f$getUp = false;
        Vector4 this_$iv = this.getY();
        boolean $i$f$getXyz = false;
        return new Vector3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setUp(@NotNull Vector3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setUp = false;
        Vector4 this_$iv = this.getY();
        boolean $i$f$setXyz = false;
        this_$iv.setX(value.getX());
        this_$iv.setY(value.getY());
        this_$iv.setZ(value.getZ());
    }

    @NotNull
    public final Vector3 getForward() {
        boolean $i$f$getForward = false;
        Vector4 this_$iv = this.getZ();
        boolean $i$f$getXyz = false;
        return new Vector3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setForward(@NotNull Vector3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setForward = false;
        Vector4 this_$iv = this.getZ();
        boolean $i$f$setXyz = false;
        this_$iv.setX(value.getX());
        this_$iv.setY(value.getY());
        this_$iv.setZ(value.getZ());
    }

    @NotNull
    public final Vector3 getPosition() {
        boolean $i$f$getPosition = false;
        Vector4 this_$iv = this.getW();
        boolean $i$f$getXyz = false;
        return new Vector3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setPosition(@NotNull Vector3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setPosition = false;
        Vector4 this_$iv = this.getW();
        boolean $i$f$setXyz = false;
        this_$iv.setX(value.getX());
        this_$iv.setY(value.getY());
        this_$iv.setZ(value.getZ());
    }

    @NotNull
    public final Vector3 getScale() {
        float f;
        boolean $i$f$getScale = false;
        Object this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        Vector3 vector3 = new Vector3(((Vector4)this_$iv).getX(), ((Vector4)this_$iv).getY(), ((Vector4)this_$iv).getZ());
        Object v$iv = vector3;
        boolean $i$f$length = false;
        float f2 = ((Vector3)v$iv).getX() * ((Vector3)v$iv).getX() + ((Vector3)v$iv).getY() * ((Vector3)v$iv).getY() + ((Vector3)v$iv).getZ() * ((Vector3)v$iv).getZ();
        boolean bl = false;
        float f3 = (float)Math.sqrt(f2);
        v$iv = this.getY();
        $i$f$getXyz = false;
        Vector3 vector32 = new Vector3(((Vector4)this_$iv).getX(), ((Vector4)this_$iv).getY(), ((Vector4)this_$iv).getZ());
        this_$iv = vector32;
        $i$f$length = false;
        f2 = ((Vector3)v$iv).getX() * ((Vector3)v$iv).getX() + ((Vector3)v$iv).getY() * ((Vector3)v$iv).getY() + ((Vector3)v$iv).getZ() * ((Vector3)v$iv).getZ();
        bl = false;
        float f4 = (float)Math.sqrt(f2);
        v$iv = this.getZ();
        $i$f$getXyz = false;
        Vector3 vector33 = new Vector3(((Vector4)this_$iv).getX(), ((Vector4)this_$iv).getY(), ((Vector4)this_$iv).getZ());
        this_$iv = vector33;
        $i$f$length = false;
        f2 = ((Vector3)v$iv).getX() * ((Vector3)v$iv).getX() + ((Vector3)v$iv).getY() * ((Vector3)v$iv).getY() + ((Vector3)v$iv).getZ() * ((Vector3)v$iv).getZ();
        bl = false;
        float f5 = f = (float)Math.sqrt(f2);
        float f6 = f4;
        float f7 = f3;
        return new Vector3(f7, f6, f5);
    }

    @NotNull
    public final Vector3 getTranslation() {
        boolean $i$f$getTranslation = false;
        Vector4 this_$iv = this.getW();
        boolean $i$f$getXyz = false;
        return new Vector3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    @NotNull
    public final Vector3 getRotation() {
        Vector3 vector3;
        boolean $i$f$degrees22;
        Matrix4 this_$iv = this;
        boolean $i$f$getRight = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getXyz = false;
        Vector3 x = VectorExtensionsKt.normalize(new Vector3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ()));
        Matrix4 this_$iv2 = this;
        boolean $i$f$getUp = false;
        Vector4 this_$iv$iv2 = this_$iv2.getY();
        boolean $i$f$getXyz2 = false;
        Vector3 y = VectorExtensionsKt.normalize(new Vector3(this_$iv$iv2.getX(), this_$iv$iv2.getY(), this_$iv$iv2.getZ()));
        Matrix4 this_$iv3 = this;
        boolean $i$f$getForward = false;
        Vector4 this_$iv$iv3 = this_$iv3.getZ();
        boolean $i$f$getXyz3 = false;
        Vector3 z = VectorExtensionsKt.normalize(new Vector3(this_$iv$iv3.getX(), this_$iv$iv3.getY(), this_$iv$iv3.getZ()));
        if (z.getY() <= -1.0f) {
            float f;
            float v$iv = -1.5707964f;
            $i$f$degrees22 = false;
            float f2 = v$iv * 57.295776f;
            v$iv = x.getZ();
            float $i$f$degrees22 = y.getZ();
            float f3 = 0.0f;
            boolean bl = false;
            v$iv = f = (float)Math.atan2(v$iv, $i$f$degrees22);
            boolean $i$f$degrees = false;
            float f4 = f = v$iv * 57.295776f;
            float f5 = f3;
            float f6 = f2;
            vector3 = new Vector3(f6, f5, f4);
        } else if (z.getY() >= 1.0f) {
            float f;
            float v$iv = 1.5707964f;
            $i$f$degrees22 = false;
            float f7 = v$iv * 57.295776f;
            v$iv = -x.getZ();
            float $i$f$degrees = -y.getZ();
            float f8 = 0.0f;
            boolean bl = false;
            v$iv = f = (float)Math.atan2(v$iv, $i$f$degrees);
            boolean $i$f$degrees3 = false;
            float f9 = f = v$iv * 57.295776f;
            float f10 = f8;
            float f11 = f7;
            vector3 = new Vector3(f11, f10, f9);
        } else {
            float f;
            float v$iv = z.getY();
            $i$f$degrees22 = false;
            float f12 = (float)Math.asin(v$iv);
            v$iv = -f12;
            $i$f$degrees22 = false;
            f12 = v$iv * 57.295776f;
            v$iv = z.getX();
            $i$f$degrees = z.getZ();
            boolean bl = false;
            float f13 = (float)Math.atan2(v$iv, $i$f$degrees);
            v$iv = -f13;
            boolean $i$f$degrees52 = false;
            f13 = v$iv * 57.295776f;
            v$iv = x.getY();
            float $i$f$degrees52 = y.getY();
            bl = false;
            v$iv = f = (float)Math.atan2(v$iv, $i$f$degrees52);
            boolean $i$f$degrees4 = false;
            float f14 = f = v$iv * 57.295776f;
            float f15 = f13;
            float f16 = f12;
            vector3 = new Vector3(f16, f15, f14);
        }
        return vector3;
    }

    @NotNull
    public final Matrix3 getUpperLeft() {
        Vector3 vector3;
        boolean $i$f$getUpperLeft = false;
        Vector4 this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        Vector3 vector32 = new Vector3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        this_$iv = this.getY();
        $i$f$getXyz = false;
        Vector3 vector33 = new Vector3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        this_$iv = this.getZ();
        $i$f$getXyz = false;
        Vector3 vector34 = vector3 = new Vector3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        Vector3 vector35 = vector33;
        Vector3 vector36 = vector32;
        return new Matrix3(vector36, vector35, vector34);
    }

    @NotNull
    public final Vector4 get(int column) {
        Vector4 vector4;
        int n = column;
        switch (n) {
            case 0: {
                vector4 = this.getX();
                break;
            }
            case 1: {
                vector4 = this.getY();
                break;
            }
            case 2: {
                vector4 = this.getZ();
                break;
            }
            case 3: {
                vector4 = this.getW();
                break;
            }
            default: {
                throw new IllegalArgumentException("column must be in 0..3");
            }
        }
        return vector4;
    }

    public final float get(int column, int row) {
        return this.get(column).get(row);
    }

    @NotNull
    public final Vector4 get(@NotNull MatrixColumn column) {
        Vector4 vector4;
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        MatrixColumn matrixColumn = column;
        int n = WhenMappings.$EnumSwitchMapping$0[matrixColumn.ordinal()];
        switch (n) {
            case 1: {
                vector4 = this.getX();
                break;
            }
            case 2: {
                vector4 = this.getY();
                break;
            }
            case 3: {
                vector4 = this.getZ();
                break;
            }
            case 4: {
                vector4 = this.getW();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return vector4;
    }

    public final float get(@NotNull MatrixColumn column, int row) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return this.get(column).get(row);
    }

    @NotNull
    public final Vector4 getRow(int row) {
        return new Vector4(this.getX().get(row), this.getY().get(row), this.getZ().get(row), this.getW().get(row));
    }

    public final void set(int column, @NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Vector4 this_$iv = this.get(column);
        boolean $i$f$setXyzw = false;
        this_$iv.setX(v.getX());
        this_$iv.setY(v.getY());
        this_$iv.setZ(v.getZ());
        this_$iv.setW(v.getW());
    }

    public final void set(int column, int row, float v) {
        this.get(column).set(row, v);
    }

    @NotNull
    public final Matrix4 unaryMinus() {
        return new Matrix4(this.getX().unaryMinus(), this.getY().unaryMinus(), this.getZ().unaryMinus(), this.getW().unaryMinus());
    }

    @NotNull
    public final Matrix4 inc() {
        Matrix4 matrix4 = new Matrix4(this);
        boolean bl = false;
        boolean bl2 = false;
        Matrix4 $this$inc_u24lambda_u2d0 = matrix4;
        boolean bl3 = false;
        Matrix4 matrix42 = $this$inc_u24lambda_u2d0;
        matrix42.setX(matrix42.getX().inc());
        matrix42.getX();
        matrix42 = $this$inc_u24lambda_u2d0;
        matrix42.setY(matrix42.getY().inc());
        matrix42.getY();
        matrix42 = $this$inc_u24lambda_u2d0;
        matrix42.setZ(matrix42.getZ().inc());
        matrix42.getZ();
        matrix42 = $this$inc_u24lambda_u2d0;
        matrix42.setW(matrix42.getW().inc());
        matrix42.getW();
        return matrix4;
    }

    @NotNull
    public final Matrix4 dec() {
        Matrix4 matrix4 = new Matrix4(this);
        boolean bl = false;
        boolean bl2 = false;
        Matrix4 $this$dec_u24lambda_u2d1 = matrix4;
        boolean bl3 = false;
        Matrix4 matrix42 = $this$dec_u24lambda_u2d1;
        matrix42.setX(matrix42.getX().dec());
        matrix42.getX();
        matrix42 = $this$dec_u24lambda_u2d1;
        matrix42.setY(matrix42.getY().dec());
        matrix42.getY();
        matrix42 = $this$dec_u24lambda_u2d1;
        matrix42.setZ(matrix42.getZ().dec());
        matrix42.getZ();
        matrix42 = $this$dec_u24lambda_u2d1;
        matrix42.setW(matrix42.getW().dec());
        matrix42.getW();
        return matrix4;
    }

    @NotNull
    public final Matrix4 plus(float v) {
        Vector4 vector4;
        Vector4 this_$iv = this.getX();
        boolean $i$f$plus = false;
        Vector4 vector42 = new Vector4(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v, this_$iv.getW() + v);
        this_$iv = this.getY();
        $i$f$plus = false;
        Vector4 vector43 = new Vector4(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v, this_$iv.getW() + v);
        this_$iv = this.getZ();
        $i$f$plus = false;
        Vector4 vector44 = new Vector4(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v, this_$iv.getW() + v);
        this_$iv = this.getW();
        $i$f$plus = false;
        Vector4 vector45 = vector4 = new Vector4(this_$iv.getX() + v, this_$iv.getY() + v, this_$iv.getZ() + v, this_$iv.getW() + v);
        Vector4 vector46 = vector44;
        Vector4 vector47 = vector43;
        Vector4 vector48 = vector42;
        return new Matrix4(vector48, vector47, vector46, vector45);
    }

    @NotNull
    public final Matrix4 minus(float v) {
        Vector4 vector4;
        Vector4 this_$iv = this.getX();
        boolean $i$f$minus = false;
        Vector4 vector42 = new Vector4(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v, this_$iv.getW() - v);
        this_$iv = this.getY();
        $i$f$minus = false;
        Vector4 vector43 = new Vector4(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v, this_$iv.getW() - v);
        this_$iv = this.getZ();
        $i$f$minus = false;
        Vector4 vector44 = new Vector4(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v, this_$iv.getW() - v);
        this_$iv = this.getW();
        $i$f$minus = false;
        Vector4 vector45 = vector4 = new Vector4(this_$iv.getX() - v, this_$iv.getY() - v, this_$iv.getZ() - v, this_$iv.getW() - v);
        Vector4 vector46 = vector44;
        Vector4 vector47 = vector43;
        Vector4 vector48 = vector42;
        return new Matrix4(vector48, vector47, vector46, vector45);
    }

    @NotNull
    public final Matrix4 times(float v) {
        Vector4 vector4;
        Vector4 this_$iv = this.getX();
        boolean $i$f$times = false;
        Vector4 vector42 = new Vector4(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v, this_$iv.getW() * v);
        this_$iv = this.getY();
        $i$f$times = false;
        Vector4 vector43 = new Vector4(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v, this_$iv.getW() * v);
        this_$iv = this.getZ();
        $i$f$times = false;
        Vector4 vector44 = new Vector4(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v, this_$iv.getW() * v);
        this_$iv = this.getW();
        $i$f$times = false;
        Vector4 vector45 = vector4 = new Vector4(this_$iv.getX() * v, this_$iv.getY() * v, this_$iv.getZ() * v, this_$iv.getW() * v);
        Vector4 vector46 = vector44;
        Vector4 vector47 = vector43;
        Vector4 vector48 = vector42;
        return new Matrix4(vector48, vector47, vector46, vector45);
    }

    @NotNull
    public final Matrix4 div(float v) {
        Vector4 vector4;
        Vector4 this_$iv = this.getX();
        boolean $i$f$div = false;
        Vector4 vector42 = new Vector4(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v, this_$iv.getW() / v);
        this_$iv = this.getY();
        $i$f$div = false;
        Vector4 vector43 = new Vector4(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v, this_$iv.getW() / v);
        this_$iv = this.getZ();
        $i$f$div = false;
        Vector4 vector44 = new Vector4(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v, this_$iv.getW() / v);
        this_$iv = this.getW();
        $i$f$div = false;
        Vector4 vector45 = vector4 = new Vector4(this_$iv.getX() / v, this_$iv.getY() / v, this_$iv.getZ() / v, this_$iv.getW() / v);
        Vector4 vector46 = vector44;
        Vector4 vector47 = vector43;
        Vector4 vector48 = vector42;
        return new Matrix4(vector48, vector47, vector46, vector45);
    }

    @NotNull
    public final Matrix4 times(@NotNull Matrix4 m) {
        float f;
        float f2;
        float f3;
        float f4;
        Vector4 a$iv;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Matrix4 t = MatrixExtensionsKt.transpose(this);
        Vector4 vector4 = t.getX();
        Vector4 b$iv = m.getX();
        boolean $i$f$dot = false;
        float f5 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getY();
        b$iv = m.getX();
        $i$f$dot = false;
        float f6 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getZ();
        b$iv = m.getX();
        $i$f$dot = false;
        float f7 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getW();
        b$iv = m.getX();
        $i$f$dot = false;
        float f8 = f4 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        float f9 = f7;
        float f10 = f6;
        float f11 = f5;
        a$iv = t.getX();
        b$iv = m.getY();
        Vector4 vector42 = new Vector4(f11, f10, f9, f8);
        $i$f$dot = false;
        f6 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getY();
        b$iv = m.getY();
        $i$f$dot = false;
        f7 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getZ();
        b$iv = m.getY();
        $i$f$dot = false;
        f4 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getW();
        b$iv = m.getY();
        $i$f$dot = false;
        float f12 = f3 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        float f13 = f4;
        float f14 = f7;
        float f15 = f6;
        a$iv = t.getX();
        b$iv = m.getZ();
        Vector4 vector43 = new Vector4(f15, f14, f13, f12);
        $i$f$dot = false;
        f7 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getY();
        b$iv = m.getZ();
        $i$f$dot = false;
        f4 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getZ();
        b$iv = m.getZ();
        $i$f$dot = false;
        f3 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getW();
        b$iv = m.getZ();
        $i$f$dot = false;
        float f16 = f2 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        float f17 = f3;
        float f18 = f4;
        float f19 = f7;
        a$iv = t.getX();
        b$iv = m.getW();
        Vector4 vector44 = new Vector4(f19, f18, f17, f16);
        $i$f$dot = false;
        f4 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getY();
        b$iv = m.getW();
        $i$f$dot = false;
        f3 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getZ();
        b$iv = m.getW();
        $i$f$dot = false;
        f2 = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        a$iv = t.getW();
        b$iv = m.getW();
        $i$f$dot = false;
        float f20 = f = a$iv.getX() * b$iv.getX() + a$iv.getY() * b$iv.getY() + a$iv.getZ() * b$iv.getZ() + a$iv.getW() * b$iv.getW();
        float f21 = f2;
        float f22 = f3;
        float f23 = f4;
        Vector4 vector45 = new Vector4(f23, f22, f21, f20);
        Vector4 vector46 = vector44;
        Vector4 vector47 = vector43;
        Vector4 vector48 = vector42;
        return new Matrix4(vector48, vector47, vector46, vector45);
    }

    @NotNull
    public final Vector4 times(@NotNull Vector4 v) {
        float f;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Matrix4 t = MatrixExtensionsKt.transpose(this);
        Vector4 a$iv = t.getX();
        boolean $i$f$dot = false;
        float f2 = a$iv.getX() * v.getX() + a$iv.getY() * v.getY() + a$iv.getZ() * v.getZ() + a$iv.getW() * v.getW();
        a$iv = t.getY();
        $i$f$dot = false;
        float f3 = a$iv.getX() * v.getX() + a$iv.getY() * v.getY() + a$iv.getZ() * v.getZ() + a$iv.getW() * v.getW();
        a$iv = t.getZ();
        $i$f$dot = false;
        float f4 = a$iv.getX() * v.getX() + a$iv.getY() * v.getY() + a$iv.getZ() * v.getZ() + a$iv.getW() * v.getW();
        a$iv = t.getW();
        $i$f$dot = false;
        float f5 = f = a$iv.getX() * v.getX() + a$iv.getY() * v.getY() + a$iv.getZ() * v.getZ() + a$iv.getW() * v.getW();
        float f6 = f4;
        float f7 = f3;
        float f8 = f2;
        return new Vector4(f8, f7, f6, f5);
    }

    public final void timesAssign(@NotNull Matrix4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.assignColumns(this.times(m));
    }

    public final void assignColumns(@NotNull Matrix4 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.setX(other.getX());
        this.setY(other.getY());
        this.setZ(other.getZ());
        this.setW(other.getW());
    }

    public final void assignFromStorage(@NotNull List<Float> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        boolean bl = storage.size() == 16;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.getX().assignFromStorage(storage.subList(0, 4));
        this.getY().assignFromStorage(storage.subList(4, 8));
        this.getZ().assignFromStorage(storage.subList(8, 12));
        this.getW().assignFromStorage(storage.subList(12, 16));
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] fArray = new float[]{this.getX().getX(), this.getY().getX(), this.getZ().getX(), this.getW().getX(), this.getX().getY(), this.getY().getY(), this.getZ().getY(), this.getW().getY(), this.getX().getZ(), this.getY().getZ(), this.getZ().getZ(), this.getW().getZ(), this.getX().getW(), this.getY().getW(), this.getZ().getW(), this.getW().getW()};
        return fArray;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            |" + this.getX().getX() + " " + this.getY().getX() + " " + this.getZ().getX() + " " + this.getW().getX() + "|\n            |" + this.getX().getY() + " " + this.getY().getY() + " " + this.getZ().getY() + " " + this.getW().getY() + "|\n            |" + this.getX().getZ() + " " + this.getY().getZ() + " " + this.getZ().getZ() + " " + this.getW().getZ() + "|\n            |" + this.getX().getW() + " " + this.getY().getW() + " " + this.getZ().getW() + " " + this.getW().getW() + "|\n            "));
    }

    @NotNull
    public final Vector3 perspectiveTransform(@NotNull Vector3 arg) {
        Matrix4 this_$iv;
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Vector3 this_$iv2 = arg;
        boolean $i$f$getV3storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv2.getX()), Float.valueOf(this_$iv2.getY()), Float.valueOf(this_$iv2.getZ())};
        List argStorage = CollectionsKt.listOf((Object[])objectArray);
        Matrix4 this_$iv3 = this;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv3.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv3.getY();
        Object[] objectArray3 = (Object[])CollectionsKt.listOf((Object[])objectArray2);
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        Object[] objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv = this_$iv3.getZ();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv = this_$iv3.getW();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv3 = this;
        float f = ((Number)CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4)).get(0)).floatValue() * ((Number)argStorage.get(0)).floatValue();
        $i$f$getM4storage = false;
        this_$iv$iv = this_$iv3.getX();
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv3.getY();
        objectArray3 = CollectionsKt.listOf((Object[])objectArray2);
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv = this_$iv3.getZ();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv = this_$iv3.getW();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        List list = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        this_$iv3 = this;
        f += ((Number)list.get(4)).floatValue() * ((Number)argStorage.get(1)).floatValue();
        $i$f$getM4storage = false;
        this_$iv$iv = this_$iv3.getX();
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv3.getY();
        objectArray3 = CollectionsKt.listOf((Object[])objectArray2);
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv = this_$iv3.getZ();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv = this_$iv3.getW();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        list = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        this_$iv3 = this;
        f += ((Number)list.get(8)).floatValue() * ((Number)argStorage.get(2)).floatValue();
        $i$f$getM4storage = false;
        this_$iv$iv = this_$iv3.getX();
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv3.getY();
        objectArray3 = CollectionsKt.listOf((Object[])objectArray2);
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv = this_$iv3.getZ();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv = this_$iv3.getW();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        list = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        float x_ = f + ((Number)list.get(12)).floatValue();
        Matrix4 this_$iv4 = this;
        boolean $i$f$getM4storage2 = false;
        Vector4 this_$iv$iv2 = this_$iv4.getX();
        boolean $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        this_$iv$iv2 = this_$iv4.getY();
        objectArray4 = CollectionsKt.listOf((Object[])objectArray3);
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        Object[] objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv2 = this_$iv4.getZ();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv2 = this_$iv4.getW();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv4 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5)).get(1)).floatValue() * ((Number)argStorage.get(0)).floatValue();
        $i$f$getM4storage2 = false;
        this_$iv$iv2 = this_$iv4.getX();
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        this_$iv$iv2 = this_$iv4.getY();
        objectArray4 = CollectionsKt.listOf((Object[])objectArray3);
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv2 = this_$iv4.getZ();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv2 = this_$iv4.getW();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        list = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        this_$iv4 = this;
        f += ((Number)list.get(5)).floatValue() * ((Number)argStorage.get(1)).floatValue();
        $i$f$getM4storage2 = false;
        this_$iv$iv2 = this_$iv4.getX();
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        this_$iv$iv2 = this_$iv4.getY();
        objectArray4 = CollectionsKt.listOf((Object[])objectArray3);
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv2 = this_$iv4.getZ();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv2 = this_$iv4.getW();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        list = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        this_$iv4 = this;
        f += ((Number)list.get(9)).floatValue() * ((Number)argStorage.get(2)).floatValue();
        $i$f$getM4storage2 = false;
        this_$iv$iv2 = this_$iv4.getX();
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        this_$iv$iv2 = this_$iv4.getY();
        objectArray4 = CollectionsKt.listOf((Object[])objectArray3);
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv2 = this_$iv4.getZ();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv2 = this_$iv4.getW();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage2 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        list = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        float y_ = f + ((Number)list.get(13)).floatValue();
        Matrix4 this_$iv5 = this;
        boolean $i$f$getM4storage3 = false;
        Vector4 this_$iv$iv3 = this_$iv5.getX();
        boolean $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        this_$iv$iv3 = this_$iv5.getY();
        objectArray5 = CollectionsKt.listOf((Object[])objectArray4);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        Collection collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv3 = this_$iv5.getZ();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv3 = this_$iv5.getW();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv5 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray5, (Iterable)collection).get(2)).floatValue() * ((Number)argStorage.get(0)).floatValue();
        $i$f$getM4storage3 = false;
        this_$iv$iv3 = this_$iv5.getX();
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        this_$iv$iv3 = this_$iv5.getY();
        objectArray5 = CollectionsKt.listOf((Object[])objectArray4);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv3 = this_$iv5.getZ();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv3 = this_$iv5.getW();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        list = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        this_$iv5 = this;
        f += ((Number)list.get(6)).floatValue() * ((Number)argStorage.get(1)).floatValue();
        $i$f$getM4storage3 = false;
        this_$iv$iv3 = this_$iv5.getX();
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        this_$iv$iv3 = this_$iv5.getY();
        objectArray5 = CollectionsKt.listOf((Object[])objectArray4);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv3 = this_$iv5.getZ();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv3 = this_$iv5.getW();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        list = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        this_$iv5 = this;
        f += ((Number)list.get(10)).floatValue() * ((Number)argStorage.get(2)).floatValue();
        $i$f$getM4storage3 = false;
        this_$iv$iv3 = this_$iv5.getX();
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        this_$iv$iv3 = this_$iv5.getY();
        objectArray5 = CollectionsKt.listOf((Object[])objectArray4);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv3 = this_$iv5.getZ();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv3 = this_$iv5.getW();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        $i$f$getV4storage3 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray4);
        list = CollectionsKt.plus((Collection)objectArray5, (Iterable)collection);
        float z_ = f + ((Number)list.get(14)).floatValue();
        Matrix4 $i$f$getM4storage22 = this;
        f = 1.0f;
        boolean $i$f$getM4storage4 = false;
        Vector4 this_$iv$iv4 = this_$iv.getX();
        boolean $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        this_$iv$iv4 = this_$iv.getY();
        collection = CollectionsKt.listOf((Object[])objectArray5);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        List list2 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv4 = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv4 = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        list = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        this_$iv = this;
        float f2 = ((Number)list.get(3)).floatValue() * ((Number)argStorage.get(0)).floatValue();
        $i$f$getM4storage4 = false;
        this_$iv$iv4 = this_$iv.getX();
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        this_$iv$iv4 = this_$iv.getY();
        collection = CollectionsKt.listOf((Object[])objectArray5);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv4 = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv4 = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        List list3 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        this_$iv = this;
        f2 += ((Number)list3.get(7)).floatValue() * ((Number)argStorage.get(1)).floatValue();
        $i$f$getM4storage4 = false;
        this_$iv$iv4 = this_$iv.getX();
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        this_$iv$iv4 = this_$iv.getY();
        collection = CollectionsKt.listOf((Object[])objectArray5);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv4 = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv4 = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        list3 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        this_$iv = this;
        f2 += ((Number)list3.get(11)).floatValue() * ((Number)argStorage.get(2)).floatValue();
        $i$f$getM4storage4 = false;
        this_$iv$iv4 = this_$iv.getX();
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        this_$iv$iv4 = this_$iv.getY();
        collection = CollectionsKt.listOf((Object[])objectArray5);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv4 = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv4 = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$getV4storage4 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        list2 = CollectionsKt.listOf((Object[])objectArray5);
        list3 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        float w_ = f / (f2 + ((Number)list3.get(15)).floatValue());
        arg.setX(x_ * w_);
        arg.setY(y_ * w_);
        arg.setZ(z_ * w_);
        return arg;
    }

    public final float getDeterminant() {
        Matrix4 this_$iv = this;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        Object[] objectArray2 = (Object[])CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        Object[] objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        objectArray2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        objectArray2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv = this;
        float f = ((Number)CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3)).get(0)).floatValue();
        $i$f$getM4storage = false;
        this_$iv$iv = this_$iv.getX();
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        objectArray2 = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        objectArray2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        objectArray2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        List list = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        this_$iv = this;
        f *= ((Number)list.get(5)).floatValue();
        $i$f$getM4storage = false;
        this_$iv$iv = this_$iv.getX();
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        objectArray2 = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        objectArray2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        objectArray2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        list = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        this_$iv = this;
        float f2 = ((Number)list.get(1)).floatValue();
        $i$f$getM4storage = false;
        this_$iv$iv = this_$iv.getX();
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        objectArray2 = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        objectArray2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        objectArray2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        objectArray3 = CollectionsKt.listOf((Object[])objectArray);
        List list2 = CollectionsKt.plus((Collection)objectArray2, (Iterable)((Iterable)objectArray3));
        float det2_01_01 = f - f2 * ((Number)list2.get(4)).floatValue();
        Matrix4 this_$iv2 = this;
        boolean $i$f$getM4storage2 = false;
        Vector4 this_$iv$iv2 = this_$iv2.getX();
        boolean $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        this_$iv$iv2 = this_$iv2.getY();
        objectArray3 = CollectionsKt.listOf((Object[])objectArray2);
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        Object[] objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv2 = this_$iv2.getZ();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv2 = this_$iv2.getW();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv2 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4)).get(0)).floatValue();
        $i$f$getM4storage2 = false;
        this_$iv$iv2 = this_$iv2.getX();
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        this_$iv$iv2 = this_$iv2.getY();
        objectArray3 = CollectionsKt.listOf((Object[])objectArray2);
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv2 = this_$iv2.getZ();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv2 = this_$iv2.getW();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        List list3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        this_$iv2 = this;
        f *= ((Number)list3.get(6)).floatValue();
        $i$f$getM4storage2 = false;
        this_$iv$iv2 = this_$iv2.getX();
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        this_$iv$iv2 = this_$iv2.getY();
        objectArray3 = CollectionsKt.listOf((Object[])objectArray2);
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv2 = this_$iv2.getZ();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv2 = this_$iv2.getW();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        list3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        this_$iv2 = this;
        float f3 = ((Number)list3.get(2)).floatValue();
        $i$f$getM4storage2 = false;
        this_$iv$iv2 = this_$iv2.getX();
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        this_$iv$iv2 = this_$iv2.getY();
        objectArray3 = CollectionsKt.listOf((Object[])objectArray2);
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv2 = this_$iv2.getZ();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        this_$iv$iv2 = this_$iv2.getW();
        objectArray3 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        $i$f$getV4storage2 = false;
        objectArray2 = new Float[]{Float.valueOf(this_$iv$iv2.getX()), Float.valueOf(this_$iv$iv2.getY()), Float.valueOf(this_$iv$iv2.getZ()), Float.valueOf(this_$iv$iv2.getW())};
        objectArray4 = CollectionsKt.listOf((Object[])objectArray2);
        list2 = CollectionsKt.plus((Collection)objectArray3, (Iterable)((Iterable)objectArray4));
        float det2_01_02 = f - f3 * ((Number)list2.get(4)).floatValue();
        Matrix4 this_$iv3 = this;
        boolean $i$f$getM4storage3 = false;
        Vector4 this_$iv$iv3 = this_$iv3.getX();
        boolean $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        this_$iv$iv3 = this_$iv3.getY();
        objectArray4 = CollectionsKt.listOf((Object[])objectArray3);
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        Object[] objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv3 = this_$iv3.getZ();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv3 = this_$iv3.getW();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv3 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5)).get(0)).floatValue();
        $i$f$getM4storage3 = false;
        this_$iv$iv3 = this_$iv3.getX();
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        this_$iv$iv3 = this_$iv3.getY();
        objectArray4 = CollectionsKt.listOf((Object[])objectArray3);
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv3 = this_$iv3.getZ();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv3 = this_$iv3.getW();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        List list4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        this_$iv3 = this;
        f *= ((Number)list4.get(7)).floatValue();
        $i$f$getM4storage3 = false;
        this_$iv$iv3 = this_$iv3.getX();
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        this_$iv$iv3 = this_$iv3.getY();
        objectArray4 = CollectionsKt.listOf((Object[])objectArray3);
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv3 = this_$iv3.getZ();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv3 = this_$iv3.getW();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        list4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        this_$iv3 = this;
        float f4 = ((Number)list4.get(3)).floatValue();
        $i$f$getM4storage3 = false;
        this_$iv$iv3 = this_$iv3.getX();
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        this_$iv$iv3 = this_$iv3.getY();
        objectArray4 = CollectionsKt.listOf((Object[])objectArray3);
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv3 = this_$iv3.getZ();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        this_$iv$iv3 = this_$iv3.getW();
        objectArray4 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        $i$f$getV4storage3 = false;
        objectArray3 = new Float[]{Float.valueOf(this_$iv$iv3.getX()), Float.valueOf(this_$iv$iv3.getY()), Float.valueOf(this_$iv$iv3.getZ()), Float.valueOf(this_$iv$iv3.getW())};
        objectArray5 = CollectionsKt.listOf((Object[])objectArray3);
        list2 = CollectionsKt.plus((Collection)objectArray4, (Iterable)((Iterable)objectArray5));
        float det2_01_03 = f - f4 * ((Number)list2.get(4)).floatValue();
        Matrix4 this_$iv4 = this;
        boolean $i$f$getM4storage4 = false;
        Vector4 this_$iv$iv4 = this_$iv4.getX();
        boolean $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        this_$iv$iv4 = this_$iv4.getY();
        objectArray5 = CollectionsKt.listOf((Object[])objectArray4);
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        Object[] objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv4 = this_$iv4.getZ();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv4 = this_$iv4.getW();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv4 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6)).get(1)).floatValue();
        $i$f$getM4storage4 = false;
        this_$iv$iv4 = this_$iv4.getX();
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        this_$iv$iv4 = this_$iv4.getY();
        objectArray5 = CollectionsKt.listOf((Object[])objectArray4);
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv4 = this_$iv4.getZ();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv4 = this_$iv4.getW();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        List list5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        this_$iv4 = this;
        f *= ((Number)list5.get(6)).floatValue();
        $i$f$getM4storage4 = false;
        this_$iv$iv4 = this_$iv4.getX();
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        this_$iv$iv4 = this_$iv4.getY();
        objectArray5 = CollectionsKt.listOf((Object[])objectArray4);
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv4 = this_$iv4.getZ();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv4 = this_$iv4.getW();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        list5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        this_$iv4 = this;
        float f5 = ((Number)list5.get(2)).floatValue();
        $i$f$getM4storage4 = false;
        this_$iv$iv4 = this_$iv4.getX();
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        this_$iv$iv4 = this_$iv4.getY();
        objectArray5 = CollectionsKt.listOf((Object[])objectArray4);
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv4 = this_$iv4.getZ();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        this_$iv$iv4 = this_$iv4.getW();
        objectArray5 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        $i$f$getV4storage4 = false;
        objectArray4 = new Float[]{Float.valueOf(this_$iv$iv4.getX()), Float.valueOf(this_$iv$iv4.getY()), Float.valueOf(this_$iv$iv4.getZ()), Float.valueOf(this_$iv$iv4.getW())};
        objectArray6 = CollectionsKt.listOf((Object[])objectArray4);
        list2 = CollectionsKt.plus((Collection)objectArray5, (Iterable)((Iterable)objectArray6));
        float det2_01_12 = f - f5 * ((Number)list2.get(5)).floatValue();
        Matrix4 this_$iv5 = this;
        boolean $i$f$getM4storage5 = false;
        Vector4 this_$iv$iv5 = this_$iv5.getX();
        boolean $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        this_$iv$iv5 = this_$iv5.getY();
        objectArray6 = CollectionsKt.listOf((Object[])objectArray5);
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        Object[] objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv5 = this_$iv5.getZ();
        objectArray6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv5 = this_$iv5.getW();
        objectArray6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv5 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7)).get(1)).floatValue();
        $i$f$getM4storage5 = false;
        this_$iv$iv5 = this_$iv5.getX();
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        this_$iv$iv5 = this_$iv5.getY();
        objectArray6 = CollectionsKt.listOf((Object[])objectArray5);
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv5 = this_$iv5.getZ();
        objectArray6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv5 = this_$iv5.getW();
        objectArray6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        List list6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        this_$iv5 = this;
        f *= ((Number)list6.get(7)).floatValue();
        $i$f$getM4storage5 = false;
        this_$iv$iv5 = this_$iv5.getX();
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        this_$iv$iv5 = this_$iv5.getY();
        objectArray6 = CollectionsKt.listOf((Object[])objectArray5);
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv5 = this_$iv5.getZ();
        objectArray6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv5 = this_$iv5.getW();
        objectArray6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        list6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        this_$iv5 = this;
        float f6 = ((Number)list6.get(3)).floatValue();
        $i$f$getM4storage5 = false;
        this_$iv$iv5 = this_$iv5.getX();
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        this_$iv$iv5 = this_$iv5.getY();
        objectArray6 = CollectionsKt.listOf((Object[])objectArray5);
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv5 = this_$iv5.getZ();
        objectArray6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        this_$iv$iv5 = this_$iv5.getW();
        objectArray6 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        $i$f$getV4storage5 = false;
        objectArray5 = new Float[]{Float.valueOf(this_$iv$iv5.getX()), Float.valueOf(this_$iv$iv5.getY()), Float.valueOf(this_$iv$iv5.getZ()), Float.valueOf(this_$iv$iv5.getW())};
        objectArray7 = CollectionsKt.listOf((Object[])objectArray5);
        list2 = CollectionsKt.plus((Collection)objectArray6, (Iterable)((Iterable)objectArray7));
        float det2_01_13 = f - f6 * ((Number)list2.get(5)).floatValue();
        Matrix4 this_$iv6 = this;
        boolean $i$f$getM4storage6 = false;
        Vector4 this_$iv$iv6 = this_$iv6.getX();
        boolean $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        this_$iv$iv6 = this_$iv6.getY();
        objectArray7 = CollectionsKt.listOf((Object[])objectArray6);
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        Object[] objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv$iv6 = this_$iv6.getZ();
        objectArray7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv$iv6 = this_$iv6.getW();
        objectArray7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv6 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8)).get(2)).floatValue();
        $i$f$getM4storage6 = false;
        this_$iv$iv6 = this_$iv6.getX();
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        this_$iv$iv6 = this_$iv6.getY();
        objectArray7 = CollectionsKt.listOf((Object[])objectArray6);
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv$iv6 = this_$iv6.getZ();
        objectArray7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv$iv6 = this_$iv6.getW();
        objectArray7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        List list7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        this_$iv6 = this;
        f *= ((Number)list7.get(7)).floatValue();
        $i$f$getM4storage6 = false;
        this_$iv$iv6 = this_$iv6.getX();
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        this_$iv$iv6 = this_$iv6.getY();
        objectArray7 = CollectionsKt.listOf((Object[])objectArray6);
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv$iv6 = this_$iv6.getZ();
        objectArray7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv$iv6 = this_$iv6.getW();
        objectArray7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        list7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        this_$iv6 = this;
        float f7 = ((Number)list7.get(3)).floatValue();
        $i$f$getM4storage6 = false;
        this_$iv$iv6 = this_$iv6.getX();
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        this_$iv$iv6 = this_$iv6.getY();
        objectArray7 = CollectionsKt.listOf((Object[])objectArray6);
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv$iv6 = this_$iv6.getZ();
        objectArray7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        this_$iv$iv6 = this_$iv6.getW();
        objectArray7 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        $i$f$getV4storage6 = false;
        objectArray6 = new Float[]{Float.valueOf(this_$iv$iv6.getX()), Float.valueOf(this_$iv$iv6.getY()), Float.valueOf(this_$iv$iv6.getZ()), Float.valueOf(this_$iv$iv6.getW())};
        objectArray8 = CollectionsKt.listOf((Object[])objectArray6);
        list2 = CollectionsKt.plus((Collection)objectArray7, (Iterable)((Iterable)objectArray8));
        float det2_01_23 = f - f7 * ((Number)list2.get(6)).floatValue();
        Matrix4 this_$iv7 = this;
        boolean $i$f$getM4storage7 = false;
        Vector4 this_$iv$iv7 = this_$iv7.getX();
        boolean $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        this_$iv$iv7 = this_$iv7.getY();
        objectArray8 = CollectionsKt.listOf((Object[])objectArray7);
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        Object[] objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        this_$iv$iv7 = this_$iv7.getZ();
        objectArray8 = CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9));
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        this_$iv$iv7 = this_$iv7.getW();
        objectArray8 = CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9));
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        this_$iv7 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9)).get(8)).floatValue() * det2_01_12;
        $i$f$getM4storage7 = false;
        this_$iv$iv7 = this_$iv7.getX();
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        this_$iv$iv7 = this_$iv7.getY();
        objectArray8 = CollectionsKt.listOf((Object[])objectArray7);
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        this_$iv$iv7 = this_$iv7.getZ();
        objectArray8 = CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9));
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        this_$iv$iv7 = this_$iv7.getW();
        objectArray8 = CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9));
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        List list8 = CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9));
        this_$iv7 = this;
        f -= ((Number)list8.get(9)).floatValue() * det2_01_02;
        $i$f$getM4storage7 = false;
        this_$iv$iv7 = this_$iv7.getX();
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        this_$iv$iv7 = this_$iv7.getY();
        objectArray8 = CollectionsKt.listOf((Object[])objectArray7);
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        this_$iv$iv7 = this_$iv7.getZ();
        objectArray8 = CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9));
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        this_$iv$iv7 = this_$iv7.getW();
        objectArray8 = CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9));
        $i$f$getV4storage7 = false;
        objectArray7 = new Float[]{Float.valueOf(this_$iv$iv7.getX()), Float.valueOf(this_$iv$iv7.getY()), Float.valueOf(this_$iv$iv7.getZ()), Float.valueOf(this_$iv$iv7.getW())};
        objectArray9 = CollectionsKt.listOf((Object[])objectArray7);
        list8 = CollectionsKt.plus((Collection)objectArray8, (Iterable)((Iterable)objectArray9));
        float det3_201_012 = f + ((Number)list8.get(10)).floatValue() * det2_01_01;
        Matrix4 this_$iv8 = this;
        boolean $i$f$getM4storage8 = false;
        Vector4 this_$iv$iv8 = this_$iv8.getX();
        boolean $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        this_$iv$iv8 = this_$iv8.getY();
        objectArray9 = CollectionsKt.listOf((Object[])objectArray8);
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        Object[] objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        this_$iv$iv8 = this_$iv8.getZ();
        objectArray9 = CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10));
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        this_$iv$iv8 = this_$iv8.getW();
        objectArray9 = CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10));
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        this_$iv8 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10)).get(8)).floatValue() * det2_01_13;
        $i$f$getM4storage8 = false;
        this_$iv$iv8 = this_$iv8.getX();
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        this_$iv$iv8 = this_$iv8.getY();
        objectArray9 = CollectionsKt.listOf((Object[])objectArray8);
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        this_$iv$iv8 = this_$iv8.getZ();
        objectArray9 = CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10));
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        this_$iv$iv8 = this_$iv8.getW();
        objectArray9 = CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10));
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        list8 = CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10));
        this_$iv8 = this;
        f -= ((Number)list8.get(9)).floatValue() * det2_01_03;
        $i$f$getM4storage8 = false;
        this_$iv$iv8 = this_$iv8.getX();
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        this_$iv$iv8 = this_$iv8.getY();
        objectArray9 = CollectionsKt.listOf((Object[])objectArray8);
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        this_$iv$iv8 = this_$iv8.getZ();
        objectArray9 = CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10));
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        this_$iv$iv8 = this_$iv8.getW();
        objectArray9 = CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10));
        $i$f$getV4storage8 = false;
        objectArray8 = new Float[]{Float.valueOf(this_$iv$iv8.getX()), Float.valueOf(this_$iv$iv8.getY()), Float.valueOf(this_$iv$iv8.getZ()), Float.valueOf(this_$iv$iv8.getW())};
        objectArray10 = CollectionsKt.listOf((Object[])objectArray8);
        list8 = CollectionsKt.plus((Collection)objectArray9, (Iterable)((Iterable)objectArray10));
        float det3_201_013 = f + ((Number)list8.get(11)).floatValue() * det2_01_01;
        Matrix4 this_$iv9 = this;
        boolean $i$f$getM4storage9 = false;
        Vector4 this_$iv$iv9 = this_$iv9.getX();
        boolean $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        this_$iv$iv9 = this_$iv9.getY();
        objectArray10 = CollectionsKt.listOf((Object[])objectArray9);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        Collection collection = CollectionsKt.listOf((Object[])objectArray9);
        this_$iv$iv9 = this_$iv9.getZ();
        objectArray10 = CollectionsKt.plus((Collection)objectArray10, (Iterable)collection);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray9);
        this_$iv$iv9 = this_$iv9.getW();
        objectArray10 = CollectionsKt.plus((Collection)objectArray10, (Iterable)collection);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray9);
        this_$iv9 = this;
        f = ((Number)CollectionsKt.plus((Collection)objectArray10, (Iterable)collection).get(8)).floatValue() * det2_01_23;
        $i$f$getM4storage9 = false;
        this_$iv$iv9 = this_$iv9.getX();
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        this_$iv$iv9 = this_$iv9.getY();
        objectArray10 = CollectionsKt.listOf((Object[])objectArray9);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray9);
        this_$iv$iv9 = this_$iv9.getZ();
        objectArray10 = CollectionsKt.plus((Collection)objectArray10, (Iterable)collection);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray9);
        this_$iv$iv9 = this_$iv9.getW();
        objectArray10 = CollectionsKt.plus((Collection)objectArray10, (Iterable)collection);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray9);
        list8 = CollectionsKt.plus((Collection)objectArray10, (Iterable)collection);
        this_$iv9 = this;
        f -= ((Number)list8.get(10)).floatValue() * det2_01_03;
        $i$f$getM4storage9 = false;
        this_$iv$iv9 = this_$iv9.getX();
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        this_$iv$iv9 = this_$iv9.getY();
        objectArray10 = CollectionsKt.listOf((Object[])objectArray9);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray9);
        this_$iv$iv9 = this_$iv9.getZ();
        objectArray10 = CollectionsKt.plus((Collection)objectArray10, (Iterable)collection);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray9);
        this_$iv$iv9 = this_$iv9.getW();
        objectArray10 = CollectionsKt.plus((Collection)objectArray10, (Iterable)collection);
        $i$f$getV4storage9 = false;
        objectArray9 = new Float[]{Float.valueOf(this_$iv$iv9.getX()), Float.valueOf(this_$iv$iv9.getY()), Float.valueOf(this_$iv$iv9.getZ()), Float.valueOf(this_$iv$iv9.getW())};
        collection = CollectionsKt.listOf((Object[])objectArray9);
        list8 = CollectionsKt.plus((Collection)objectArray10, (Iterable)collection);
        float det3_201_023 = f + ((Number)list8.get(11)).floatValue() * det2_01_02;
        Matrix4 this_$iv10 = this;
        boolean $i$f$getM4storage10 = false;
        Vector4 this_$iv$iv10 = this_$iv10.getX();
        boolean $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        this_$iv$iv10 = this_$iv10.getY();
        collection = CollectionsKt.listOf((Object[])objectArray10);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        List list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv10 = this;
        f = ((Number)CollectionsKt.plus((Collection)collection, (Iterable)list9).get(9)).floatValue() * det2_01_23;
        $i$f$getM4storage10 = false;
        this_$iv$iv10 = this_$iv10.getX();
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        this_$iv$iv10 = this_$iv10.getY();
        collection = CollectionsKt.listOf((Object[])objectArray10);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        list8 = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        this_$iv10 = this;
        f -= ((Number)list8.get(10)).floatValue() * det2_01_13;
        $i$f$getM4storage10 = false;
        this_$iv$iv10 = this_$iv10.getX();
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        this_$iv$iv10 = this_$iv10.getY();
        collection = CollectionsKt.listOf((Object[])objectArray10);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        list8 = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        float det3_201_123 = f + ((Number)list8.get(11)).floatValue() * det2_01_12;
        this_$iv10 = this;
        f = -det3_201_123;
        $i$f$getM4storage10 = false;
        this_$iv$iv10 = this_$iv10.getX();
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        this_$iv$iv10 = this_$iv10.getY();
        collection = CollectionsKt.listOf((Object[])objectArray10);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        list8 = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        this_$iv10 = this;
        float f8 = det3_201_023;
        f *= ((Number)list8.get(12)).floatValue();
        $i$f$getM4storage10 = false;
        this_$iv$iv10 = this_$iv10.getX();
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        this_$iv$iv10 = this_$iv10.getY();
        collection = CollectionsKt.listOf((Object[])objectArray10);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        list2 = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        float f9 = f + f8 * ((Number)list2.get(13)).floatValue();
        this_$iv10 = this;
        f8 = det3_201_013;
        f = f9;
        $i$f$getM4storage10 = false;
        this_$iv$iv10 = this_$iv10.getX();
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        this_$iv$iv10 = this_$iv10.getY();
        collection = CollectionsKt.listOf((Object[])objectArray10);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        list2 = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        float f10 = f - f8 * ((Number)list2.get(14)).floatValue();
        this_$iv10 = this;
        f8 = det3_201_012;
        f = f10;
        $i$f$getM4storage10 = false;
        this_$iv$iv10 = this_$iv10.getX();
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        this_$iv$iv10 = this_$iv10.getY();
        collection = CollectionsKt.listOf((Object[])objectArray10);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        this_$iv$iv10 = this_$iv10.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        $i$f$getV4storage10 = false;
        objectArray10 = new Float[]{Float.valueOf(this_$iv$iv10.getX()), Float.valueOf(this_$iv$iv10.getY()), Float.valueOf(this_$iv$iv10.getZ()), Float.valueOf(this_$iv$iv10.getW())};
        list9 = CollectionsKt.listOf((Object[])objectArray10);
        list2 = CollectionsKt.plus((Collection)collection, (Iterable)list9);
        return f + f8 * ((Number)list2.get(15)).floatValue();
    }

    public final float invert() {
        return this.copyInverse(this);
    }

    public final float copyInverse(@NotNull Matrix4 arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Matrix4 this_$iv = arg;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        List argStorage = CollectionsKt.plus((Collection)collection, (Iterable)list);
        float a00 = ((Number)argStorage.get(0)).floatValue();
        float a01 = ((Number)argStorage.get(1)).floatValue();
        float a02 = ((Number)argStorage.get(2)).floatValue();
        float a03 = ((Number)argStorage.get(3)).floatValue();
        float a10 = ((Number)argStorage.get(4)).floatValue();
        float a11 = ((Number)argStorage.get(5)).floatValue();
        float a12 = ((Number)argStorage.get(6)).floatValue();
        float a13 = ((Number)argStorage.get(7)).floatValue();
        float a20 = ((Number)argStorage.get(8)).floatValue();
        float a21 = ((Number)argStorage.get(9)).floatValue();
        float a22 = ((Number)argStorage.get(10)).floatValue();
        float a23 = ((Number)argStorage.get(11)).floatValue();
        float a30 = ((Number)argStorage.get(12)).floatValue();
        float a31 = ((Number)argStorage.get(13)).floatValue();
        float a32 = ((Number)argStorage.get(14)).floatValue();
        float a33 = ((Number)argStorage.get(15)).floatValue();
        float b00 = a00 * a11 - a01 * a10;
        float b01 = a00 * a12 - a02 * a10;
        float b02 = a00 * a13 - a03 * a10;
        float b03 = a01 * a12 - a02 * a11;
        float b04 = a01 * a13 - a03 * a11;
        float b05 = a02 * a13 - a03 * a12;
        float b06 = a20 * a31 - a21 * a30;
        float b07 = a20 * a32 - a22 * a30;
        float b08 = a20 * a33 - a23 * a30;
        float b09 = a21 * a32 - a22 * a31;
        float b10 = a21 * a33 - a23 * a31;
        float b11 = a22 * a33 - a23 * a32;
        float det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
        if (det == 0.0f) {
            this.setFrom(arg);
            return 0.0f;
        }
        float invDet = 1.0f / det;
        int n = 16;
        boolean bl = false;
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        boolean bl2 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int n4 = n2++;
            boolean bl3 = false;
            int n5 = n4;
            ArrayList<Float> arrayList2 = arrayList;
            boolean bl4 = false;
            Float f = Float.valueOf(0.0f);
            arrayList2.add(f);
        }
        List newStorage = arrayList;
        ((Number)newStorage.set(0, Float.valueOf((a11 * b11 - a12 * b10 + a13 * b09) * invDet))).floatValue();
        ((Number)newStorage.set(1, Float.valueOf((-a01 * b11 + a02 * b10 - a03 * b09) * invDet))).floatValue();
        ((Number)newStorage.set(2, Float.valueOf((a31 * b05 - a32 * b04 + a33 * b03) * invDet))).floatValue();
        ((Number)newStorage.set(3, Float.valueOf((-a21 * b05 + a22 * b04 - a23 * b03) * invDet))).floatValue();
        ((Number)newStorage.set(4, Float.valueOf((-a10 * b11 + a12 * b08 - a13 * b07) * invDet))).floatValue();
        ((Number)newStorage.set(5, Float.valueOf((a00 * b11 - a02 * b08 + a03 * b07) * invDet))).floatValue();
        ((Number)newStorage.set(6, Float.valueOf((-a30 * b05 + a32 * b02 - a33 * b01) * invDet))).floatValue();
        ((Number)newStorage.set(7, Float.valueOf((a20 * b05 - a22 * b02 + a23 * b01) * invDet))).floatValue();
        ((Number)newStorage.set(8, Float.valueOf((a10 * b10 - a11 * b08 + a13 * b06) * invDet))).floatValue();
        ((Number)newStorage.set(9, Float.valueOf((-a00 * b10 + a01 * b08 - a03 * b06) * invDet))).floatValue();
        ((Number)newStorage.set(10, Float.valueOf((a30 * b04 - a31 * b02 + a33 * b00) * invDet))).floatValue();
        ((Number)newStorage.set(11, Float.valueOf((-a20 * b04 + a21 * b02 - a23 * b00) * invDet))).floatValue();
        ((Number)newStorage.set(12, Float.valueOf((-a10 * b09 + a11 * b07 - a12 * b06) * invDet))).floatValue();
        ((Number)newStorage.set(13, Float.valueOf((a00 * b09 - a01 * b07 + a02 * b06) * invDet))).floatValue();
        ((Number)newStorage.set(14, Float.valueOf((-a30 * b03 + a31 * b01 - a32 * b00) * invDet))).floatValue();
        ((Number)newStorage.set(15, Float.valueOf((a20 * b03 - a21 * b01 + a22 * b00) * invDet))).floatValue();
        this.assignFromStorage(newStorage);
        return det;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrom(@NotNull Matrix4 arg) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Matrix4 matrix4 = arg;
        Matrix4 matrix42 = this;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        List list2 = CollectionsKt.plus((Collection)collection, (Iterable)list);
        matrix42.assignFromStorage(list2);
    }

    public final void rotateX(float radians) {
        boolean bl = false;
        float c = (float)Math.cos(radians);
        boolean bl2 = false;
        float s = (float)Math.sin(radians);
        Matrix4 this_$iv = this;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        List newStorage = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list));
        ((Number)newStorage.set(0, Float.valueOf(1.0f))).floatValue();
        ((Number)newStorage.set(1, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(2, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(4, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(5, Float.valueOf(c))).floatValue();
        ((Number)newStorage.set(6, Float.valueOf(s))).floatValue();
        ((Number)newStorage.set(8, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(9, Float.valueOf(-s))).floatValue();
        ((Number)newStorage.set(10, Float.valueOf(c))).floatValue();
        ((Number)newStorage.set(3, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(7, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(11, Float.valueOf(0.0f))).floatValue();
        this.assignFromStorage(newStorage);
    }

    public final void rotateY(float radians) {
        boolean bl = false;
        float c = (float)Math.cos(radians);
        boolean bl2 = false;
        float s = (float)Math.sin(radians);
        Matrix4 this_$iv = this;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        List newStorage = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list));
        ((Number)newStorage.set(0, Float.valueOf(c))).floatValue();
        ((Number)newStorage.set(1, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(2, Float.valueOf(-s))).floatValue();
        ((Number)newStorage.set(4, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(5, Float.valueOf(1.0f))).floatValue();
        ((Number)newStorage.set(6, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(8, Float.valueOf(s))).floatValue();
        ((Number)newStorage.set(9, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(10, Float.valueOf(c))).floatValue();
        ((Number)newStorage.set(3, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(7, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(11, Float.valueOf(0.0f))).floatValue();
        this.assignFromStorage(newStorage);
    }

    public final void rotateZ(float radians) {
        boolean bl = false;
        float c = (float)Math.cos(radians);
        boolean bl2 = false;
        float s = (float)Math.sin(radians);
        Matrix4 this_$iv = this;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        List newStorage = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list));
        ((Number)newStorage.set(0, Float.valueOf(c))).floatValue();
        ((Number)newStorage.set(1, Float.valueOf(s))).floatValue();
        ((Number)newStorage.set(2, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(4, Float.valueOf(-s))).floatValue();
        ((Number)newStorage.set(5, Float.valueOf(c))).floatValue();
        ((Number)newStorage.set(6, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(8, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(9, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(10, Float.valueOf(1.0f))).floatValue();
        ((Number)newStorage.set(3, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(7, Float.valueOf(0.0f))).floatValue();
        ((Number)newStorage.set(11, Float.valueOf(0.0f))).floatValue();
        this.assignFromStorage(newStorage);
    }

    public final void setTranslationRaw(float x, float y, float z) {
        this.set(3, 0, x);
        this.set(3, 1, y);
        this.set(3, 2, z);
    }

    public final void scale(@NotNull Object x, @Nullable Float y, @Nullable Float z) {
        List newStorage;
        float sw;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Float sx = null;
        Float sy = null;
        Float sz = null;
        float f = sw = x instanceof Vector4 ? ((Vector4)x).getW() : 1.0f;
        if (x instanceof Vector3) {
            sx = Float.valueOf(((Vector3)x).getX());
            sy = Float.valueOf(((Vector3)x).getY());
            sz = Float.valueOf(((Vector3)x).getZ());
        } else if (x instanceof Vector4) {
            sx = Float.valueOf(((Vector4)x).getX());
            sy = Float.valueOf(((Vector4)x).getY());
            sz = Float.valueOf(((Vector4)x).getZ());
        } else if (x instanceof Float) {
            sx = Float.valueOf(((Number)x).floatValue());
            sy = y != null ? y : Float.valueOf(((Number)x).floatValue());
            sz = z != null ? z : Float.valueOf(((Number)x).floatValue());
        }
        Float f2 = sx;
        if (f2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        f2.floatValue();
        f2 = sy;
        if (f2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        f2.floatValue();
        f2 = sz;
        if (f2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        f2.floatValue();
        Matrix4 this_$iv = this;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        List list2 = newStorage = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list));
        ((Number)list2.set(0, Float.valueOf(((Number)list2.get(0)).floatValue() * sx.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(1, Float.valueOf(((Number)list2.get(1)).floatValue() * sx.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(2, Float.valueOf(((Number)list2.get(2)).floatValue() * sx.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(3, Float.valueOf(((Number)list2.get(3)).floatValue() * sx.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(4, Float.valueOf(((Number)list2.get(4)).floatValue() * sy.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(5, Float.valueOf(((Number)list2.get(5)).floatValue() * sy.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(6, Float.valueOf(((Number)list2.get(6)).floatValue() * sy.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(7, Float.valueOf(((Number)list2.get(7)).floatValue() * sy.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(8, Float.valueOf(((Number)list2.get(8)).floatValue() * sz.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(9, Float.valueOf(((Number)list2.get(9)).floatValue() * sz.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(10, Float.valueOf(((Number)list2.get(10)).floatValue() * sz.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(11, Float.valueOf(((Number)list2.get(11)).floatValue() * sz.floatValue()))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(12, Float.valueOf(((Number)list2.get(12)).floatValue() * sw))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(13, Float.valueOf(((Number)list2.get(13)).floatValue() * sw))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(14, Float.valueOf(((Number)list2.get(14)).floatValue() * sw))).floatValue();
        list2 = newStorage;
        ((Number)list2.set(15, Float.valueOf(((Number)list2.get(15)).floatValue() * sw))).floatValue();
        this.assignFromStorage(newStorage);
    }

    public static /* synthetic */ void scale$default(Matrix4 this_, Object x, Float y, Float z, int n, Object object) {
        if ((n & 2) != 0) {
            y = null;
        }
        if ((n & 4) != 0) {
            z = null;
        }
        this_.scale(x, y, z);
    }

    public final void translate(@NotNull Object x, float y, float z) {
        float tw;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Float tx = null;
        Float ty = null;
        Float tz = null;
        float f = tw = x instanceof Vector4 ? ((Vector4)x).getW() : 1.0f;
        if (x instanceof Vector3) {
            tx = Float.valueOf(((Vector3)x).getX());
            ty = Float.valueOf(((Vector3)x).getY());
            tz = Float.valueOf(((Vector3)x).getZ());
        } else if (x instanceof Vector4) {
            tx = Float.valueOf(((Vector4)x).getX());
            ty = Float.valueOf(((Vector4)x).getY());
            tz = Float.valueOf(((Vector4)x).getZ());
        } else if (x instanceof Float) {
            tx = Float.valueOf(((Number)x).floatValue());
            ty = Float.valueOf(y);
            tz = Float.valueOf(z);
        }
        Float f2 = tx;
        if (f2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        f2.floatValue();
        f2 = ty;
        if (f2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        f2.floatValue();
        f2 = tz;
        if (f2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
        }
        f2.floatValue();
        Matrix4 this_$iv = this;
        boolean $i$f$getM4storage = false;
        Vector4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getV4storage = false;
        Object[] objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        this_$iv$iv = this_$iv.getY();
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getZ();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        this_$iv$iv = this_$iv.getW();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
        $i$f$getV4storage = false;
        objectArray = new Float[]{Float.valueOf(this_$iv$iv.getX()), Float.valueOf(this_$iv$iv.getY()), Float.valueOf(this_$iv$iv.getZ()), Float.valueOf(this_$iv$iv.getW())};
        list = CollectionsKt.listOf((Object[])objectArray);
        List newStorage = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list));
        float t1 = ((Number)newStorage.get(0)).floatValue() * tx.floatValue() + ((Number)newStorage.get(4)).floatValue() * ty.floatValue() + ((Number)newStorage.get(8)).floatValue() * tz.floatValue() + ((Number)newStorage.get(12)).floatValue() * tw;
        float t2 = ((Number)newStorage.get(1)).floatValue() * tx.floatValue() + ((Number)newStorage.get(5)).floatValue() * ty.floatValue() + ((Number)newStorage.get(9)).floatValue() * tz.floatValue() + ((Number)newStorage.get(13)).floatValue() * tw;
        float t3 = ((Number)newStorage.get(2)).floatValue() * tx.floatValue() + ((Number)newStorage.get(6)).floatValue() * ty.floatValue() + ((Number)newStorage.get(10)).floatValue() * tz.floatValue() + ((Number)newStorage.get(14)).floatValue() * tw;
        float t4 = ((Number)newStorage.get(3)).floatValue() * tx.floatValue() + ((Number)newStorage.get(7)).floatValue() * ty.floatValue() + ((Number)newStorage.get(11)).floatValue() * tz.floatValue() + ((Number)newStorage.get(15)).floatValue() * tw;
        ((Number)newStorage.set(12, Float.valueOf(t1))).floatValue();
        ((Number)newStorage.set(13, Float.valueOf(t2))).floatValue();
        ((Number)newStorage.set(14, Float.valueOf(t3))).floatValue();
        ((Number)newStorage.set(15, Float.valueOf(t4))).floatValue();
        this.assignFromStorage(newStorage);
    }

    public static /* synthetic */ void translate$default(Matrix4 this_, Object x, float y, float z, int n, Object object) {
        if ((n & 2) != 0) {
            y = 0.0f;
        }
        if ((n & 4) != 0) {
            z = 0.0f;
        }
        this_.translate(x, y, z);
    }

    @NotNull
    public final Vector4 component1() {
        return this.x;
    }

    @NotNull
    public final Vector4 component2() {
        return this.y;
    }

    @NotNull
    public final Vector4 component3() {
        return this.z;
    }

    @NotNull
    public final Vector4 component4() {
        return this.w;
    }

    @NotNull
    public final Matrix4 copy(@NotNull Vector4 x, @NotNull Vector4 y, @NotNull Vector4 z, @NotNull Vector4 w) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return new Matrix4(x, y, z, w);
    }

    public static /* synthetic */ Matrix4 copy$default(Matrix4 this_, Vector4 x, Vector4 y, Vector4 z, Vector4 w, int n, Object object) {
        if ((n & 1) != 0) {
            x = this_.x;
        }
        if ((n & 2) != 0) {
            y = this_.y;
        }
        if ((n & 4) != 0) {
            z = this_.z;
        }
        if ((n & 8) != 0) {
            w = this_.w;
        }
        return this_.copy(x, y, z, w);
    }

    public int hashCode() {
        return ((this.x.hashCode() * 31 + this.y.hashCode()) * 31 + this.z.hashCode()) * 31 + this.w.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Matrix4)) {
            return false;
        }
        Object object = other;
        Matrix4 matrix4 = (Matrix4)object;
        if (!Intrinsics.areEqual((Object)this.x, (Object)matrix4.x)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.y, (Object)matrix4.y)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.z, (Object)matrix4.z)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.w, (Object)matrix4.w);
    }

    public Matrix4() {
        this((Vector4)null, (Vector4)null, (Vector4)null, (Vector4)null, 15, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\u0004J\u0012\u0010\r\u001a\u00020\u00042\n\u0010\u000e\u001a\u00020\u000f\"\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006J\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\u0004\u00a8\u0006\u0017"}, d2={"Landroidx/ui/graphics/vectormath/Matrix4$Companion;", "", "()V", "diagonal3", "Landroidx/ui/graphics/vectormath/Matrix4;", "scale", "Landroidx/ui/graphics/vectormath/Vector3;", "diagonal3Values", "x", "", "y", "z", "identity", "of", "a", "", "rotationX", "radians", "rotationY", "rotationZ", "translation", "translationValues", "zero", "ui-graphics_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Matrix4 of(float ... a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            boolean bl = a.length >= 16;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new Matrix4(new Vector4(a[0], a[4], a[8], a[12]), new Vector4(a[1], a[5], a[9], a[13]), new Vector4(a[2], a[6], a[10], a[14]), new Vector4(a[3], a[7], a[11], a[15]));
        }

        @NotNull
        public final Matrix4 zero() {
            return this.diagonal3Values(0.0f, 0.0f, 0.0f);
        }

        @NotNull
        public final Matrix4 identity() {
            return new Matrix4(null, null, null, null, 15, null);
        }

        @NotNull
        public final Matrix4 diagonal3(@NotNull Vector3 scale) {
            Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
            return this.diagonal3Values(scale.getX(), scale.getY(), scale.getZ());
        }

        @NotNull
        public final Matrix4 diagonal3Values(float x, float y, float z) {
            return new Matrix4(new Vector4(x, 0.0f, 0.0f, 0.0f), new Vector4(0.0f, y, 0.0f, 0.0f), new Vector4(0.0f, 0.0f, z, 0.0f), new Vector4(0.0f, 0.0f, 0.0f, 1.0f));
        }

        @NotNull
        public final Matrix4 rotationX(float radians) {
            Matrix4 matrix4 = this.zero();
            boolean bl = false;
            boolean bl2 = false;
            Matrix4 $this$rotationX_u24lambda_u2d0 = matrix4;
            boolean bl3 = false;
            $this$rotationX_u24lambda_u2d0.set(3, 3, 1.0f);
            $this$rotationX_u24lambda_u2d0.rotateX(radians);
            return matrix4;
        }

        @NotNull
        public final Matrix4 rotationY(float radians) {
            Matrix4 matrix4 = this.zero();
            boolean bl = false;
            boolean bl2 = false;
            Matrix4 $this$rotationY_u24lambda_u2d1 = matrix4;
            boolean bl3 = false;
            $this$rotationY_u24lambda_u2d1.set(3, 3, 1.0f);
            $this$rotationY_u24lambda_u2d1.rotateY(radians);
            return matrix4;
        }

        @NotNull
        public final Matrix4 rotationZ(float radians) {
            Matrix4 matrix4 = this.zero();
            boolean bl = false;
            boolean bl2 = false;
            Matrix4 $this$rotationZ_u24lambda_u2d2 = matrix4;
            boolean bl3 = false;
            $this$rotationZ_u24lambda_u2d2.set(3, 3, 1.0f);
            $this$rotationZ_u24lambda_u2d2.rotateZ(radians);
            return matrix4;
        }

        @NotNull
        public final Matrix4 translation(@NotNull Vector3 translation) {
            Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
            Matrix4 matrix4 = this.identity();
            boolean bl = false;
            boolean bl2 = false;
            Matrix4 $this$translation_u24lambda_u2d3 = matrix4;
            boolean bl3 = false;
            $this$translation_u24lambda_u2d3.setTranslationRaw(translation.getX(), translation.getY(), translation.getZ());
            return matrix4;
        }

        @NotNull
        public final Matrix4 translationValues(float x, float y, float z) {
            Matrix4 matrix4 = this.identity();
            boolean bl = false;
            boolean bl2 = false;
            Matrix4 $this$translationValues_u24lambda_u2d4 = matrix4;
            boolean bl3 = false;
            $this$translationValues_u24lambda_u2d4.setTranslationRaw(x, y, z);
            return matrix4;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatrixColumn.values().length];
            nArray[MatrixColumn.X.ordinal()] = 1;
            nArray[MatrixColumn.Y.ordinal()] = 2;
            nArray[MatrixColumn.Z.ordinal()] = 3;
            nArray[MatrixColumn.W.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

