/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.colorspace;

import androidx.annotation.Size;
import androidx.ui.graphics.colorspace.Adaptation;
import androidx.ui.graphics.colorspace.ColorModel;
import androidx.ui.graphics.colorspace.ColorSpace;
import androidx.ui.graphics.colorspace.ColorSpaces;
import androidx.ui.graphics.colorspace.Connector;
import androidx.ui.graphics.colorspace.RenderIntent;
import androidx.ui.graphics.colorspace.Rgb;
import androidx.ui.graphics.colorspace.TransferParameters;
import androidx.ui.graphics.colorspace.WhitePoint;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a8\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a&\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\nH\u0001\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u0010H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\nH\u0000\u001a\u0012\u0010\u0012\u001a\u00020\n2\b\b\u0001\u0010\u0013\u001a\u00020\nH\u0001\u001a\u001c\u0010\u0014\u001a\u00020\n2\b\b\u0001\u0010\u0015\u001a\u00020\n2\b\b\u0001\u0010\u0016\u001a\u00020\nH\u0001\u001a\u001c\u0010\u0017\u001a\u00020\n2\b\b\u0001\u0010\u0015\u001a\u00020\n2\b\b\u0001\u0010\u0016\u001a\u00020\nH\u0001\u001a\u001c\u0010\u0018\u001a\u00020\n2\b\b\u0001\u0010\u0015\u001a\u00020\n2\b\b\u0001\u0010\u0016\u001a\u00020\nH\u0001\u001a8\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001aH\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a8\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001aH\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u001d\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\b\b\u0002\u0010 \u001a\u00020!H\u0007\u001a\u001e\u0010\"\u001a\u00020#*\u00020\u001e2\b\b\u0002\u0010$\u001a\u00020\u001e2\b\b\u0002\u0010%\u001a\u00020&\u00a8\u0006'"}, d2={"absRcpResponse", "", "x", "a", "b", "c", "d", "g", "absResponse", "chromaticAdaptation", "", "matrix", "srcWhitePoint", "dstWhitePoint", "compare", "", "Landroidx/ui/graphics/colorspace/TransferParameters;", "Landroidx/ui/graphics/colorspace/WhitePoint;", "inverse3x3", "m", "mul3x3", "lhs", "rhs", "mul3x3Diag", "mul3x3Float3", "rcpResponse", "e", "f", "response", "adapt", "Landroidx/ui/graphics/colorspace/ColorSpace;", "whitePoint", "adaptation", "Landroidx/ui/graphics/colorspace/Adaptation;", "connect", "Landroidx/ui/graphics/colorspace/Connector;", "destination", "intent", "Landroidx/ui/graphics/colorspace/RenderIntent;", "ui-graphics_release"})
public final class ColorSpaceKt {
    @NotNull
    public static final Connector connect(@NotNull ColorSpace $this$connect, @NotNull ColorSpace destination, @NotNull RenderIntent intent) {
        Intrinsics.checkNotNullParameter((Object)$this$connect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)((Object)intent), (String)"intent");
        if ($this$connect == destination) {
            return Connector.Companion.identity$ui_graphics_release($this$connect);
        }
        return $this$connect.getModel() == ColorModel.Rgb && destination.getModel() == ColorModel.Rgb ? (Connector)new Connector.RgbConnector((Rgb)$this$connect, (Rgb)destination, intent) : new Connector($this$connect, destination, intent);
    }

    public static /* synthetic */ Connector connect$default(ColorSpace $this$connect_u24default, ColorSpace destination, RenderIntent intent, int n, Object object) {
        if ((n & 1) != 0) {
            destination = ColorSpaces.INSTANCE.getSrgb();
        }
        if ((n & 2) != 0) {
            intent = RenderIntent.Perceptual;
        }
        return ColorSpaceKt.connect($this$connect_u24default, destination, intent);
    }

    @JvmOverloads
    @NotNull
    public static final ColorSpace adapt(@NotNull ColorSpace $this$adapt, @NotNull WhitePoint whitePoint, @NotNull Adaptation adaptation) {
        Intrinsics.checkNotNullParameter((Object)$this$adapt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)((Object)adaptation), (String)"adaptation");
        if (Intrinsics.areEqual((Object)((Object)$this$adapt.getModel()), (Object)((Object)ColorModel.Rgb))) {
            Rgb rgb = (Rgb)$this$adapt;
            if (ColorSpaceKt.compare(rgb.getWhitePoint(), whitePoint)) {
                return $this$adapt;
            }
            float[] xyz = whitePoint.toXyz$ui_graphics_release();
            float[] adaptationTransform = ColorSpaceKt.chromaticAdaptation(adaptation.getTransform$ui_graphics_release(), rgb.getWhitePoint().toXyz$ui_graphics_release(), xyz);
            float[] transform2 = ColorSpaceKt.mul3x3(adaptationTransform, rgb.getTransform$ui_graphics_release());
            return new Rgb(rgb, transform2, whitePoint);
        }
        return $this$adapt;
    }

    public static /* synthetic */ ColorSpace adapt$default(ColorSpace $this$adapt_u24default, WhitePoint whitePoint, Adaptation adaptation, int n, Object object) {
        if ((n & 2) != 0) {
            adaptation = Adaptation.Bradford;
        }
        return ColorSpaceKt.adapt($this$adapt_u24default, whitePoint, adaptation);
    }

    public static final double rcpResponse(double x, double a, double b, double c, double d, double g) {
        double d2;
        if (x >= d * c) {
            double d3 = x;
            double d4 = 1.0 / g;
            boolean bl = false;
            d2 = (Math.pow(d3, d4) - b) / a;
        } else {
            d2 = x / c;
        }
        return d2;
    }

    public static final double response(double x, double a, double b, double c, double d, double g) {
        double d2;
        if (x >= d) {
            double d3 = a * x + b;
            boolean bl = false;
            d2 = Math.pow(d3, g);
        } else {
            d2 = c * x;
        }
        return d2;
    }

    public static final double rcpResponse(double x, double a, double b, double c, double d, double e, double f, double g) {
        double d2;
        if (x >= d * c) {
            double d3 = x - e;
            double d4 = 1.0 / g;
            boolean bl = false;
            d2 = (Math.pow(d3, d4) - b) / a;
        } else {
            d2 = (x - f) / c;
        }
        return d2;
    }

    public static final double response(double x, double a, double b, double c, double d, double e, double f, double g) {
        double d2;
        if (x >= d) {
            double d3 = a * x + b;
            boolean bl = false;
            d2 = Math.pow(d3, g) + e;
        } else {
            d2 = c * x + f;
        }
        return d2;
    }

    public static final double absRcpResponse(double x, double a, double b, double c, double d, double g) {
        double d2 = ColorSpaceKt.rcpResponse(x < 0.0 ? -x : x, a, b, c, d, g);
        boolean bl = false;
        return Math.copySign(d2, x);
    }

    public static final double absResponse(double x, double a, double b, double c, double d, double g) {
        double d2 = ColorSpaceKt.response(x < 0.0 ? -x : x, a, b, c, d, g);
        boolean bl = false;
        return Math.copySign(d2, x);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean compare(@NotNull TransferParameters a, @Nullable TransferParameters b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (b == null) return false;
        double d = a.getA() - b.getA();
        boolean bl = false;
        if (!(Math.abs(d) < 0.001)) return false;
        d = a.getB() - b.getB();
        bl = false;
        if (!(Math.abs(d) < 0.001)) return false;
        d = a.getC() - b.getC();
        bl = false;
        if (!(Math.abs(d) < 0.001)) return false;
        d = a.getD() - b.getD();
        bl = false;
        if (!(Math.abs(d) < 0.002)) return false;
        d = a.getE() - b.getE();
        bl = false;
        if (!(Math.abs(d) < 0.001)) return false;
        d = a.getF() - b.getF();
        bl = false;
        if (!(Math.abs(d) < 0.001)) return false;
        d = a.getGamma() - b.getGamma();
        bl = false;
        if (!(Math.abs(d) < 0.001)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean compare(@NotNull WhitePoint a, @NotNull WhitePoint b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a == b) {
            return true;
        }
        float f = a.getX() - b.getX();
        boolean bl = false;
        if (!(Math.abs(f) < 0.001f)) return false;
        f = a.getY() - b.getY();
        bl = false;
        if (!(Math.abs(f) < 0.001f)) return false;
        return true;
    }

    public static final boolean compare(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a == b) {
            return true;
        }
        int n = 0;
        int n2 = a.length + -1;
        if (n <= n2) {
            do {
                int i;
                if (Float.compare(a[i = n++], b[i]) == 0) continue;
                float f = a[i] - b[i];
                boolean bl = false;
                if (!(Math.abs(f) > 0.001f)) continue;
                return false;
            } while (n <= n2);
        }
        return true;
    }

    @Size(value=9L)
    @NotNull
    public static final float[] inverse3x3(@Size(value=9L) @NotNull float[] m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        float a = m[0];
        float b = m[3];
        float c = m[6];
        float d = m[1];
        float e = m[4];
        float f = m[7];
        float g = m[2];
        float h = m[5];
        float i = m[8];
        float xA = e * i - f * h;
        float xB = f * g - d * i;
        float xC = d * h - e * g;
        float det = a * xA + b * xB + c * xC;
        float[] inverted = new float[m.length];
        inverted[0] = xA / det;
        inverted[1] = xB / det;
        inverted[2] = xC / det;
        inverted[3] = (c * h - b * i) / det;
        inverted[4] = (a * i - c * g) / det;
        inverted[5] = (b * g - a * h) / det;
        inverted[6] = (b * f - c * e) / det;
        inverted[7] = (c * d - a * f) / det;
        inverted[8] = (a * e - b * d) / det;
        return inverted;
    }

    @Size(value=9L)
    @NotNull
    public static final float[] mul3x3(@Size(value=9L) @NotNull float[] lhs, @Size(value=9L) @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float[] r = new float[]{lhs[0] * rhs[0] + lhs[3] * rhs[1] + lhs[6] * rhs[2], lhs[1] * rhs[0] + lhs[4] * rhs[1] + lhs[7] * rhs[2], lhs[2] * rhs[0] + lhs[5] * rhs[1] + lhs[8] * rhs[2], lhs[0] * rhs[3] + lhs[3] * rhs[4] + lhs[6] * rhs[5], lhs[1] * rhs[3] + lhs[4] * rhs[4] + lhs[7] * rhs[5], lhs[2] * rhs[3] + lhs[5] * rhs[4] + lhs[8] * rhs[5], lhs[0] * rhs[6] + lhs[3] * rhs[7] + lhs[6] * rhs[8], lhs[1] * rhs[6] + lhs[4] * rhs[7] + lhs[7] * rhs[8], lhs[2] * rhs[6] + lhs[5] * rhs[7] + lhs[8] * rhs[8]};
        return r;
    }

    @Size(min=3L)
    @NotNull
    public static final float[] mul3x3Float3(@Size(value=9L) @NotNull float[] lhs, @Size(min=3L) @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float r0 = rhs[0];
        float r1 = rhs[1];
        float r2 = rhs[2];
        rhs[0] = lhs[0] * r0 + lhs[3] * r1 + lhs[6] * r2;
        rhs[1] = lhs[1] * r0 + lhs[4] * r1 + lhs[7] * r2;
        rhs[2] = lhs[2] * r0 + lhs[5] * r1 + lhs[8] * r2;
        return rhs;
    }

    @Size(value=9L)
    @NotNull
    public static final float[] mul3x3Diag(@Size(value=3L) @NotNull float[] lhs, @Size(value=9L) @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        float[] fArray = new float[]{lhs[0] * rhs[0], lhs[1] * rhs[1], lhs[2] * rhs[2], lhs[0] * rhs[3], lhs[1] * rhs[4], lhs[2] * rhs[5], lhs[0] * rhs[6], lhs[1] * rhs[7], lhs[2] * rhs[8]};
        return fArray;
    }

    @Size(value=9L)
    @NotNull
    public static final float[] chromaticAdaptation(@Size(value=9L) @NotNull float[] matrix, @Size(value=3L) @NotNull float[] srcWhitePoint, @Size(value=3L) @NotNull float[] dstWhitePoint) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)srcWhitePoint, (String)"srcWhitePoint");
        Intrinsics.checkNotNullParameter((Object)dstWhitePoint, (String)"dstWhitePoint");
        float[] srcLMS = ColorSpaceKt.mul3x3Float3(matrix, srcWhitePoint);
        float[] dstLMS = ColorSpaceKt.mul3x3Float3(matrix, dstWhitePoint);
        float[] fArray = new float[]{dstLMS[0] / srcLMS[0], dstLMS[1] / srcLMS[1], dstLMS[2] / srcLMS[2]};
        float[] LMS = fArray;
        return ColorSpaceKt.mul3x3(ColorSpaceKt.inverse3x3(matrix), ColorSpaceKt.mul3x3Diag(LMS, matrix));
    }

    @JvmOverloads
    @NotNull
    public static final ColorSpace adapt(@NotNull ColorSpace $this$adapt, @NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$adapt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        return ColorSpaceKt.adapt$default($this$adapt, whitePoint, null, 2, null);
    }
}

