/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.layout;

import androidx.ui.core.AlignmentLine;
import androidx.ui.core.Constraints;
import androidx.ui.core.DensityScope;
import androidx.ui.core.IntPx;
import androidx.ui.core.IntPxPosition;
import androidx.ui.core.IntPxSize;
import androidx.ui.core.LayoutModifier;
import androidx.ui.core.Measurable;
import androidx.ui.core.Modifier;
import androidx.ui.layout.AspectRatioKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u001c\u0010\u0017\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u001c\u0010\u0019\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u001c\u0010\u001a\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J \u0010\u001b\u001a\u0004\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0016J\u0014\u0010\u001f\u001a\u00020 *\u00020\u00132\u0006\u0010!\u001a\u00020 H\u0016J\u0018\u0010\"\u001a\u0004\u0018\u00010\f*\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010\fH\u0016J$\u0010$\u001a\u00020%*\u00020\u00132\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u001c\u0010*\u001a\u00020(*\u00020\u00132\u0006\u0010!\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006+"}, d2={"Landroidx/ui/layout/AspectRatioModifier;", "Landroidx/ui/core/LayoutModifier;", "aspectRatio", "", "(F)V", "getAspectRatio", "()F", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "maxIntrinsicHeightOf", "Landroidx/ui/core/IntPx;", "Landroidx/ui/core/DensityScope;", "measurable", "Landroidx/ui/core/Measurable;", "width", "maxIntrinsicWidthOf", "height", "minIntrinsicHeightOf", "minIntrinsicWidthOf", "modifyAlignmentLine", "line", "Landroidx/ui/core/AlignmentLine;", "value", "modifyConstraints", "Landroidx/ui/core/Constraints;", "constraints", "modifyParentData", "parentData", "modifyPosition", "Landroidx/ui/core/IntPxPosition;", "childPosition", "childSize", "Landroidx/ui/core/IntPxSize;", "containerSize", "modifySize", "ui-layout_release"})
final class AspectRatioModifier
implements LayoutModifier {
    private final float aspectRatio;

    public AspectRatioModifier(float aspectRatio) {
        this.aspectRatio = aspectRatio;
        boolean bl = this.getAspectRatio() > 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Received aspect ratio value " + this.getAspectRatio() + " is expected to be positive non-zero.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final float getAspectRatio() {
        return this.aspectRatio;
    }

    @NotNull
    public Constraints modifyConstraints(@NotNull DensityScope $this$modifyConstraints, @NotNull Constraints constraints) {
        Constraints constraints2;
        Intrinsics.checkParameterIsNotNull((Object)$this$modifyConstraints, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        IntPxSize size = AspectRatioKt.access$findSizeWith$0(constraints, this.getAspectRatio());
        if (size != null) {
            IntPxSize this_$iv;
            IntPxSize intPxSize = size;
            Constraints.Companion companion = Constraints.Companion;
            long value$iv$iv = this_$iv.getValue();
            int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
            IntPx intPx = new IntPx($this$ipx$iv$iv);
            this_$iv = size;
            value$iv$iv = this_$iv.getValue();
            $this$ipx$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            IntPx intPx2 = new IntPx($this$ipx$iv$iv);
            constraints2 = companion.tightConstraints(intPx, intPx2);
        } else {
            constraints2 = constraints;
        }
        return constraints2;
    }

    @NotNull
    public IntPxSize modifySize(@NotNull DensityScope $this$modifySize, @NotNull Constraints constraints, @NotNull IntPxSize childSize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$modifySize, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)childSize, (String)"childSize");
        return childSize;
    }

    @NotNull
    public IntPx minIntrinsicWidthOf(@NotNull DensityScope $this$minIntrinsicWidthOf, @NotNull Measurable measurable, @NotNull IntPx height) {
        Intrinsics.checkParameterIsNotNull((Object)$this$minIntrinsicWidthOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)height, (String)"height");
        return Intrinsics.areEqual((Object)height, (Object)IntPx.Companion.getInfinity()) ? measurable.minIntrinsicWidth(height) : height.times(this.getAspectRatio());
    }

    @NotNull
    public IntPx maxIntrinsicWidthOf(@NotNull DensityScope $this$maxIntrinsicWidthOf, @NotNull Measurable measurable, @NotNull IntPx height) {
        Intrinsics.checkParameterIsNotNull((Object)$this$maxIntrinsicWidthOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)height, (String)"height");
        return Intrinsics.areEqual((Object)height, (Object)IntPx.Companion.getInfinity()) ? measurable.maxIntrinsicWidth(height) : height.times(this.getAspectRatio());
    }

    @NotNull
    public IntPx minIntrinsicHeightOf(@NotNull DensityScope $this$minIntrinsicHeightOf, @NotNull Measurable measurable, @NotNull IntPx width) {
        Intrinsics.checkParameterIsNotNull((Object)$this$minIntrinsicHeightOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)width, (String)"width");
        return Intrinsics.areEqual((Object)width, (Object)IntPx.Companion.getInfinity()) ? measurable.minIntrinsicHeight(width) : width.div(this.getAspectRatio());
    }

    @NotNull
    public IntPx maxIntrinsicHeightOf(@NotNull DensityScope $this$maxIntrinsicHeightOf, @NotNull Measurable measurable, @NotNull IntPx width) {
        Intrinsics.checkParameterIsNotNull((Object)$this$maxIntrinsicHeightOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)width, (String)"width");
        return Intrinsics.areEqual((Object)width, (Object)IntPx.Companion.getInfinity()) ? measurable.maxIntrinsicHeight(width) : width.div(this.getAspectRatio());
    }

    @NotNull
    public IntPxPosition modifyPosition(@NotNull DensityScope $this$modifyPosition, @NotNull IntPxPosition childPosition, @NotNull IntPxSize childSize, @NotNull IntPxSize containerSize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$modifyPosition, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)childPosition, (String)"childPosition");
        Intrinsics.checkParameterIsNotNull((Object)childSize, (String)"childSize");
        Intrinsics.checkParameterIsNotNull((Object)containerSize, (String)"containerSize");
        return childPosition;
    }

    @Nullable
    public IntPx modifyAlignmentLine(@NotNull DensityScope $this$modifyAlignmentLine, @NotNull AlignmentLine line, @Nullable IntPx value) {
        Intrinsics.checkParameterIsNotNull((Object)$this$modifyAlignmentLine, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        return value;
    }

    @Nullable
    public Object modifyParentData(@NotNull DensityScope $this$modifyParentData, @Nullable Object parentData) {
        Intrinsics.checkParameterIsNotNull((Object)$this$modifyParentData, (String)"<this>");
        return parentData;
    }

    public final float component1() {
        return this.aspectRatio;
    }

    @NotNull
    public final AspectRatioModifier copy(float aspectRatio) {
        return new AspectRatioModifier(aspectRatio);
    }

    public static /* synthetic */ AspectRatioModifier copy$default(@NotNull AspectRatioModifier this_, float aspectRatio, int $mask0, @Nullable Object $handler) {
        float f = ($mask0 & 1) != 0 ? this_.aspectRatio : aspectRatio;
        return this_.copy(f);
    }

    @NotNull
    public String toString() {
        return "AspectRatioModifier(aspectRatio=" + this.aspectRatio + ")";
    }

    public int hashCode() {
        return Float.hashCode(this.aspectRatio);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AspectRatioModifier)) {
            return false;
        }
        Object object = other;
        AspectRatioModifier aspectRatioModifier = (AspectRatioModifier)object;
        return Intrinsics.areEqual((Object)Float.valueOf(this.aspectRatio), (Object)Float.valueOf(aspectRatioModifier.aspectRatio));
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    @NotNull
    public Modifier wraps(@NotNull Modifier other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Modifier.DefaultImpls.wraps((Modifier)this, (Modifier)other);
    }
}

