/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.layout;

import androidx.annotation.FloatRange;
import androidx.ui.core.AlignmentLine;
import androidx.ui.core.Constraints;
import androidx.ui.core.LayoutDirection;
import androidx.ui.core.LayoutModifier;
import androidx.ui.core.Measurable;
import androidx.ui.core.Modifier;
import androidx.ui.layout.AspectRatioKt;
import androidx.ui.unit.Density;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxPosition;
import androidx.ui.unit.IntPxSize;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\n\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003J\t\u0010\u0006\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J$\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u001a\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u001b\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u001c\u001a\u00020\u001d*\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001f"}, d2={"Landroidx/ui/layout/LayoutAspectRatio;", "Landroidx/ui/core/LayoutModifier;", "aspectRatio", "", "getAspectRatio", "()F", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "maxIntrinsicHeightOf", "Landroidx/ui/unit/IntPx;", "Landroidx/ui/unit/Density;", "measurable", "Landroidx/ui/core/Measurable;", "width", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "maxIntrinsicWidthOf", "height", "minIntrinsicHeightOf", "minIntrinsicWidthOf", "modifyConstraints", "Landroidx/ui/core/Constraints;", "constraints", "ui-layout_release"})
public final class LayoutAspectRatio
implements LayoutModifier {
    private final float aspectRatio;

    public LayoutAspectRatio(@FloatRange(from=0.0, fromInclusive=false) float aspectRatio) {
        this.aspectRatio = aspectRatio;
        boolean bl = this.getAspectRatio() > 0.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "aspectRatio " + this.getAspectRatio() + " must be > 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final float getAspectRatio() {
        return this.aspectRatio;
    }

    @NotNull
    public Constraints modifyConstraints(@NotNull Density $this$modifyConstraints, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection) {
        Constraints constraints2;
        Intrinsics.checkParameterIsNotNull((Object)$this$modifyConstraints, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        IntPxSize size = AspectRatioKt.access$findSizeWith$0(constraints, this.getAspectRatio());
        if (size != null) {
            IntPxSize this_$iv;
            IntPxSize intPxSize = size;
            Constraints.Companion companion = Constraints.Companion;
            long value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackInt1 = false;
            int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
            IntPx intPx = new IntPx($this$ipx$iv$iv);
            this_$iv = size;
            value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackInt2 = false;
            $this$ipx$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            IntPx intPx2 = new IntPx($this$ipx$iv$iv);
            constraints2 = companion.fixed(intPx, intPx2);
        } else {
            constraints2 = constraints;
        }
        return constraints2;
    }

    @NotNull
    public IntPx minIntrinsicWidthOf(@NotNull Density $this$minIntrinsicWidthOf, @NotNull Measurable measurable, @NotNull IntPx height, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)$this$minIntrinsicWidthOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)height, (String)"height");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        return Intrinsics.areEqual((Object)height, (Object)IntPx.Companion.getInfinity()) ? measurable.minIntrinsicWidth(height) : height.times(this.getAspectRatio());
    }

    @NotNull
    public IntPx maxIntrinsicWidthOf(@NotNull Density $this$maxIntrinsicWidthOf, @NotNull Measurable measurable, @NotNull IntPx height, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)$this$maxIntrinsicWidthOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)height, (String)"height");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        return Intrinsics.areEqual((Object)height, (Object)IntPx.Companion.getInfinity()) ? measurable.maxIntrinsicWidth(height) : height.times(this.getAspectRatio());
    }

    @NotNull
    public IntPx minIntrinsicHeightOf(@NotNull Density $this$minIntrinsicHeightOf, @NotNull Measurable measurable, @NotNull IntPx width, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)$this$minIntrinsicHeightOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)width, (String)"width");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        return Intrinsics.areEqual((Object)width, (Object)IntPx.Companion.getInfinity()) ? measurable.minIntrinsicHeight(width) : width.div(this.getAspectRatio());
    }

    @NotNull
    public IntPx maxIntrinsicHeightOf(@NotNull Density $this$maxIntrinsicHeightOf, @NotNull Measurable measurable, @NotNull IntPx width, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)$this$maxIntrinsicHeightOf, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)measurable, (String)"measurable");
        Intrinsics.checkParameterIsNotNull((Object)width, (String)"width");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        return Intrinsics.areEqual((Object)width, (Object)IntPx.Companion.getInfinity()) ? measurable.maxIntrinsicHeight(width) : width.div(this.getAspectRatio());
    }

    public final float component1() {
        return this.aspectRatio;
    }

    @NotNull
    public final LayoutAspectRatio copy(@FloatRange(from=0.0, fromInclusive=false) float aspectRatio) {
        return new LayoutAspectRatio(aspectRatio);
    }

    public static /* synthetic */ LayoutAspectRatio copy$default(@NotNull LayoutAspectRatio this_, @FloatRange(from=0.0, fromInclusive=false) float aspectRatio, int $mask0, @Nullable Object $handler) {
        float f = ($mask0 & 1) != 0 ? this_.aspectRatio : aspectRatio;
        return this_.copy(f);
    }

    @NotNull
    public String toString() {
        return "LayoutAspectRatio(aspectRatio=" + this.aspectRatio + ")";
    }

    public int hashCode() {
        return Float.hashCode(this.aspectRatio);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayoutAspectRatio)) {
            return false;
        }
        Object object = other;
        LayoutAspectRatio layoutAspectRatio = (LayoutAspectRatio)object;
        return Intrinsics.areEqual((Object)Float.valueOf(this.aspectRatio), (Object)Float.valueOf(layoutAspectRatio.aspectRatio));
    }

    @Deprecated(message="use + instead", replaceWith=@ReplaceWith(expression="this + other", imports={}))
    @NotNull
    public Modifier wraps(@NotNull Modifier other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Modifier.DefaultImpls.wraps((Modifier)this, (Modifier)other);
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    @Nullable
    public IntPx modifyAlignmentLine(@NotNull Density $this$modifyAlignmentLine, @NotNull AlignmentLine line, @Nullable IntPx value, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)$this$modifyAlignmentLine, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        return LayoutModifier.DefaultImpls.modifyAlignmentLine((LayoutModifier)this, (Density)$this$modifyAlignmentLine, (AlignmentLine)line, (IntPx)value, (LayoutDirection)layoutDirection);
    }

    @NotNull
    public LayoutDirection modifyLayoutDirection(@NotNull Density $this$modifyLayoutDirection, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)$this$modifyLayoutDirection, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        return LayoutModifier.DefaultImpls.modifyLayoutDirection((LayoutModifier)this, (Density)$this$modifyLayoutDirection, (LayoutDirection)layoutDirection);
    }

    @NotNull
    public IntPxPosition modifyPosition(@NotNull Density $this$modifyPosition, @NotNull IntPxSize childSize, @NotNull IntPxSize containerSize, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkParameterIsNotNull((Object)$this$modifyPosition, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)childSize, (String)"childSize");
        Intrinsics.checkParameterIsNotNull((Object)containerSize, (String)"containerSize");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        return LayoutModifier.DefaultImpls.modifyPosition((LayoutModifier)this, (Density)$this$modifyPosition, (IntPxSize)childSize, (IntPxSize)containerSize, (LayoutDirection)layoutDirection);
    }

    @NotNull
    public IntPxSize modifySize(@NotNull Density $this$modifySize, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @NotNull IntPxSize childSize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$modifySize, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkParameterIsNotNull((Object)childSize, (String)"childSize");
        return LayoutModifier.DefaultImpls.modifySize((LayoutModifier)this, (Density)$this$modifySize, (Constraints)constraints, (LayoutDirection)layoutDirection, (IntPxSize)childSize);
    }

    @NotNull
    public Modifier plus(@NotNull Modifier other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Modifier.DefaultImpls.plus((Modifier)this, (Modifier)other);
    }
}

