/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.layout;

import androidx.annotation.FloatRange;
import androidx.ui.core.Alignment;
import androidx.ui.core.AlignmentLine;
import androidx.ui.core.Measured;
import androidx.ui.core.Modifier;
import androidx.ui.core.VerticalAlignmentLine;
import androidx.ui.layout.ColumnAlign;
import androidx.ui.layout.GravityModifier;
import androidx.ui.layout.LayoutScopeMarker;
import androidx.ui.layout.LayoutWeightImpl;
import androidx.ui.layout.SiblingsAlignedModifier;
import androidx.ui.unit.IntPx;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@LayoutScopeMarker
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0002\b\u0002J!\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00f8\u0001\u0000J\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\n\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\rH\u0007J\u001e\u0010\u000e\u001a\u00020\u0003*\u00020\u00032\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Landroidx/ui/layout/ColumnScope;", "", "alignWithSiblings", "Landroidx/ui/core/Modifier;", "alignmentLineBlock", "Lkotlin/Function1;", "Landroidx/ui/core/Measured;", "Landroidx/ui/unit/IntPx;", "alignmentLine", "Landroidx/ui/core/VerticalAlignmentLine;", "gravity", "align", "Landroidx/ui/core/Alignment$Horizontal;", "Landroidx/ui/layout/ColumnAlign;", "weight", "", "fill", "", "ui-layout_release"})
public final class ColumnScope {
    @NotNull
    public static final ColumnScope INSTANCE = new ColumnScope();

    private ColumnScope() {
    }

    @NotNull
    public final Modifier gravity(@NotNull Modifier $this$gravity, @NotNull Alignment.Horizontal align) {
        Intrinsics.checkNotNullParameter((Object)$this$gravity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)align, (String)"align");
        return $this$gravity.plus((Modifier)new GravityModifier(align));
    }

    @Deprecated(message="gravity(ColumnAlign) is deprecated. Please use gravity instead.", replaceWith=@ReplaceWith(expression="gravity(align)", imports={}))
    @NotNull
    public final Modifier gravity(@NotNull Modifier $this$gravity, @NotNull ColumnAlign align) {
        GravityModifier gravityModifier;
        Intrinsics.checkNotNullParameter((Object)$this$gravity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        ColumnAlign columnAlign = align;
        int n = WhenMappings.$EnumSwitchMapping$0[columnAlign.ordinal()];
        switch (n) {
            case 1: {
                gravityModifier = new GravityModifier(Alignment.Companion.getStart());
                break;
            }
            case 2: {
                gravityModifier = new GravityModifier(Alignment.Companion.getCenterHorizontally());
                break;
            }
            case 3: {
                gravityModifier = new GravityModifier(Alignment.Companion.getEnd());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return $this$gravity.plus((Modifier)gravityModifier);
    }

    @NotNull
    public final Modifier alignWithSiblings(@NotNull Modifier $this$alignWithSiblings, @NotNull VerticalAlignmentLine alignmentLine) {
        Intrinsics.checkNotNullParameter((Object)$this$alignWithSiblings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alignmentLine, (String)"alignmentLine");
        return $this$alignWithSiblings.plus((Modifier)new SiblingsAlignedModifier.WithAlignmentLine((AlignmentLine)alignmentLine));
    }

    @NotNull
    public final Modifier weight(@NotNull Modifier $this$weight, @FloatRange(from=0.0, fromInclusive=false) float weight, boolean fill) {
        Intrinsics.checkNotNullParameter((Object)$this$weight, (String)"<this>");
        boolean bl = (double)weight > 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "invalid weight " + weight + "; must be greater than zero";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return $this$weight.plus((Modifier)new LayoutWeightImpl(weight, fill));
    }

    public static /* synthetic */ Modifier weight$default(ColumnScope this_, Modifier receiver, float weight, boolean fill, int n, Object object) {
        if ((n & 2) != 0) {
            fill = true;
        }
        return this_.weight(receiver, weight, fill);
    }

    @NotNull
    public final Modifier alignWithSiblings(@NotNull Modifier $this$alignWithSiblings, @NotNull Function1<? super Measured, IntPx> alignmentLineBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$alignWithSiblings, (String)"<this>");
        Intrinsics.checkNotNullParameter(alignmentLineBlock, (String)"alignmentLineBlock");
        return $this$alignWithSiblings.plus((Modifier)new SiblingsAlignedModifier.WithAlignmentLineBlock(alignmentLineBlock));
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColumnAlign.values().length];
            nArray[ColumnAlign.Start.ordinal()] = 1;
            nArray[ColumnAlign.Center.ordinal()] = 2;
            nArray[ColumnAlign.End.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

