/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material;

import androidx.ui.foundation.ScrollerPosition;
import androidx.ui.material.TabRow;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.Px;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0005H\u0002R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Landroidx/ui/material/ScrollableTabData;", "", "position", "Landroidx/ui/foundation/ScrollerPosition;", "initialSelectedTab", "", "tabPositions", "", "Landroidx/ui/material/TabRow$TabPosition;", "visibleWidth", "Landroidx/ui/unit/IntPx;", "edgeOffset", "(Landroidx/ui/foundation/ScrollerPosition;ILjava/util/List;Landroidx/ui/unit/IntPx;Landroidx/ui/unit/IntPx;)V", "getEdgeOffset", "()Landroidx/ui/unit/IntPx;", "getPosition", "()Landroidx/ui/foundation/ScrollerPosition;", "value", "selectedTab", "getSelectedTab", "()I", "setSelectedTab", "(I)V", "getTabPositions", "()Ljava/util/List;", "setTabPositions", "(Ljava/util/List;)V", "getVisibleWidth", "setVisibleWidth", "(Landroidx/ui/unit/IntPx;)V", "calculateTabOffset", "Landroidx/ui/unit/Px;", "index", "isTabFullyVisible", "", "ui-material_release"})
final class ScrollableTabData {
    private final ScrollerPosition position;
    private List<TabRow.TabPosition> tabPositions;
    private IntPx visibleWidth;
    private final IntPx edgeOffset;
    private int selectedTab;

    public ScrollableTabData(@NotNull ScrollerPosition position, int initialSelectedTab, @NotNull List<TabRow.TabPosition> tabPositions2, @NotNull IntPx visibleWidth, @NotNull IntPx edgeOffset) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull(tabPositions2, (String)"tabPositions");
        Intrinsics.checkParameterIsNotNull((Object)visibleWidth, (String)"visibleWidth");
        Intrinsics.checkParameterIsNotNull((Object)edgeOffset, (String)"edgeOffset");
        this.position = position;
        this.tabPositions = tabPositions2;
        this.visibleWidth = visibleWidth;
        this.edgeOffset = edgeOffset;
        this.selectedTab = initialSelectedTab;
    }

    @NotNull
    public final ScrollerPosition getPosition() {
        return this.position;
    }

    @NotNull
    public final List<TabRow.TabPosition> getTabPositions() {
        return this.tabPositions;
    }

    public final void setTabPositions(@NotNull List<TabRow.TabPosition> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.tabPositions = list;
    }

    @NotNull
    public final IntPx getVisibleWidth() {
        return this.visibleWidth;
    }

    public final void setVisibleWidth(@NotNull IntPx intPx) {
        Intrinsics.checkParameterIsNotNull((Object)intPx, (String)"<set-?>");
        this.visibleWidth = intPx;
    }

    @NotNull
    public final IntPx getEdgeOffset() {
        return this.edgeOffset;
    }

    public final int getSelectedTab() {
        return this.selectedTab;
    }

    public final void setSelectedTab(int value) {
        if (this.selectedTab != value && !this.isTabFullyVisible(value)) {
            Px calculatedOffset = this.calculateTabOffset(value);
            ScrollerPosition.smoothScrollTo$default((ScrollerPosition)this.getPosition(), (float)calculatedOffset.getValue(), (Function2)null, (int)2, null);
        }
        this.selectedTab = value;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isTabFullyVisible(int index) {
        void $this$toPx$iv;
        void this_$iv;
        void $this$toPx$iv2;
        TabRow.TabPosition tabPosition = this.getTabPositions().get(index);
        float $this$px$iv = this.getPosition().getValue();
        Px leftEdgeStart = new Px($this$px$iv);
        IntPx intPx = tabPosition.getLeft();
        Px px = leftEdgeStart;
        int $this$px$iv$iv22 = $this$toPx$iv2.getValue();
        Px px2 = new Px((float)$this$px$iv$iv22);
        boolean leftEdgeVisible = px.compareTo(px2) <= 0;
        Px $this$px$iv$iv22 = leftEdgeStart;
        IntPx other$iv = this.getVisibleWidth();
        Px rightEdgeEnd = new Px(this_$iv.getValue() + (float)other$iv.getValue());
        other$iv = tabPosition.getRight();
        px = rightEdgeEnd;
        int $this$px$iv$iv = $this$toPx$iv.getValue();
        px2 = new Px((float)$this$px$iv$iv);
        boolean rightEdgeVisible = px.compareTo(px2) >= 0;
        return leftEdgeVisible && rightEdgeVisible;
    }

    private final Px calculateTabOffset(int index) {
        TabRow.TabPosition tabPosition = this.getTabPositions().get(index);
        IntPx tabOffset = tabPosition.getLeft();
        IntPx scrollerCenter = this.getVisibleWidth().div(2);
        IntPx tabWidth = tabPosition.getWidth();
        IntPx centeredTabOffset = tabOffset.minus(scrollerCenter.minus(tabWidth.div(2)));
        IntPx totalTabRowWidth = ((TabRow.TabPosition)CollectionsKt.last(this.getTabPositions())).getRight().plus(this.getEdgeOffset());
        IntPx $this$toPx$iv = (IntPx)RangesKt.coerceIn((Comparable)((Comparable)centeredTabOffset), (Comparable)((Comparable)IntPx.Companion.getZero()), (Comparable)((Comparable)totalTabRowWidth.minus(this.getVisibleWidth())));
        int $this$px$iv$iv = $this$toPx$iv.getValue();
        return new Px((float)$this$px$iv$iv);
    }
}

