/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material;

import androidx.animation.AnimationClockObservable;
import androidx.animation.DefaultAnimationClock;
import androidx.annotation.IntRange;
import androidx.ui.animation.AnimatedFloatModel;
import androidx.ui.material.SliderKt;
import androidx.ui.util.MathHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001d\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b'R*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR$\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010 R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Landroidx/ui/material/SliderPosition;", "", "initial", "", "valueRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "steps", "", "animatedClock", "Landroidx/animation/AnimationClockObservable;", "(FLkotlin/ranges/ClosedFloatingPointRange;ILandroidx/animation/AnimationClockObservable;)V", "<set-?>", "", "anchorsPx", "getAnchorsPx$ui_material_release", "()Ljava/util/List;", "endPx", "endValue", "getEndValue$ui_material_release", "()F", "holder", "Landroidx/ui/animation/AnimatedFloatModel;", "getHolder$ui_material_release", "()Landroidx/ui/animation/AnimatedFloatModel;", "startPx", "startValue", "getStartValue$ui_material_release", "tickFractions", "getTickFractions$ui_material_release", "value", "getValue", "setValue", "(F)V", "getValueRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "setBounds", "", "min", "max", "setBounds$ui_material_release", "ui-material_release"})
public final class SliderPosition {
    private final ClosedFloatingPointRange<Float> valueRange;
    private final float startValue;
    private final float endValue;
    private float endPx;
    private float startPx;
    private final AnimatedFloatModel holder;
    private final List<Float> tickFractions;
    private List<Float> anchorsPx;

    /*
     * WARNING - void declaration
     */
    public SliderPosition(float initial, @NotNull ClosedFloatingPointRange<Float> valueRange, @IntRange(from=0L) int steps, @NotNull AnimationClockObservable animatedClock) {
        List list;
        Intrinsics.checkParameterIsNotNull(valueRange, (String)"valueRange");
        Intrinsics.checkParameterIsNotNull((Object)animatedClock, (String)"animatedClock");
        this.valueRange = valueRange;
        this.startValue = ((Number)((Object)this.getValueRange().getStart())).floatValue();
        this.endValue = ((Number)((Object)this.getValueRange().getEndInclusive())).floatValue();
        int n = steps >= 0 ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            String string = "steps should be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.endPx = FloatCompanionObject.INSTANCE.getMAX_VALUE();
        this.startPx = FloatCompanionObject.INSTANCE.getMIN_VALUE();
        this.holder = new AnimatedFloatModel(SliderKt.access$scale$0(this.getStartValue$ui_material_release(), this.getEndValue$ui_material_release(), initial, this.startPx, this.endPx), animatedClock);
        SliderPosition sliderPosition = this;
        if (steps == 0) {
            list = CollectionsKt.emptyList();
        } else {
            ArrayList<Float> arrayList;
            n = steps + 2;
            SliderPosition sliderPosition2 = sliderPosition;
            bl = false;
            bl2 = false;
            ArrayList<Float> arrayList2 = new ArrayList<Float>(n);
            boolean bl3 = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                void it;
                int n4 = n2++;
                boolean bl4 = false;
                int n5 = n4;
                arrayList = arrayList2;
                Float f = Float.valueOf((float)it / (float)(steps + 1));
                arrayList.add(f);
            }
            arrayList = arrayList2;
            sliderPosition = sliderPosition2;
            list = arrayList;
        }
        sliderPosition.tickFractions = list;
        this.anchorsPx = CollectionsKt.emptyList();
    }

    public /* synthetic */ SliderPosition(float initial, ClosedFloatingPointRange valueRange, int steps, AnimationClockObservable animatedClock, int $mask0, DefaultConstructorMarker $marker) {
        float f = ($mask0 & 1) != 0 ? 0.0f : initial;
        ClosedFloatingPointRange closedFloatingPointRange = ($mask0 & 2) != 0 ? RangesKt.rangeTo((float)0.0f, (float)1.0f) : valueRange;
        int n = ($mask0 & 4) != 0 ? 0 : steps;
        AnimationClockObservable animationClockObservable = ($mask0 & 8) != 0 ? (AnimationClockObservable)new DefaultAnimationClock() : animatedClock;
        this(f, (ClosedFloatingPointRange<Float>)closedFloatingPointRange, n, animationClockObservable);
    }

    @NotNull
    public final ClosedFloatingPointRange<Float> getValueRange() {
        return this.valueRange;
    }

    public final float getStartValue$ui_material_release() {
        return this.startValue;
    }

    public final float getEndValue$ui_material_release() {
        return this.endValue;
    }

    public final float getValue() {
        return SliderKt.access$scale$0(this.startPx, this.endPx, this.getHolder$ui_material_release().getValue().floatValue(), this.getStartValue$ui_material_release(), this.getEndValue$ui_material_release());
    }

    public final void setValue(float value) {
        this.getHolder$ui_material_release().snapTo(SliderKt.access$scale$0(this.getStartValue$ui_material_release(), this.getEndValue$ui_material_release(), value, this.startPx, this.endPx));
    }

    /*
     * WARNING - void declaration
     */
    public final void setBounds$ui_material_release(float min, float max) {
        Collection<Float> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.startPx == min && this.endPx == max) {
            return;
        }
        float newValue = SliderKt.access$scale$0(this.startPx, this.endPx, this.getHolder$ui_material_release().getValue().floatValue(), min, max);
        this.startPx = min;
        this.endPx = max;
        this.getHolder$ui_material_release().setBounds(min, max);
        Iterable iterable = this.getTickFractions$ui_material_release();
        SliderPosition sliderPosition = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            collection = destination$iv$iv;
            Float f2 = Float.valueOf(MathHelpersKt.lerp((float)this.startPx, (float)this.endPx, (float)it));
            collection.add(f2);
        }
        collection = (List)destination$iv$iv;
        sliderPosition.anchorsPx = collection;
        this.getHolder$ui_material_release().snapTo(newValue);
    }

    @NotNull
    public final AnimatedFloatModel getHolder$ui_material_release() {
        return this.holder;
    }

    @NotNull
    public final List<Float> getTickFractions$ui_material_release() {
        return this.tickFractions;
    }

    @NotNull
    public final List<Float> getAnchorsPx$ui_material_release() {
        return this.anchorsPx;
    }

    public SliderPosition() {
        this(0.0f, null, 0, null, 15, null);
    }
}

