/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material.ripple;

import androidx.animation.AnimationClockObservable;
import androidx.animation.PropKey;
import androidx.animation.TransitionAnimation;
import androidx.animation.TransitionDefinitionKt;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.ClipOp;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Paint;
import androidx.ui.material.ripple.DefaultRippleEffectKt;
import androidx.ui.material.ripple.RippleEffect;
import androidx.ui.material.ripple.RippleTransition;
import androidx.ui.unit.Density;
import androidx.ui.unit.Dp;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxPosition;
import androidx.ui.unit.PxSize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000bH\u0016R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/ui/material/ripple/DefaultRippleEffect;", "Landroidx/ui/material/ripple/RippleEffect;", "coordinates", "Landroidx/ui/core/LayoutCoordinates;", "startPosition", "Landroidx/ui/unit/PxPosition;", "density", "Landroidx/ui/unit/Density;", "radius", "Landroidx/ui/unit/Dp;", "clipped", "", "clock", "Landroidx/animation/AnimationClockObservable;", "requestRedraw", "Lkotlin/Function0;", "", "onAnimationFinished", "Lkotlin/Function1;", "(Landroidx/ui/core/LayoutCoordinates;Landroidx/ui/unit/PxPosition;Landroidx/ui/unit/Density;Landroidx/ui/unit/Dp;ZLandroidx/animation/AnimationClockObservable;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "animation", "Landroidx/animation/TransitionAnimation;", "Landroidx/ui/material/ripple/RippleTransition$State;", "finishRequested", "paint", "Landroidx/ui/graphics/Paint;", "transitionState", "dispose", "draw", "canvas", "Landroidx/ui/graphics/Canvas;", "color", "Landroidx/ui/graphics/Color;", "finish", "canceled", "ui-material_release"})
final class DefaultRippleEffect
implements RippleEffect {
    private final LayoutCoordinates coordinates;
    private final boolean clipped;
    private final Function0<Unit> requestRedraw;
    private final Function1<RippleEffect, Unit> onAnimationFinished;
    private final TransitionAnimation<RippleTransition.State> animation;
    private RippleTransition.State transitionState;
    private boolean finishRequested;
    private final Paint paint;

    /*
     * WARNING - void declaration
     */
    public DefaultRippleEffect(@NotNull LayoutCoordinates coordinates, @NotNull PxPosition startPosition, @NotNull Density density, @Nullable Dp radius, boolean clipped, @NotNull AnimationClockObservable clock, @NotNull Function0<Unit> requestRedraw, @NotNull Function1<? super RippleEffect, Unit> onAnimationFinished2) {
        long l;
        void val1$iv$iv$iv$iv;
        void height$iv$iv$iv;
        void width$iv$iv$iv;
        void height$iv$iv;
        void width$iv$iv;
        IntPxSize $this$toPxSize$iv;
        long l2;
        void val1$iv$iv$iv$iv22;
        void height$iv$iv$iv2;
        void width$iv$iv$iv2;
        void height$iv$iv2;
        void width$iv$iv2;
        IntPxSize $this$toPxSize$iv2;
        Intrinsics.checkParameterIsNotNull((Object)coordinates, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull((Object)startPosition, (String)"startPosition");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull(requestRedraw, (String)"requestRedraw");
        Intrinsics.checkParameterIsNotNull(onAnimationFinished2, (String)"onAnimationFinished");
        this.coordinates = coordinates;
        this.clipped = clipped;
        this.requestRedraw = requestRedraw;
        this.onAnimationFinished = onAnimationFinished2;
        this.transitionState = RippleTransition.State.Initial;
        this.paint = new Paint();
        IntPxSize this_$iv$iv = $this$toPxSize$iv2 = this.coordinates.getSize();
        long value$iv$iv$iv22 = this_$iv$iv.getValue();
        boolean $i$f$unpackInt1 = false;
        int $this$ipx$iv$iv$iv = (int)(value$iv$iv$iv22 >> 32);
        this_$iv$iv = new IntPx($this$ipx$iv$iv$iv);
        IntPxSize this_$iv$iv2 = $this$toPxSize$iv2;
        long value$iv$iv$iv = this_$iv$iv2.getValue();
        boolean $i$f$unpackInt2 = false;
        int $this$ipx$iv$iv$iv2 = (int)(value$iv$iv$iv & 0xFFFFFFFFL);
        this_$iv$iv2 = new IntPx($this$ipx$iv$iv$iv2);
        Px $this$toPx$iv$iv$iv = width$iv$iv2;
        int $this$px$iv$iv$iv$iv = $this$toPx$iv$iv$iv.getValue();
        $this$toPx$iv$iv$iv = new Px((float)$this$px$iv$iv$iv$iv);
        Px $this$toPx$iv$iv$iv2 = height$iv$iv2;
        int $this$px$iv$iv$iv$iv22 = $this$toPx$iv$iv$iv2.getValue();
        $this$toPx$iv$iv$iv2 = new Px((float)$this$px$iv$iv$iv$iv22);
        float $this$px$iv$iv$iv$iv22 = width$iv$iv$iv2.getValue();
        float val2$iv$iv$iv$iv = height$iv$iv$iv2.getValue();
        boolean $i$f$packFloats = false;
        void var22_30 = val1$iv$iv$iv$iv22;
        boolean bl = false;
        long v1$iv$iv$iv$iv = Float.floatToIntBits((float)var22_30);
        float f = val2$iv$iv$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv$iv$iv = Float.floatToIntBits(f);
        long l3 = l2 = v1$iv$iv$iv$iv << 32 | v2$iv$iv$iv$iv & 0xFFFFFFFFL;
        PxSize surfaceSize = new PxSize(l3);
        Px startRadius = DefaultRippleEffectKt.getRippleStartRadius(surfaceSize);
        boolean value$iv$iv$iv22 = false;
        boolean bl3 = false;
        Density $this$lambda_u2d0 = density;
        Dp val1$iv$iv$iv$iv22 = radius;
        Px px = val1$iv$iv$iv$iv22 == null ? (Px)null : $this$lambda_u2d0.toPx(val1$iv$iv$iv$iv22);
        Px targetRadius = px == null ? DefaultRippleEffectKt.getRippleTargetRadius($this$lambda_u2d0, surfaceSize) : px;
        IntPxSize this_$iv$iv3 = $this$toPxSize$iv = this.coordinates.getSize();
        long value$iv$iv$iv3 = this_$iv$iv3.getValue();
        boolean $i$f$unpackInt12 = false;
        int $this$ipx$iv$iv$iv3 = (int)(value$iv$iv$iv3 >> 32);
        this_$iv$iv3 = new IntPx($this$ipx$iv$iv$iv3);
        IntPxSize this_$iv$iv4 = $this$toPxSize$iv;
        long value$iv$iv$iv4 = this_$iv$iv4.getValue();
        boolean $i$f$unpackInt22 = false;
        int $this$ipx$iv$iv$iv4 = (int)(value$iv$iv$iv4 & 0xFFFFFFFFL);
        this_$iv$iv4 = new IntPx($this$ipx$iv$iv$iv4);
        Px $this$toPx$iv$iv$iv3 = width$iv$iv;
        int $this$px$iv$iv$iv$iv3 = $this$toPx$iv$iv$iv3.getValue();
        $this$toPx$iv$iv$iv3 = new Px((float)$this$px$iv$iv$iv$iv3);
        Px $this$toPx$iv$iv$iv4 = height$iv$iv;
        int $this$px$iv$iv$iv$iv322 = $this$toPx$iv$iv$iv4.getValue();
        $this$toPx$iv$iv$iv4 = new Px((float)$this$px$iv$iv$iv$iv322);
        float $this$px$iv$iv$iv$iv322 = width$iv$iv$iv.getValue();
        float val2$iv$iv$iv$iv2 = height$iv$iv$iv.getValue();
        boolean $i$f$packFloats2 = false;
        void var25_50 = val1$iv$iv$iv$iv;
        boolean bl4 = false;
        long v1$iv$iv$iv$iv2 = Float.floatToIntBits((float)var25_50);
        float f2 = val2$iv$iv$iv$iv2;
        boolean bl5 = false;
        long v2$iv$iv$iv$iv2 = Float.floatToIntBits(f2);
        long l4 = l = v1$iv$iv$iv$iv2 << 32 | v2$iv$iv$iv$iv2 & 0xFFFFFFFFL;
        PxPosition center = PxKt.center((PxSize)new PxSize(l4));
        this.animation = TransitionDefinitionKt.createAnimation$default(RippleTransition.INSTANCE.definition(startRadius, targetRadius, startPosition, center), (AnimationClockObservable)clock, null, (int)2, null);
        this.animation.setOnUpdate(this.requestRedraw);
        this.animation.setOnStateChangeFinished((Function1)new Function1<RippleTransition.State, Unit>(){

            public final void invoke(@NotNull RippleTransition.State stage) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)stage), (String)"stage");
                    transitionState = stage;
                    if (!Intrinsics.areEqual((Object)((Object)transitionState), (Object)((Object)RippleTransition.State.Finished))) break block0;
                    onAnimationFinished.invoke((Object)this);
                }
            }
        });
        this.animation.toState((Object)RippleTransition.State.Revealed);
    }

    public /* synthetic */ DefaultRippleEffect(LayoutCoordinates coordinates, PxPosition startPosition, Density density, Dp radius, boolean clipped, AnimationClockObservable clock, Function0 requestRedraw, Function1 onAnimationFinished2, int $mask0, DefaultConstructorMarker $marker) {
        Dp dp = ($mask0 & 8) != 0 ? (Dp)null : radius;
        this(coordinates, startPosition, density, dp, clipped, clock, (Function0<Unit>)requestRedraw, (Function1<? super RippleEffect, Unit>)onAnimationFinished2);
    }

    @Override
    public void finish(boolean canceled) {
        this.finishRequested = true;
        this.animation.toState((Object)RippleTransition.State.Finished);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull Canvas canvas, @NotNull Color color) {
        block1: {
            PxPosition $this$toOffset$iv;
            float f;
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
            float alpha = Intrinsics.areEqual((Object)((Object)this.transitionState), (Object)((Object)RippleTransition.State.Initial)) && this.finishRequested ? 1.0f : ((Number)this.animation.get((PropKey)RippleTransition.INSTANCE.getAlpha())).floatValue();
            this.paint.setColor(Color.copy$default((Color)color, (float)(color.getAlpha() * alpha), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null));
            if (this.clipped) {
                long l;
                void val1$iv$iv$iv$iv;
                void height$iv$iv$iv;
                void width$iv$iv$iv;
                void height$iv$iv;
                void width$iv$iv;
                void $this$toPxSize$iv;
                canvas.save();
                IntPxSize intPxSize = this.coordinates.getSize();
                Canvas canvas2 = canvas;
                IntPx this_$iv$iv = $this$toPxSize$iv;
                long value$iv$iv$iv = this_$iv$iv.getValue();
                boolean $i$f$unpackInt1 = false;
                int $this$ipx$iv$iv$iv = (int)(value$iv$iv$iv >> 32);
                this_$iv$iv = new IntPx($this$ipx$iv$iv$iv);
                IntPx this_$iv$iv2 = $this$toPxSize$iv;
                long value$iv$iv$iv2 = this_$iv$iv2.getValue();
                boolean $i$f$unpackInt2 = false;
                int $this$ipx$iv$iv$iv2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
                this_$iv$iv2 = new IntPx($this$ipx$iv$iv$iv2);
                Px $this$toPx$iv$iv$iv = width$iv$iv;
                int $this$px$iv$iv$iv$iv = $this$toPx$iv$iv$iv.getValue();
                $this$toPx$iv$iv$iv = new Px((float)$this$px$iv$iv$iv$iv);
                Px $this$toPx$iv$iv$iv2 = height$iv$iv;
                int $this$px$iv$iv$iv$iv22 = $this$toPx$iv$iv$iv2.getValue();
                $this$toPx$iv$iv$iv2 = new Px((float)$this$px$iv$iv$iv$iv22);
                float $this$px$iv$iv$iv$iv22 = width$iv$iv$iv.getValue();
                float val2$iv$iv$iv$iv = height$iv$iv$iv.getValue();
                boolean $i$f$packFloats = false;
                f = val1$iv$iv$iv$iv;
                boolean bl = false;
                long v1$iv$iv$iv$iv = Float.floatToIntBits(f);
                float f2 = val2$iv$iv$iv$iv;
                boolean bl2 = false;
                long v2$iv$iv$iv$iv = Float.floatToIntBits(f2);
                long l2 = l = v1$iv$iv$iv$iv << 32 | v2$iv$iv$iv$iv & 0xFFFFFFFFL;
                PxSize pxSize = new PxSize(l2);
                Canvas.DefaultImpls.clipRect$default((Canvas)canvas2, (Rect)PxKt.toRect((PxSize)pxSize), (ClipOp)null, (int)2, null);
            }
            PxPosition this_$iv$iv = $this$toOffset$iv = (PxPosition)this.animation.get((PropKey)RippleTransition.INSTANCE.getCenter());
            long value$iv$iv$iv = this_$iv$iv.getValue();
            boolean $i$f$unpackFloat1 = false;
            FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
            int n = (int)(value$iv$iv$iv >> 32);
            boolean bl = false;
            float $this$px$iv$iv$iv = Float.intBitsToFloat(n);
            Px px = new Px($this$px$iv$iv$iv);
            this_$iv$iv = $this$toOffset$iv;
            float f3 = px.getValue();
            value$iv$iv$iv = this_$iv$iv.getValue();
            boolean $i$f$unpackFloat2 = false;
            floatCompanionObject = FloatCompanionObject.INSTANCE;
            n = (int)(value$iv$iv$iv & 0xFFFFFFFFL);
            bl = false;
            $this$px$iv$iv$iv = Float.intBitsToFloat(n);
            Px px2 = new Px($this$px$iv$iv$iv);
            f = px2.getValue();
            float f4 = f3;
            Offset centerOffset = new Offset(f4, f);
            float radius = ((Px)this.animation.get((PropKey)RippleTransition.INSTANCE.getRadius())).getValue();
            canvas.drawCircle(centerOffset, radius, this.paint);
            if (!this.clipped) break block1;
            canvas.restore();
        }
    }

    @Override
    public void dispose() {
    }
}

