/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material;

import androidx.ui.foundation.ScrollerPosition;
import androidx.ui.material.TabRow;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.Px;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0002\u0018\u00002\u00020\u0001B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\f\u0010 \u001a\u00020!*\u00020\bH\u0002R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Landroidx/ui/material/ScrollableTabData;", "", "scrollerPosition", "Landroidx/ui/foundation/ScrollerPosition;", "initialSelectedTab", "", "tabPositions", "", "Landroidx/ui/material/TabRow$TabPosition;", "visibleWidth", "Landroidx/ui/unit/IntPx;", "edgeOffset", "getEdgeOffset", "()Landroidx/ui/unit/IntPx;", "getScrollerPosition", "()Landroidx/ui/foundation/ScrollerPosition;", "value", "selectedTab", "getSelectedTab", "()I", "setSelectedTab", "(I)V", "getTabPositions", "()Ljava/util/List;", "setTabPositions", "(Ljava/util/List;)V", "getVisibleWidth", "setVisibleWidth", "(Landroidx/ui/unit/IntPx;)V", "scrollToTab", "", "tabPosition", "calculateTabOffset", "", "ui-material_release"})
final class ScrollableTabData {
    private final ScrollerPosition scrollerPosition;
    private List<TabRow.TabPosition> tabPositions;
    private IntPx visibleWidth;
    private final IntPx edgeOffset;
    private int selectedTab;

    public ScrollableTabData(@NotNull ScrollerPosition scrollerPosition, int initialSelectedTab, @NotNull List<TabRow.TabPosition> tabPositions, @NotNull IntPx visibleWidth, @NotNull IntPx edgeOffset) {
        Intrinsics.checkParameterIsNotNull((Object)scrollerPosition, (String)"scrollerPosition");
        Intrinsics.checkParameterIsNotNull(tabPositions, (String)"tabPositions");
        Intrinsics.checkParameterIsNotNull((Object)visibleWidth, (String)"visibleWidth");
        Intrinsics.checkParameterIsNotNull((Object)edgeOffset, (String)"edgeOffset");
        this.scrollerPosition = scrollerPosition;
        this.tabPositions = tabPositions;
        this.visibleWidth = visibleWidth;
        this.edgeOffset = edgeOffset;
        this.selectedTab = initialSelectedTab;
    }

    @NotNull
    public final ScrollerPosition getScrollerPosition() {
        return this.scrollerPosition;
    }

    @NotNull
    public final List<TabRow.TabPosition> getTabPositions() {
        return this.tabPositions;
    }

    public final void setTabPositions(@NotNull List<TabRow.TabPosition> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.tabPositions = list;
    }

    @NotNull
    public final IntPx getVisibleWidth() {
        return this.visibleWidth;
    }

    public final void setVisibleWidth(@NotNull IntPx intPx) {
        Intrinsics.checkParameterIsNotNull((Object)intPx, (String)"<set-?>");
        this.visibleWidth = intPx;
    }

    @NotNull
    public final IntPx getEdgeOffset() {
        return this.edgeOffset;
    }

    public final int getSelectedTab() {
        return this.selectedTab;
    }

    public final void setSelectedTab(int value) {
        block1: {
            if (this.selectedTab == value) break block1;
            TabRow.TabPosition tabPosition = (TabRow.TabPosition)CollectionsKt.getOrNull(this.getTabPositions(), (int)value);
            if (tabPosition != null) {
                TabRow.TabPosition tabPosition2 = tabPosition;
                boolean bl = false;
                boolean bl2 = false;
                TabRow.TabPosition it = tabPosition2;
                this.scrollToTab(it);
            }
            this.selectedTab = value;
        }
    }

    private final void scrollToTab(TabRow.TabPosition tabPosition) {
        float calculatedOffset = this.calculateTabOffset(tabPosition);
        ScrollerPosition.smoothScrollTo$default((ScrollerPosition)this.getScrollerPosition(), (float)calculatedOffset, (Function2)null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final float calculateTabOffset(TabRow.TabPosition $this$calculateTabOffset) {
        void $this$coerceAtLeast$iv;
        IntPx tabOffset = $this$calculateTabOffset.getLeft();
        IntPx scrollerCenter = this.getVisibleWidth().div(2);
        IntPx tabWidth = $this$calculateTabOffset.getWidth();
        IntPx centeredTabOffset = tabOffset.minus(scrollerCenter.minus(tabWidth.div(2)));
        IntPx totalTabRowWidth = ((TabRow.TabPosition)CollectionsKt.last(this.getTabPositions())).getRight().plus(this.getEdgeOffset());
        IntPx intPx = totalTabRowWidth.minus(this.getVisibleWidth());
        IntPx minimumValue$iv = IntPx.Companion.getZero();
        IntPx availableSpace = new IntPx(RangesKt.coerceAtLeast((int)$this$coerceAtLeast$iv.getValue(), (int)minimumValue$iv.getValue()));
        IntPx $this$toPx$iv = (IntPx)RangesKt.coerceIn((Comparable)((Comparable)centeredTabOffset), (Comparable)((Comparable)IntPx.Companion.getZero()), (Comparable)((Comparable)availableSpace));
        int $this$px$iv$iv = $this$toPx$iv.getValue();
        return new Px((float)$this$px$iv$iv).getValue();
    }
}

