/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material;

import android.annotation.SuppressLint;
import androidx.animation.AnimationClockObservable;
import androidx.annotation.IntRange;
import androidx.ui.material.CallbackBasedAnimatedFloat;
import androidx.ui.material.SliderKt;
import androidx.ui.util.MathHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0002\u0018\u00002\u00020\u0001B@\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bJ\u001d\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b.R*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00020\u00188\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0015\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0015R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006/"}, d2={"Landroidx/ui/material/SliderPosition;", "", "initial", "", "valueRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "steps", "", "animatedClock", "Landroidx/animation/AnimationClockObservable;", "onValueChange", "Lkotlin/Function1;", "", "<set-?>", "", "anchorsPx", "getAnchorsPx$ui_material_release", "()Ljava/util/List;", "endPx", "endValue", "getEndValue$ui_material_release", "()F", "floatPointMistakeCorrection", "holder", "Landroidx/ui/material/CallbackBasedAnimatedFloat;", "getHolder$ui_material_release", "()Landroidx/ui/material/CallbackBasedAnimatedFloat;", "getOnValueChange", "()Lkotlin/jvm/functions/Function1;", "setOnValueChange", "(Lkotlin/jvm/functions/Function1;)V", "value", "scaledValue", "getScaledValue$ui_material_release", "setScaledValue$ui_material_release", "(F)V", "startPx", "startValue", "getStartValue$ui_material_release", "tickFractions", "getTickFractions$ui_material_release", "getValueRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "setBounds", "min", "max", "setBounds$ui_material_release", "ui-material_release"})
final class SliderPosition {
    private final ClosedFloatingPointRange<Float> valueRange;
    private Function1<? super Float, Unit> onValueChange;
    private final float startValue;
    private final float endValue;
    private float scaledValue;
    private final float floatPointMistakeCorrection;
    private float endPx;
    private float startPx;
    private final List<Float> tickFractions;
    private List<Float> anchorsPx;
    @SuppressLint(value={"UnnecessaryLambdaCreation"})
    private final CallbackBasedAnimatedFloat holder;

    /*
     * WARNING - void declaration
     */
    public SliderPosition(float initial, @NotNull ClosedFloatingPointRange<Float> valueRange, @IntRange(from=0L) int steps, @NotNull AnimationClockObservable animatedClock, @NotNull Function1<? super Float, Unit> onValueChange) {
        List list;
        Intrinsics.checkNotNullParameter(valueRange, (String)"valueRange");
        Intrinsics.checkNotNullParameter((Object)animatedClock, (String)"animatedClock");
        Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
        this.valueRange = valueRange;
        this.onValueChange = onValueChange;
        this.startValue = ((Number)((Object)this.getValueRange().getStart())).floatValue();
        this.endValue = ((Number)((Object)this.getValueRange().getEndInclusive())).floatValue();
        int n = steps >= 0 ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "steps should be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.scaledValue = initial;
        this.floatPointMistakeCorrection = (((Number)((Object)this.getValueRange().getEndInclusive())).floatValue() - ((Number)((Object)this.getValueRange().getStart())).floatValue()) / (float)100;
        this.endPx = FloatCompanionObject.INSTANCE.getMAX_VALUE();
        this.startPx = FloatCompanionObject.INSTANCE.getMIN_VALUE();
        SliderPosition sliderPosition = this;
        if (steps == 0) {
            list = CollectionsKt.emptyList();
        } else {
            ArrayList<Float> arrayList;
            n = steps + 2;
            SliderPosition sliderPosition2 = sliderPosition;
            bl = false;
            bl2 = false;
            ArrayList<Float> arrayList2 = new ArrayList<Float>(n);
            boolean bl4 = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                void it;
                int n4 = n2++;
                boolean bl5 = false;
                int n5 = n4;
                arrayList = arrayList2;
                boolean bl6 = false;
                Float f = Float.valueOf((float)it / (float)(steps + 1));
                arrayList.add(f);
            }
            arrayList = arrayList2;
            sliderPosition = sliderPosition2;
            list = arrayList;
        }
        sliderPosition.tickFractions = list;
        this.anchorsPx = CollectionsKt.emptyList();
        this.holder = new CallbackBasedAnimatedFloat(SliderKt.access$scale(this.getStartValue$ui_material_release(), this.getEndValue$ui_material_release(), initial, this.startPx, this.endPx), animatedClock, (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this){
            private final /* synthetic */ SliderPosition $this;
            {
                this.$this = $receiver;
                super(1);
            }

            public final void invoke(float it) {
                this.$this.getOnValueChange().invoke((Object)Float.valueOf(SliderKt.access$scale(SliderPosition.access$getStartPx$p(this.$this), SliderPosition.access$getEndPx$p(this.$this), it, this.$this.getStartValue$ui_material_release(), this.$this.getEndValue$ui_material_release())));
            }
        }));
    }

    public /* synthetic */ SliderPosition(float initial, ClosedFloatingPointRange valueRange, int steps, AnimationClockObservable animatedClock, Function1 onValueChange, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            initial = 0.0f;
        }
        if ((n & 2) != 0) {
            valueRange = RangesKt.rangeTo((float)0.0f, (float)1.0f);
        }
        if ((n & 4) != 0) {
            steps = 0;
        }
        this(initial, (ClosedFloatingPointRange<Float>)valueRange, steps, animatedClock, (Function1<? super Float, Unit>)onValueChange);
    }

    @NotNull
    public final ClosedFloatingPointRange<Float> getValueRange() {
        return this.valueRange;
    }

    @NotNull
    public final Function1<Float, Unit> getOnValueChange() {
        return this.onValueChange;
    }

    public final void setOnValueChange(@NotNull Function1<? super Float, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onValueChange = function1;
    }

    public final float getStartValue$ui_material_release() {
        return this.startValue;
    }

    public final float getEndValue$ui_material_release() {
        return this.endValue;
    }

    public final float getScaledValue$ui_material_release() {
        return this.scaledValue;
    }

    public final void setScaledValue$ui_material_release(float value) {
        float scaled = SliderKt.access$scale(this.getStartValue$ui_material_release(), this.getEndValue$ui_material_release(), value, this.startPx, this.endPx);
        if (scaled - this.getHolder$ui_material_release().getValue().floatValue() > this.floatPointMistakeCorrection) {
            this.getHolder$ui_material_release().snapTo(scaled);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setBounds$ui_material_release(float min, float max) {
        Collection<Float> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.startPx == min && this.endPx == max) {
            return;
        }
        float newValue = SliderKt.access$scale(this.startPx, this.endPx, this.getHolder$ui_material_release().getValue().floatValue(), min, max);
        this.startPx = min;
        this.endPx = max;
        this.getHolder$ui_material_release().setBounds(min, max);
        Iterable iterable = this.getTickFractions$ui_material_release();
        SliderPosition sliderPosition = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            float f = ((Number)item$iv$iv).floatValue();
            collection = destination$iv$iv;
            boolean bl = false;
            Float f2 = Float.valueOf(MathHelpersKt.lerp((float)this.startPx, (float)this.endPx, (float)it));
            collection.add(f2);
        }
        collection = (List)destination$iv$iv;
        sliderPosition.anchorsPx = collection;
        this.getHolder$ui_material_release().snapTo(newValue);
    }

    @NotNull
    public final List<Float> getTickFractions$ui_material_release() {
        return this.tickFractions;
    }

    @NotNull
    public final List<Float> getAnchorsPx$ui_material_release() {
        return this.anchorsPx;
    }

    @NotNull
    public final CallbackBasedAnimatedFloat getHolder$ui_material_release() {
        return this.holder;
    }

    public static final /* synthetic */ float access$getStartPx$p(SliderPosition sliderPosition) {
        return sliderPosition.startPx;
    }

    public static final /* synthetic */ float access$getEndPx$p(SliderPosition sliderPosition) {
        return sliderPosition.endPx;
    }
}

