/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material.ripple;

import androidx.animation.AnimationClockObservable;
import androidx.compose.State;
import androidx.compose.frames.FrameContainersKt;
import androidx.compose.frames.ModelList;
import androidx.ui.core.ContentDrawScope;
import androidx.ui.foundation.IndicationInstance;
import androidx.ui.foundation.Interaction;
import androidx.ui.foundation.InteractionState;
import androidx.ui.geometry.Size;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.drawscope.DrawScope;
import androidx.ui.material.ripple.RippleEffect;
import androidx.ui.material.ripple.RippleEffectFactory;
import androidx.ui.unit.Density;
import androidx.ui.unit.Dp;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxPosition;
import androidx.ui.unit.PxSize;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u0014*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u0014*\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0014\u0010\u001c\u001a\u00020\u0014*\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Landroidx/ui/material/ripple/RippleIndicationInstance;", "Landroidx/ui/foundation/IndicationInstance;", "bounded", "", "radius", "Landroidx/ui/unit/Dp;", "color", "Landroidx/compose/State;", "Landroidx/ui/graphics/Color;", "factory", "Landroidx/ui/material/ripple/RippleEffectFactory;", "clock", "Landroidx/animation/AnimationClockObservable;", "currentEffect", "Landroidx/ui/material/ripple/RippleEffect;", "currentPressPosition", "Landroidx/ui/unit/PxPosition;", "effects", "Landroidx/compose/frames/ModelList;", "cleanPressState", "", "onDispose", "drawIndication", "Landroidx/ui/core/ContentDrawScope;", "interactionState", "Landroidx/ui/foundation/InteractionState;", "refreshEffectsState", "state", "startRippleEffect", "pressPosition", "ui-material_release"})
final class RippleIndicationInstance
implements IndicationInstance {
    private final boolean bounded;
    private final Dp radius;
    private State<Color> color;
    private final RippleEffectFactory factory;
    private final AnimationClockObservable clock;
    private final ModelList<RippleEffect> effects;
    private PxPosition currentPressPosition;
    private RippleEffect currentEffect;

    private RippleIndicationInstance(boolean bounded, Dp radius, State<Color> color, RippleEffectFactory factory, AnimationClockObservable clock) {
        this.bounded = bounded;
        this.radius = radius;
        this.color = color;
        this.factory = factory;
        this.clock = clock;
        this.effects = FrameContainersKt.modelListOf();
    }

    public /* synthetic */ RippleIndicationInstance(boolean bounded, Dp radius, State color, RippleEffectFactory factory, AnimationClockObservable clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            radius = null;
        }
        this(bounded, radius, color, factory, clock, null);
    }

    public void drawIndication(@NotNull ContentDrawScope $this$drawIndication, @NotNull InteractionState interactionState) {
        Intrinsics.checkNotNullParameter((Object)$this$drawIndication, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interactionState, (String)"interactionState");
        this.refreshEffectsState($this$drawIndication, interactionState);
        $this$drawIndication.drawContent();
        List $this$fastForEach$iv = (List)this.effects;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
        if (n <= n2) {
            do {
                int index$iv = n++;
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                RippleEffect it = (RippleEffect)item$iv;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                RippleEffect $this$drawIndication_u24lambda_u2d1_u24lambda_u2d0 = it;
                boolean bl4 = false;
                $this$drawIndication_u24lambda_u2d1_u24lambda_u2d0.draw-z8Px3OI((DrawScope)$this$drawIndication, ((Color)this.color.getValue()).unbox-impl());
            } while (n <= n2);
        }
    }

    private final void refreshEffectsState(ContentDrawScope $this$refreshEffectsState, InteractionState state) {
        PxPosition pressPosition = state.interactionPositionFor((Interaction)Interaction.Pressed.INSTANCE);
        if (pressPosition == null) {
            this.cleanPressState();
        } else if (!Intrinsics.areEqual((Object)this.currentPressPosition, (Object)pressPosition)) {
            this.startRippleEffect($this$refreshEffectsState, pressPosition);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startRippleEffect(ContentDrawScope $this$startRippleEffect, PxPosition pressPosition) {
        long l;
        void val1$iv$iv;
        void width$iv;
        RippleEffect rippleEffect = this.currentEffect;
        if (rippleEffect != null) {
            rippleEffect.finish(false);
        }
        float $this$px$iv = Size.getWidth-impl((long)$this$startRippleEffect.getSize());
        boolean $i$f$getPx = false;
        $this$px$iv = Px.constructor-impl((float)$this$px$iv);
        float $this$px$iv2 = Size.getHeight-impl((long)$this$startRippleEffect.getSize());
        boolean $i$f$getPx2 = false;
        float height$iv = Px.constructor-impl((float)$this$px$iv2);
        boolean bl = false;
        void var7_10 = width$iv;
        float val2$iv$iv = height$iv;
        boolean $i$f$packFloats = false;
        void var10_13 = val1$iv$iv;
        boolean bl2 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var10_13);
        float f = val2$iv$iv;
        boolean bl3 = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        PxSize pxSize = new PxSize(l2);
        PxPosition position = this.bounded ? pressPosition : PxKt.center((PxSize)pxSize);
        RippleEffect effect2 = this.factory.create-muzrHoo(pxSize, position, (Density)$this$startRippleEffect, this.radius, this.bounded, this.clock, (Function1<? super RippleEffect, Unit>)((Function1)new Function1<RippleEffect, Unit>(this){
            private final /* synthetic */ RippleIndicationInstance $this;
            {
                this.$this = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RippleEffect effect2) {
                Intrinsics.checkNotNullParameter((Object)effect2, (String)"effect");
                RippleIndicationInstance.access$getEffects$p(this.$this).remove((Object)effect2);
                if (Intrinsics.areEqual((Object)RippleIndicationInstance.access$getCurrentEffect$p(this.$this), (Object)effect2)) {
                    RippleIndicationInstance.access$setCurrentEffect$p(this.$this, null);
                }
            }
        }));
        this.effects.add((Object)effect2);
        this.currentPressPosition = pressPosition;
        this.currentEffect = effect2;
    }

    private final void cleanPressState() {
        RippleEffect rippleEffect = this.currentEffect;
        if (rippleEffect != null) {
            rippleEffect.finish(false);
        }
        this.currentEffect = null;
        this.currentPressPosition = null;
    }

    public void onDispose() {
        List $this$fastForEach$iv = (List)this.effects;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
        if (n <= n2) {
            do {
                int index$iv = n++;
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                RippleEffect it = (RippleEffect)item$iv;
                boolean bl = false;
                it.dispose();
            } while (n <= n2);
        }
        this.effects.clear();
        this.currentEffect = null;
    }

    public /* synthetic */ RippleIndicationInstance(boolean bl, @Nullable Dp dp, @NotNull State state, @NotNull RippleEffectFactory rippleEffectFactory, @NotNull AnimationClockObservable animationClockObservable, @NotNull DefaultConstructorMarker defaultConstructorMarker) {
        this(bl, dp, (State<Color>)state, rippleEffectFactory, animationClockObservable);
    }

    public static final /* synthetic */ ModelList access$getEffects$p(RippleIndicationInstance rippleIndicationInstance) {
        return rippleIndicationInstance.effects;
    }

    public static final /* synthetic */ RippleEffect access$getCurrentEffect$p(RippleIndicationInstance rippleIndicationInstance) {
        return rippleIndicationInstance.currentEffect;
    }

    public static final /* synthetic */ void access$setCurrentEffect$p(RippleIndicationInstance rippleIndicationInstance, RippleEffect rippleEffect) {
        rippleIndicationInstance.currentEffect = rippleEffect;
    }
}

