/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material;

import androidx.ui.foundation.shape.corner.RoundedCornerShapeKt;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.geometry.Size;
import androidx.ui.geometry.SizeKt;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.OutlineKt;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.PathOperation;
import androidx.ui.graphics.Shape;
import androidx.ui.material.AppBarKt;
import androidx.ui.unit.Density;
import androidx.ui.unit.PxBounds;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J4\u0010\u001d\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"Landroidx/ui/material/BottomAppBarCutoutShape;", "Landroidx/ui/graphics/Shape;", "cutoutShape", "fabBounds", "Landroidx/ui/unit/PxBounds;", "getCutoutShape", "()Landroidx/ui/graphics/Shape;", "getFabBounds", "()Landroidx/ui/unit/PxBounds;", "component1", "component2", "copy", "createOutline", "Landroidx/ui/graphics/Outline;", "size", "Landroidx/ui/geometry/Size;", "density", "Landroidx/ui/unit/Density;", "equals", "", "other", "", "hashCode", "", "toString", "", "addCutoutShape", "", "Landroidx/ui/graphics/Path;", "addRoundedEdges", "cutoutStartPosition", "", "cutoutEndPosition", "cutoutRadius", "roundedEdgeRadius", "verticalOffset", "ui-material_release"})
final class BottomAppBarCutoutShape
implements Shape {
    private final Shape cutoutShape;
    private final PxBounds fabBounds;

    public BottomAppBarCutoutShape(@NotNull Shape cutoutShape, @NotNull PxBounds fabBounds) {
        Intrinsics.checkNotNullParameter((Object)cutoutShape, (String)"cutoutShape");
        Intrinsics.checkNotNullParameter((Object)fabBounds, (String)"fabBounds");
        this.cutoutShape = cutoutShape;
        this.fabBounds = fabBounds;
    }

    @NotNull
    public final Shape getCutoutShape() {
        return this.cutoutShape;
    }

    @NotNull
    public final PxBounds getFabBounds() {
        return this.fabBounds;
    }

    @NotNull
    public Outline createOutline(@NotNull Size size, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Path path = AndroidPathKt.Path();
        boolean bl = false;
        boolean bl2 = false;
        Path $this$createOutline_u24lambda_u2d0 = path;
        boolean bl3 = false;
        $this$createOutline_u24lambda_u2d0.addRect(Rect.Companion.fromLTRB(0.0f, 0.0f, size.getWidth(), size.getHeight()));
        Path boundingRectangle = path;
        Path path2 = AndroidPathKt.Path();
        bl2 = false;
        boolean bl4 = false;
        Path $this$createOutline_u24lambda_u2d1 = path2;
        boolean bl5 = false;
        this.addCutoutShape($this$createOutline_u24lambda_u2d1, density);
        $this$createOutline_u24lambda_u2d1.op(boundingRectangle, $this$createOutline_u24lambda_u2d1, PathOperation.difference);
        Path path3 = path2;
        return (Outline)new Outline.Generic(path3);
    }

    /*
     * WARNING - void declaration
     */
    private final void addCutoutShape(Path $this$addCutoutShape, Density density) {
        long l;
        void $this$height$iv;
        boolean bl = false;
        boolean bl2 = false;
        Density $this$addCutoutShape_u24lambda_u2d2 = density;
        boolean bl3 = false;
        float cutoutOffset = $this$addCutoutShape_u24lambda_u2d2.toPx-ipo6vVg(AppBarKt.access$getBottomAppBarCutoutOffset$cp$s1205138267());
        PxBounds $this$width$iv = this.getFabBounds();
        boolean $i$f$getWidth = false;
        float f = $this$width$iv.getRight() - $this$width$iv.getLeft() + cutoutOffset * (float)2;
        $this$width$iv = this.getFabBounds();
        float f2 = f;
        boolean $i$f$getHeight = false;
        float f3 = $this$height$iv.getBottom() - $this$height$iv.getTop();
        Size cutoutSize = SizeKt.Size((float)f2, (float)(f3 + cutoutOffset * (float)2));
        float cutoutStartX = this.getFabBounds().getLeft() - cutoutOffset;
        float cutoutEndX = cutoutStartX + cutoutSize.getWidth();
        float cutoutRadius = cutoutSize.getHeight() / 2.0f;
        float cutoutStartY = -cutoutRadius;
        OutlineKt.addOutline((Path)$this$addCutoutShape, (Outline)this.getCutoutShape().createOutline(cutoutSize, density));
        Path path = $this$addCutoutShape;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f4 = cutoutStartX;
        boolean bl4 = false;
        long v1$iv$iv = Float.floatToIntBits(f4);
        float f5 = cutoutStartY;
        boolean bl5 = false;
        long v2$iv$iv = Float.floatToIntBits(f5);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset offset = new Offset(l2);
        path.shift(offset);
        if (Intrinsics.areEqual((Object)this.getCutoutShape(), (Object)RoundedCornerShapeKt.getCircleShape())) {
            boolean bl6 = false;
            boolean bl7 = false;
            Density $this$addCutoutShape_u24lambda_u2d3 = density;
            boolean bl8 = false;
            float edgeRadius = $this$addCutoutShape_u24lambda_u2d3.toPx-ipo6vVg(AppBarKt.access$getBottomAppBarRoundedEdgeRadius$cp$s1205138267());
            this.addRoundedEdges($this$addCutoutShape, cutoutStartX, cutoutEndX, cutoutRadius, edgeRadius, 0.0f);
        }
    }

    private final void addRoundedEdges(Path $this$addRoundedEdges, float cutoutStartPosition, float cutoutEndPosition, float cutoutRadius, float roundedEdgeRadius, float verticalOffset) {
        boolean $i$f$calculateCutoutCircleYIntercept = false;
        boolean $i$f$square = false;
        float f = cutoutRadius * cutoutRadius;
        $i$f$square = false;
        float f2 = verticalOffset * verticalOffset;
        float $i$f$square2 = f - f2;
        boolean bl = false;
        float appBarInterceptOffset = -((float)Math.sqrt($i$f$square2));
        float appBarInterceptStartX = cutoutStartPosition + (cutoutRadius + appBarInterceptOffset);
        float appBarInterceptEndX = cutoutEndPosition - (cutoutRadius + appBarInterceptOffset);
        float controlPointOffset = 1.0f;
        float controlPointRadiusOffset = appBarInterceptOffset - controlPointOffset;
        Pair<Float, Float> pair = AppBarKt.calculateRoundedEdgeIntercept(controlPointRadiusOffset, verticalOffset, cutoutRadius);
        float curveInterceptXOffset = ((Number)pair.component1()).floatValue();
        float curveInterceptYOffset = ((Number)pair.component2()).floatValue();
        float curveInterceptStartX = cutoutStartPosition + (curveInterceptXOffset + cutoutRadius);
        float curveInterceptEndX = cutoutEndPosition - (curveInterceptXOffset + cutoutRadius);
        float curveInterceptY = curveInterceptYOffset - verticalOffset;
        float roundedEdgeStartX = appBarInterceptStartX - roundedEdgeRadius;
        float roundedEdgeEndX = appBarInterceptEndX + roundedEdgeRadius;
        $this$addRoundedEdges.moveTo(roundedEdgeStartX, 0.0f);
        $this$addRoundedEdges.quadraticBezierTo(appBarInterceptStartX - controlPointOffset, 0.0f, curveInterceptStartX, curveInterceptY);
        $this$addRoundedEdges.lineTo(curveInterceptEndX, curveInterceptY);
        $this$addRoundedEdges.quadraticBezierTo(appBarInterceptEndX + controlPointOffset, 0.0f, roundedEdgeEndX, 0.0f);
        $this$addRoundedEdges.close();
    }

    @NotNull
    public final Shape component1() {
        return this.cutoutShape;
    }

    @NotNull
    public final PxBounds component2() {
        return this.fabBounds;
    }

    @NotNull
    public final BottomAppBarCutoutShape copy(@NotNull Shape cutoutShape, @NotNull PxBounds fabBounds) {
        Intrinsics.checkNotNullParameter((Object)cutoutShape, (String)"cutoutShape");
        Intrinsics.checkNotNullParameter((Object)fabBounds, (String)"fabBounds");
        return new BottomAppBarCutoutShape(cutoutShape, fabBounds);
    }

    public static /* synthetic */ BottomAppBarCutoutShape copy$default(BottomAppBarCutoutShape this_, Shape cutoutShape, PxBounds fabBounds, int n, Object object) {
        if ((n & 1) != 0) {
            cutoutShape = this_.cutoutShape;
        }
        if ((n & 2) != 0) {
            fabBounds = this_.fabBounds;
        }
        return this_.copy(cutoutShape, fabBounds);
    }

    @NotNull
    public String toString() {
        return "BottomAppBarCutoutShape(cutoutShape=" + this.cutoutShape + ", fabBounds=" + this.fabBounds + ")";
    }

    public int hashCode() {
        return this.cutoutShape.hashCode() * 31 + this.fabBounds.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BottomAppBarCutoutShape)) {
            return false;
        }
        Object object = other;
        BottomAppBarCutoutShape bottomAppBarCutoutShape = (BottomAppBarCutoutShape)object;
        if (!Intrinsics.areEqual((Object)this.cutoutShape, (Object)bottomAppBarCutoutShape.cutoutShape)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fabBounds, (Object)bottomAppBarCutoutShape.fabBounds);
    }
}

