/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material;

import androidx.ui.foundation.ScrollerPosition;
import androidx.ui.material.TabRow;
import androidx.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0002\u0018\u00002\u00020\u0001B6\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0002J\f\u0010!\u001a\u00020\"*\u00020\bH\u0002R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0017R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u0017\u00a8\u0006#"}, d2={"Landroidx/ui/material/ScrollableTabData;", "", "scrollerPosition", "Landroidx/ui/foundation/ScrollerPosition;", "initialSelectedTab", "", "tabPositions", "", "Landroidx/ui/material/TabRow$TabPosition;", "visibleWidth", "edgeOffset", "density", "Landroidx/ui/unit/Density;", "getDensity", "()Landroidx/ui/unit/Density;", "getEdgeOffset", "()I", "getScrollerPosition", "()Landroidx/ui/foundation/ScrollerPosition;", "value", "selectedTab", "getSelectedTab", "setSelectedTab", "(I)V", "getTabPositions", "()Ljava/util/List;", "setTabPositions", "(Ljava/util/List;)V", "getVisibleWidth", "setVisibleWidth", "scrollToTab", "", "tabPosition", "calculateTabOffset", "", "ui-material_release"})
final class ScrollableTabData {
    private final ScrollerPosition scrollerPosition;
    private List<TabRow.TabPosition> tabPositions;
    private int visibleWidth;
    private final int edgeOffset;
    private final Density density;
    private int selectedTab;

    public ScrollableTabData(@NotNull ScrollerPosition scrollerPosition, int initialSelectedTab, @NotNull List<TabRow.TabPosition> tabPositions, int visibleWidth, int edgeOffset, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)scrollerPosition, (String)"scrollerPosition");
        Intrinsics.checkNotNullParameter(tabPositions, (String)"tabPositions");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.scrollerPosition = scrollerPosition;
        this.tabPositions = tabPositions;
        this.visibleWidth = visibleWidth;
        this.edgeOffset = edgeOffset;
        this.density = density;
        this.selectedTab = initialSelectedTab;
    }

    @NotNull
    public final ScrollerPosition getScrollerPosition() {
        return this.scrollerPosition;
    }

    @NotNull
    public final List<TabRow.TabPosition> getTabPositions() {
        return this.tabPositions;
    }

    public final void setTabPositions(@NotNull List<TabRow.TabPosition> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.tabPositions = list;
    }

    public final int getVisibleWidth() {
        return this.visibleWidth;
    }

    public final void setVisibleWidth(int n) {
        this.visibleWidth = n;
    }

    public final int getEdgeOffset() {
        return this.edgeOffset;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    public final int getSelectedTab() {
        return this.selectedTab;
    }

    public final void setSelectedTab(int value) {
        if (this.selectedTab != value) {
            TabRow.TabPosition tabPosition = (TabRow.TabPosition)CollectionsKt.getOrNull(this.getTabPositions(), (int)value);
            if (tabPosition != null) {
                TabRow.TabPosition tabPosition2 = tabPosition;
                boolean bl = false;
                boolean bl2 = false;
                TabRow.TabPosition it = tabPosition2;
                boolean bl3 = false;
                this.scrollToTab(it);
            }
            this.selectedTab = value;
        }
    }

    private final void scrollToTab(TabRow.TabPosition tabPosition) {
        float calculatedOffset = this.calculateTabOffset(tabPosition);
        ScrollerPosition.smoothScrollTo$default((ScrollerPosition)this.getScrollerPosition(), (float)calculatedOffset, null, (int)2, null);
    }

    private final float calculateTabOffset(TabRow.TabPosition $this$calculateTabOffset) {
        Density density = this.getDensity();
        boolean bl = false;
        boolean bl2 = false;
        Density $this$calculateTabOffset_u24lambda_u2d1 = density;
        boolean bl3 = false;
        int tabOffset = $this$calculateTabOffset_u24lambda_u2d1.toIntPx-ipo6vVg($this$calculateTabOffset.getLeft());
        int scrollerCenter = this.getVisibleWidth() / 2;
        int tabWidth = $this$calculateTabOffset_u24lambda_u2d1.toIntPx-ipo6vVg($this$calculateTabOffset.getWidth());
        int centeredTabOffset = tabOffset - (scrollerCenter - tabWidth / 2);
        int totalTabRowWidth = $this$calculateTabOffset_u24lambda_u2d1.toIntPx-ipo6vVg(((TabRow.TabPosition)CollectionsKt.last(this.getTabPositions())).getRight()) + this.getEdgeOffset();
        int availableSpace = RangesKt.coerceAtLeast((int)(totalTabRowWidth - this.getVisibleWidth()), (int)0);
        return RangesKt.coerceIn((int)centeredTabOffset, (int)0, (int)availableSpace);
    }
}

