/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material.ripple;

import androidx.animation.AnimationClockObservable;
import androidx.animation.PropKey;
import androidx.animation.TransitionAnimation;
import androidx.animation.TransitionDefinitionKt;
import androidx.compose.MutableState;
import androidx.compose.MutableStateKt;
import androidx.compose.State;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Size;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.ClipOp;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.drawscope.DrawScope;
import androidx.ui.graphics.drawscope.DrawTransform;
import androidx.ui.material.ripple.RippleAnimationKt;
import androidx.ui.material.ripple.RippleTransition;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B<\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u001d\u001a\u00020\u000eJ\u001c\u0010\u001e\u001a\u00020\u000e*\u00020\u001f2\u0006\u0010 \u001a\u00020!\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Landroidx/ui/material/ripple/RippleAnimation;", "", "size", "Landroidx/ui/geometry/Size;", "startPosition", "Landroidx/ui/geometry/Offset;", "radius", "", "clipped", "", "clock", "Landroidx/animation/AnimationClockObservable;", "onAnimationFinished", "Lkotlin/Function1;", "", "animation", "Landroidx/animation/TransitionAnimation;", "Landroidx/ui/material/ripple/RippleTransition$State;", "<set-?>", "", "animationPulse", "getAnimationPulse", "()J", "setAnimationPulse", "(J)V", "animationPulse$delegate", "Landroidx/compose/MutableState;", "finishRequested", "transitionState", "finish", "draw", "Landroidx/ui/graphics/drawscope/DrawScope;", "color", "Landroidx/ui/graphics/Color;", "draw-z8Px3OI", "(Landroidx/ui/graphics/drawscope/DrawScope;J)V", "ui-material_release"})
public final class RippleAnimation {
    @NotNull
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final boolean clipped;
    private final Function1<RippleAnimation, Unit> onAnimationFinished;
    private final TransitionAnimation<RippleTransition.State> animation;
    private RippleTransition.State transitionState;
    private boolean finishRequested;
    private final MutableState animationPulse$delegate;

    public RippleAnimation(@NotNull Size size, @NotNull Offset startPosition, float radius, boolean clipped, @NotNull AnimationClockObservable clock, @NotNull Function1<? super RippleAnimation, Unit> onAnimationFinished2) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(onAnimationFinished2, (String)"onAnimationFinished");
        this.clipped = clipped;
        this.onAnimationFinished = onAnimationFinished2;
        this.transitionState = RippleTransition.State.Initial;
        this.animationPulse$delegate = MutableStateKt.mutableStateOf$default((Object)0L, null, (int)2, null);
        Size surfaceSize = size;
        float startRadius = RippleAnimationKt.getRippleStartRadius(surfaceSize);
        float targetRadius = radius;
        Offset center = Size.center$default((Size)size, null, (int)1, null);
        this.animation = TransitionDefinitionKt.createAnimation$default(RippleTransition.INSTANCE.definition(startRadius, targetRadius, startPosition, center), (AnimationClockObservable)clock, null, (int)2, null);
        this.animation.setOnUpdate((Function0)new Function0<Unit>(){

            public final void invoke() {
                RippleAnimation rippleAnimation = this;
                long l = rippleAnimation.getAnimationPulse();
                rippleAnimation.setAnimationPulse(l + 1L);
            }
        });
        this.animation.setOnStateChangeFinished((Function1)new Function1<RippleTransition.State, Unit>(){

            public final void invoke(@NotNull RippleTransition.State stage) {
                Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
                transitionState = stage;
                if (Intrinsics.areEqual((Object)((Object)transitionState), (Object)((Object)RippleTransition.State.Finished))) {
                    onAnimationFinished.invoke((Object)this);
                }
            }
        });
        this.animation.toState((Object)RippleTransition.State.Revealed);
    }

    /*
     * WARNING - void declaration
     */
    private final long getAnimationPulse() {
        void $this$getValue$iv;
        State state = (State)this.animationPulse$delegate;
        KProperty<Object> property$iv = $$delegatedProperties[0];
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).longValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setAnimationPulse(long l) {
        void $this$setValue$iv;
        MutableState mutableState = this.animationPulse$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        Long value$iv = l;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    public final void finish() {
        this.finishRequested = true;
        this.animation.toState((Object)RippleTransition.State.Finished);
    }

    public final void draw-z8Px3OI(@NotNull DrawScope $receiver, long color) {
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        this.getAnimationPulse();
        float alpha = Intrinsics.areEqual((Object)((Object)this.transitionState), (Object)((Object)RippleTransition.State.Initial)) && this.finishRequested ? 1.0f : ((Number)this.animation.get((PropKey)RippleTransition.INSTANCE.getAlpha())).floatValue();
        Offset centerOffset = (Offset)this.animation.get((PropKey)RippleTransition.INSTANCE.getCenter());
        float radius = ((Number)this.animation.get((PropKey)RippleTransition.INSTANCE.getRadius())).floatValue();
        long modulatedColor = Color.copy-impl$default((long)color, (float)(Color.getAlpha-impl((long)color) * alpha), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
        if (this.clipped) {
            DrawScope $this$clipRect_u24default$iv = $receiver;
            float left$iv = 0.0f;
            float top$iv = 0.0f;
            float right$iv = $this$clipRect_u24default$iv.getSize().getWidth();
            float bottom$iv = $this$clipRect_u24default$iv.getSize().getHeight();
            ClipOp clipOp$iv = ClipOp.intersect;
            DrawScope $this$clipRect$iv$iv = $this$clipRect_u24default$iv;
            boolean $i$f$clipRect = false;
            DrawScope $this$withTransform$iv$iv$iv = $this$clipRect$iv$iv;
            boolean $i$f$withTransform = false;
            Canvas canvas = $this$withTransform$iv$iv$iv.getCanvas();
            boolean bl = false;
            boolean bl2 = false;
            Canvas it$iv$iv$iv = canvas;
            boolean bl3 = false;
            Size previousSize$iv$iv$iv = $this$withTransform$iv$iv$iv.getSize();
            it$iv$iv$iv.save();
            DrawTransform $this$clipRect_u24lambda_u2d3$iv$iv = $this$withTransform$iv$iv$iv.getTransform();
            boolean bl4 = false;
            $this$clipRect_u24lambda_u2d3$iv$iv.clipRect(left$iv, top$iv, right$iv, bottom$iv, clipOp$iv);
            DrawScope $this$draw_z8Px3OI_u24lambda_u2d0 = $this$withTransform$iv$iv$iv;
            boolean bl5 = false;
            DrawScope.drawCircle-UNeD5NE$default((DrawScope)$this$draw_z8Px3OI_u24lambda_u2d0, (long)modulatedColor, (float)radius, (Offset)centerOffset, (float)0.0f, null, null, null, (int)120, null);
            it$iv$iv$iv.restore();
            $this$withTransform$iv$iv$iv.setSize(previousSize$iv$iv$iv);
        } else {
            DrawScope.drawCircle-UNeD5NE$default((DrawScope)$receiver, (long)modulatedColor, (float)radius, (Offset)centerOffset, (float)0.0f, null, null, null, (int)120, null);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RippleAnimation.class), "animationPulse", "getAnimationPulse()J")))};
        $$delegatedProperties = kPropertyArray;
    }
}

