/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material.ripple;

import androidx.animation.AnimationClockObservable;
import androidx.compose.State;
import androidx.compose.frames.FrameContainersKt;
import androidx.compose.frames.ModelList;
import androidx.ui.core.ContentDrawScope;
import androidx.ui.foundation.IndicationInstance;
import androidx.ui.foundation.Interaction;
import androidx.ui.foundation.InteractionState;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Size;
import androidx.ui.geometry.SizeKt;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.drawscope.DrawScope;
import androidx.ui.material.ripple.RippleAnimation;
import androidx.ui.material.ripple.RippleAnimationKt;
import androidx.ui.material.ripple.RippleOpacity;
import androidx.ui.material.ripple.StateLayer;
import androidx.ui.unit.Density;
import androidx.ui.unit.Dp;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u001c\u0010\u0018\u001a\u00020\u0016*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0014\u0010\u001d\u001a\u00020\u0016*\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020\u0016*\u00020!2\u0006\u0010\u0006\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Landroidx/ui/material/ripple/RippleIndicationInstance;", "Landroidx/ui/foundation/IndicationInstance;", "bounded", "", "radius", "Landroidx/ui/unit/Dp;", "color", "Landroidx/compose/State;", "Landroidx/ui/graphics/Color;", "rippleOpacity", "Landroidx/ui/material/ripple/RippleOpacity;", "clock", "Landroidx/animation/AnimationClockObservable;", "currentPressPosition", "Landroidx/ui/geometry/Offset;", "currentRipple", "Landroidx/ui/material/ripple/RippleAnimation;", "ripples", "Landroidx/compose/frames/ModelList;", "stateLayer", "Landroidx/ui/material/ripple/StateLayer;", "onDispose", "", "removeRipple", "addRipple", "Landroidx/ui/core/ContentDrawScope;", "targetRadius", "", "pressPosition", "drawIndication", "interactionState", "Landroidx/ui/foundation/InteractionState;", "drawRipples", "Landroidx/ui/graphics/drawscope/DrawScope;", "drawRipples-z8Px3OI", "(Landroidx/ui/graphics/drawscope/DrawScope;J)V", "ui-material_release"})
final class RippleIndicationInstance
implements IndicationInstance {
    private final boolean bounded;
    private final Dp radius;
    private State<Color> color;
    private final RippleOpacity rippleOpacity;
    private final AnimationClockObservable clock;
    private final StateLayer stateLayer;
    private final ModelList<RippleAnimation> ripples;
    private Offset currentPressPosition;
    private RippleAnimation currentRipple;

    private RippleIndicationInstance(boolean bounded, Dp radius, State<Color> color, RippleOpacity rippleOpacity, AnimationClockObservable clock) {
        this.bounded = bounded;
        this.radius = radius;
        this.color = color;
        this.rippleOpacity = rippleOpacity;
        this.clock = clock;
        this.stateLayer = new StateLayer(this.clock, this.bounded, this.rippleOpacity);
        this.ripples = FrameContainersKt.modelListOf();
    }

    public /* synthetic */ RippleIndicationInstance(boolean bounded, Dp radius, State color, RippleOpacity rippleOpacity, AnimationClockObservable clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            radius = null;
        }
        this(bounded, radius, color, rippleOpacity, clock, null);
    }

    public void drawIndication(@NotNull ContentDrawScope $this$drawIndication, @NotNull InteractionState interactionState) {
        Intrinsics.checkNotNullParameter((Object)$this$drawIndication, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interactionState, (String)"interactionState");
        long color = ((Color)this.color.getValue()).unbox-impl();
        Dp dp = this.radius;
        Object object = dp == null ? (Float)null : Float.valueOf($this$drawIndication.toPx-ipo6vVg(dp.unbox-impl()));
        float targetRadius = object == null ? RippleAnimationKt.getRippleEndRadius((Density)$this$drawIndication, this.bounded, $this$drawIndication.getSize()) : ((Float)object).floatValue();
        $this$drawIndication.drawContent();
        object = this.stateLayer;
        boolean bl = false;
        boolean bl2 = false;
        Object $this$drawIndication_u24lambda_u2d0 = object;
        boolean bl3 = false;
        ((StateLayer)$this$drawIndication_u24lambda_u2d0).drawStateLayer-63rzH2k($this$drawIndication, interactionState, targetRadius, color);
        Offset pressPosition = interactionState.interactionPositionFor((Interaction)Interaction.Pressed.INSTANCE);
        if (pressPosition != null) {
            if (!Intrinsics.areEqual((Object)this.currentPressPosition, (Object)pressPosition)) {
                this.addRipple($this$drawIndication, targetRadius, pressPosition);
            }
        } else {
            this.removeRipple();
        }
        this.drawRipples-z8Px3OI((DrawScope)$this$drawIndication, color);
    }

    private final void addRipple(ContentDrawScope $this$addRipple, float targetRadius, Offset pressPosition) {
        RippleAnimation rippleAnimation = this.currentRipple;
        if (rippleAnimation != null) {
            rippleAnimation.finish();
        }
        Size pxSize = SizeKt.Size((float)$this$addRipple.getSize().getWidth(), (float)$this$addRipple.getSize().getHeight());
        Offset position = this.bounded ? pressPosition : Size.center$default((Size)pxSize, null, (int)1, null);
        RippleAnimation ripple2 = new RippleAnimation(pxSize, position, targetRadius, this.bounded, this.clock, (Function1<? super RippleAnimation, Unit>)((Function1)new Function1<RippleAnimation, Unit>(this){
            private final /* synthetic */ RippleIndicationInstance $this;
            {
                this.$this = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RippleAnimation ripple2) {
                Intrinsics.checkNotNullParameter((Object)ripple2, (String)"ripple");
                RippleIndicationInstance.access$getRipples$p(this.$this).remove((Object)ripple2);
                if (Intrinsics.areEqual((Object)RippleIndicationInstance.access$getCurrentRipple$p(this.$this), (Object)ripple2)) {
                    RippleIndicationInstance.access$setCurrentRipple$p(this.$this, null);
                }
            }
        }));
        this.ripples.add((Object)ripple2);
        this.currentPressPosition = pressPosition;
        this.currentRipple = ripple2;
    }

    private final void removeRipple() {
        RippleAnimation rippleAnimation = this.currentRipple;
        if (rippleAnimation != null) {
            rippleAnimation.finish();
        }
        this.currentRipple = null;
        this.currentPressPosition = null;
    }

    private final void drawRipples-z8Px3OI(DrawScope $receiver, long color) {
        List $this$fastForEach$iv = (List)this.ripples;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
        if (n <= n2) {
            do {
                int index$iv = n++;
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                RippleAnimation it = (RippleAnimation)item$iv;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                RippleAnimation $this$drawRipples_z8Px3OI_u24lambda_u2d2_u24lambda_u2d1 = it;
                boolean bl4 = false;
                float alpha = this.rippleOpacity.opacityForInteraction((Interaction)Interaction.Pressed.INSTANCE);
                if (alpha == 0.0f) continue;
                $this$drawRipples_z8Px3OI_u24lambda_u2d2_u24lambda_u2d1.draw-z8Px3OI($receiver, Color.copy-impl$default((long)color, (float)alpha, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null));
            } while (n <= n2);
        }
    }

    public void onDispose() {
        this.ripples.clear();
        this.currentRipple = null;
    }

    public /* synthetic */ RippleIndicationInstance(boolean bl, @Nullable Dp dp, @NotNull State state, @NotNull RippleOpacity rippleOpacity, @NotNull AnimationClockObservable animationClockObservable, @NotNull DefaultConstructorMarker defaultConstructorMarker) {
        this(bl, dp, (State<Color>)state, rippleOpacity, animationClockObservable);
    }

    public static final /* synthetic */ ModelList access$getRipples$p(RippleIndicationInstance rippleIndicationInstance) {
        return rippleIndicationInstance.ripples;
    }

    public static final /* synthetic */ RippleAnimation access$getCurrentRipple$p(RippleIndicationInstance rippleIndicationInstance) {
        return rippleIndicationInstance.currentRipple;
    }

    public static final /* synthetic */ void access$setCurrentRipple$p(RippleIndicationInstance rippleIndicationInstance, RippleAnimation rippleAnimation) {
        rippleIndicationInstance.currentRipple = rippleAnimation;
    }
}

