/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.material.ripple;

import androidx.animation.AnimationBuilder;
import androidx.animation.AnimationClockObservable;
import androidx.animation.BaseAnimatedValue;
import androidx.animation.EasingKt;
import androidx.animation.TweenBuilder;
import androidx.ui.animation.AnimatedFloatModel;
import androidx.ui.core.ContentDrawScope;
import androidx.ui.foundation.Interaction;
import androidx.ui.foundation.InteractionState;
import androidx.ui.geometry.Size;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.ClipOp;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.drawscope.DrawScope;
import androidx.ui.graphics.drawscope.DrawTransform;
import androidx.ui.material.ripple.RippleOpacity;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0018\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J,\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Landroidx/ui/material/ripple/StateLayer;", "", "clock", "Landroidx/animation/AnimationClockObservable;", "bounded", "", "rippleOpacity", "Landroidx/ui/material/ripple/RippleOpacity;", "animatedOpacity", "Landroidx/ui/animation/AnimatedFloatModel;", "lastDrawnInteraction", "Landroidx/ui/foundation/Interaction;", "previousInteractions", "", "animationBuilderForInteraction", "Landroidx/animation/AnimationBuilder;", "", "interaction", "drawStateLayer", "", "Landroidx/ui/core/ContentDrawScope;", "interactionState", "Landroidx/ui/foundation/InteractionState;", "targetRadius", "color", "Landroidx/ui/graphics/Color;", "drawStateLayer-63rzH2k", "(Landroidx/ui/core/ContentDrawScope;Landroidx/ui/foundation/InteractionState;FJ)V", "ui-material_release"})
final class StateLayer {
    private final boolean bounded;
    private final RippleOpacity rippleOpacity;
    private final AnimatedFloatModel animatedOpacity;
    private Set<? extends Interaction> previousInteractions;
    private Interaction lastDrawnInteraction;

    public StateLayer(@NotNull AnimationClockObservable clock, boolean bounded, @NotNull RippleOpacity rippleOpacity) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)rippleOpacity, (String)"rippleOpacity");
        this.bounded = bounded;
        this.rippleOpacity = rippleOpacity;
        this.animatedOpacity = new AnimatedFloatModel(0.0f, clock, 0.0f, 4, null);
        this.previousInteractions = SetsKt.emptySet();
    }

    public final void drawStateLayer-63rzH2k(@NotNull ContentDrawScope $receiver, @NotNull InteractionState interactionState, float targetRadius, long color) {
        Interaction previousInteraction;
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        Intrinsics.checkNotNullParameter((Object)interactionState, (String)"interactionState");
        Set currentInteractions = interactionState.getValue();
        boolean handled = false;
        for (Interaction interaction : currentInteractions) {
            float targetOpacity;
            if (handled) break;
            if (this.previousInteractions.contains(interaction) || interaction instanceof Interaction.Pressed || (targetOpacity = this.rippleOpacity.opacityForInteraction(interaction)) == 0.0f) continue;
            AnimationBuilder<Float> animationBuilder = this.animationBuilderForInteraction(interaction);
            BaseAnimatedValue.animateTo$default((BaseAnimatedValue)((BaseAnimatedValue)this.animatedOpacity), (Object)Float.valueOf(targetOpacity), animationBuilder, null, (int)4, null);
            this.lastDrawnInteraction = interaction;
            handled = true;
        }
        if (!handled && (previousInteraction = this.lastDrawnInteraction) != null && !currentInteractions.contains(previousInteraction)) {
            BaseAnimatedValue.animateTo$default((BaseAnimatedValue)((BaseAnimatedValue)this.animatedOpacity), (Object)Float.valueOf(0.0f), this.animationBuilderForInteraction(previousInteraction), null, (int)4, null);
            this.lastDrawnInteraction = null;
        }
        this.previousInteractions = currentInteractions;
        float opacity = this.animatedOpacity.getValue().floatValue();
        if (opacity > 0.0f) {
            long modulatedColor = Color.copy-impl$default((long)color, (float)opacity, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
            if (this.bounded) {
                DrawScope $this$clipRect_u24default$iv = (DrawScope)$receiver;
                float left$iv = 0.0f;
                float top$iv = 0.0f;
                float right$iv = $this$clipRect_u24default$iv.getSize().getWidth();
                float bottom$iv = $this$clipRect_u24default$iv.getSize().getHeight();
                ClipOp clipOp$iv = ClipOp.intersect;
                DrawScope $this$clipRect$iv$iv = $this$clipRect_u24default$iv;
                boolean $i$f$clipRect = false;
                DrawScope $this$withTransform$iv$iv$iv = $this$clipRect$iv$iv;
                boolean $i$f$withTransform = false;
                Canvas canvas = $this$withTransform$iv$iv$iv.getCanvas();
                boolean bl = false;
                boolean bl2 = false;
                Canvas it$iv$iv$iv = canvas;
                boolean bl3 = false;
                Size previousSize$iv$iv$iv = $this$withTransform$iv$iv$iv.getSize();
                it$iv$iv$iv.save();
                DrawTransform $this$clipRect_u24lambda_u2d3$iv$iv = $this$withTransform$iv$iv$iv.getTransform();
                boolean bl4 = false;
                $this$clipRect_u24lambda_u2d3$iv$iv.clipRect(left$iv, top$iv, right$iv, bottom$iv, clipOp$iv);
                DrawScope $this$drawStateLayer_63rzH2k_u24lambda_u2d0 = $this$withTransform$iv$iv$iv;
                boolean bl5 = false;
                DrawScope.drawCircle-UNeD5NE$default((DrawScope)$this$drawStateLayer_63rzH2k_u24lambda_u2d0, (long)modulatedColor, (float)targetRadius, null, (float)0.0f, null, null, null, (int)124, null);
                it$iv$iv$iv.restore();
                $this$withTransform$iv$iv$iv.setSize(previousSize$iv$iv$iv);
            } else {
                DrawScope.drawCircle-UNeD5NE$default((DrawScope)((DrawScope)$receiver), (long)modulatedColor, (float)targetRadius, null, (float)0.0f, null, null, null, (int)124, null);
            }
        }
    }

    private final AnimationBuilder<Float> animationBuilderForInteraction(Interaction interaction) {
        TweenBuilder tweenBuilder = new TweenBuilder();
        boolean bl = false;
        boolean bl2 = false;
        TweenBuilder $this$animationBuilderForInteraction_u24lambda_u2d1 = tweenBuilder;
        boolean bl3 = false;
        $this$animationBuilderForInteraction_u24lambda_u2d1.setDuration(15);
        $this$animationBuilderForInteraction_u24lambda_u2d1.setEasing(EasingKt.getLinearEasing());
        return (AnimationBuilder)tweenBuilder;
    }
}

