/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.autofill;

import android.graphics.Rect;
import android.view.View;
import android.view.autofill.AutofillManager;
import androidx.annotation.RequiresApi;
import androidx.ui.autofill.Autofill;
import androidx.ui.autofill.AutofillNode;
import androidx.ui.autofill.AutofillTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Landroidx/ui/autofill/AndroidAutofill;", "Landroidx/ui/autofill/Autofill;", "view", "Landroid/view/View;", "autofillTree", "Landroidx/ui/autofill/AutofillTree;", "(Landroid/view/View;Landroidx/ui/autofill/AutofillTree;)V", "autofillManager", "Landroid/view/autofill/AutofillManager;", "getAutofillManager", "()Landroid/view/autofill/AutofillManager;", "getAutofillTree", "()Landroidx/ui/autofill/AutofillTree;", "getView", "()Landroid/view/View;", "cancelAutofillForNode", "", "autofillNode", "Landroidx/ui/autofill/AutofillNode;", "requestAutofillForNode", "ui-platform_release"})
@RequiresApi(value=26)
public final class AndroidAutofill
implements Autofill {
    @NotNull
    private final AutofillManager autofillManager;
    @NotNull
    private final View view;
    @NotNull
    private final AutofillTree autofillTree;

    @NotNull
    public final AutofillManager getAutofillManager() {
        return this.autofillManager;
    }

    public void requestAutofillForNode(@NotNull AutofillNode autofillNode) {
        Intrinsics.checkParameterIsNotNull((Object)autofillNode, (String)"autofillNode");
        AutofillManager autofillManager = this.autofillManager;
        View view = this.view;
        int n = autofillNode.getId();
        Rect rect = autofillNode.getBoundingBox();
        if (rect == null) {
            String string = "requestAutofill called before onChildPositioned()";
            int n2 = n;
            View view2 = view;
            AutofillManager autofillManager2 = autofillManager;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        autofillManager.notifyViewEntered(view, n, rect);
    }

    public void cancelAutofillForNode(@NotNull AutofillNode autofillNode) {
        Intrinsics.checkParameterIsNotNull((Object)autofillNode, (String)"autofillNode");
        this.autofillManager.notifyViewExited(this.view, autofillNode.getId());
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    @NotNull
    public final AutofillTree getAutofillTree() {
        return this.autofillTree;
    }

    public AndroidAutofill(@NotNull View view, @NotNull AutofillTree autofillTree) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)autofillTree, (String)"autofillTree");
        this.view = view;
        this.autofillTree = autofillTree;
        AutofillManager autofillManager = (AutofillManager)this.view.getContext().getSystemService(AutofillManager.class);
        if (autofillManager == null) {
            String string = "Autofill service could not be located.";
            AndroidAutofill androidAutofill = this;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.autofillManager = autofillManager;
        this.view.setImportantForAutofill(1);
    }
}

