/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.autofill;

import android.util.Log;
import android.view.View;
import android.view.autofill.AutofillManager;
import androidx.annotation.RequiresApi;
import androidx.ui.autofill.AndroidAutofill;
import androidx.ui.autofill.AndroidAutofillDebugUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0015\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0001\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0001\u001a\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0005H\u0001\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"autofillCallback", "androidx/ui/autofill/AndroidAutofillDebugUtilsKt$autofillCallback$1", "Landroidx/ui/autofill/AndroidAutofillDebugUtilsKt$autofillCallback$1;", "registerCallback", "", "Landroidx/ui/autofill/AndroidAutofill;", "unregisterCallback", "ui-platform_release"})
public final class AndroidAutofillDebugUtilsKt {
    private static final autofillCallback.1 autofillCallback = new AutofillManager.AutofillCallback(){

        public void onAutofillEvent(@NotNull View view, int virtualId, int event) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            super.onAutofillEvent(view, virtualId, event);
            switch (event) {
                case 1: {
                    string = "Autofill popup was shown.";
                    break;
                }
                case 2: {
                    string = "Autofill popup was hidden.";
                    break;
                }
                case 3: {
                    string = "Autofill popup isn't shown because autofill is not available.\n\nDid you set up autofill?\n1. Go to Settings > System > Languages&input > Advanced > Autofill Service\n2. Pick a service\n\nDid you add an account?\n1. Go to Settings > System > Languages&input > Advanced\n2. Click on the settings icon next to the Autofill Service\n3. Add your account";
                    break;
                }
                default: {
                    string = "Unknown status event.";
                }
            }
            Log.d((String)"Autofill Status", (String)string);
        }
    };

    @RequiresApi(value=26)
    public static final void registerCallback(@NotNull AndroidAutofill $this$registerCallback) {
        Intrinsics.checkParameterIsNotNull((Object)$this$registerCallback, (String)"$this$registerCallback");
        $this$registerCallback.getAutofillManager().registerCallback((AutofillManager.AutofillCallback)autofillCallback);
    }

    @RequiresApi(value=26)
    public static final void unregisterCallback(@NotNull AndroidAutofill $this$unregisterCallback) {
        Intrinsics.checkParameterIsNotNull((Object)$this$unregisterCallback, (String)"$this$unregisterCallback");
        $this$unregisterCallback.getAutofillManager().unregisterCallback((AutofillManager.AutofillCallback)autofillCallback);
    }
}

